/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.refactoring.ui;

import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.ProcessorBasedRefactoring;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.xtext.ui.refactoring.impl.AbstractRenameProcessor;

public class RenameElementWizard
extends RefactoringWizard {
    private AbstractRenameProcessor renameProcessor;

    public RenameElementWizard(ProcessorBasedRefactoring refactoring) {
        super((Refactoring)refactoring, 4);
        this.renameProcessor = (AbstractRenameProcessor)refactoring.getProcessor();
    }

    protected void addUserInputPages() {
        this.addPage((IWizardPage)new UserInputPage(this.getRenameProcessor()));
    }

    protected AbstractRenameProcessor getRenameProcessor() {
        return this.renameProcessor;
    }

    protected static class UserInputPage
    extends UserInputWizardPage {
        private final AbstractRenameProcessor renameProcessor;
        private Text nameField;
        private String currentName;

        public UserInputPage(AbstractRenameProcessor renameProcessor) {
            super("RenameElementResourceRefactoringInputPage");
            this.renameProcessor = renameProcessor;
            this.currentName = renameProcessor.getNewName() != null ? renameProcessor.getNewName() : renameProcessor.getOriginalName();
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout(2, false));
            composite.setLayoutData((Object)new GridData(4, 4, true, true));
            composite.setFont(parent.getFont());
            Label label = new Label(composite, 0);
            label.setText("New name");
            label.setLayoutData((Object)new GridData());
            this.nameField = new Text(composite, 2048);
            this.nameField.setText(this.currentName);
            this.nameField.setFont(composite.getFont());
            this.nameField.setLayoutData((Object)new GridData(4, 1, true, false));
            this.nameField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    UserInputPage.this.validatePage();
                }
            });
            this.nameField.selectAll();
            this.setPageComplete(this.renameProcessor.validateNewName(this.currentName));
            this.setControl((Control)composite);
        }

        public void setVisible(boolean visible) {
            if (visible) {
                this.nameField.setFocus();
            }
            super.setVisible(visible);
        }

        protected final void validatePage() {
            String text = this.nameField.getText();
            RefactoringStatus status = this.renameProcessor.validateNewName(text);
            this.setPageComplete(status);
        }

        protected boolean performFinish() {
            this.setNewName();
            return super.performFinish();
        }

        public IWizardPage getNextPage() {
            this.setNewName();
            return super.getNextPage();
        }

        private void setNewName() {
            this.renameProcessor.setNewName(this.nameField.getText());
        }
    }
}

