/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.presentation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.ui.action.ViewerFilterAction;
import org.eclipse.emf.common.ui.dialogs.DiagnosticDialog;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.ETypeParameter;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.presentation.EcoreEditor;
import org.eclipse.emf.ecore.presentation.EcoreEditorPlugin;
import org.eclipse.emf.ecore.provider.EcoreEditPlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.ui.action.CollapseAllAction;
import org.eclipse.emf.edit.ui.action.ControlAction;
import org.eclipse.emf.edit.ui.action.CreateChildAction;
import org.eclipse.emf.edit.ui.action.CreateSiblingAction;
import org.eclipse.emf.edit.ui.action.EditingDomainActionBarContributor;
import org.eclipse.emf.edit.ui.action.ExpandAllAction;
import org.eclipse.emf.edit.ui.action.FindAction;
import org.eclipse.emf.edit.ui.action.LoadResourceAction;
import org.eclipse.emf.edit.ui.action.RevertAction;
import org.eclipse.emf.edit.ui.action.ValidateAction;
import org.eclipse.emf.edit.ui.provider.DiagnosticDecorator;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.SubContributionItem;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EcoreActionBarContributor
extends EditingDomainActionBarContributor
implements ISelectionChangedListener {
    protected IEditorPart activeEditorPart;
    protected ISelectionProvider selectionProvider;
    protected IAction showPropertiesViewAction = new Action(EcoreEditorPlugin.INSTANCE.getString("_UI_ShowPropertiesView_menu_item")){

        public void run() {
            try {
                EcoreActionBarContributor.this.getPage().showView("org.eclipse.ui.views.PropertySheet");
            }
            catch (PartInitException exception) {
                EcoreEditorPlugin.INSTANCE.log((Object)exception);
            }
        }
    };
    protected IAction refreshViewerAction = new Action(EcoreEditorPlugin.INSTANCE.getString("_UI_RefreshViewer_menu_item")){

        public boolean isEnabled() {
            return EcoreActionBarContributor.this.activeEditorPart instanceof IViewerProvider;
        }

        public void run() {
            Viewer viewer;
            if (EcoreActionBarContributor.this.activeEditorPart instanceof IViewerProvider && (viewer = ((IViewerProvider)EcoreActionBarContributor.this.activeEditorPart).getViewer()) != null) {
                viewer.refresh();
            }
        }
    };
    protected Collection<IAction> createChildActions;
    protected IMenuManager createChildMenuManager;
    protected Collection<IAction> createSiblingActions;
    protected IMenuManager createSiblingMenuManager;
    protected SelectionChangedEvent lastSelectionChangedEvent;
    protected ViewerFilterAction showGenericsAction = new ViewerFilterAction(EcoreEditorPlugin.INSTANCE.getString("_UI_ShowGenerics_menu_item"), 2){

        protected void refreshViewers() {
            if (EcoreActionBarContributor.this.activeEditorPart instanceof EcoreEditor) {
                ((EcoreEditor)EcoreActionBarContributor.this.activeEditorPart).ecoreItemProviderAdapterFactory.setShowGenerics(this.isChecked());
            }
            super.refreshViewers();
            if (EcoreActionBarContributor.this.lastSelectionChangedEvent != null && EcoreActionBarContributor.this.activeEditorPart instanceof EcoreEditor) {
                EcoreActionBarContributor.this.selectionChanged(EcoreActionBarContributor.this.lastSelectionChangedEvent);
            }
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return this.isChecked() || !(element instanceof ETypeParameter) && !(element instanceof EGenericType);
        }
    };

    public EcoreActionBarContributor() {
        super(1);
        this.loadResourceAction = new ExtendedLoadResourceAction();
        this.liveValidationAction = new DiagnosticDecorator.LiveValidator.LiveValidationAction(EcoreEditorPlugin.getPlugin().getDialogSettings());
        this.validateAction = new ValidateAction();
        this.controlAction = new ControlAction();
        this.findAction = FindAction.create();
        this.revertAction = new RevertAction();
        this.expandAllAction = new ExpandAllAction();
        this.collapseAllAction = new CollapseAllAction();
        this.showGenericsAction.setChecked(Boolean.parseBoolean(EcoreEditorPlugin.getPlugin().getDialogSettings().get("showGenericsAction")));
    }

    public void showGenerics(boolean isChecked) {
        if (this.showGenericsAction != null) {
            this.showGenericsAction.setChecked(isChecked);
        }
    }

    public void dispose() {
        EcoreEditorPlugin.getPlugin().getDialogSettings().put("showGenericsAction", Boolean.toString(this.showGenericsAction.isChecked()));
        super.dispose();
    }

    public void contributeToToolBar(IToolBarManager toolBarManager) {
        super.contributeToToolBar(toolBarManager);
        toolBarManager.add((IContributionItem)new Separator("ecore-settings"));
        toolBarManager.add((IContributionItem)new Separator("ecore-additions"));
    }

    public void contributeToMenu(IMenuManager menuManager) {
        super.contributeToMenu(menuManager);
        IMenuManager submenuManager = this.createSubmenuManager();
        menuManager.insertAfter("additions", (IContributionItem)submenuManager);
        submenuManager.add((IContributionItem)new Separator("settings"));
        submenuManager.add((IContributionItem)new Separator("actions"));
        submenuManager.add((IContributionItem)new Separator("additions"));
        submenuManager.add((IContributionItem)new Separator("additions-end"));
        this.createChildMenuManager = new MenuManager(EcoreEditorPlugin.getPlugin().getString("_UI_CreateChild_menu_item"));
        submenuManager.insertBefore("additions", (IContributionItem)this.createChildMenuManager);
        this.createSiblingMenuManager = new MenuManager(EcoreEditorPlugin.getPlugin().getString("_UI_CreateSibling_menu_item"));
        submenuManager.insertBefore("additions", (IContributionItem)this.createSiblingMenuManager);
        submenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menuManager) {
                menuManager.updateAll(true);
            }
        });
        this.addGlobalActions(submenuManager);
        submenuManager.insertBefore("additions-end", (IAction)this.showGenericsAction);
    }

    protected IMenuManager createSubmenuManager() {
        return new MenuManager(EcoreEditorPlugin.getPlugin().getString("_UI_EcoreEditor_menu"), "org.eclipse.emf.ecoreMenuID");
    }

    public void setActiveEditorGen(IEditorPart part) {
        super.setActiveEditor(part);
        this.activeEditorPart = part;
        if (this.selectionProvider != null) {
            this.selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        if (part == null) {
            this.selectionProvider = null;
        } else {
            this.selectionProvider = part.getSite().getSelectionProvider();
            this.selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
            if (this.selectionProvider.getSelection() != null) {
                this.selectionChanged(new SelectionChangedEvent(this.selectionProvider, this.selectionProvider.getSelection()));
            }
        }
    }

    public void setActiveEditor(IEditorPart part) {
        this.setActiveEditorGen(part);
        if (part instanceof EcoreEditor) {
            this.showGenericsAction.addViewer(((EcoreEditor)part).getViewer());
            this.showGenericsAction.setEnabled(true);
        } else {
            this.showGenericsAction.setEnabled(false);
        }
    }

    public void selectionChangedGen(SelectionChangedEvent event) {
        if (this.createChildMenuManager != null) {
            this.depopulateManager((IContributionManager)this.createChildMenuManager, this.createChildActions);
        }
        if (this.createSiblingMenuManager != null) {
            this.depopulateManager((IContributionManager)this.createSiblingMenuManager, this.createSiblingActions);
        }
        Collection newChildDescriptors = null;
        Collection newSiblingDescriptors = null;
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1) {
            Object object = ((IStructuredSelection)selection).getFirstElement();
            EditingDomain domain = ((IEditingDomainProvider)this.activeEditorPart).getEditingDomain();
            newChildDescriptors = domain.getNewChildDescriptors(object, null);
            newSiblingDescriptors = domain.getNewChildDescriptors(null, object);
        }
        this.createChildActions = this.generateCreateChildActions(newChildDescriptors, selection);
        this.createSiblingActions = this.generateCreateSiblingActions(newSiblingDescriptors, selection);
        if (this.createChildMenuManager != null) {
            this.populateManager((IContributionManager)this.createChildMenuManager, this.createChildActions, null);
            this.createChildMenuManager.update(true);
        }
        if (this.createSiblingMenuManager != null) {
            this.populateManager((IContributionManager)this.createSiblingMenuManager, this.createSiblingActions, null);
            this.createSiblingMenuManager.update(true);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.lastSelectionChangedEvent = event;
        this.selectionChangedGen(event);
    }

    protected Collection<IAction> generateCreateChildActions(Collection<?> descriptors, ISelection selection) {
        ArrayList<IAction> actions = new ArrayList<IAction>();
        if (descriptors != null) {
            for (Object descriptor : descriptors) {
                Object feature;
                if (!this.showGenericsAction.isChecked() && descriptor instanceof CommandParameter && this.isGenericFeature(feature = ((CommandParameter)descriptor).getFeature())) continue;
                actions.add((IAction)new EcoreCreateChildAction((IWorkbenchPart)this.activeEditorPart, selection, descriptor));
            }
        }
        return actions;
    }

    protected Collection<IAction> generateCreateSiblingActions(Collection<?> descriptors, ISelection selection) {
        ArrayList<IAction> actions = new ArrayList<IAction>();
        if (descriptors != null) {
            for (Object descriptor : descriptors) {
                Object feature;
                if (!this.showGenericsAction.isChecked() && descriptor instanceof CommandParameter && this.isGenericFeature(feature = ((CommandParameter)descriptor).getFeature())) continue;
                actions.add((IAction)new EcoreCreateSiblingAction((IWorkbenchPart)this.activeEditorPart, selection, descriptor));
            }
        }
        return actions;
    }

    protected boolean isGenericFeature(Object feature) {
        return feature == EcorePackage.Literals.ECLASS__EGENERIC_SUPER_TYPES || feature == EcorePackage.Literals.ECLASSIFIER__ETYPE_PARAMETERS || feature == EcorePackage.Literals.EOPERATION__EGENERIC_EXCEPTIONS || feature == EcorePackage.Literals.EOPERATION__ETYPE_PARAMETERS || feature == EcorePackage.Literals.ETYPED_ELEMENT__EGENERIC_TYPE;
    }

    protected void populateManager(IContributionManager manager, Collection<? extends IAction> actions, String contributionID) {
        if (actions != null) {
            HashSet<IAction> ignoredActions = new HashSet<IAction>();
            LinkedHashSet<IAction> annotationActions = new LinkedHashSet<IAction>();
            for (IAction iAction : actions) {
                EObjectProvider eObjectProvider;
                EObject eObject;
                if (!(iAction instanceof EObjectProvider) || !((eObject = (eObjectProvider = (EObjectProvider)iAction).getEObject()) instanceof EAnnotation)) continue;
                annotationActions.add(iAction);
                ignoredActions.add(iAction);
            }
            if (annotationActions.size() > 1) {
                IAction iAction = (IAction)annotationActions.iterator().next();
                String actionText = iAction.getText();
                MenuManager annotationMenuManager = new MenuManager(actionText, iAction.getImageDescriptor(), "annotations");
                if (contributionID != null) {
                    manager.insertBefore(contributionID, (IContributionItem)annotationMenuManager);
                } else {
                    manager.add((IContributionItem)annotationMenuManager);
                }
                for (IAction annotationAction : annotationActions) {
                    annotationMenuManager.add(annotationAction);
                    String source = ((EAnnotation)((EObjectProvider)annotationAction).getEObject()).getSource();
                    if (source == null) continue;
                    annotationAction.setText(String.valueOf(actionText) + " - " + source);
                }
            } else {
                ignoredActions.clear();
            }
            for (IAction iAction : actions) {
                if (ignoredActions.contains(iAction)) continue;
                if (contributionID != null) {
                    manager.insertBefore(contributionID, iAction);
                    continue;
                }
                manager.add(iAction);
            }
        }
    }

    protected void depopulateManagerGen(IContributionManager manager, Collection<? extends IAction> actions) {
        if (actions != null) {
            IContributionItem[] items = manager.getItems();
            int i = 0;
            while (i < items.length) {
                IAction action;
                IContributionItem contributionItem = items[i];
                while (contributionItem instanceof SubContributionItem) {
                    contributionItem = ((SubContributionItem)contributionItem).getInnerItem();
                }
                if (contributionItem instanceof ActionContributionItem && actions.contains(action = ((ActionContributionItem)contributionItem).getAction())) {
                    manager.remove(contributionItem);
                }
                ++i;
            }
        }
    }

    protected void depopulateManager(IContributionManager manager, Collection<? extends IAction> actions) {
        this.depopulateManagerGen(manager, actions);
        IContributionItem[] items = manager.getItems();
        int i = 0;
        while (i < items.length) {
            IContributionItem contributionItem = items[i];
            if ("annotations".equals(contributionItem.getId())) {
                manager.remove(contributionItem);
            }
            ++i;
        }
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        super.menuAboutToShow(menuManager);
        MenuManager submenuManager = null;
        submenuManager = new MenuManager(EcoreEditorPlugin.INSTANCE.getString("_UI_CreateChild_menu_item"));
        this.populateManager((IContributionManager)submenuManager, this.createChildActions, null);
        menuManager.insertBefore("edit", (IContributionItem)submenuManager);
        submenuManager = new MenuManager(EcoreEditorPlugin.INSTANCE.getString("_UI_CreateSibling_menu_item"));
        this.populateManager((IContributionManager)submenuManager, this.createSiblingActions, null);
        menuManager.insertBefore("edit", (IContributionItem)submenuManager);
    }

    protected void addGlobalActions(IMenuManager menuManager) {
        menuManager.insertAfter("additions-end", (IContributionItem)new Separator("ui-actions"));
        menuManager.insertAfter("ui-actions", this.showPropertiesViewAction);
        this.refreshViewerAction.setEnabled(this.refreshViewerAction.isEnabled());
        menuManager.insertAfter("ui-actions", this.refreshViewerAction);
        super.addGlobalActions(menuManager);
    }

    protected boolean removeAllReferencesOnDelete() {
        return true;
    }

    public static interface EObjectProvider {
        public EObject getEObject();
    }

    public class EcoreCreateChildAction
    extends CreateChildAction
    implements EObjectProvider {
        public EcoreCreateChildAction(IWorkbenchPart workbenchPart, ISelection selection, Object descriptor) {
            super(workbenchPart, selection, descriptor);
        }

        public EObject getEObject() {
            if (this.descriptor instanceof CommandParameter) {
                CommandParameter commandParameter = (CommandParameter)this.descriptor;
                return commandParameter.getEValue();
            }
            return null;
        }

        public void run() {
            super.run();
            final Display display = EcoreActionBarContributor.this.getPage().getWorkbenchWindow().getShell().getDisplay();
            display.asyncExec(new Runnable(){

                public void run() {
                    display.asyncExec(new Runnable(){

                        public void run() {
                            ((EcoreCreateChildAction)(this).EcoreCreateChildAction.this).EcoreActionBarContributor.this.showPropertiesViewAction.run();
                        }
                    });
                }
            });
        }
    }

    public class EcoreCreateSiblingAction
    extends CreateSiblingAction
    implements EObjectProvider {
        public EcoreCreateSiblingAction(IWorkbenchPart workbenchPart, ISelection selection, Object descriptor) {
            super(workbenchPart, selection, descriptor);
        }

        public EObject getEObject() {
            if (this.descriptor instanceof CommandParameter) {
                CommandParameter commandParameter = (CommandParameter)this.descriptor;
                return commandParameter.getEValue();
            }
            return null;
        }

        public void run() {
            super.run();
            final Display display = EcoreActionBarContributor.this.getPage().getWorkbenchWindow().getShell().getDisplay();
            display.asyncExec(new Runnable(){

                public void run() {
                    display.asyncExec(new Runnable(){

                        public void run() {
                            ((EcoreCreateSiblingAction)(this).EcoreCreateSiblingAction.this).EcoreActionBarContributor.this.showPropertiesViewAction.run();
                        }
                    });
                }
            });
        }
    }

    public static class ExtendedLoadResourceAction
    extends LoadResourceAction {
        public void run() {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            ExtendedLoadResourceDialog loadResourceDialog = new ExtendedLoadResourceDialog(shell, this.domain);
            if (loadResourceDialog.open() == 0 && !loadResourceDialog.getRegisteredPackages().isEmpty()) {
                String source = EcoreEditorPlugin.INSTANCE.getSymbolicName();
                BasicDiagnostic diagnosic = new BasicDiagnostic(1, source, 0, EcoreEditorPlugin.INSTANCE.getString("_UI_RuntimePackageDetail_message"), null);
                for (EPackage ePackage : loadResourceDialog.getRegisteredPackages()) {
                    diagnosic.add((Diagnostic)new BasicDiagnostic(1, source, 0, ePackage.getNsURI(), null));
                }
                new DiagnosticDialog(shell, EcoreEditorPlugin.INSTANCE.getString("_UI_Information_title"), EcoreEditorPlugin.INSTANCE.getString("_UI_RuntimePackageHeader_message"), (Diagnostic)diagnosic, 1).open();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class ExtendedLoadResourceDialog
        extends LoadResourceAction.LoadResourceDialog {
            protected Set<EPackage> registeredPackages = new LinkedHashSet<EPackage>();

            public ExtendedLoadResourceDialog(Shell parent, EditingDomain domain) {
                super(parent, domain);
            }

            protected boolean processResource(Resource resource) {
                ResourceSet resourceSet = this.domain.getResourceSet();
                if (!resourceSet.getResources().contains((Object)resource)) {
                    EPackage.Registry packageRegistry = resourceSet.getPackageRegistry();
                    for (EPackage ePackage : this.getAllPackages(resource)) {
                        packageRegistry.put((Object)ePackage.getNsURI(), (Object)ePackage);
                        this.registeredPackages.add(ePackage);
                    }
                }
                return true;
            }

            public Set<EPackage> getRegisteredPackages() {
                return this.registeredPackages;
            }

            protected Collection<EPackage> getAllPackages(Resource resource) {
                ArrayList<EPackage> result = new ArrayList<EPackage>();
                EcoreUtil.ContentTreeIterator<Object> j = new EcoreUtil.ContentTreeIterator<Object>((Collection)resource.getContents()){
                    private static final long serialVersionUID = 1L;

                    protected Iterator<? extends EObject> getEObjectChildren(EObject eObject) {
                        return eObject instanceof EPackage ? ((EPackage)eObject).getESubpackages().iterator() : Collections.emptyList().iterator();
                    }
                };
                while (j.hasNext()) {
                    Object content = j.next();
                    if (!(content instanceof EPackage)) continue;
                    result.add((EPackage)content);
                }
                return result;
            }

            protected Control createDialogArea(Composite parent) {
                Composite composite = (Composite)super.createDialogArea(parent);
                Composite buttonComposite = (Composite)composite.getChildren()[0];
                Button browseRegisteredPackagesButton = new Button(buttonComposite, 8);
                browseRegisteredPackagesButton.setText(EcoreEditorPlugin.INSTANCE.getString("_UI_BrowseRegisteredPackages_label"));
                this.prepareBrowseRegisteredPackagesButton(browseRegisteredPackagesButton);
                FormData data = new FormData();
                Control[] children = buttonComposite.getChildren();
                data.right = new FormAttachment(children[0], -10);
                browseRegisteredPackagesButton.setLayoutData((Object)data);
                Button browseTargetPlatformPackagesButton = new Button(buttonComposite, 8);
                browseTargetPlatformPackagesButton.setText(EcoreEditorPlugin.INSTANCE.getString("_UI_BrowseTargetPlatformPackages_label"));
                this.prepareBrowseTargetPlatformPackagesButton(browseTargetPlatformPackagesButton);
                FormData data2 = new FormData();
                data2.right = new FormAttachment((Control)browseRegisteredPackagesButton, -10);
                browseTargetPlatformPackagesButton.setLayoutData((Object)data2);
                return composite;
            }

            protected void prepareBrowseTargetPlatformPackagesButton(Button browseTargetPlatformPackagesButton) {
                browseTargetPlatformPackagesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        TargetPlatformPackageDialog classpathPackageDialog = new TargetPlatformPackageDialog(ExtendedLoadResourceDialog.this.getShell());
                        classpathPackageDialog.open();
                        Object[] result = classpathPackageDialog.getResult();
                        if (result != null) {
                            List<Object> nsURIs = Arrays.asList(result);
                            ResourceSetImpl resourceSet = new ResourceSetImpl();
                            resourceSet.getURIConverter().getURIMap().putAll(EcorePlugin.computePlatformURIMap((boolean)true));
                            Resource dummyResource = ExtendedLoadResourceDialog.this.domain == null ? null : resourceSet.createResource(((Resource)ExtendedLoadResourceDialog.this.domain.getResourceSet().getResources().get(0)).getURI());
                            StringBuffer uris = new StringBuffer();
                            Map ePackageNsURItoGenModelLocationMap = EcorePlugin.getEPackageNsURIToGenModelLocationMap((boolean)true);
                            int i = 0;
                            int length = result.length;
                            while (i < length) {
                                URI location = (URI)ePackageNsURItoGenModelLocationMap.get(result[i]);
                                Resource resource = resourceSet.getResource(location, true);
                                EcoreUtil.resolveAll((Resource)resource);
                                ++i;
                            }
                            EList resources = resourceSet.getResources();
                            resources.remove((Object)dummyResource);
                            block1: for (Resource resource : resources) {
                                for (EPackage ePackage : ExtendedLoadResourceDialog.this.getAllPackages(resource)) {
                                    if (!nsURIs.contains(ePackage.getNsURI())) continue;
                                    uris.append(resource.getURI());
                                    uris.append("  ");
                                    continue block1;
                                }
                            }
                            ExtendedLoadResourceDialog.this.uriField.setText((String.valueOf(ExtendedLoadResourceDialog.this.uriField.getText()) + "  " + uris.toString()).trim());
                        }
                    }
                });
            }

            protected void prepareBrowseRegisteredPackagesButton(Button browseRegisteredPackagesButton) {
                browseRegisteredPackagesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        RegisteredPackageDialog registeredPackageDialog = new RegisteredPackageDialog(ExtendedLoadResourceDialog.this.getShell());
                        registeredPackageDialog.open();
                        Object[] result = registeredPackageDialog.getResult();
                        if (result != null) {
                            List<Object> nsURIs = Arrays.asList(result);
                            if (registeredPackageDialog.isDevelopmentTimeVersion()) {
                                ResourceSetImpl resourceSet = new ResourceSetImpl();
                                resourceSet.getURIConverter().getURIMap().putAll(EcorePlugin.computePlatformURIMap((boolean)false));
                                Resource dummyResource = ExtendedLoadResourceDialog.this.domain == null ? null : resourceSet.createResource(((Resource)ExtendedLoadResourceDialog.this.domain.getResourceSet().getResources().get(0)).getURI());
                                StringBuffer uris = new StringBuffer();
                                Map ePackageNsURItoGenModelLocationMap = EcorePlugin.getEPackageNsURIToGenModelLocationMap((boolean)false);
                                int i = 0;
                                int length = result.length;
                                while (i < length) {
                                    URI location = (URI)ePackageNsURItoGenModelLocationMap.get(result[i]);
                                    Resource resource = resourceSet.getResource(location, true);
                                    EcoreUtil.resolveAll((Resource)resource);
                                    ++i;
                                }
                                EList resources = resourceSet.getResources();
                                resources.remove((Object)dummyResource);
                                block1: for (Resource resource : resources) {
                                    for (EPackage ePackage : ExtendedLoadResourceDialog.this.getAllPackages(resource)) {
                                        if (!nsURIs.contains(ePackage.getNsURI())) continue;
                                        uris.append(resource.getURI());
                                        uris.append("  ");
                                        continue block1;
                                    }
                                }
                                ExtendedLoadResourceDialog.this.uriField.setText((String.valueOf(ExtendedLoadResourceDialog.this.uriField.getText()) + "  " + uris.toString()).trim());
                            } else {
                                StringBuffer uris = new StringBuffer();
                                int i = 0;
                                int length = result.length;
                                while (i < length) {
                                    uris.append(result[i]);
                                    uris.append("  ");
                                    ++i;
                                }
                                ExtendedLoadResourceDialog.this.uriField.setText((String.valueOf(ExtendedLoadResourceDialog.this.uriField.getText()) + "  " + uris.toString()).trim());
                            }
                        }
                    }
                });
            }
        }

        public static class RegisteredPackageDialog
        extends ElementListSelectionDialog {
            protected boolean isDevelopmentTimeVersion = true;

            public RegisteredPackageDialog(Shell parent) {
                super(parent, (ILabelProvider)new LabelProvider(){

                    public Image getImage(Object element) {
                        return ExtendedImageRegistry.getInstance().getImage(EcoreEditPlugin.INSTANCE.getImage("full/obj16/EPackage"));
                    }
                });
                this.setMultipleSelection(true);
                this.setMessage(EcoreEditorPlugin.INSTANCE.getString("_UI_SelectRegisteredPackageURI"));
                this.setFilter("*");
                this.setTitle(EcoreEditorPlugin.INSTANCE.getString("_UI_PackageSelection_label"));
            }

            public boolean isDevelopmentTimeVersion() {
                return this.isDevelopmentTimeVersion;
            }

            protected void updateElements() {
                if (this.isDevelopmentTimeVersion) {
                    Map ePackageNsURItoGenModelLocationMap = EcorePlugin.getEPackageNsURIToGenModelLocationMap((boolean)false);
                    Object[] result = ePackageNsURItoGenModelLocationMap.keySet().toArray(new Object[ePackageNsURItoGenModelLocationMap.size()]);
                    Arrays.sort(result);
                    this.setListElements(result);
                } else {
                    Object[] result = EPackage.Registry.INSTANCE.keySet().toArray(new Object[EPackage.Registry.INSTANCE.size()]);
                    Arrays.sort(result);
                    this.setListElements(result);
                }
            }

            protected Control createDialogArea(Composite parent) {
                Composite result = (Composite)super.createDialogArea(parent);
                Composite buttonGroup = new Composite(result, 0);
                GridLayout layout = new GridLayout();
                layout.numColumns = 2;
                buttonGroup.setLayout((Layout)layout);
                final Button developmentTimeVersionButton = new Button(buttonGroup, 16);
                developmentTimeVersionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        RegisteredPackageDialog.this.isDevelopmentTimeVersion = developmentTimeVersionButton.getSelection();
                        RegisteredPackageDialog.this.updateElements();
                    }
                });
                developmentTimeVersionButton.setText(EcoreEditorPlugin.INSTANCE.getString("_UI_DevelopmentTimeVersion_label"));
                Button runtimeTimeVersionButton = new Button(buttonGroup, 16);
                runtimeTimeVersionButton.setText(EcoreEditorPlugin.INSTANCE.getString("_UI_RuntimeVersion_label"));
                developmentTimeVersionButton.setSelection(true);
                this.updateElements();
                return result;
            }
        }

        public static class TargetPlatformPackageDialog
        extends ElementListSelectionDialog {
            public TargetPlatformPackageDialog(Shell parent) {
                super(parent, (ILabelProvider)new LabelProvider(){

                    public Image getImage(Object element) {
                        return ExtendedImageRegistry.getInstance().getImage(EcoreEditPlugin.INSTANCE.getImage("full/obj16/EPackage"));
                    }
                });
                this.setMultipleSelection(true);
                this.setMessage(EcoreEditorPlugin.INSTANCE.getString("_UI_SelectRegisteredPackageURI"));
                this.setFilter("*");
                this.setTitle(EcoreEditorPlugin.INSTANCE.getString("_UI_PackageSelection_label"));
            }

            protected void updateElements() {
                Map ePackageNsURItoGenModelLocationMap = EcorePlugin.getEPackageNsURIToGenModelLocationMap((boolean)true);
                Object[] result = ePackageNsURItoGenModelLocationMap.keySet().toArray(new Object[ePackageNsURItoGenModelLocationMap.size()]);
                Arrays.sort(result);
                this.setListElements(result);
            }

            protected Control createDialogArea(Composite parent) {
                Composite result = (Composite)super.createDialogArea(parent);
                this.updateElements();
                return result;
            }
        }
    }

    public static class Reflective
    extends EcoreActionBarContributor {
        protected IMenuManager createSubmenuManager() {
            return new MenuManager(EcoreEditorPlugin.getPlugin().getString("_UI_ReflectiveEditor_menu"), "org.eclipse.emf.ecoreMenuID");
        }
    }
}

