/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.diseasemodels.standard.impl;

import java.text.DecimalFormat;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.graph.impl.IntegrationLabelImpl;
import org.eclipse.stem.definitions.labels.PopulationLabel;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabel;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabelValue;
import org.eclipse.stem.diseasemodels.standard.StandardPackage;
import org.eclipse.stem.populationmodels.standard.PopulationModelLabel;

public abstract class DiseaseModelLabelImpl
extends IntegrationLabelImpl
implements DiseaseModelLabel {
    protected PopulationLabel populationLabel;
    protected PopulationModelLabel populationModelLabel;

    protected EClass eStaticClass() {
        return StandardPackage.Literals.DISEASE_MODEL_LABEL;
    }

    @Override
    public PopulationLabel getPopulationLabel() {
        if (this.populationLabel != null && this.populationLabel.eIsProxy()) {
            InternalEObject oldPopulationLabel = (InternalEObject)this.populationLabel;
            this.populationLabel = (PopulationLabel)this.eResolveProxy(oldPopulationLabel);
        }
        return this.populationLabel;
    }

    public PopulationLabel basicGetPopulationLabel() {
        return this.populationLabel;
    }

    @Override
    public void setPopulationLabel(PopulationLabel newPopulationLabel) {
        this.populationLabel = newPopulationLabel;
    }

    @Override
    public PopulationModelLabel getPopulationModelLabel() {
        if (this.populationModelLabel != null && this.populationModelLabel.eIsProxy()) {
            InternalEObject oldPopulationModelLabel = (InternalEObject)this.populationModelLabel;
            this.populationModelLabel = (PopulationModelLabel)this.eResolveProxy(oldPopulationModelLabel);
        }
        return this.populationModelLabel;
    }

    public PopulationModelLabel basicGetPopulationModelLabel() {
        return this.populationModelLabel;
    }

    @Override
    public void setPopulationModelLabel(PopulationModelLabel newPopulationModelLabel) {
        this.populationModelLabel = newPopulationModelLabel;
    }

    @Override
    public String toTooltipString() {
        DiseaseModelLabelValue current = (DiseaseModelLabelValue)this.getCurrentValue();
        double populationCount = current.getPopulationCount();
        if (populationCount == 0.0) {
            populationCount = 1.0;
        }
        DecimalFormat formatPercentage = new DecimalFormat("#%");
        EList attributes = current.eClass().getEAllAttributes();
        StringBuffer result = new StringBuffer();
        int i = 0;
        result.append(String.valueOf(this.getIdentifier()) + ": ");
        for (EAttribute attribute : attributes) {
            if (attribute.getName().startsWith("incidence") || attribute.getName().startsWith("diseaseDeaths") || attribute.getName().startsWith("populationCount")) continue;
            String name = attribute.getName().toUpperCase();
            String value = formatPercentage.format((Double)current.eGet((EStructuralFeature)attribute) / populationCount);
            if (i != 0 && i % 10 == 0) {
                result.append("\n\t");
            }
            result.append(String.valueOf(name) + ":");
            result.append(value);
            result.append(", ");
            ++i;
        }
        result.delete(result.length() - 2, result.length());
        return result.toString();
    }

    public static void labelNode(DiseaseModelLabel dml, PopulationModelLabel populationModelLabel, Node node) {
        dml.setPopulationLabel(populationModelLabel.getPopulationLabel());
        dml.setPopulationModelLabel(populationModelLabel);
        node.getLabels().add((Object)dml);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 15: {
                if (resolve) {
                    return this.getPopulationLabel();
                }
                return this.basicGetPopulationLabel();
            }
            case 16: {
                if (resolve) {
                    return this.getPopulationModelLabel();
                }
                return this.basicGetPopulationModelLabel();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 15: {
                this.setPopulationLabel((PopulationLabel)newValue);
                return;
            }
            case 16: {
                this.setPopulationModelLabel((PopulationModelLabel)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 15: {
                this.setPopulationLabel(null);
                return;
            }
            case 16: {
                this.setPopulationModelLabel(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 15: {
                return this.populationLabel != null;
            }
            case 16: {
                return this.populationModelLabel != null;
            }
        }
        return super.eIsSet(featureID);
    }

    public boolean sane() {
        boolean retValue = super.sane();
        assert (retValue);
        return retValue;
    }
}

