/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.views.geographic.map;

import org.eclipse.emf.common.util.EList;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.graph.NodeLabel;
import org.eclipse.stem.definitions.adapters.spatial.geo.LatLong;
import org.eclipse.stem.definitions.labels.AreaLabel;
import org.eclipse.stem.definitions.nodes.Region;
import org.eclipse.stem.ui.views.geographic.map.StemPolygonTransform;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class StemPolygon
implements Comparable<StemPolygon> {
    private static final int LATITUDE_DIRECTION = -1;
    private static final long serialVersionUID = 1L;
    private static final int scalingFactorForData = 1000000;
    private transient Identifiable identifiable;
    public int[] points = null;
    public int[] transformedPoints = null;
    private int minX = Integer.MAX_VALUE;
    private int minY = Integer.MAX_VALUE;
    private int maxX = Integer.MIN_VALUE;
    private int maxY = Integer.MIN_VALUE;
    public double area = -1.0;

    public StemPolygon() {
    }

    public StemPolygon(LatLong.Segment latLongSegment, Identifiable identifiable) {
        this.identifiable = identifiable;
        int size = latLongSegment.size();
        this.points = new int[2 * size];
        int i = 0;
        int pointsIndex = 0;
        while (i < size) {
            this.addPoint(latLongSegment.longitude(i), latLongSegment.latitude(i), pointsIndex);
            ++i;
            pointsIndex += 2;
        }
        if (identifiable != null && identifiable instanceof Region) {
            Region r = (Region)identifiable;
            EList labs = r.getLabels();
            int i2 = 0;
            while (i2 < labs.size()) {
                NodeLabel lab = (NodeLabel)labs.get(i2);
                if (lab instanceof AreaLabel) {
                    AreaLabel al = (AreaLabel)lab;
                    this.area = al.getCurrentAreaValue().getArea();
                    break;
                }
                ++i2;
            }
        }
    }

    @Override
    public int compareTo(StemPolygon otherP) {
        int BEFORE = -1;
        boolean AFTER = true;
        if (otherP.area < this.area) {
            return -1;
        }
        if (otherP.area > this.area) {
            return 1;
        }
        return -1;
    }

    private void addPoint(double longitude, double latitude, int pointsIndex) {
        int x = (int)(longitude * 1000000.0);
        int y = (int)(latitude * 1000000.0 * -1.0);
        this.points[pointsIndex] = x;
        this.points[pointsIndex + 1] = y;
        this.maxX = Math.max(x, this.maxX);
        this.maxY = Math.max(y, this.maxY);
        this.minX = Math.min(x, this.minX);
        this.minY = Math.min(y, this.minY);
    }

    public void setPointsTransformer(StemPolygonTransform pointsTransformer) {
        this.transformedPoints = new int[this.getNumberOfPoints() * 2];
        int i = 0;
        while (i < this.getNumberOfPoints()) {
            int xBefore = this.points[2 * i];
            int yBefore = this.points[2 * i + 1];
            int xAfter = (int)((double)xBefore * pointsTransformer.getScale() + pointsTransformer.getOffsetX());
            int yAfter = (int)((double)yBefore * pointsTransformer.getScale() + pointsTransformer.getOffsetY());
            this.transformedPoints[2 * i] = xAfter;
            this.transformedPoints[2 * i + 1] = yAfter;
            ++i;
        }
    }

    public double unScaleLongitude(double longitude) {
        return longitude / 1000000.0;
    }

    public double unScaleLatitude(double latitude) {
        return latitude / 1000000.0 * -1.0;
    }

    public String getTitle() {
        return this.identifiable.getDublinCore().getTitle();
    }

    public final Identifiable getIdentifiable() {
        return this.identifiable;
    }

    public final void setIdentifiable(Identifiable identifiable) {
        this.identifiable = identifiable;
    }

    public Rectangle getBounds() {
        if (this.minX == Integer.MAX_VALUE && this.maxY == Integer.MIN_VALUE) {
            return null;
        }
        Rectangle bounds = new Rectangle(this.minX, this.minY, this.maxX - this.minX, this.maxY - this.minY);
        return bounds;
    }

    public boolean containsPoint(Point point) {
        return this.containsPoint(point.x, point.y);
    }

    public boolean containsPoint(int x, int y) {
        boolean isInside = false;
        int numOfPoints = this.points.length / 2;
        int i = 0;
        int j = (numOfPoints - 1) * 2;
        while (i < this.points.length - 1) {
            if ((this.points[i + 1] <= y && y < this.points[j + 1] || this.points[j + 1] <= y && y < this.points[i + 1]) && x < (this.points[j] - this.points[i]) * (y - this.points[i + 1]) / (this.points[j + 1] - this.points[i + 1]) + this.points[i]) {
                isInside = !isInside;
            }
            j = i;
            i += 2;
        }
        return isInside;
    }

    public int getNumberOfPoints() {
        if (this.points == null) {
            return 0;
        }
        return this.points.length / 2;
    }

    public double getNonScaledLatitude(int i) {
        return (double)this.points[2 * i + 1] / 1000000.0;
    }

    public double getNonScaledLongitude(int i) {
        return (double)this.points[2 * i] / 1000000.0 * -1.0;
    }

    public static double getUnscaledLatitude(int latValue) {
        return (double)latValue / 1000000.0;
    }

    public static double getUnscaledLongitude(int longValue) {
        return (double)longValue / 1000000.0 * -1.0;
    }
}

