/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.wizards;

import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.stem.diseasemodels.standard.DiseaseModel;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseInitializer;
import org.eclipse.stem.diseasemodels.standard.StandardFactory;
import org.eclipse.stem.diseasemodels.standard.impl.DiseaseModelImpl;
import org.eclipse.stem.ui.widgets.LocationPickerDialog;
import org.eclipse.stem.ui.wizards.DiseaseWizardMessages;
import org.eclipse.stem.ui.wizards.NewIdentifiablePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class NewStandardDiseaseInitializerPage
extends NewIdentifiablePage {
    private DiseaseModel target;
    private Composite outerComposite;
    private Combo populationBox;
    private Composite valuesComposite;
    private EList<Label> valueLabels;
    private EList<Text> valueTexts;
    private Button useFractionsButton;
    private Text locationText;
    private URI locationURI;

    protected NewStandardDiseaseInitializerPage(DiseaseModel target) {
        super(DiseaseWizardMessages.getString("NStandardDiseaseInitializerWiz.page_title"));
        this.setTitle(DiseaseWizardMessages.getString("NStandardDiseaseInitializerWiz.page_title"));
        this.setDescription(DiseaseWizardMessages.getString("NStandardDiseaseInitializerWiz.page_description"));
        this.target = target;
        this.valueLabels = new BasicEList();
        this.valueTexts = new BasicEList();
    }

    protected Composite createSpecificComposite(Composite parent) {
        this.outerComposite = new Composite(parent, 0);
        this.outerComposite.setLayout((Layout)new GridLayout(2, true));
        Label populationLabel = new Label(this.outerComposite, 0);
        populationLabel.setLayoutData((Object)new GridData(1, 4, true, false));
        populationLabel.setText(DiseaseWizardMessages.getString("NInitializerWiz.population"));
        this.populationBox = new Combo(this.outerComposite, 8);
        this.populationBox.setLayoutData((Object)new GridData(4, 4, true, false));
        EList populations = this.target.getAllLabelIdentifiers();
        for (String p : populations) {
            this.populationBox.add(p);
        }
        this.populationBox.addModifyListener(this.projectValidator);
        this.populationBox.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewStandardDiseaseInitializerPage.this.removeInitializerFields(NewStandardDiseaseInitializerPage.this.outerComposite);
                NewStandardDiseaseInitializerPage.this.addInitializerFields(NewStandardDiseaseInitializerPage.this.outerComposite);
            }
        });
        this.valuesComposite = new Composite(this.outerComposite, 0);
        this.valuesComposite.setLayout((Layout)new GridLayout(2, true));
        this.valuesComposite.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        Label percentageLabel = new Label(this.outerComposite, 0);
        percentageLabel.setLayoutData((Object)new GridData(1, 4, true, false));
        percentageLabel.setText(DiseaseWizardMessages.getString("NInitializerWiz.valueType"));
        Composite radioComposite = new Composite(this.outerComposite, 2048);
        radioComposite.setLayout((Layout)new FillLayout(256));
        radioComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        Button useAbsoluteButton = new Button(radioComposite, 16);
        useAbsoluteButton.setText(DiseaseWizardMessages.getString("NInitializerWiz.absolute"));
        useAbsoluteButton.setSelection(true);
        this.useFractionsButton = new Button(radioComposite, 16);
        this.useFractionsButton.setText(DiseaseWizardMessages.getString("NInitializerWiz.fractions"));
        this.useFractionsButton.setSelection(false);
        this.useFractionsButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                NewStandardDiseaseInitializerPage.this.setValuesToDefault();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button locationButton = new Button(this.outerComposite, 8);
        locationButton.setLayoutData((Object)new GridData(1, 4, true, false));
        locationButton.setText(DiseaseWizardMessages.getString("NInitializerWiz.location"));
        locationButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                LocationPickerDialog lpDialog = new LocationPickerDialog(NewStandardDiseaseInitializerPage.this.getShell(), 0, DiseaseWizardMessages.getString("NInfWizPickLocTitle"), NewStandardDiseaseInitializerPage.this.locationText.getText(), NewStandardDiseaseInitializerPage.this.getSelectedProject());
                Object[] ret = lpDialog.open();
                if (ret != null) {
                    NewStandardDiseaseInitializerPage.this.locationText.setText((String)ret[0]);
                    NewStandardDiseaseInitializerPage.this.locationURI = (URI)ret[1];
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        this.locationText = new Text(this.outerComposite, 133120);
        this.locationText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.locationText.setEditable(false);
        this.locationText.addModifyListener(this.projectValidator);
        return this.outerComposite;
    }

    private void addInitializerFields(Composite parent) {
        String population = this.populationBox.getText();
        EList attributes = this.target.createDiseaseModelLabelValue(population).eClass().getEAllAttributes();
        DiseaseModelImpl diseaseImpl = (DiseaseModelImpl)this.target;
        for (EAttribute a : attributes) {
            if (!a.isChangeable() || DiseaseModelImpl.isDiseaseDeaths((EAttribute)a) || DiseaseModelImpl.isIncidence((EAttribute)a)) continue;
            Label label = new Label(this.valuesComposite, 0);
            label.setLayoutData((Object)new GridData(1, 4, true, false));
            label.setText(a.getName());
            this.valueLabels.add((Object)label);
            Text text = new Text(this.valuesComposite, 133120);
            text.setLayoutData((Object)new GridData(4, 4, true, false));
            this.valueTexts.add((Object)text);
            if (a.getName().equals("s")) {
                text.setEditable(false);
            } else {
                text.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        if (NewStandardDiseaseInitializerPage.this.useFractionsButton.getSelection()) {
                            double v = 1.0 - NewStandardDiseaseInitializerPage.this.addFractions();
                            for (Text t : NewStandardDiseaseInitializerPage.this.valueTexts) {
                                if (t.getEditable()) continue;
                                t.setText(String.valueOf(v));
                                break;
                            }
                        }
                    }
                });
            }
            this.setValuesToDefault();
        }
        for (Text text : this.valueTexts) {
            text.addModifyListener(this.projectValidator);
        }
        this.updateGUI();
    }

    private void removeInitializerFields(Composite parent) {
        for (Label l : this.valueLabels) {
            l.dispose();
        }
        for (Text t : this.valueTexts) {
            t.dispose();
        }
        this.valueLabels.clear();
        this.valueTexts.clear();
        this.updateGUI();
    }

    protected StandardDiseaseInitializer getStandardDiseaseInitializer() {
        StandardDiseaseInitializer init = StandardFactory.eINSTANCE.createStandardDiseaseInitializer();
        init.setDiseaseName(this.target.getDiseaseName());
        init.setTargetISOKey(this.locationText.getText());
        init.setTargetURI(this.locationURI);
        init.setPopulationIdentifier(this.populationBox.getText());
        init.setUseFractions(this.useFractionsButton.getSelection());
        init.getCompartments().clear();
        init.getCompartmentValues().clear();
        for (Label l : this.valueLabels) {
            init.getCompartments().add((Object)l.getText());
        }
        for (Text t : this.valueTexts) {
            if (!this.useFractionsButton.getSelection() && !t.getEditable()) {
                init.getCompartmentValues().add((Object)0.0);
                continue;
            }
            init.getCompartmentValues().add((Object)Double.parseDouble(t.getText()));
        }
        return init;
    }

    public boolean validatePage() {
        if (!super.validatePage()) {
            return false;
        }
        if (this.populationBox.getText().isEmpty()) {
            this.setErrorMessage(DiseaseWizardMessages.getString("NInitializerWiz.population.missing"));
            return false;
        }
        if (!this.validateValues()) {
            this.setErrorMessage(DiseaseWizardMessages.getString("NInitializerWiz.values.invalid"));
            return false;
        }
        return true;
    }

    private double addFractions() {
        double sum = 0.0;
        for (Text t : this.valueTexts) {
            double v = 0.0;
            if (!t.getEditable()) continue;
            try {
                v = Double.parseDouble(t.getText());
            }
            catch (NumberFormatException e) {
                return -1.0;
            }
            if (v < 0.0 || v > 1.0) {
                return -1.0;
            }
            sum += v;
        }
        if (sum < 0.0 || sum > 1.0) {
            return -1.0;
        }
        return sum;
    }

    private void setValuesToDefault() {
        for (Text t : this.valueTexts) {
            if (t.getEditable()) {
                t.setText("0.0");
                continue;
            }
            if (this.useFractionsButton.getSelection()) {
                t.setText("1.0");
                continue;
            }
            t.setText("");
        }
    }

    private boolean validateValues() {
        if (this.useFractionsButton.getSelection()) {
            return this.addFractions() != -1.0;
        }
        for (Text t : this.valueTexts) {
            if (!t.getEditable()) continue;
            double v = 0.0;
            try {
                v = Double.parseDouble(t.getText());
            }
            catch (NumberFormatException e) {
                return false;
            }
            if (!(v < 0.0)) continue;
            return false;
        }
        return true;
    }

    private void updateGUI() {
        this.outerComposite.getParent().pack();
        this.outerComposite.getParent().getParent().layout();
        this.outerComposite.getParent().getParent().getParent().getParent().layout();
    }
}

