/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.gis.shp.type;

public class Part {
    protected double[] xs;
    protected double[] ys;
    protected double[] zs;
    protected double[] ms;
    protected int pointCount;
    protected int partType;

    public Part(double[][] points) {
        this(5, points);
    }

    public Part(int partType, double[][] points) {
        this.xs = points[0];
        this.ys = points[1];
        this.partType = partType;
        this.pointCount = this.xs.length;
    }

    public int getPointCount() {
        return this.pointCount;
    }

    public void setZs(double[] zs) {
        this.zs = zs;
    }

    public void setMs(double[] ms) {
        this.ms = ms;
    }

    public double[] getZs() {
        return this.zs;
    }

    public double[] getMs() {
        return this.ms;
    }

    public double[] getYs() {
        return this.ys;
    }

    public double[] getXs() {
        return this.xs;
    }

    public int getPartType() {
        return this.partType;
    }

    public String arrayToString(double[] values, int maxLen) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        int idx = 0;
        while (idx < Math.min(maxLen, values.length)) {
            sb.append(values[idx]);
            sb.append(", ");
            ++idx;
        }
        if (maxLen < values.length) {
            sb.append("...");
        } else {
            sb.deleteCharAt(sb.length() - 1);
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append("]");
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Part 2D (");
        sb.append(this.getPointCount());
        sb.append(") [\n");
        if (this.xs != null) {
            sb.append("Xs: ");
            sb.append(this.arrayToString(this.xs, 10));
            sb.append("\n");
        }
        if (this.ys != null) {
            sb.append("Ys: ");
            sb.append(this.arrayToString(this.ys, 10));
            sb.append("\n");
        }
        if (this.zs != null) {
            sb.append("Zs: ");
            sb.append(this.arrayToString(this.zs, 10));
            sb.append("\n");
        }
        if (this.ms != null) {
            sb.append("Ms: ");
            sb.append(this.arrayToString(this.ms, 10));
            sb.append("\n");
        }
        sb.append("]");
        return sb.toString();
    }
}

