/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.graphgenerators.adapters.graphgeneratorpropertyeditor;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.stem.core.STEMURI;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.graphgenerators.AreaUnit;
import org.eclipse.stem.graphgenerators.GraphGenerator;
import org.eclipse.stem.graphgenerators.GraphgeneratorsFactory;
import org.eclipse.stem.graphgenerators.GraphgeneratorsPackage;
import org.eclipse.stem.graphgenerators.LatticeGraphGenerator;
import org.eclipse.stem.graphgenerators.MigrationEdgeGraphGenerator;
import org.eclipse.stem.graphgenerators.MigrationShapefile;
import org.eclipse.stem.graphgenerators.MixingEdgeGraphGenerator;
import org.eclipse.stem.graphgenerators.PajekNetGraphGenerator;
import org.eclipse.stem.graphgenerators.PlateCarreeGlobeGraphGenerator;
import org.eclipse.stem.graphgenerators.RegionShapefile;
import org.eclipse.stem.graphgenerators.RoadShapefile;
import org.eclipse.stem.graphgenerators.SeasonalMigrationEdgeGraphGenerator;
import org.eclipse.stem.graphgenerators.Shapefile;
import org.eclipse.stem.graphgenerators.ShapefileGraphGenerator;
import org.eclipse.stem.graphgenerators.SquareLatticeGraphGenerator;
import org.eclipse.stem.graphgenerators.impl.Reader;
import org.eclipse.stem.ui.editors.GenericPropertyEditor;
import org.eclipse.stem.ui.graphgenerators.adapters.graphgeneratorpropertyeditor.TableDialog;
import org.eclipse.stem.ui.graphgenerators.wizards.Messages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class GraphGeneratorPropertyEditor
extends GenericPropertyEditor
implements SelectionListener,
ModifyListener {
    private ModifyListener projectValidator;
    private List<Shapefile> shapefiles;
    private String selectedDir;
    private List<String> columnNames;
    private List<List<String>> data;
    private Button shapeButton;
    private org.eclipse.swt.widgets.List shapeFileList;
    private Group typeGroup;
    private Button regionButton;
    private Button roadButton;
    private Button migrationButton;
    private Button showDataButton;
    private Group dataGroup;
    private Text regionIDText;
    private Combo regionIDCombo;
    private Text regionAreaText;
    private Combo regionAreaCombo;
    private Combo regionAreaUnitCombo;
    private List<Text> regionPopNameTexts;
    private List<Combo> regionPopNameCombos;
    private List<Text> regionPopSizeTexts;
    private List<Combo> regionPopSizeCombos;
    private Button regionAddPopButton;
    private Button regionRemovePopButton;
    private Text roadIDText;
    private Combo roadIDCombo;
    private Text roadClassText;
    private Combo roadClassCombo;
    private Text migrationIDText;
    private Combo migrationIDCombo;
    private Text migrationPopulationText;
    private Combo migrationPopulationCombo;
    private Text migrationRateText;
    private Combo migrationRateCombo;

    public GraphGeneratorPropertyEditor(Composite parent, int style, IProject project) {
        super(parent, style, project);
    }

    public GraphGeneratorPropertyEditor(Composite parent, int style, GraphGenerator graphGenerator, ModifyListener projectValidator, IProject project) {
        super(parent, style, (Identifiable)graphGenerator, projectValidator, project);
        this.projectValidator = projectValidator;
        if (graphGenerator instanceof ShapefileGraphGenerator) {
            this.shapefiles = new ArrayList<Shapefile>();
            this.shapeButton = new Button((Composite)this, 8);
            this.shapeButton.setText(Messages.getString("selectShapefiles"));
            this.shapeButton.addSelectionListener((SelectionListener)this);
            this.shapeButton.setLayoutData((Object)new GridData(16384, 128, true, true, 3, 1));
            Label listLabel = new Label((Composite)this, 0);
            listLabel.setText(String.valueOf(Messages.getString("shapefileListHelp")) + ":");
            listLabel.setLayoutData((Object)new GridData(16384, 1024, true, true, 3, 1));
            this.shapeFileList = new org.eclipse.swt.widgets.List((Composite)this, 2564);
            this.shapeFileList.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
            this.shapeFileList.addSelectionListener((SelectionListener)this);
            this.regionPopNameTexts = new ArrayList<Text>();
            this.regionPopNameCombos = new ArrayList<Combo>();
            this.regionPopSizeTexts = new ArrayList<Text>();
            this.regionPopSizeCombos = new ArrayList<Combo>();
        }
    }

    public Graph getGraph(GraphGenerator graphGenerator) {
        String locationString;
        EAttribute location;
        String populationString;
        EAttribute population;
        EAttribute rateType;
        EAttribute rate;
        if (graphGenerator instanceof LatticeGraphGenerator) {
            LatticeGraphGenerator lattice = (LatticeGraphGenerator)graphGenerator;
            EAttribute nearest = GraphgeneratorsPackage.Literals.LATTICE_GRAPH_GENERATOR__USE_NEAREST_NEIGHBORS;
            EAttribute nextNearest = GraphgeneratorsPackage.Literals.LATTICE_GRAPH_GENERATOR__USE_NEXT_NEAREST_NEIGHBORS;
            EAttribute periodic = GraphgeneratorsPackage.Literals.LATTICE_GRAPH_GENERATOR__PERIODIC_BOUNDARIES;
            lattice.setUseNearestNeighbors(((Button)this.booleanMap.get(nearest)).getSelection());
            lattice.setUseNextNearestNeighbors(((Button)this.booleanMap.get(nextNearest)).getSelection());
            lattice.setPeriodicBoundaries(((Button)this.booleanMap.get(periodic)).getSelection());
        }
        if (graphGenerator instanceof SquareLatticeGraphGenerator) {
            SquareLatticeGraphGenerator squareLattice = (SquareLatticeGraphGenerator)graphGenerator;
            EAttribute xSize = GraphgeneratorsPackage.Literals.SQUARE_LATTICE_GRAPH_GENERATOR__XSIZE;
            EAttribute ySize = GraphgeneratorsPackage.Literals.SQUARE_LATTICE_GRAPH_GENERATOR__YSIZE;
            EAttribute area = GraphgeneratorsPackage.Literals.SQUARE_LATTICE_GRAPH_GENERATOR__AREA;
            squareLattice.setXSize(Integer.parseInt(((Text)this.map.get(xSize)).getText()));
            squareLattice.setYSize(Integer.parseInt(((Text)this.map.get(ySize)).getText()));
            squareLattice.setArea(Double.parseDouble(((Text)this.map.get(area)).getText()));
        }
        if (graphGenerator instanceof PlateCarreeGlobeGraphGenerator) {
            PlateCarreeGlobeGraphGenerator plateCarree = (PlateCarreeGlobeGraphGenerator)graphGenerator;
            EAttribute angularStep = GraphgeneratorsPackage.Literals.PLATE_CARREE_GLOBE_GRAPH_GENERATOR__ANGULAR_STEP;
            EAttribute radius = GraphgeneratorsPackage.Literals.PLATE_CARREE_GLOBE_GRAPH_GENERATOR__RADIUS;
            plateCarree.setAngularStep(Integer.parseInt(((Text)this.map.get(angularStep)).getText()));
            plateCarree.setRadius(Double.parseDouble(((Text)this.map.get(radius)).getText()));
        }
        if (graphGenerator instanceof MigrationEdgeGraphGenerator) {
            MigrationEdgeGraphGenerator migrationEdge = (MigrationEdgeGraphGenerator)graphGenerator;
            rate = GraphgeneratorsPackage.Literals.MIGRATION_EDGE_GRAPH_GENERATOR__MIGRATION_RATE;
            rateType = GraphgeneratorsPackage.Literals.MIGRATION_EDGE_GRAPH_GENERATOR__USE_ABSOLUTE_VALUES;
            population = GraphgeneratorsPackage.Literals.MIGRATION_EDGE_GRAPH_GENERATOR__POPULATION;
            populationString = ((Text)this.map.get(population)).getText().trim();
            location = GraphgeneratorsPackage.Literals.MIGRATION_EDGE_GRAPH_GENERATOR__LOCATION;
            locationString = ((Text)this.map.get(location)).getText().trim();
            migrationEdge.setMigrationRate(Double.parseDouble(((Text)this.map.get(rate)).getText()));
            migrationEdge.setUseAbsoluteValues(((Button)this.booleanMap.get(rateType)).getSelection());
            if (this.project != null) {
                migrationEdge.setProject(this.project);
            }
            if (!populationString.isEmpty()) {
                migrationEdge.setPopulation(populationString);
            }
            if (!locationString.isEmpty()) {
                migrationEdge.setLocation(STEMURI.createURI((String)locationString));
            }
        }
        if (graphGenerator instanceof MixingEdgeGraphGenerator) {
            MixingEdgeGraphGenerator mixingEdge = (MixingEdgeGraphGenerator)graphGenerator;
            rate = GraphgeneratorsPackage.Literals.MIXING_EDGE_GRAPH_GENERATOR__MIXING_RATE;
            rateType = GraphgeneratorsPackage.Literals.MIXING_EDGE_GRAPH_GENERATOR__USE_ABSOLUTE_VALUES;
            population = GraphgeneratorsPackage.Literals.MIXING_EDGE_GRAPH_GENERATOR__POPULATION;
            populationString = ((Text)this.map.get(population)).getText().trim();
            location = GraphgeneratorsPackage.Literals.MIXING_EDGE_GRAPH_GENERATOR__LOCATION;
            locationString = ((Text)this.map.get(location)).getText().trim();
            mixingEdge.setMixingRate(Double.parseDouble(((Text)this.map.get(rate)).getText()));
            mixingEdge.setUseAbsoluteValues(((Button)this.booleanMap.get(rateType)).getSelection());
            if (this.project != null) {
                mixingEdge.setProject(this.project);
            }
            if (!populationString.isEmpty()) {
                mixingEdge.setPopulation(populationString);
            }
            if (!locationString.isEmpty()) {
                mixingEdge.setLocation(STEMURI.createURI((String)locationString));
            }
        }
        if (graphGenerator instanceof PajekNetGraphGenerator) {
            PajekNetGraphGenerator pajek = (PajekNetGraphGenerator)graphGenerator;
            EAttribute file = GraphgeneratorsPackage.Literals.PAJEK_NET_GRAPH_GENERATOR__DATA_FILE;
            EAttribute scaling = GraphgeneratorsPackage.Literals.PAJEK_NET_GRAPH_GENERATOR__SCALING_FACTOR;
            EAttribute size = GraphgeneratorsPackage.Literals.PAJEK_NET_GRAPH_GENERATOR__NODE_SIZE;
            EAttribute regionURI = GraphgeneratorsPackage.Literals.PAJEK_NET_GRAPH_GENERATOR__USE_REGION_URI;
            EAttribute moveToContainer = GraphgeneratorsPackage.Literals.PAJEK_NET_GRAPH_GENERATOR__MOVE_NODES_TO_CONTAINERS;
            EAttribute useAbsoluteValues = GraphgeneratorsPackage.Literals.PAJEK_NET_GRAPH_GENERATOR__USE_ABSOLUTE_RATES;
            String fileString = ((Text)this.map.get(file)).getText().trim();
            pajek.setScalingFactor(Double.parseDouble(((Text)this.map.get(scaling)).getText()));
            pajek.setNodeSize(Double.parseDouble(((Text)this.map.get(size)).getText()));
            pajek.setUseRegionURI(((Button)this.booleanMap.get(regionURI)).getSelection());
            pajek.setMoveNodesToContainers(((Button)this.booleanMap.get(moveToContainer)).getSelection());
            pajek.setUseAbsoluteRates(((Button)this.booleanMap.get(useAbsoluteValues)).getSelection());
            pajek.setProject(this.project);
            if (!fileString.isEmpty()) {
                pajek.setDataFile(fileString);
            }
        }
        if (graphGenerator instanceof SeasonalMigrationEdgeGraphGenerator) {
            SeasonalMigrationEdgeGraphGenerator migrationEdgeGG = (SeasonalMigrationEdgeGraphGenerator)graphGenerator;
            rate = GraphgeneratorsPackage.Literals.SEASONAL_MIGRATION_EDGE_GRAPH_GENERATOR__MIGRATION_RATE;
            EAttribute population2 = GraphgeneratorsPackage.Literals.SEASONAL_MIGRATION_EDGE_GRAPH_GENERATOR__POPULATION;
            EAttribute toleranceAngleA = GraphgeneratorsPackage.Literals.SEASONAL_MIGRATION_EDGE_GRAPH_GENERATOR__TOLERANCE_ANGLE_A;
            EAttribute toleranceAngleB = GraphgeneratorsPackage.Literals.SEASONAL_MIGRATION_EDGE_GRAPH_GENERATOR__TOLERANCE_ANGLE_B;
            String populationString2 = ((Text)this.map.get(population2)).getText().trim();
            EAttribute locationA = GraphgeneratorsPackage.Literals.SEASONAL_MIGRATION_EDGE_GRAPH_GENERATOR__LOCATION_A;
            EAttribute locationB = GraphgeneratorsPackage.Literals.SEASONAL_MIGRATION_EDGE_GRAPH_GENERATOR__LOCATION_B;
            Text locationAText = (Text)this.map.get(locationA);
            String locationAString = "";
            if (locationAText != null) {
                locationAString = locationAText.getText().trim();
            }
            Text locationBText = (Text)this.map.get(locationB);
            String locationBString = "";
            if (locationBText != null) {
                locationBString = locationBText.getText().trim();
            }
            String toleranceAngleAString = ((Text)this.map.get(toleranceAngleA)).getText();
            String toleranceAngleBString = ((Text)this.map.get(toleranceAngleB)).getText();
            migrationEdgeGG.setMigrationRate(Double.parseDouble(((Text)this.map.get(rate)).getText()));
            if (this.project != null) {
                migrationEdgeGG.setProject(this.project);
            }
            if (!populationString2.isEmpty()) {
                migrationEdgeGG.setPopulation(populationString2);
            }
            if (!locationAString.isEmpty()) {
                migrationEdgeGG.setLocationA(STEMURI.createURI((String)locationAString));
            }
            if (!locationBString.isEmpty()) {
                migrationEdgeGG.setLocationB(STEMURI.createURI((String)locationBString));
            }
            migrationEdgeGG.setToleranceAngleA(Double.parseDouble(toleranceAngleAString));
            migrationEdgeGG.setToleranceAngleB(Double.parseDouble(toleranceAngleBString));
        }
        if (graphGenerator instanceof ShapefileGraphGenerator) {
            ShapefileGraphGenerator shapefile = (ShapefileGraphGenerator)graphGenerator;
            shapefile.getShapefiles().clear();
            shapefile.getShapefiles().addAll(this.shapefiles);
        }
        return graphGenerator.getGraph();
    }

    public boolean validate() {
        Text text;
        boolean retValue = true;
        if (retValue && (text = (Text)this.map.get(GraphgeneratorsPackage.Literals.SQUARE_LATTICE_GRAPH_GENERATOR__XSIZE)) != null) {
            boolean bl = retValue = !text.getText().equals("");
            if (!retValue) {
                this.errorMessage = Messages.getString("NGGWizErr1");
            } else {
                retValue = this.isValidIntValue(text.getText(), 1);
                if (!retValue) {
                    this.errorMessage = Messages.getString("NGGWizErr2");
                }
            }
        }
        if (retValue && (text = (Text)this.map.get(GraphgeneratorsPackage.Literals.SQUARE_LATTICE_GRAPH_GENERATOR__YSIZE)) != null) {
            boolean bl = retValue = !text.getText().equals("");
            if (!retValue) {
                this.errorMessage = Messages.getString("NGGWizErr3");
            } else {
                retValue = this.isValidIntValue(text.getText(), 1);
                if (!retValue) {
                    this.errorMessage = Messages.getString("NGGWizErr4");
                }
            }
        }
        if (retValue && (text = (Text)this.map.get(GraphgeneratorsPackage.Literals.SQUARE_LATTICE_GRAPH_GENERATOR__AREA)) != null) {
            boolean bl = retValue = !text.getText().equals("");
            if (!retValue) {
                this.errorMessage = Messages.getString("NGGWizErr8");
            } else {
                retValue = this.isValidValue(text.getText(), 0.0);
                if (!retValue) {
                    this.errorMessage = Messages.getString("NGGWizErr9");
                }
            }
        }
        if (retValue && (text = (Text)this.map.get(GraphgeneratorsPackage.Literals.SQUARE_LATTICE_GRAPH_GENERATOR__XSIZE)) != null) {
            int xsize = Integer.parseInt(text.getText());
            text = (Text)this.map.get(GraphgeneratorsPackage.Literals.SQUARE_LATTICE_GRAPH_GENERATOR__YSIZE);
            int ysize = Integer.parseInt(text.getText());
            text = (Text)this.map.get(GraphgeneratorsPackage.Literals.SQUARE_LATTICE_GRAPH_GENERATOR__AREA);
            double area = Double.parseDouble(text.getText());
            double scale = Math.sqrt(area);
            if ((double)xsize * scale / 111.13508055555556 > 360.0 || (double)ysize * scale / 111.13508055555556 > 180.0) {
                retValue = false;
                this.errorMessage = Messages.getString("NGGWizErr10");
            }
        }
        if (retValue && (text = (Text)this.map.get(GraphgeneratorsPackage.Literals.MIGRATION_EDGE_GRAPH_GENERATOR__POPULATION)) != null) {
            boolean bl = retValue = !text.getText().equals("");
            if (!retValue) {
                this.errorMessage = Messages.getString("NGGWizErr5");
            }
        }
        if (retValue && (text = (Text)this.map.get(GraphgeneratorsPackage.Literals.PLATE_CARREE_GLOBE_GRAPH_GENERATOR__ANGULAR_STEP)) != null && !(retValue = this.isValidIntValue(text.getText(), 1))) {
            this.errorMessage = Messages.getString("NGGWizErr11");
        }
        if (retValue && (text = (Text)this.map.get(GraphgeneratorsPackage.Literals.PLATE_CARREE_GLOBE_GRAPH_GENERATOR__RADIUS)) != null && !(retValue = this.isValidDoubleValue(text.getText(), 1.0))) {
            this.errorMessage = Messages.getString("NGGWizErr12");
        }
        if (retValue && (text = (Text)this.map.get(GraphgeneratorsPackage.Literals.MIGRATION_EDGE_GRAPH_GENERATOR__POPULATION)) != null) {
            boolean bl = retValue = !text.getText().equals("");
            if (!retValue) {
                this.errorMessage = Messages.getString("NGGWizErr5");
            }
        }
        if (retValue && (text = (Text)this.map.get(GraphgeneratorsPackage.Literals.MIGRATION_EDGE_GRAPH_GENERATOR__MIGRATION_RATE)) != null) {
            try {
                double rate = Double.parseDouble(text.getText());
                if (rate < 0.0) {
                    retValue = false;
                    this.errorMessage = Messages.getString("NGGWizErr7");
                }
            }
            catch (Exception e) {
                retValue = false;
                this.errorMessage = Messages.getString("NGGWizErr6");
            }
            boolean bl = retValue = !text.getText().equals("");
            if (!retValue) {
                this.errorMessage = Messages.getString("NGGWizErr5");
            }
        }
        if (retValue && (text = (Text)this.map.get(GraphgeneratorsPackage.Literals.PAJEK_NET_GRAPH_GENERATOR__DATA_FILE)) != null) {
            File file = new File(text.getText());
            boolean bl = retValue = file != null && !file.isDirectory() && file.exists();
            if (!retValue) {
                this.errorMessage = Messages.getString("NGGWizErr13");
            }
        }
        if (retValue && this.shapeButton != null) {
            if (this.shapefiles.isEmpty()) {
                retValue = false;
                this.errorMessage = Messages.getString("NGGWizErr15");
            } else {
                boolean error = false;
                for (Shapefile s : this.shapefiles) {
                    MigrationShapefile ms;
                    if (s.getId().equals("")) {
                        error = true;
                        break;
                    }
                    if (s instanceof RegionShapefile) {
                        RegionShapefile rs = (RegionShapefile)s;
                        int i = 0;
                        while (i < rs.getPopulationNames().size()) {
                            if (((String)rs.getPopulationNames().get(i)).equals("") || ((String)rs.getPopulationSizes().get(i)).equals("")) {
                                error = true;
                                break;
                            }
                            ++i;
                        }
                        if (!error) continue;
                        break;
                    }
                    if (s instanceof RoadShapefile) {
                        if (!((RoadShapefile)s).getRoadClass().equals("")) continue;
                        error = true;
                        break;
                    }
                    if (!(s instanceof MigrationShapefile) || !(ms = (MigrationShapefile)s).getPopulationName().equals("") && !ms.getMigrationRate().equals("")) continue;
                    error = true;
                    break;
                }
                if (error) {
                    retValue = false;
                    this.errorMessage = Messages.getString("NGGWizErr16");
                }
            }
        }
        if (retValue && (text = (Text)this.map.get(GraphgeneratorsPackage.Literals.SEASONAL_MIGRATION_EDGE_GRAPH_GENERATOR__TOLERANCE_ANGLE_A)) != null) {
            try {
                double angle = Double.parseDouble(text.getText());
                if (angle < 5.0) {
                    retValue = false;
                    this.errorMessage = Messages.getString("NGGWizErr17");
                }
                if (angle > 179.0) {
                    retValue = false;
                    this.errorMessage = Messages.getString("NGGWizErr17");
                }
            }
            catch (Exception e) {
                retValue = false;
                this.errorMessage = Messages.getString("NGGWizErr17");
            }
        }
        if (retValue && (text = (Text)this.map.get(GraphgeneratorsPackage.Literals.SEASONAL_MIGRATION_EDGE_GRAPH_GENERATOR__TOLERANCE_ANGLE_B)) != null) {
            try {
                double angle = Double.parseDouble(text.getText());
                if (angle < 5.0) {
                    retValue = false;
                    this.errorMessage = Messages.getString("NGGWizErr17");
                }
                if (angle > 179.0) {
                    retValue = false;
                    this.errorMessage = Messages.getString("NGGWizErr17");
                }
            }
            catch (Exception e) {
                retValue = false;
                this.errorMessage = Messages.getString("NGGWizErr17");
            }
        }
        if (retValue && (text = (Text)this.map.get(GraphgeneratorsPackage.Literals.SEASONAL_MIGRATION_EDGE_GRAPH_GENERATOR__POPULATION)) != null) {
            boolean bl = retValue = !text.getText().equals("");
            if (!retValue) {
                this.errorMessage = Messages.getString("NGGWizErr5");
            }
        }
        if (retValue && (text = (Text)this.map.get(GraphgeneratorsPackage.Literals.SEASONAL_MIGRATION_EDGE_GRAPH_GENERATOR__MIGRATION_RATE)) != null) {
            try {
                double rate = Double.parseDouble(text.getText());
                if (rate < 0.0) {
                    retValue = false;
                    this.errorMessage = Messages.getString("NGGWizErr6");
                }
            }
            catch (Exception e) {
                retValue = false;
                this.errorMessage = Messages.getString("NGGWizErr6");
            }
            boolean bl = retValue = !text.getText().equals("");
            if (!retValue) {
                this.errorMessage = Messages.getString("NGGWizErr6");
            }
        }
        return retValue;
    }

    protected boolean isUserSpecifiedProperty(EStructuralFeature feature) {
        boolean retValue = false;
        EClass containingClass = feature.getEContainingClass();
        if (containingClass.getEPackage() == GraphgeneratorsPackage.eINSTANCE) {
            retValue = true;
        }
        if (containingClass == GraphgeneratorsPackage.Literals.SHAPEFILE_GRAPH_GENERATOR) {
            retValue = false;
        }
        return retValue;
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource() == this.shapeButton) {
            FileDialog fileDialog_shp = new FileDialog(new Shell(), 2);
            fileDialog_shp.setFilterPath(this.selectedDir);
            fileDialog_shp.setFilterExtensions(new String[]{"*.shp"});
            if (fileDialog_shp.open() != null) {
                this.selectedDir = fileDialog_shp.getFilterPath();
                this.shapeFileList.removeAll();
                this.shapefiles.clear();
                String[] stringArray = fileDialog_shp.getFileNames();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String fName = stringArray[n2];
                    RegionShapefile s = GraphgeneratorsFactory.eINSTANCE.createRegionShapefile();
                    s.setFileName(String.valueOf(fileDialog_shp.getFilterPath()) + "/" + fName);
                    s.setId("");
                    s.setArea("");
                    this.shapeFileList.add(fName);
                    this.shapefiles.add((Shapefile)s);
                    ++n2;
                }
                if (this.dataGroup != null) {
                    this.dataGroup.dispose();
                }
                if (this.showDataButton != null) {
                    this.showDataButton.dispose();
                }
                if (this.typeGroup != null) {
                    this.typeGroup.dispose();
                }
                this.shapeFileList.setSelection(0);
                this.updateSelection();
                this.updateUI();
                this.projectValidator.modifyText(null);
            }
        } else if (e.getSource() == this.shapeFileList) {
            this.updateSelection();
            this.updateUI();
        } else if (e.getSource() == this.showDataButton) {
            new TableDialog(this.getShell(), "", this.columnNames, this.data);
        } else if (e.getSource() == this.regionButton) {
            if (this.dataGroup != null) {
                this.dataGroup.dispose();
            }
            int i = this.shapeFileList.getSelectionIndex();
            RegionShapefile s = GraphgeneratorsFactory.eINSTANCE.createRegionShapefile();
            s.setFileName(this.shapefiles.get(i).getFileName());
            s.setId("");
            s.setArea("");
            this.shapefiles.set(i, (Shapefile)s);
            this.createRegionComposite();
            this.updateUI();
            this.projectValidator.modifyText(null);
        } else if (e.getSource() == this.roadButton) {
            if (this.dataGroup != null) {
                this.dataGroup.dispose();
            }
            int i = this.shapeFileList.getSelectionIndex();
            RoadShapefile s = GraphgeneratorsFactory.eINSTANCE.createRoadShapefile();
            s.setFileName(this.shapefiles.get(i).getFileName());
            s.setId("");
            s.setRoadClass("");
            this.shapefiles.set(i, (Shapefile)s);
            this.createRoadComposite();
            this.updateUI();
            this.projectValidator.modifyText(null);
        } else if (e.getSource() == this.migrationButton) {
            if (this.dataGroup != null) {
                this.dataGroup.dispose();
            }
            int i = this.shapeFileList.getSelectionIndex();
            MigrationShapefile s = GraphgeneratorsFactory.eINSTANCE.createMigrationShapefile();
            s.setFileName(this.shapefiles.get(i).getFileName());
            s.setId("");
            s.setPopulationName("");
            s.setMigrationRate("");
            this.shapefiles.set(i, (Shapefile)s);
            this.createMigrationComposite();
            this.updateUI();
            this.projectValidator.modifyText(null);
        } else if (e.getSource() == this.regionIDCombo) {
            String regionID = "column:" + this.columnNames.get(this.regionIDCombo.getSelectionIndex());
            this.regionIDText.setText(regionID);
            this.shapefiles.get(this.shapeFileList.getSelectionIndex()).setId(regionID);
            this.projectValidator.modifyText(null);
        } else if (e.getSource() == this.regionAreaCombo) {
            String regionArea = "column:" + this.columnNames.get(this.regionAreaCombo.getSelectionIndex());
            this.regionAreaText.setText(regionArea);
            ((RegionShapefile)this.shapefiles.get(this.shapeFileList.getSelectionIndex())).setArea(regionArea);
            this.projectValidator.modifyText(null);
        } else if (e.getSource() == this.regionAreaUnitCombo) {
            RegionShapefile s = (RegionShapefile)this.shapefiles.get(this.shapeFileList.getSelectionIndex());
            s.setAreaUnit(AreaUnit.get((String)this.regionAreaUnitCombo.getItem(this.regionAreaUnitCombo.getSelectionIndex())));
            this.projectValidator.modifyText(null);
        } else if (e.getSource() == this.regionAddPopButton) {
            RegionShapefile s = (RegionShapefile)this.shapefiles.get(this.shapeFileList.getSelectionIndex());
            s.getPopulationNames().add((Object)"");
            s.getPopulationSizes().add((Object)"");
            this.updateSelection();
            this.updateUI();
            this.projectValidator.modifyText(null);
        } else if (e.getSource() == this.regionRemovePopButton) {
            RegionShapefile s = (RegionShapefile)this.shapefiles.get(this.shapeFileList.getSelectionIndex());
            if (!s.getPopulationNames().isEmpty()) {
                s.getPopulationNames().remove((Object)"");
                s.getPopulationSizes().remove((Object)"");
                this.updateSelection();
                this.updateUI();
                this.projectValidator.modifyText(null);
            }
        } else if (e.getSource() == this.roadIDCombo) {
            String roadID = "column:" + this.columnNames.get(this.roadIDCombo.getSelectionIndex());
            this.roadIDText.setText(roadID);
            this.shapefiles.get(this.shapeFileList.getSelectionIndex()).setId(roadID);
            this.projectValidator.modifyText(null);
        } else if (e.getSource() == this.roadClassCombo) {
            String roadClass = "column:" + this.columnNames.get(this.roadClassCombo.getSelectionIndex());
            this.roadClassText.setText(roadClass);
            ((RoadShapefile)this.shapefiles.get(this.shapeFileList.getSelectionIndex())).setRoadClass(roadClass);
            this.projectValidator.modifyText(null);
        } else if (e.getSource() == this.migrationIDCombo) {
            String migrationID = "column:" + this.columnNames.get(this.migrationIDCombo.getSelectionIndex());
            this.migrationIDText.setText(migrationID);
            this.shapefiles.get(this.shapeFileList.getSelectionIndex()).setId(migrationID);
            this.projectValidator.modifyText(null);
        } else if (e.getSource() == this.migrationPopulationCombo) {
            String migrationPopulation = "column:" + this.columnNames.get(this.migrationPopulationCombo.getSelectionIndex());
            this.migrationPopulationText.setText(migrationPopulation);
            ((MigrationShapefile)this.shapefiles.get(this.shapeFileList.getSelectionIndex())).setPopulationName(migrationPopulation);
            this.projectValidator.modifyText(null);
        } else if (e.getSource() == this.migrationRateCombo) {
            String migrationRate = "column:" + this.columnNames.get(this.migrationRateCombo.getSelectionIndex());
            this.migrationRateText.setText(migrationRate);
            ((MigrationShapefile)this.shapefiles.get(this.shapeFileList.getSelectionIndex())).setMigrationRate(migrationRate);
            this.projectValidator.modifyText(null);
        } else if (this.regionPopNameCombos.contains(e.getSource())) {
            int i = this.regionPopNameCombos.indexOf(e.getSource());
            String popName = "column:" + this.columnNames.get(this.regionPopNameCombos.get(i).getSelectionIndex());
            this.regionPopNameTexts.get(i).setText(popName);
            ((RegionShapefile)this.shapefiles.get(this.shapeFileList.getSelectionIndex())).getPopulationNames().set(i, (Object)popName);
            this.projectValidator.modifyText(null);
        } else if (this.regionPopSizeCombos.contains(e.getSource())) {
            int i = this.regionPopSizeCombos.indexOf(e.getSource());
            String popSize = "column:" + this.columnNames.get(this.regionPopSizeCombos.get(i).getSelectionIndex());
            this.regionPopSizeTexts.get(i).setText(popSize);
            ((RegionShapefile)this.shapefiles.get(this.shapeFileList.getSelectionIndex())).getPopulationSizes().set(i, (Object)popSize);
            this.projectValidator.modifyText(null);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void modifyText(ModifyEvent e) {
        if (e.getSource() == this.regionAreaText) {
            int column = this.getColumnIndex(this.regionAreaText.getText());
            ((RegionShapefile)this.shapefiles.get(this.shapeFileList.getSelectionIndex())).setArea(this.regionAreaText.getText());
            if (column == -1) {
                this.regionAreaCombo.removeAll();
                this.regionAreaCombo.setItems(this.columnNames.toArray(new String[0]));
            } else {
                this.regionAreaCombo.select(column);
            }
        } else if (e.getSource() == this.roadClassText) {
            int column = this.getColumnIndex(this.roadClassText.getText());
            ((RoadShapefile)this.shapefiles.get(this.shapeFileList.getSelectionIndex())).setRoadClass(this.roadClassText.getText());
            if (column == -1) {
                this.roadClassCombo.removeAll();
                this.roadClassCombo.setItems(this.columnNames.toArray(new String[0]));
            } else {
                this.roadClassCombo.select(column);
            }
        } else if (e.getSource() == this.migrationPopulationText) {
            int column = this.getColumnIndex(this.migrationPopulationText.getText());
            ((MigrationShapefile)this.shapefiles.get(this.shapeFileList.getSelectionIndex())).setPopulationName(this.migrationPopulationText.getText());
            if (column == -1) {
                this.migrationPopulationCombo.removeAll();
                this.migrationPopulationCombo.setItems(this.columnNames.toArray(new String[0]));
            } else {
                this.migrationPopulationCombo.select(column);
            }
        } else if (e.getSource() == this.migrationRateText) {
            int column = this.getColumnIndex(this.migrationRateText.getText());
            ((MigrationShapefile)this.shapefiles.get(this.shapeFileList.getSelectionIndex())).setMigrationRate(this.migrationRateText.getText());
            if (column == -1) {
                this.migrationRateCombo.removeAll();
                this.migrationRateCombo.setItems(this.columnNames.toArray(new String[0]));
            } else {
                this.migrationRateCombo.select(column);
            }
        } else if (this.regionPopNameTexts.contains(e.getSource())) {
            int i = this.regionPopNameTexts.indexOf(e.getSource());
            int column = this.getColumnIndex(this.regionPopNameTexts.get(i).getText());
            ((RegionShapefile)this.shapefiles.get(this.shapeFileList.getSelectionIndex())).getPopulationNames().set(i, (Object)this.regionPopNameTexts.get(i).getText());
            if (column == -1) {
                this.regionPopNameCombos.get(i).removeAll();
                this.regionPopNameCombos.get(i).setItems(this.columnNames.toArray(new String[0]));
            } else {
                this.regionPopNameCombos.get(i).select(column);
            }
        } else if (this.regionPopSizeTexts.contains(e.getSource())) {
            int i = this.regionPopSizeTexts.indexOf(e.getSource());
            int column = this.getColumnIndex(this.regionPopSizeTexts.get(i).getText());
            ((RegionShapefile)this.shapefiles.get(this.shapeFileList.getSelectionIndex())).getPopulationSizes().set(i, (Object)this.regionPopSizeTexts.get(i).getText());
            if (column == -1) {
                this.regionPopSizeCombos.get(i).removeAll();
                this.regionPopSizeCombos.get(i).setItems(this.columnNames.toArray(new String[0]));
            } else {
                this.regionPopSizeCombos.get(i).select(column);
            }
        }
        this.projectValidator.modifyText(e);
    }

    private void createRegionComposite() {
        RegionShapefile shapefile = (RegionShapefile)this.shapefiles.get(this.shapeFileList.getSelectionIndex());
        ArrayList<String> units = new ArrayList<String>();
        for (AreaUnit u : AreaUnit.VALUES) {
            units.add(u.getLiteral());
        }
        this.dataGroup = new Group((Composite)this, 0);
        this.dataGroup.setText("Data");
        this.dataGroup.setLayoutData((Object)new GridData(4, 4, false, false, 3, 1));
        this.dataGroup.setLayout((Layout)new GridLayout(4, true));
        Label regionIDLabel = new Label((Composite)this.dataGroup, 0);
        regionIDLabel.setText(String.valueOf(Messages.getString("regionID")) + ":");
        regionIDLabel.setLayoutData((Object)new GridData(4, 4, true, true));
        this.regionIDText = new Text((Composite)this.dataGroup, 2048);
        this.regionIDText.setText(shapefile.getId());
        this.regionIDText.setEditable(false);
        this.regionIDText.setLayoutData((Object)new GridData(4, 4, true, true));
        Label regionIDColumnLabel = new Label((Composite)this.dataGroup, 0);
        regionIDColumnLabel.setText(String.valueOf(Messages.getString("selectColumn")) + ":");
        regionIDColumnLabel.setLayoutData((Object)new GridData(4, 4, true, true));
        this.regionIDCombo = new Combo((Composite)this.dataGroup, 8);
        this.regionIDCombo.setItems(this.columnNames.toArray(new String[0]));
        this.regionIDCombo.addSelectionListener((SelectionListener)this);
        this.regionIDCombo.setLayoutData((Object)new GridData(4, 4, true, true));
        Label regionAreaLabel = new Label((Composite)this.dataGroup, 0);
        regionAreaLabel.setText(String.valueOf(Messages.getString("regionArea")) + ":");
        regionAreaLabel.setLayoutData((Object)new GridData(4, 4, true, true));
        this.regionAreaText = new Text((Composite)this.dataGroup, 2048);
        this.regionAreaText.setText(shapefile.getArea());
        this.regionAreaText.addModifyListener((ModifyListener)this);
        this.regionAreaText.setLayoutData((Object)new GridData(4, 4, true, true));
        Label regionAreaColumnLabel = new Label((Composite)this.dataGroup, 0);
        regionAreaColumnLabel.setText(String.valueOf(Messages.getString("selectColumn")) + ":");
        regionAreaColumnLabel.setLayoutData((Object)new GridData(4, 4, true, true));
        this.regionAreaCombo = new Combo((Composite)this.dataGroup, 8);
        this.regionAreaCombo.setItems(this.columnNames.toArray(new String[0]));
        this.regionAreaCombo.addSelectionListener((SelectionListener)this);
        this.regionAreaCombo.setLayoutData((Object)new GridData(4, 4, true, true));
        Label regionAreaUnitLabel = new Label((Composite)this.dataGroup, 0);
        regionAreaUnitLabel.setText(String.valueOf(Messages.getString("regionAreaUnit")) + ":");
        regionAreaUnitLabel.setLayoutData((Object)new GridData(4, 4, true, true));
        this.regionAreaUnitCombo = new Combo((Composite)this.dataGroup, 8);
        this.regionAreaUnitCombo.setItems(units.toArray(new String[0]));
        this.regionAreaUnitCombo.addSelectionListener((SelectionListener)this);
        this.regionAreaUnitCombo.setLayoutData((Object)new GridData(4, 4, true, true));
        this.regionAreaUnitCombo.select(units.indexOf(shapefile.getAreaUnit().getLiteral()));
        new Label((Composite)this.dataGroup, 0);
        new Label((Composite)this.dataGroup, 0);
        int regionIDIndex = this.getColumnIndex(shapefile.getId());
        int regionAreaIndex = this.getColumnIndex(shapefile.getArea());
        if (regionIDIndex != -1) {
            this.regionIDCombo.select(regionIDIndex);
        }
        if (regionAreaIndex != -1) {
            this.regionAreaCombo.select(regionAreaIndex);
        }
        this.regionPopNameTexts.clear();
        this.regionPopNameCombos.clear();
        this.regionPopSizeTexts.clear();
        this.regionPopSizeCombos.clear();
        int i = 0;
        while (i < shapefile.getPopulationNames().size()) {
            Label regionPopNameLabel = new Label((Composite)this.dataGroup, 0);
            regionPopNameLabel.setText(String.valueOf(Messages.getString("regionPopulationName")) + ":");
            regionPopNameLabel.setLayoutData((Object)new GridData(4, 4, true, true));
            Text regionPopNameText = new Text((Composite)this.dataGroup, 2048);
            regionPopNameText.setText((String)shapefile.getPopulationNames().get(i));
            regionPopNameText.setLayoutData((Object)new GridData(4, 4, true, true));
            regionPopNameText.addModifyListener((ModifyListener)this);
            Label regionPopNameColumnLabel = new Label((Composite)this.dataGroup, 0);
            regionPopNameColumnLabel.setText(String.valueOf(Messages.getString("selectColumn")) + ":");
            regionPopNameColumnLabel.setLayoutData((Object)new GridData(4, 4, true, true));
            Combo regionPopNameCombo = new Combo((Composite)this.dataGroup, 8);
            regionPopNameCombo.setItems(this.columnNames.toArray(new String[0]));
            regionPopNameCombo.addSelectionListener((SelectionListener)this);
            regionPopNameCombo.setLayoutData((Object)new GridData(4, 4, true, true));
            Label regionPopSizeLabel = new Label((Composite)this.dataGroup, 0);
            regionPopSizeLabel.setText(String.valueOf(Messages.getString("regionPopulationSize")) + ":");
            regionPopSizeLabel.setLayoutData((Object)new GridData(4, 4, true, true));
            Text regionPopSizeText = new Text((Composite)this.dataGroup, 2048);
            regionPopSizeText.setText((String)shapefile.getPopulationSizes().get(i));
            regionPopSizeText.setLayoutData((Object)new GridData(4, 4, true, true));
            regionPopSizeText.addModifyListener((ModifyListener)this);
            Label regionPopSizeColumnLabel = new Label((Composite)this.dataGroup, 0);
            regionPopSizeColumnLabel.setText(String.valueOf(Messages.getString("selectColumn")) + ":");
            regionPopSizeColumnLabel.setLayoutData((Object)new GridData(4, 4, true, true));
            Combo regionPopSizeCombo = new Combo((Composite)this.dataGroup, 8);
            regionPopSizeCombo.setItems(this.columnNames.toArray(new String[0]));
            regionPopSizeCombo.addSelectionListener((SelectionListener)this);
            regionPopSizeCombo.setLayoutData((Object)new GridData(4, 4, true, true));
            int regionPopNameIndex = this.getColumnIndex((String)shapefile.getPopulationNames().get(i));
            int regionPopSizeIndex = this.getColumnIndex((String)shapefile.getPopulationSizes().get(i));
            if (regionPopNameIndex != -1) {
                regionPopNameCombo.select(regionPopNameIndex);
            }
            if (regionPopSizeIndex != -1) {
                regionPopSizeCombo.select(regionPopSizeIndex);
            }
            this.regionPopNameTexts.add(regionPopNameText);
            this.regionPopNameCombos.add(regionPopNameCombo);
            this.regionPopSizeTexts.add(regionPopSizeText);
            this.regionPopSizeCombos.add(regionPopSizeCombo);
            ++i;
        }
        new Label((Composite)this.dataGroup, 0);
        new Label((Composite)this.dataGroup, 0);
        this.regionAddPopButton = new Button((Composite)this.dataGroup, 8);
        this.regionAddPopButton.setText(Messages.getString("regionAddPopulation"));
        this.regionAddPopButton.addSelectionListener((SelectionListener)this);
        this.regionAddPopButton.setLayoutData((Object)new GridData(4, 4, true, true));
        this.regionRemovePopButton = new Button((Composite)this.dataGroup, 8);
        this.regionRemovePopButton.setText(Messages.getString("regionRemovePopulation"));
        this.regionRemovePopButton.addSelectionListener((SelectionListener)this);
        this.regionRemovePopButton.setLayoutData((Object)new GridData(4, 4, true, true));
    }

    private void createRoadComposite() {
        RoadShapefile shapefile = (RoadShapefile)this.shapefiles.get(this.shapeFileList.getSelectionIndex());
        this.dataGroup = new Group((Composite)this, 0);
        this.dataGroup.setText("Data");
        this.dataGroup.setLayoutData((Object)new GridData(4, 4, false, false, 3, 1));
        this.dataGroup.setLayout((Layout)new GridLayout(4, true));
        Label roadIDLabel = new Label((Composite)this.dataGroup, 0);
        roadIDLabel.setText(String.valueOf(Messages.getString("roadID")) + ":");
        roadIDLabel.setLayoutData((Object)new GridData(4, 4, true, true));
        this.roadIDText = new Text((Composite)this.dataGroup, 2048);
        this.roadIDText.setText(shapefile.getId());
        this.roadIDText.setEditable(false);
        this.roadIDText.setLayoutData((Object)new GridData(4, 4, true, true));
        Label roadIDColumnLabel = new Label((Composite)this.dataGroup, 0);
        roadIDColumnLabel.setText(String.valueOf(Messages.getString("selectColumn")) + ":");
        roadIDColumnLabel.setLayoutData((Object)new GridData(4, 4, true, true));
        this.roadIDCombo = new Combo((Composite)this.dataGroup, 8);
        this.roadIDCombo.setItems(this.columnNames.toArray(new String[0]));
        this.roadIDCombo.addSelectionListener((SelectionListener)this);
        this.roadIDCombo.setLayoutData((Object)new GridData(4, 4, true, true));
        Label roadClassLabel = new Label((Composite)this.dataGroup, 0);
        roadClassLabel.setText(String.valueOf(Messages.getString("roadClass")) + ":");
        roadClassLabel.setLayoutData((Object)new GridData(4, 4, true, true));
        this.roadClassText = new Text((Composite)this.dataGroup, 2048);
        this.roadClassText.setText(shapefile.getRoadClass());
        this.roadClassText.addModifyListener((ModifyListener)this);
        this.roadClassText.setLayoutData((Object)new GridData(4, 4, true, true));
        Label roadClassColumnLabel = new Label((Composite)this.dataGroup, 0);
        roadClassColumnLabel.setText(String.valueOf(Messages.getString("selectColumn")) + ":");
        roadClassColumnLabel.setLayoutData((Object)new GridData(4, 4, true, true));
        this.roadClassCombo = new Combo((Composite)this.dataGroup, 8);
        this.roadClassCombo.setItems(this.columnNames.toArray(new String[0]));
        this.roadClassCombo.addSelectionListener((SelectionListener)this);
        this.roadClassCombo.setLayoutData((Object)new GridData(4, 4, true, true));
        int roadIDIndex = this.getColumnIndex(shapefile.getId());
        int roadClassIndex = this.getColumnIndex(shapefile.getRoadClass());
        if (roadIDIndex != -1) {
            this.roadIDCombo.select(roadIDIndex);
        }
        if (roadClassIndex != -1) {
            this.roadClassCombo.select(roadClassIndex);
        }
    }

    private void createMigrationComposite() {
        MigrationShapefile shapefile = (MigrationShapefile)this.shapefiles.get(this.shapeFileList.getSelectionIndex());
        this.dataGroup = new Group((Composite)this, 0);
        this.dataGroup.setText("Data");
        this.dataGroup.setLayoutData((Object)new GridData(4, 4, false, false, 3, 1));
        this.dataGroup.setLayout((Layout)new GridLayout(4, true));
        Label migrationIDLabel = new Label((Composite)this.dataGroup, 0);
        migrationIDLabel.setText(String.valueOf(Messages.getString("migrationID")) + ":");
        migrationIDLabel.setLayoutData((Object)new GridData(4, 4, true, true));
        this.migrationIDText = new Text((Composite)this.dataGroup, 2048);
        this.migrationIDText.setText(shapefile.getId());
        this.migrationIDText.setEditable(false);
        this.migrationIDText.setLayoutData((Object)new GridData(4, 4, true, true));
        Label migrationIDColumnLabel = new Label((Composite)this.dataGroup, 0);
        migrationIDColumnLabel.setText(String.valueOf(Messages.getString("selectColumn")) + ":");
        migrationIDColumnLabel.setLayoutData((Object)new GridData(4, 4, true, true));
        this.migrationIDCombo = new Combo((Composite)this.dataGroup, 8);
        this.migrationIDCombo.setItems(this.columnNames.toArray(new String[0]));
        this.migrationIDCombo.addSelectionListener((SelectionListener)this);
        this.migrationIDCombo.setLayoutData((Object)new GridData(4, 4, true, true));
        Label migrationPopulationLabel = new Label((Composite)this.dataGroup, 0);
        migrationPopulationLabel.setText(String.valueOf(Messages.getString("migrationPopulation")) + ":");
        migrationPopulationLabel.setLayoutData((Object)new GridData(4, 4, true, true));
        this.migrationPopulationText = new Text((Composite)this.dataGroup, 2048);
        this.migrationPopulationText.setText(shapefile.getPopulationName());
        this.migrationPopulationText.addModifyListener((ModifyListener)this);
        this.migrationPopulationText.setLayoutData((Object)new GridData(4, 4, true, true));
        Label migrationPopulationColumnLabel = new Label((Composite)this.dataGroup, 0);
        migrationPopulationColumnLabel.setText(String.valueOf(Messages.getString("selectColumn")) + ":");
        migrationPopulationColumnLabel.setLayoutData((Object)new GridData(4, 4, true, true));
        this.migrationPopulationCombo = new Combo((Composite)this.dataGroup, 8);
        this.migrationPopulationCombo.setItems(this.columnNames.toArray(new String[0]));
        this.migrationPopulationCombo.addSelectionListener((SelectionListener)this);
        this.migrationPopulationCombo.setLayoutData((Object)new GridData(4, 4, true, true));
        Label migrationRateLabel = new Label((Composite)this.dataGroup, 0);
        migrationRateLabel.setText(String.valueOf(Messages.getString("migrationRate")) + ":");
        migrationRateLabel.setLayoutData((Object)new GridData(4, 4, true, true));
        this.migrationRateText = new Text((Composite)this.dataGroup, 2048);
        this.migrationRateText.setText(shapefile.getMigrationRate());
        this.migrationRateText.addModifyListener((ModifyListener)this);
        this.migrationRateText.setLayoutData((Object)new GridData(4, 4, true, true));
        Label migrationRateColumnLabel = new Label((Composite)this.dataGroup, 0);
        migrationRateColumnLabel.setText(String.valueOf(Messages.getString("selectColumn")) + ":");
        migrationRateColumnLabel.setLayoutData((Object)new GridData(4, 4, true, true));
        this.migrationRateCombo = new Combo((Composite)this.dataGroup, 8);
        this.migrationRateCombo.setItems(this.columnNames.toArray(new String[0]));
        this.migrationRateCombo.addSelectionListener((SelectionListener)this);
        this.migrationRateCombo.setLayoutData((Object)new GridData(4, 4, true, true));
        int migrationIDIndex = this.getColumnIndex(shapefile.getId());
        int migrationPopulationIndex = this.getColumnIndex(shapefile.getPopulationName());
        int migrationRateIndex = this.getColumnIndex(shapefile.getMigrationRate());
        if (migrationIDIndex != -1) {
            this.migrationIDCombo.select(migrationIDIndex);
        }
        if (migrationPopulationIndex != -1) {
            this.migrationPopulationCombo.select(migrationPopulationIndex);
        }
        if (migrationRateIndex != -1) {
            this.migrationRateCombo.select(migrationRateIndex);
        }
    }

    private void updateSelection() {
        int selection = this.shapeFileList.getSelectionIndex();
        if (this.dataGroup != null) {
            this.dataGroup.dispose();
        }
        if (this.showDataButton != null) {
            this.showDataButton.dispose();
        }
        if (this.typeGroup != null) {
            this.typeGroup.dispose();
        }
        if (selection != -1) {
            this.updateDBFData();
            this.showDataButton = new Button((Composite)this, 8);
            this.showDataButton.setText(Messages.getString("showData"));
            this.showDataButton.addSelectionListener((SelectionListener)this);
            this.typeGroup = new Group((Composite)this, 0);
            this.typeGroup.setText(Messages.getString("shapefileType"));
            this.typeGroup.setLayoutData((Object)new GridData(4, 4, false, false, 3, 1));
            this.typeGroup.setLayout((Layout)new GridLayout(3, true));
            this.regionButton = new Button((Composite)this.typeGroup, 16);
            this.regionButton.setText(Messages.getString("regionsType"));
            this.regionButton.setLayoutData((Object)new GridData(4, 4, true, true));
            this.regionButton.addSelectionListener((SelectionListener)this);
            this.roadButton = new Button((Composite)this.typeGroup, 16);
            this.roadButton.setText(Messages.getString("roadsType"));
            this.roadButton.setLayoutData((Object)new GridData(4, 4, true, true));
            this.roadButton.addSelectionListener((SelectionListener)this);
            this.migrationButton = new Button((Composite)this.typeGroup, 16);
            this.migrationButton.setText(Messages.getString("migrationType"));
            this.migrationButton.setLayoutData((Object)new GridData(4, 4, true, true));
            this.migrationButton.addSelectionListener((SelectionListener)this);
            Shapefile shapefile = this.shapefiles.get(selection);
            if (shapefile instanceof RegionShapefile) {
                this.regionButton.setSelection(true);
                this.createRegionComposite();
            } else if (shapefile instanceof RoadShapefile) {
                this.roadButton.setSelection(true);
                this.createRoadComposite();
            } else if (shapefile instanceof MigrationShapefile) {
                this.migrationButton.setSelection(true);
                this.createMigrationComposite();
            }
        }
    }

    private void updateUI() {
        this.pack();
        this.getParent().layout();
        this.getParent().getParent().getParent().layout();
        this.layout();
    }

    private void updateDBFData() {
        try {
            Reader reader = new Reader(this.shapefiles.get(this.shapeFileList.getSelectionIndex()).getFileName());
            this.columnNames = reader.getColumnNames();
            this.data = reader.getData();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private int getColumnIndex(String s) {
        if (!s.startsWith("column:")) {
            return -1;
        }
        s = s.replaceFirst("column:", "");
        return this.columnNames.indexOf(s);
    }
}

