/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.analysis.automaticexperiment.ui;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.stem.analysis.ErrorFunction;
import org.eclipse.stem.analysis.automaticexperiment.AutomaticExperiment;
import org.eclipse.stem.analysis.automaticexperiment.AutomaticexperimentFactory;
import org.eclipse.stem.analysis.automaticexperiment.ModifiableParameter;
import org.eclipse.stem.analysis.automaticexperiment.OptimizerAlgorithm;
import org.eclipse.stem.analysis.automaticexperiment.ui.AlgorithmCompositeEditor;
import org.eclipse.stem.analysis.automaticexperiment.views.Messages;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.common.impl.IdentifiableImpl;
import org.eclipse.stem.core.scenario.Scenario;
import org.eclipse.stem.core.scenario.impl.ScenarioImpl;
import org.eclipse.stem.ui.Activator;
import org.eclipse.stem.ui.widgets.IdentifiablePickerDialog;
import org.eclipse.stem.ui.widgets.ParameterPickerDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class AutomaticExperimentCompositeEditor
extends AlgorithmCompositeEditor {
    Text maxItersText;
    Text referenceDataText;
    Text baseScenarioText;
    Combo errorFunctionCombo;
    Text startValText;
    Text stepValText;
    Text minValText;
    Text maxValText;
    Text toleranceText;
    Table table;
    boolean reInit = true;
    ArrayList<Identifiable> identifiableList = new ArrayList();
    ArrayList<EAttribute> attributeList = new ArrayList();
    ArrayList<Double> minList = new ArrayList();
    ArrayList<Double> maxList = new ArrayList();
    ArrayList<Double> startList = new ArrayList();
    ArrayList<Double> stepList = new ArrayList();
    int currentTableIndex;
    Scenario baseScenario;
    String errorMessage;
    private ErrorFunction[] errorFunctions;

    public AutomaticExperimentCompositeEditor(Composite parent, int style, final ModifyListener projectValidator, final IProject project) {
        super(parent, style);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        this.setLayout((Layout)gridLayout);
        Label maxItersLabel = new Label((Composite)this, 0);
        maxItersLabel.setText(Messages.getString("NM.MAXITERS"));
        GridData gridData = new GridData();
        gridData.horizontalSpan = 1;
        maxItersLabel.setLayoutData((Object)gridData);
        this.maxItersText = new Text((Composite)this, 0);
        this.maxItersText.setText("-1");
        GridData gridData2 = new GridData();
        gridData2.horizontalSpan = 2;
        gridData2.grabExcessHorizontalSpace = true;
        gridData2.horizontalAlignment = 4;
        this.maxItersText.setLayoutData((Object)gridData2);
        this.maxItersText.addModifyListener(projectValidator);
        Label refDataLabel = new Label((Composite)this, 0);
        refDataLabel.setText(Messages.getString("NM.REFERENCE"));
        GridData gridData3 = new GridData();
        gridData3.horizontalSpan = 1;
        refDataLabel.setLayoutData((Object)gridData3);
        this.referenceDataText = new Text((Composite)this, 0);
        this.referenceDataText.setText("");
        GridData gridData4 = new GridData();
        gridData4.horizontalSpan = 1;
        gridData4.grabExcessHorizontalSpace = true;
        gridData4.horizontalAlignment = 4;
        this.referenceDataText.setLayoutData((Object)gridData4);
        this.referenceDataText.addModifyListener(projectValidator);
        Button pickRefereceButton = new Button((Composite)this, 0);
        pickRefereceButton.setText(Messages.getString("NM.REFPICKFOLDER"));
        GridData gridData5 = new GridData();
        gridData5.horizontalSpan = 1;
        pickRefereceButton.setLayoutData((Object)gridData5);
        final Shell shell = this.getShell();
        pickRefereceButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dd = new DirectoryDialog(shell, 4100);
                dd.setText(Messages.getString("NM.REFFOLDERTITLE"));
                String selected = dd.open();
                if (selected != null) {
                    AutomaticExperimentCompositeEditor.this.referenceDataText.setText(selected);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label baseScenarioLabel = new Label((Composite)this, 0);
        baseScenarioLabel.setText(Messages.getString("NM.BASESCENARIO"));
        GridData gridData6 = new GridData();
        gridData6.horizontalSpan = 1;
        baseScenarioLabel.setLayoutData((Object)gridData6);
        this.baseScenarioText = new Text((Composite)this, 0);
        this.baseScenarioText.setText("");
        GridData gridData7 = new GridData();
        gridData7.horizontalSpan = 1;
        gridData7.grabExcessHorizontalSpace = true;
        gridData7.horizontalAlignment = 4;
        this.baseScenarioText.setLayoutData((Object)gridData7);
        this.baseScenarioText.setEditable(false);
        this.baseScenarioText.addModifyListener(projectValidator);
        Button pickScenarioButton = new Button((Composite)this, 0);
        pickScenarioButton.setText(Messages.getString("NM.SELECTSCENARIO"));
        GridData gridData8 = new GridData();
        gridData8.horizontalSpan = 1;
        pickScenarioButton.setLayoutData((Object)gridData8);
        pickScenarioButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IdentifiablePickerDialog ppDialog = new IdentifiablePickerDialog(AutomaticExperimentCompositeEditor.this.getShell(), 0, Messages.getString("NM.PICKSCENARIO"), project, ScenarioImpl.class);
                Object ret = ppDialog.open();
                if (ret != null) {
                    AutomaticExperimentCompositeEditor.this.baseScenario = (Scenario)ret;
                    AutomaticExperimentCompositeEditor.this.baseScenarioText.setText(AutomaticExperimentCompositeEditor.this.baseScenario.getURI().toString());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label errorFunctionLabel = new Label((Composite)this, 0);
        errorFunctionLabel.setText(Messages.getString("NM.ERRORFUNCTION"));
        GridData gridData9 = new GridData();
        gridData9.horizontalSpan = 1;
        baseScenarioLabel.setLayoutData((Object)gridData9);
        this.errorFunctionCombo = new Combo((Composite)this, 0);
        this.initializeErrorFunctionCombo();
        GridData gridData10 = new GridData();
        gridData10.horizontalSpan = 2;
        gridData10.grabExcessHorizontalSpace = true;
        gridData10.horizontalAlignment = 4;
        this.errorFunctionCombo.setLayoutData((Object)gridData10);
        Label reInitLabel = new Label((Composite)this, 0);
        reInitLabel.setText(Messages.getString("NM.REINITLABEL"));
        GridData gridDataRI = new GridData();
        gridDataRI.horizontalSpan = 1;
        reInitLabel.setLayoutData((Object)gridDataRI);
        Composite radioComposite = new Composite((Composite)this, 2048);
        FillLayout fillLayout = new FillLayout();
        fillLayout.type = 256;
        radioComposite.setLayout((Layout)fillLayout);
        final Button falseButton = new Button(radioComposite, 16);
        falseButton.setText(Messages.getString("NM.NO"));
        Button trueButton = new Button(radioComposite, 16);
        trueButton.setText(Messages.getString("NM.YES"));
        trueButton.setSelection(true);
        falseButton.setSelection(false);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                if (event.widget == falseButton) {
                    AutomaticExperimentCompositeEditor.this.reInit = !falseButton.getSelection();
                }
            }
        };
        falseButton.addListener(13, listener);
        GridData cGD = new GridData();
        cGD.grabExcessHorizontalSpace = true;
        cGD.horizontalAlignment = 4;
        cGD.horizontalSpan = 2;
        radioComposite.setLayoutData((Object)cGD);
        Label toleranceTabel = new Label((Composite)this, 0);
        toleranceTabel.setText(Messages.getString("NM.TOLERANCE"));
        GridData tolGD = new GridData();
        tolGD.horizontalSpan = 1;
        toleranceTabel.setLayoutData((Object)tolGD);
        this.toleranceText = new Text((Composite)this, 0);
        this.toleranceText.setText("1E-9");
        GridData tol2GD = new GridData();
        tol2GD.horizontalSpan = 2;
        tol2GD.grabExcessHorizontalSpace = true;
        tol2GD.horizontalAlignment = 4;
        this.toleranceText.setLayoutData((Object)tol2GD);
        this.table = new Table((Composite)this, 2052);
        GridData gridData11 = new GridData();
        gridData11.horizontalSpan = 1;
        gridData11.grabExcessHorizontalSpace = true;
        gridData11.horizontalAlignment = 4;
        gridData11.grabExcessVerticalSpace = false;
        this.table.setLayoutData((Object)gridData11);
        Composite startStepComp = new Composite((Composite)this, 0);
        GridLayout startLayout = new GridLayout();
        startLayout.numColumns = 2;
        startStepComp.setLayout((Layout)startLayout);
        Label startLabel = new Label(startStepComp, 0);
        startLabel.setText(Messages.getString("NM.INITIAL"));
        GridData gridData12 = new GridData();
        gridData12.horizontalSpan = 1;
        startLabel.setLayoutData((Object)gridData12);
        Label stepLabel = new Label(startStepComp, 0);
        stepLabel.setText(Messages.getString("NM.STEP"));
        GridData gridData13 = new GridData();
        gridData13.horizontalSpan = 1;
        stepLabel.setLayoutData((Object)gridData13);
        this.startValText = new Text(startStepComp, 0);
        GridData gridData14 = new GridData();
        gridData13.horizontalSpan = 1;
        this.startValText.setLayoutData((Object)gridData14);
        this.startValText.addModifyListener(projectValidator);
        this.startValText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (AutomaticExperimentCompositeEditor.this.currentTableIndex == -1) {
                    return;
                }
                String txt = AutomaticExperimentCompositeEditor.this.startValText.getText();
                double d = 0.0;
                try {
                    d = Double.parseDouble(txt);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                AutomaticExperimentCompositeEditor.this.startList.set(AutomaticExperimentCompositeEditor.this.currentTableIndex, d);
            }
        });
        this.stepValText = new Text(startStepComp, 0);
        GridData gridData15 = new GridData();
        gridData15.horizontalSpan = 1;
        this.stepValText.setLayoutData((Object)gridData15);
        this.stepValText.addModifyListener(projectValidator);
        this.stepValText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (AutomaticExperimentCompositeEditor.this.currentTableIndex == -1) {
                    return;
                }
                String txt = AutomaticExperimentCompositeEditor.this.stepValText.getText();
                double d = 0.0;
                try {
                    d = Double.parseDouble(txt);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                AutomaticExperimentCompositeEditor.this.stepList.set(AutomaticExperimentCompositeEditor.this.currentTableIndex, d);
            }
        });
        Composite minMaxComp = new Composite((Composite)this, 0);
        GridLayout minMaxLayout = new GridLayout();
        minMaxLayout.numColumns = 2;
        minMaxComp.setLayout((Layout)startLayout);
        Label minLabel = new Label(minMaxComp, 0);
        minLabel.setText(Messages.getString("NM.MIN"));
        GridData gridData16 = new GridData();
        gridData16.horizontalSpan = 1;
        minLabel.setLayoutData((Object)gridData12);
        Label maxLabel = new Label(minMaxComp, 0);
        maxLabel.setText(Messages.getString("NM.MAX"));
        GridData gridData17 = new GridData();
        gridData17.horizontalSpan = 1;
        maxLabel.setLayoutData((Object)gridData17);
        this.minValText = new Text(minMaxComp, 0);
        GridData gridData18 = new GridData();
        gridData18.horizontalSpan = 1;
        this.minValText.setLayoutData((Object)gridData18);
        this.minValText.addModifyListener(projectValidator);
        this.minValText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (AutomaticExperimentCompositeEditor.this.currentTableIndex == -1) {
                    return;
                }
                String txt = AutomaticExperimentCompositeEditor.this.minValText.getText();
                double d = 0.0;
                try {
                    d = Double.parseDouble(txt);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                AutomaticExperimentCompositeEditor.this.minList.set(AutomaticExperimentCompositeEditor.this.currentTableIndex, d);
            }
        });
        this.maxValText = new Text(minMaxComp, 0);
        GridData gridData19 = new GridData();
        gridData19.horizontalSpan = 1;
        this.maxValText.setLayoutData((Object)gridData19);
        this.maxValText.addModifyListener(projectValidator);
        this.maxValText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (AutomaticExperimentCompositeEditor.this.currentTableIndex == -1) {
                    return;
                }
                String txt = AutomaticExperimentCompositeEditor.this.maxValText.getText();
                double d = 0.0;
                try {
                    d = Double.parseDouble(txt);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                AutomaticExperimentCompositeEditor.this.maxList.set(AutomaticExperimentCompositeEditor.this.currentTableIndex, d);
            }
        });
        this.minValText.setEnabled(false);
        this.maxValText.setEnabled(false);
        this.startValText.setEnabled(false);
        this.stepValText.setEnabled(false);
        Composite plusminusbuttons = new Composite((Composite)this, 0);
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.numColumns = 2;
        plusminusbuttons.setLayout((Layout)gridLayout2);
        GridData gridData20 = new GridData();
        gridData20.horizontalSpan = 1;
        gridData20.grabExcessHorizontalSpace = true;
        gridData20.horizontalAlignment = 4;
        plusminusbuttons.setLayoutData((Object)gridData20);
        Button plusButton = new Button(plusminusbuttons, 0);
        plusButton.setText(Messages.getString("NM.PLUS"));
        GridData gridData21 = new GridData();
        gridData21.horizontalSpan = 1;
        plusButton.setLayoutData((Object)gridData21);
        final Button minusButton = new Button(plusminusbuttons, 0);
        minusButton.setText(Messages.getString("NM.MINUS"));
        GridData gridData22 = new GridData();
        gridData21.horizontalSpan = 1;
        minusButton.setLayoutData((Object)gridData22);
        minusButton.setEnabled(false);
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AutomaticExperimentCompositeEditor.this.currentTableIndex = AutomaticExperimentCompositeEditor.this.table.getSelectionIndex();
                if (AutomaticExperimentCompositeEditor.this.currentTableIndex > -1) {
                    AutomaticExperimentCompositeEditor.this.minValText.setText("" + AutomaticExperimentCompositeEditor.this.minList.get(AutomaticExperimentCompositeEditor.this.currentTableIndex));
                    AutomaticExperimentCompositeEditor.this.maxValText.setText("" + AutomaticExperimentCompositeEditor.this.maxList.get(AutomaticExperimentCompositeEditor.this.currentTableIndex));
                    AutomaticExperimentCompositeEditor.this.startValText.setText("" + AutomaticExperimentCompositeEditor.this.startList.get(AutomaticExperimentCompositeEditor.this.currentTableIndex));
                    AutomaticExperimentCompositeEditor.this.stepValText.setText("" + AutomaticExperimentCompositeEditor.this.stepList.get(AutomaticExperimentCompositeEditor.this.currentTableIndex));
                    AutomaticExperimentCompositeEditor.this.minValText.setEnabled(true);
                    AutomaticExperimentCompositeEditor.this.maxValText.setEnabled(true);
                    AutomaticExperimentCompositeEditor.this.startValText.setEnabled(true);
                    AutomaticExperimentCompositeEditor.this.stepValText.setEnabled(true);
                    minusButton.setEnabled(true);
                } else {
                    AutomaticExperimentCompositeEditor.this.minValText.setText("");
                    AutomaticExperimentCompositeEditor.this.maxValText.setText("");
                    AutomaticExperimentCompositeEditor.this.startValText.setText("");
                    AutomaticExperimentCompositeEditor.this.stepValText.setText("");
                    AutomaticExperimentCompositeEditor.this.minValText.setEnabled(false);
                    AutomaticExperimentCompositeEditor.this.maxValText.setEnabled(false);
                    AutomaticExperimentCompositeEditor.this.startValText.setEnabled(false);
                    AutomaticExperimentCompositeEditor.this.stepValText.setEnabled(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        plusButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ParameterPickerDialog ppDialog = new ParameterPickerDialog(AutomaticExperimentCompositeEditor.this.getShell(), 0, Messages.getString("NM.PICKPARAM"), project, IdentifiableImpl.class);
                Object[] ret = ppDialog.open();
                if (ret != null) {
                    Identifiable id = (Identifiable)ret[0];
                    EAttribute attr = (EAttribute)ret[1];
                    AutomaticExperimentCompositeEditor.this.identifiableList.add(id);
                    AutomaticExperimentCompositeEditor.this.attributeList.add(attr);
                    TableItem newRow = new TableItem(AutomaticExperimentCompositeEditor.this.table, 0);
                    newRow.setText(String.valueOf(attr.getName()) + " (" + id.getURI().lastSegment() + ")");
                    AutomaticExperimentCompositeEditor.this.minList.add(0.0);
                    AutomaticExperimentCompositeEditor.this.maxList.add(1.0);
                    AutomaticExperimentCompositeEditor.this.startList.add(0.5);
                    AutomaticExperimentCompositeEditor.this.stepList.add(0.1);
                    projectValidator.modifyText(null);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        minusButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (AutomaticExperimentCompositeEditor.this.currentTableIndex > -1) {
                    AutomaticExperimentCompositeEditor.this.table.remove(AutomaticExperimentCompositeEditor.this.currentTableIndex);
                    AutomaticExperimentCompositeEditor.this.minList.remove(AutomaticExperimentCompositeEditor.this.currentTableIndex);
                    AutomaticExperimentCompositeEditor.this.maxList.remove(AutomaticExperimentCompositeEditor.this.currentTableIndex);
                    AutomaticExperimentCompositeEditor.this.startList.remove(AutomaticExperimentCompositeEditor.this.currentTableIndex);
                    AutomaticExperimentCompositeEditor.this.stepList.remove(AutomaticExperimentCompositeEditor.this.currentTableIndex);
                    AutomaticExperimentCompositeEditor.this.currentTableIndex = AutomaticExperimentCompositeEditor.this.table.getSelectionIndex();
                    AutomaticExperimentCompositeEditor.this.minValText.setText("");
                    AutomaticExperimentCompositeEditor.this.maxValText.setText("");
                    AutomaticExperimentCompositeEditor.this.startValText.setText("");
                    AutomaticExperimentCompositeEditor.this.stepValText.setText("");
                    if (AutomaticExperimentCompositeEditor.this.minList.size() == 0) {
                        minusButton.setEnabled(false);
                        AutomaticExperimentCompositeEditor.this.minValText.setEnabled(false);
                        AutomaticExperimentCompositeEditor.this.maxValText.setEnabled(false);
                        AutomaticExperimentCompositeEditor.this.startValText.setEnabled(false);
                        AutomaticExperimentCompositeEditor.this.stepValText.setEnabled(false);
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void initializeErrorFunctionCombo() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] errorFunctionsConfigElements = registry.getConfigurationElementsFor("org.eclipse.stem.analysis.errorfunction");
        ArrayList<ErrorFunction> temp = new ArrayList<ErrorFunction>();
        this.errorFunctions = new ErrorFunction[errorFunctionsConfigElements.length];
        int i = 0;
        while (i < errorFunctionsConfigElements.length) {
            IConfigurationElement element = errorFunctionsConfigElements[i];
            System.out.println(element.getName());
            if (element.getName().equals("classdef")) {
                try {
                    temp.add((ErrorFunction)element.createExecutableExtension("class"));
                }
                catch (CoreException e) {
                    Activator.logError((String)Messages.getString("Unable to instantiate extension point " + element), (Throwable)e);
                }
            }
            ++i;
        }
        this.errorFunctions = temp.toArray(new ErrorFunction[0]);
        i = 0;
        while (i < this.errorFunctions.length) {
            this.errorFunctionCombo.add(this.errorFunctions[i].eClass().getName());
            ++i;
        }
        this.errorFunctionCombo.select(0);
    }

    @Override
    public boolean validate() {
        String val;
        boolean retValue = true;
        double minVal = 0.0;
        double maxVal = 1.0;
        double startVal = 0.5;
        double stepVal = 0.1;
        this.errorMessage = "";
        if (retValue && this.startValText.isEnabled()) {
            val = this.startValText.getText();
            retValue = this.checkDouble(val);
            if (!retValue) {
                this.errorMessage = Messages.getString("NM.BADSTART");
            } else {
                startVal = Double.parseDouble(val);
            }
        }
        if (retValue && this.stepValText.isEnabled()) {
            val = this.stepValText.getText();
            retValue = this.checkDoubleNonZero(val);
            if (!retValue) {
                this.errorMessage = Messages.getString("NM.BADSTEP");
            } else {
                stepVal = Double.parseDouble(val);
            }
        }
        if (retValue && this.minValText.isEnabled()) {
            val = this.minValText.getText();
            retValue = this.checkDouble(val);
            if (!retValue) {
                this.errorMessage = Messages.getString("NM.BADMIN");
            } else {
                minVal = Double.parseDouble(val);
            }
        }
        if (retValue && this.maxValText.isEnabled()) {
            val = this.maxValText.getText();
            retValue = this.checkDouble(val);
            if (!retValue) {
                this.errorMessage = Messages.getString("NM.BADMAX");
            } else {
                maxVal = Double.parseDouble(val);
            }
        }
        if (retValue && minVal > maxVal) {
            this.errorMessage = Messages.getString("NM.BADMINMAX");
            retValue = false;
        }
        if (retValue && this.maxItersText.isEnabled() && !(retValue = this.checkIntegerMinValue(val = this.maxItersText.getText(), -1))) {
            this.errorMessage = Messages.getString("NM.BADMAXITERS");
        }
        if (retValue && (this.referenceDataText.getText() == null || this.referenceDataText.getText().trim().equals(""))) {
            this.errorMessage = Messages.getString("NM.BADREFERENCE");
            retValue = false;
        }
        if (retValue && this.baseScenario == null) {
            this.errorMessage = Messages.getString("NM.BADBASESCENARIO");
            retValue = false;
        }
        if (retValue && this.table.getItemCount() == 0) {
            this.errorMessage = Messages.getString("NM.ATLEASTONEPARAM");
            retValue = false;
        }
        if (retValue && this.toleranceText.isEnabled()) {
            retValue = this.checkDoublePositiveNonZero(this.toleranceText.getText());
        }
        return retValue;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    private boolean checkDouble(String d) {
        boolean retValue = true;
        try {
            Double.parseDouble(d);
        }
        catch (Exception e) {
            retValue = false;
        }
        return retValue;
    }

    private boolean checkDoubleNonZero(String d) {
        boolean retValue = true;
        try {
            double _d = Double.parseDouble(d);
            if (_d == 0.0) {
                retValue = false;
            }
        }
        catch (Exception e) {
            retValue = false;
        }
        return retValue;
    }

    private boolean checkIntegerMinValue(String i, int min) {
        boolean retValue = true;
        try {
            int _i = Integer.parseInt(i);
            if (_i < min) {
                retValue = false;
            }
        }
        catch (Exception e) {
            retValue = false;
        }
        return retValue;
    }

    private boolean checkDoublePositiveNonZero(String d) {
        boolean retValue = true;
        try {
            double _d = Double.parseDouble(d);
            if (_d < 0.0) {
                retValue = false;
            }
        }
        catch (Exception e) {
            retValue = false;
        }
        return retValue;
    }

    @Override
    public OptimizerAlgorithm createAlgorithm() {
        AutomaticExperiment autoExperiment = AutomaticexperimentFactory.eINSTANCE.createAutomaticExperiment();
        autoExperiment.setBaseScenario(this.baseScenario);
        int ind = this.errorFunctionCombo.getSelectionIndex();
        if (ind == -1) {
            ind = 0;
        }
        autoExperiment.setErrorFunc(this.errorFunctions[ind]);
        autoExperiment.setMaximumNumberOfIterations(Integer.parseInt(this.maxItersText.getText()));
        String refDir = this.referenceDataText.getText();
        Path rootPath = new Path(ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile().toString());
        if (refDir != null) {
            Path path = new Path(refDir);
            if (rootPath.isPrefixOf((IPath)path)) {
                String relPath = path.makeRelativeTo((IPath)rootPath).toString();
                if (relPath.isEmpty()) {
                    relPath = "/";
                }
                autoExperiment.setReferanceDataDir(URI.createPlatformResourceURI((String)relPath, (boolean)false).toString());
            } else {
                autoExperiment.setReferanceDataDir(refDir);
            }
        }
        autoExperiment.setReInit(this.reInit);
        autoExperiment.setTolerance(Double.parseDouble(this.toleranceText.getText()));
        int n = 0;
        for (Identifiable ident : this.identifiableList) {
            ModifiableParameter param = AutomaticexperimentFactory.eINSTANCE.createModifiableParameter();
            param.setTargetURI(ident.getURI());
            param.setFeatureName(this.attributeList.get(n).getName());
            param.setInitialValue(this.startList.get(n));
            param.setStep(this.stepList.get(n));
            param.setLowerBound(this.minList.get(n));
            param.setUpperBound(this.maxList.get(n));
            autoExperiment.getParameters().add((Object)param);
            ++n;
        }
        return autoExperiment;
    }
}

