/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.model.metamodel;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ModelType implements Enumerator
{
    DISEASE_MODEL(0, "DiseaseModel", "DiseaseModel"),
    POPULATION_MODEL(1, "PopulationModel", "PopulationModel"),
    FOOD_PRODUCTION_MODEL(2, "FoodProductionModel", "FoodProductionModel");

    public static final int DISEASE_MODEL_VALUE = 0;
    public static final int POPULATION_MODEL_VALUE = 1;
    public static final int FOOD_PRODUCTION_MODEL_VALUE = 2;
    private static final ModelType[] VALUES_ARRAY;
    public static final List<ModelType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ModelType[]{DISEASE_MODEL, POPULATION_MODEL, FOOD_PRODUCTION_MODEL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ModelType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ModelType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ModelType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ModelType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ModelType get(int value) {
        switch (value) {
            case 0: {
                return DISEASE_MODEL;
            }
            case 1: {
                return POPULATION_MODEL;
            }
            case 2: {
                return FOOD_PRODUCTION_MODEL;
            }
        }
        return null;
    }

    private ModelType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

