/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.pde.api.tools.internal.ApiBaselineManager;
import org.eclipse.pde.api.tools.internal.ApiDescription;
import org.eclipse.pde.api.tools.internal.CRCVisitor;
import org.eclipse.pde.api.tools.internal.TypeAnnotations;
import org.eclipse.pde.api.tools.internal.builder.BuildStamps;
import org.eclipse.pde.api.tools.internal.model.BundleComponent;
import org.eclipse.pde.api.tools.internal.model.ProjectComponent;
import org.eclipse.pde.api.tools.internal.provisional.ApiDescriptionVisitor;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.Factory;
import org.eclipse.pde.api.tools.internal.provisional.IApiAnnotations;
import org.eclipse.pde.api.tools.internal.provisional.RestrictionModifiers;
import org.eclipse.pde.api.tools.internal.provisional.VisibilityModifiers;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IElementDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IPackageDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IReferenceTypeDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiBaseline;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiTypeContainer;
import org.eclipse.pde.api.tools.internal.provisional.scanner.TagScanner;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ProjectApiDescription
extends ApiDescription {
    private IJavaProject fProject;
    public long fPackageTimeStamp = 0L;
    private boolean fRefreshingInProgress = false;
    public IFile fManifestFile;
    private boolean fInSynch = false;

    public ProjectApiDescription(IJavaProject project) {
        super(project.getElementName());
        this.fProject = project;
    }

    public synchronized void accept(ApiDescriptionVisitor visitor, IProgressMonitor monitor) {
        boolean completeVisit = true;
        if (this.fInSynch) {
            super.accept(visitor, monitor);
        } else {
            try {
                try {
                    IPackageFragment[] fragments = this.getLocalPackageFragments();
                    IJavaElement[] children = null;
                    IJavaElement child = null;
                    ICompilationUnit unit = null;
                    int j = 0;
                    while (j < fragments.length) {
                        IPackageDescriptor packageDescriptor;
                        ApiDescription.ManifestNode pkgNode;
                        if (ApiPlugin.DEBUG_API_DESCRIPTION) {
                            System.out.println("\t" + fragments[j].getElementName());
                        }
                        if ((pkgNode = this.findNode(packageDescriptor = Factory.packageDescriptor(fragments[j].getElementName()), false)) != null) {
                            IApiAnnotations annotations = this.resolveAnnotations(pkgNode, packageDescriptor);
                            if (visitor.visitElement(packageDescriptor, annotations)) {
                                children = fragments[j].getChildren();
                                int k = 0;
                                while (k < children.length) {
                                    child = children[k];
                                    if (child instanceof ICompilationUnit) {
                                        unit = (ICompilationUnit)child;
                                        String cuName = unit.getElementName();
                                        String tName = cuName.substring(0, cuName.length() - ".java".length());
                                        this.visit(visitor, unit.getType(tName));
                                    } else if (child instanceof IClassFile) {
                                        this.visit(visitor, ((IClassFile)child).getType());
                                    }
                                    ++k;
                                }
                            } else {
                                completeVisit = false;
                            }
                            visitor.endVisitElement(packageDescriptor, annotations);
                        }
                        ++j;
                    }
                }
                catch (JavaModelException e) {
                    completeVisit = false;
                    ApiPlugin.log(e.getStatus());
                    if (completeVisit) {
                        this.fInSynch = true;
                    }
                }
            }
            finally {
                if (completeVisit) {
                    this.fInSynch = true;
                }
            }
        }
    }

    private void visit(ApiDescriptionVisitor visitor, IType type) {
        IElementDescriptor element = this.getElementDescriptor((IJavaElement)type);
        ApiDescription.ManifestNode typeNode = this.findNode(element, false);
        if (typeNode != null) {
            this.visitType(typeNode, visitor);
        }
    }

    void visitType(ApiDescription.ManifestNode node, ApiDescriptionVisitor visitor) {
        IApiAnnotations annotations = this.resolveAnnotations(node, node.element);
        if (visitor.visitElement(node.element, annotations) && node.children != null) {
            this.visitChildren(visitor, node.children, null);
        }
        visitor.endVisitElement(node.element, annotations);
    }

    protected boolean isInsertOnResolve(IElementDescriptor elementDescriptor) {
        switch (elementDescriptor.getElementType()) {
            case 5: 
            case 6: {
                return false;
            }
            case 2: {
                return ((IReferenceTypeDescriptor)elementDescriptor).getEnclosingType() == null;
            }
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    protected ApiDescription.ManifestNode createNode(ApiDescription.ManifestNode parentNode, IElementDescriptor element) {
        switch (element.getElementType()) {
            case 1: {
                try {
                    pkg = (IPackageDescriptor)element;
                    roots = this.getJavaProject().getPackageFragmentRoots();
                    fragments = new ArrayList<IPackageFragment>(1);
                    i = 0;
                    while (i < roots.length) {
                        root = roots[i];
                        entry = root.getRawClasspathEntry();
                        switch (entry.getEntryKind()) {
                            case 1: 
                            case 3: {
                                fragment = root.getPackageFragment(pkg.getName());
                                if (!fragment.exists()) break;
                                fragments.add(fragment);
                                break;
                            }
                            default: {
                                if (root.isArchive() || root.getKind() != 2 || !(fragment = root.getPackageFragment(pkg.getName())).exists()) break;
                                fragments.add(fragment);
                            }
                        }
                        ++i;
                    }
                    if (!fragments.isEmpty()) ** GOTO lbl29
                    return null;
                }
                catch (CoreException v0) {
                    return null;
                }
lbl29:
                // 2 sources

                return this.newPackageNode(fragments.toArray(new IPackageFragment[fragments.size()]), parentNode, element, 2, 0);
            }
            case 2: {
                descriptor = (IReferenceTypeDescriptor)element;
                try {
                    type = null;
                    name = descriptor.getName();
                    if (parentNode instanceof PackageNode) {
                        fragments = ((PackageNode)parentNode).fFragments;
                        i = 0;
                        while (i < fragments.length) {
                            fragment = fragments[i];
                            if (fragment.getKind() == 1) {
                                unit = fragment.getCompilationUnit(String.valueOf(name) + ".java");
                                try {
                                    resource = unit.getUnderlyingResource();
                                    if (resource == null) ** GOTO lbl53
                                    type = unit.getType(name);
                                }
                                catch (JavaModelException jme) {
                                    if (jme.getJavaModelStatus().isDoesNotExist()) ** GOTO lbl53
                                    throw jme;
                                }
                            } else {
                                file = fragment.getClassFile(String.valueOf(name) + ".class");
                                if (file.exists()) {
                                    type = file.getType();
                                }
                            }
lbl53:
                            // 6 sources

                            ++i;
                        }
                    } else if (parentNode instanceof TypeNode) {
                        type = ((TypeNode)parentNode).fType.getType(name);
                    }
                    if (type != null) {
                        return this.newTypeNode(type, parentNode, element, 0, 0);
                    }
                }
                catch (CoreException v1) {
                    return null;
                }
                return null;
            }
        }
        return super.createNode(parentNode, element);
    }

    public PackageNode newPackageNode(IPackageFragment[] fragments, ApiDescription.ManifestNode parent, IElementDescriptor descriptor, int vis, int res) {
        return new PackageNode(fragments, parent, descriptor, vis, res);
    }

    TypeNode newTypeNode(IType type, ApiDescription.ManifestNode parent, IElementDescriptor descriptor, int vis, int res) {
        return new TypeNode(type, parent, descriptor, vis, res);
    }

    ApiDescription.ManifestNode newNode(ApiDescription.ManifestNode parent, IElementDescriptor element, int vis, int res) {
        return new ApiDescription.ManifestNode(parent, element, vis, res);
    }

    synchronized void refreshPackages() {
        if (this.fRefreshingInProgress) {
            if (ApiPlugin.DEBUG_API_DESCRIPTION) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("Refreshing manifest node: ");
                buffer.append(this);
                buffer.append(" aborted because a refresh is already in progress");
                System.out.println(buffer.toString());
            }
            return;
        }
        if (this.fManifestFile == null || this.fManifestFile.getModificationStamp() != this.fPackageTimeStamp) {
            try {
                this.modified();
                this.fRefreshingInProgress = true;
                Iterator iterator = this.fPackageMap.values().iterator();
                while (iterator.hasNext()) {
                    PackageNode node = (PackageNode)iterator.next();
                    node.visibility = 2;
                }
                this.fManifestFile = this.getJavaProject().getProject().getFile("META-INF/MANIFEST.MF");
                if (this.fManifestFile.exists()) {
                    try {
                        IPackageFragment[] fragments = this.getLocalPackageFragments();
                        HashSet<String> names = new HashSet<String>();
                        int i = 0;
                        while (i < fragments.length) {
                            names.add(fragments[i].getElementName());
                            ++i;
                        }
                        ProjectComponent component = this.getApiComponent();
                        BundleComponent.initializeApiDescription(this, component.getBundleDescription(), names);
                        this.fPackageTimeStamp = this.fManifestFile.getModificationStamp();
                    }
                    catch (CoreException e) {
                        ApiPlugin.log(e.getStatus());
                    }
                }
            }
            finally {
                this.fRefreshingInProgress = false;
            }
        }
    }

    private IElementDescriptor getElementDescriptor(IJavaElement element) {
        switch (element.getElementType()) {
            case 4: {
                return Factory.packageDescriptor(element.getElementName());
            }
            case 7: {
                return Factory.typeDescriptor(((IType)element).getFullyQualifiedName('$'));
            }
        }
        return null;
    }

    private IJavaProject getJavaProject() {
        return this.fProject;
    }

    synchronized IApiTypeContainer getApiTypeContainer(IPackageFragmentRoot root) throws CoreException {
        IApiTypeContainer container = this.getApiComponent().getTypeContainer(root);
        if (container == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.api.tools", "Unable to resolve type conatiner for package fragment root"));
        }
        return container;
    }

    private IPackageFragment[] getLocalPackageFragments() {
        ArrayList<IJavaElement> local = new ArrayList<IJavaElement>();
        try {
            IPackageFragmentRoot[] roots = this.getJavaProject().getPackageFragmentRoots();
            int i = 0;
            while (i < roots.length) {
                IPackageFragmentRoot root = roots[i];
                IResource resource = root.getCorrespondingResource();
                if (resource != null && resource.getProject().equals((Object)this.getJavaProject().getProject())) {
                    IJavaElement[] children = root.getChildren();
                    int j = 0;
                    while (j < children.length) {
                        local.add(children[j]);
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {}
        return local.toArray(new IPackageFragment[local.size()]);
    }

    public synchronized String getXML() throws CoreException {
        Document document = Util.newDocument();
        Element component = document.createElement("component");
        component.setAttribute("id", this.getJavaProject().getElementName());
        component.setAttribute("modificationStamp", Long.toString(this.fPackageTimeStamp));
        component.setAttribute("version", "1.2");
        document.appendChild(component);
        this.persistChildren(document, component, this.fPackageMap);
        return Util.serializeDocument(document);
    }

    void persistChildren(Document document, Element xmlElement, Map elementMap) {
        Iterator iterator = elementMap.values().iterator();
        while (iterator.hasNext()) {
            ApiDescription.ManifestNode node = (ApiDescription.ManifestNode)iterator.next();
            node.persistXML(document, xmlElement);
        }
    }

    public synchronized void clean() {
        this.fPackageMap.clear();
        this.fPackageTimeStamp = -1L;
        this.fInSynch = false;
        this.modified();
    }

    public synchronized void projectChanged() {
        this.fInSynch = false;
    }

    public synchronized void projectClasspathChanged() {
        this.fInSynch = false;
        this.fPackageTimeStamp = -1L;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Project API description for: ").append(this.getJavaProject().getElementName());
        return buffer.toString();
    }

    private ProjectComponent getApiComponent() throws CoreException {
        IApiBaseline baseline = ApiBaselineManager.getManager().getWorkspaceBaseline();
        ProjectComponent component = (ProjectComponent)baseline.getApiComponent(this.getJavaProject().getProject());
        if (component == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.api.tools", "Unable to resolve project API component for API description"));
        }
        return component;
    }

    protected IApiAnnotations resolveAnnotations(ApiDescription.ManifestNode node, IElementDescriptor element) {
        IApiAnnotations ann = super.resolveAnnotations(node, element);
        if (node instanceof TypeNode) {
            return new TypeAnnotations(ann, ((TypeNode)node).fBuildStamp);
        }
        return ann;
    }

    class PackageNode
    extends ApiDescription.ManifestNode {
        IPackageFragment[] fFragments;

        public PackageNode(IPackageFragment[] fragments, ApiDescription.ManifestNode parent, IElementDescriptor element, int visibility, int restrictions) {
            super(parent, element, visibility, restrictions);
            this.fFragments = fragments;
        }

        protected ApiDescription.ManifestNode refresh() {
            ProjectApiDescription.this.refreshPackages();
            int i = 0;
            while (i < this.fFragments.length) {
                if (!this.fFragments[i].exists()) {
                    ProjectApiDescription.this.modified();
                    return null;
                }
                ++i;
            }
            return this;
        }

        void persistXML(Document document, Element parent) {
            if (this.hasApiVisibility(this)) {
                Element pkg = document.createElement("package");
                int i = 0;
                while (i < this.fFragments.length) {
                    Element fragment = document.createElement("fragment");
                    fragment.setAttribute("handle", this.fFragments[i].getHandleIdentifier());
                    pkg.appendChild(fragment);
                    ++i;
                }
                pkg.setAttribute("visibility", Integer.toString(this.visibility));
                ProjectApiDescription.this.persistChildren(document, pkg, this.children);
                parent.appendChild(pkg);
            }
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            String name = ((IPackageDescriptor)this.element).getName();
            buffer.append("Package Node: ").append(name.equals("") ? "<default package>" : name);
            buffer.append("\nVisibility: ").append(VisibilityModifiers.getVisibilityName(this.visibility));
            buffer.append("\nRestrictions: ").append(RestrictionModifiers.getRestrictionText(this.restrictions));
            if (this.fFragments != null) {
                buffer.append("\nFragments:");
                IPackageFragment fragment = null;
                int i = 0;
                while (i < this.fFragments.length) {
                    fragment = this.fFragments[i];
                    buffer.append("\n\t").append(fragment.getElementName());
                    buffer.append(" [");
                    buffer.append(fragment.getParent().getElementName());
                    buffer.append("]");
                    ++i;
                }
            }
            return buffer.toString();
        }
    }

    class TypeNode
    extends ApiDescription.ManifestNode {
        long fTimeStamp = -1L;
        long fBuildStamp = -1L;
        private boolean fRefreshing = false;
        IType fType;

        public TypeNode(IType type, ApiDescription.ManifestNode parent, IElementDescriptor element, int visibility, int restrictions) {
            super(parent, element, visibility, restrictions);
            this.fType = type;
            if (parent instanceof TypeNode) {
                this.fTimeStamp = ((TypeNode)parent).fTimeStamp;
                this.fBuildStamp = ((TypeNode)parent).fBuildStamp;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected synchronized ApiDescription.ManifestNode refresh() {
            if (this.fRefreshing) {
                if (!ApiPlugin.DEBUG_API_DESCRIPTION) return this;
                StringBuffer buffer = new StringBuffer();
                buffer.append("Refreshing manifest node: ");
                buffer.append(this);
                buffer.append(" aborted because a refresh is already in progress");
                System.out.println(buffer.toString());
                return this;
            }
            try {
                this.fRefreshing = true;
                int parentVis = ProjectApiDescription.this.resolveVisibility(this.parent);
                if (!VisibilityModifiers.isAPI(parentVis)) return this;
                ICompilationUnit unit = this.fType.getCompilationUnit();
                if (unit != null) {
                    IResource resource;
                    block15: {
                        resource = null;
                        try {
                            resource = unit.getUnderlyingResource();
                        }
                        catch (JavaModelException e) {
                            if (ApiPlugin.DEBUG_API_DESCRIPTION) {
                                StringBuffer buffer = new StringBuffer();
                                buffer.append("Failed to get underlying resource for compilation unit: ");
                                buffer.append(unit);
                                System.out.println(buffer.toString());
                            }
                            if (e.getJavaModelStatus().isDoesNotExist()) break block15;
                            ApiPlugin.log(e.getStatus());
                            TypeNode typeNode = this;
                            this.fRefreshing = false;
                            return typeNode;
                        }
                    }
                    if (resource != null && resource.exists()) {
                        long stamp = resource.getModificationStamp();
                        if (stamp == this.fTimeStamp) return this;
                        CRCVisitor visitor = new CRCVisitor();
                        ProjectApiDescription.this.visitType(this, visitor);
                        long crc = visitor.getValue();
                        if (ApiPlugin.DEBUG_API_DESCRIPTION) {
                            StringBuffer buffer = new StringBuffer();
                            buffer.append("Resource has changed for type manifest node: ");
                            buffer.append(this);
                            buffer.append(" tag scanning the new type");
                            buffer.append(" (CRC ");
                            buffer.append(crc);
                            buffer.append(')');
                            System.out.println(buffer.toString());
                        }
                        ProjectApiDescription.this.modified();
                        this.children.clear();
                        this.restrictions = 0;
                        this.fTimeStamp = resource.getModificationStamp();
                        try {
                            TagScanner.newScanner().scan(unit, ProjectApiDescription.this, ProjectApiDescription.this.getApiTypeContainer((IPackageFragmentRoot)this.fType.getPackageFragment().getParent()), null);
                        }
                        catch (CoreException e) {
                            ApiPlugin.log(e.getStatus());
                        }
                        visitor = new CRCVisitor();
                        ProjectApiDescription.this.visitType(this, visitor);
                        long crc2 = visitor.getValue();
                        if (crc == crc2) return this;
                        this.fBuildStamp = BuildStamps.getBuildStamp(resource.getProject());
                        if (!ApiPlugin.DEBUG_API_DESCRIPTION) return this;
                        StringBuffer buffer = new StringBuffer();
                        buffer.append("CRC changed for type manifest node: ");
                        buffer.append(this);
                        buffer.append(" (CRC ");
                        buffer.append(crc2);
                        buffer.append(')');
                        System.out.println(buffer.toString());
                        return this;
                    }
                    if (ApiPlugin.DEBUG_API_DESCRIPTION) {
                        StringBuffer buffer = new StringBuffer();
                        buffer.append("Underlying resource for the type manifest node: ");
                        buffer.append(this);
                        buffer.append(" does not exist or is null");
                        System.out.println(buffer.toString());
                    }
                    ProjectApiDescription.this.modified();
                    this.parent.children.remove(this.element);
                    return null;
                }
                if (!ApiPlugin.DEBUG_API_DESCRIPTION) return this;
                StringBuffer buffer = new StringBuffer();
                buffer.append("Failed to look up compilation unit for ");
                buffer.append(this.fType);
                buffer.append(" refreshing type manifest node: ");
                buffer.append(this);
                System.out.println(buffer.toString());
                return this;
            }
            finally {
                this.fRefreshing = false;
            }
        }

        void persistXML(Document document, Element parent) {
            if (this.hasApiVisibility(this)) {
                Element type = document.createElement("type");
                type.setAttribute("handle", this.fType.getHandleIdentifier());
                this.persistAnnotations(type);
                type.setAttribute("modificationStamp", Long.toString(this.fTimeStamp));
                ProjectApiDescription.this.persistChildren(document, type, this.children);
                parent.appendChild(type);
            }
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Type Node: ").append(this.fType.getFullyQualifiedName());
            buffer.append("\nVisibility: ").append(VisibilityModifiers.getVisibilityName(this.visibility));
            buffer.append("\nRestrictions: ").append(RestrictionModifiers.getRestrictionText(this.restrictions));
            if (this.parent != null) {
                String pname = this.parent.element.getElementType() == 1 ? ((IPackageDescriptor)this.parent.element).getName() : ((IReferenceTypeDescriptor)this.parent.element).getQualifiedName();
                buffer.append("\nParent: ").append(pname);
            }
            return buffer.toString();
        }
    }
}

