/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.model.ui.editor.figures;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.stem.model.metamodel.Transition;
import org.eclipse.stem.model.ui.editor.vismodel.TransitionElement;

public class TransitionFigure
extends PolylineConnection {
    protected TransitionElement element;

    public TransitionFigure(TransitionElement transitionElement) {
        this.element = transitionElement;
        this.setTargetDecoration((RotatableDecoration)new PolygonDecoration());
        this.setLineWidth(2);
        this.setOutline(true);
        this.updateFlags();
    }

    public void updateFlags() {
        this.setForegroundColor(ColorConstants.black);
        Transition transition = this.element.getTransition();
        if (transition != null) {
            Resource resource = transition.getExpressionResource();
            if (resource != null) {
                if (resource.getErrors().size() > 0) {
                    this.setForegroundColor(ColorConstants.red);
                } else if (resource.getWarnings().size() > 0) {
                    this.setForegroundColor(ColorConstants.orange);
                } else {
                    this.setForegroundColor(ColorConstants.black);
                }
            } else {
                this.setForegroundColor(ColorConstants.black);
            }
        } else {
            this.setForegroundColor(ColorConstants.black);
        }
    }
}

