/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.populationmodels.standard.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.graph.NodeLabel;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.definitions.labels.EarthScienceLabel;
import org.eclipse.stem.definitions.labels.PopulationLabel;
import org.eclipse.stem.definitions.labels.PopulationLabelValue;
import org.eclipse.stem.populationmodels.standard.StandardPackage;
import org.eclipse.stem.populationmodels.standard.YetiPopulationInitializer;
import org.eclipse.stem.populationmodels.standard.impl.EarthSciencePopulationInitializerImpl;

public class YetiPopulationInitializerImpl
extends EarthSciencePopulationInitializerImpl
implements YetiPopulationInitializer {
    @Override
    protected void initializeLabel(PopulationLabel lab, STEMTime time, boolean zeroValue) {
        PopulationLabelValue plv = lab.getCurrentPopulationValue();
        if (zeroValue) {
            plv.setCount(0.0);
        } else {
            Node n = lab.getNode();
            double elevation = -1.0;
            for (NodeLabel nl : n.getLabels()) {
                if (!(nl instanceof EarthScienceLabel) || !((EarthScienceLabel)nl).getCurrentEarthScienceValue().getDataType().equals("elevation")) continue;
                elevation = (Double)((EarthScienceLabel)nl).getCurrentEarthScienceValue().getMean().get(0);
                break;
            }
            if (elevation == -1.0) {
                plv.setCount(0.0);
            } else {
                plv.setCount(elevation);
            }
        }
    }

    @Override
    protected EClass eStaticClass() {
        return StandardPackage.Literals.YETI_POPULATION_INITIALIZER;
    }
}

