/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.grapheditor;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class DynamicText
extends Composite
implements ModifyListener {
    private Text text;

    public DynamicText(Composite parent, String name, boolean editable) {
        super(parent, 2048);
        this.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label((Composite)this, 0);
        label.setLayoutData((Object)new GridData(4, 4, false, true));
        label.setText(String.valueOf(name) + ":");
        this.text = new Text((Composite)this, 0);
        this.text.setLayoutData((Object)new GridData(4, 4, true, true));
        this.text.addModifyListener((ModifyListener)this);
        this.text.setEditable(editable);
        this.text.setBackground(Display.getCurrent().getSystemColor(25));
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point size = super.computeSize(wHint, hHint, changed);
        if (this.text.getEditable()) {
            return new Point(size.x + 10, size.y);
        }
        return size;
    }

    protected void checkSubclass() {
    }

    public void modifyText(ModifyEvent e) {
        this.getParent().layout(true);
        this.getShell().layout(true);
    }

    public void addModifyListener(ModifyListener listener) {
        this.text.addModifyListener(listener);
    }

    public void setText(String s) {
        this.text.setText(s);
    }

    public void setEditable(boolean editable) {
        this.text.setEditable(editable);
    }
}

