/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.util.analysis;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.stem.analysis.impl.ReferenceScenarioDataMapImpl;

public class MeanSquareDifference {
    Map<String, List<Double>> commonInfectiousLocationsA = new HashMap<String, List<Double>>();
    Map<String, List<Double>> commonInfectiousLocationsB = new HashMap<String, List<Double>>();
    Map<String, List<Double>> commonSusceptibleLocationsA = new HashMap<String, List<Double>>();
    Map<String, List<Double>> commonSusceptibleLocationsB = new HashMap<String, List<Double>>();
    Map<String, List<Double>> totalPopulation = new HashMap<String, List<Double>>();
    public double[] locationCount;
    public double[] meanSqDiff;
    public double[] time;

    public MeanSquareDifference(ReferenceScenarioDataMapImpl scenarioMapA, ReferenceScenarioDataMapImpl scenarioMapB, IRunnableContext runnableContext) {
        final ReferenceScenarioDataMapImpl mapA = scenarioMapA;
        final ReferenceScenarioDataMapImpl mapB = scenarioMapB;
        IRunnableWithProgress task = new IRunnableWithProgress(){

            public void run(IProgressMonitor progress) {
                progress.beginTask("Calculating common locations...", mapA.getNumLocations());
                Iterator iteratorA = mapA.getLocations().iterator();
                int maxTime = -1;
                while (iteratorA.hasNext()) {
                    progress.worked(1);
                    if (progress.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    String id = (String)iteratorA.next();
                    if (!mapB.containsLocation(id)) continue;
                    ReferenceScenarioDataMapImpl.ReferenceScenarioDataInstance dataMapA = mapA.getLocation(id);
                    List<Double> dataAI = MeanSquareDifference.this.getNormalizedInfectious(dataMapA);
                    MeanSquareDifference.this.commonInfectiousLocationsA.put(id, dataAI);
                    List<Double> dataAS = MeanSquareDifference.this.getNormalizedSusceptible(dataMapA);
                    MeanSquareDifference.this.commonSusceptibleLocationsA.put(id, dataAS);
                    MeanSquareDifference.this.totalPopulation.put(id, MeanSquareDifference.this.getTotalPopulation(dataMapA));
                    ReferenceScenarioDataMapImpl.ReferenceScenarioDataInstance dataMapB = mapB.getLocation(id);
                    List<Double> dataBI = MeanSquareDifference.this.getNormalizedInfectious(dataMapB);
                    MeanSquareDifference.this.commonInfectiousLocationsB.put(id, dataBI);
                    List<Double> dataBS = MeanSquareDifference.this.getNormalizedSusceptible(dataMapB);
                    MeanSquareDifference.this.commonSusceptibleLocationsB.put(id, dataBS);
                    if (maxTime == -1) {
                        maxTime = dataAI.size();
                    }
                    if (maxTime >= dataBI.size()) {
                        maxTime = dataBI.size();
                    }
                    if (maxTime < dataAI.size()) continue;
                    maxTime = dataAI.size();
                }
                progress.done();
                if (maxTime <= 0) {
                    maxTime = 0;
                }
                if (MeanSquareDifference.this.time == null) {
                    MeanSquareDifference.this.time = new double[maxTime];
                    MeanSquareDifference.this.meanSqDiff = new double[maxTime];
                    MeanSquareDifference.this.locationCount = new double[maxTime];
                    int i = 0;
                    while (i < maxTime) {
                        MeanSquareDifference.this.time[i] = i;
                        MeanSquareDifference.this.meanSqDiff[i] = 0.0;
                        MeanSquareDifference.this.locationCount[i] = 0.0;
                        ++i;
                    }
                }
            }
        };
        try {
            runnableContext.run(true, false, task);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
    }

    public List<Double> getNormalizedInfectious(ReferenceScenarioDataMapImpl.ReferenceScenarioDataInstance dataMap) {
        List exposedList = dataMap.getEtotals();
        List recoveredList = dataMap.getRtotals();
        List infectiousList = dataMap.getItotals();
        List susceptibleList = dataMap.getStotals();
        assert (infectiousList != null);
        assert (susceptibleList != null);
        ArrayList<Double> normalizedInfectious = new ArrayList<Double>();
        double[] totalPop = new double[infectiousList.size()];
        int i = 0;
        while (i < infectiousList.size()) {
            double inf = (Double)infectiousList.get(i);
            double susc = (Double)susceptibleList.get(i);
            double exposed = 0.0;
            double recovered = 0.0;
            if (exposedList != null && exposedList.size() >= i) {
                exposed = (Double)exposedList.get(i);
            }
            if (recoveredList != null && recoveredList.size() >= i) {
                recovered = (Double)recoveredList.get(i);
            }
            totalPop[i] = inf + susc + exposed + recovered;
            normalizedInfectious.add(new Double(inf /= totalPop[i]));
            ++i;
        }
        return normalizedInfectious;
    }

    public List<Double> getNormalizedSusceptible(ReferenceScenarioDataMapImpl.ReferenceScenarioDataInstance dataMap) {
        List exposedList = dataMap.getEtotals();
        List recoveredList = dataMap.getRtotals();
        List infectiousList = dataMap.getItotals();
        List susceptibleList = dataMap.getStotals();
        assert (infectiousList != null);
        assert (susceptibleList != null);
        ArrayList<Double> normalizedSusceptible = new ArrayList<Double>();
        double[] totalPop = new double[susceptibleList.size()];
        int i = 0;
        while (i < susceptibleList.size()) {
            double inf = (Double)infectiousList.get(i);
            double susc = (Double)susceptibleList.get(i);
            double exposed = 0.0;
            double recovered = 0.0;
            if (exposedList != null && exposedList.size() >= i) {
                exposed = (Double)exposedList.get(i);
            }
            if (recoveredList != null && recoveredList.size() >= i) {
                recovered = (Double)recoveredList.get(i);
            }
            totalPop[i] = inf + susc + exposed + recovered;
            susc = totalPop[i] != 0.0 ? (susc /= totalPop[i]) : 0.0;
            normalizedSusceptible.add(new Double(susc));
            ++i;
        }
        return normalizedSusceptible;
    }

    public List<Double> getTotalPopulation(ReferenceScenarioDataMapImpl.ReferenceScenarioDataInstance dataMap) {
        List exposedList = dataMap.getEtotals();
        List recoveredList = dataMap.getRtotals();
        List infectiousList = dataMap.getItotals();
        List susceptibleList = dataMap.getStotals();
        assert (infectiousList != null);
        assert (susceptibleList != null);
        ArrayList<Double> population = new ArrayList<Double>();
        int i = 0;
        while (i < infectiousList.size()) {
            double totalPop = 0.0;
            double inf = (Double)infectiousList.get(i);
            double susc = (Double)susceptibleList.get(i);
            double exposed = 0.0;
            double recovered = 0.0;
            if (exposedList != null && exposedList.size() >= i) {
                exposed = (Double)exposedList.get(i);
            }
            if (recoveredList != null && recoveredList.size() >= i) {
                recovered = (Double)recoveredList.get(i);
            }
            totalPop = inf + susc + exposed + recovered;
            population.add(new Double(totalPop));
            ++i;
        }
        return population;
    }

    public double[] solve(IRunnableContext runnableContext) {
        IRunnableWithProgress task = new IRunnableWithProgress(){

            public void run(IProgressMonitor progress) {
                progress.beginTask("Solving...", MeanSquareDifference.this.time.length);
                double[] maxPopulation = new double[MeanSquareDifference.this.time.length];
                int icount = 0;
                while (icount < MeanSquareDifference.this.time.length) {
                    progress.worked(1);
                    if (progress.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    maxPopulation[icount] = 0.0;
                    for (String id : MeanSquareDifference.this.commonInfectiousLocationsA.keySet()) {
                        List<Double> dataAI = MeanSquareDifference.this.commonInfectiousLocationsA.get(id);
                        List<Double> dataBI = MeanSquareDifference.this.commonInfectiousLocationsB.get(id);
                        List<Double> population = MeanSquareDifference.this.totalPopulation.get(id);
                        double iA = dataAI.get(icount);
                        double iB = dataBI.get(icount);
                        double pop = population.get(icount);
                        if (!(iA > 0.0) && !(iB > 0.0)) continue;
                        int n = icount;
                        MeanSquareDifference.this.locationCount[n] = MeanSquareDifference.this.locationCount[n] + 1.0;
                        int n2 = icount;
                        maxPopulation[n2] = maxPopulation[n2] + pop;
                        double term = (iA - iB) * (iA - iB);
                        double numer = pop * Math.sqrt(term);
                        int n3 = icount;
                        MeanSquareDifference.this.meanSqDiff[n3] = MeanSquareDifference.this.meanSqDiff[n3] + numer;
                    }
                    if (MeanSquareDifference.this.locationCount[icount] >= 1.0) {
                        int n = icount;
                        MeanSquareDifference.this.meanSqDiff[n] = MeanSquareDifference.this.meanSqDiff[n] / maxPopulation[icount];
                    }
                    ++icount;
                }
                progress.done();
            }
        };
        try {
            runnableContext.run(true, true, task);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            return null;
        }
        return this.meanSqDiff;
    }
}

