/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.lib;

import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import java.util.Map;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.internal.FunctionDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapExtensions {
    public static <K, V> void forEach(Map<K, V> map, Procedures.Procedure2<? super K, ? super V> procedure) {
        if (procedure == null) {
            throw new NullPointerException("procedure");
        }
        for (Map.Entry<K, V> entry : map.entrySet()) {
            procedure.apply(entry.getKey(), entry.getValue());
        }
    }

    public static <K, V> void forEach(Map<K, V> map, Procedures.Procedure3<? super K, ? super V, ? super Integer> procedure) {
        if (procedure == null) {
            throw new NullPointerException("procedure");
        }
        int i = 0;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            procedure.apply(entry.getKey(), entry.getValue(), i);
            if (i == Integer.MAX_VALUE) continue;
            ++i;
        }
    }

    public static <K, V> Map<K, V> filter(Map<K, V> original, final Functions.Function2<? super K, ? super V, Boolean> predicate) {
        if (predicate == null) {
            throw new NullPointerException("predicate");
        }
        return Maps.filterEntries(original, (Predicate)new Predicate<Map.Entry<K, V>>(){

            public boolean apply(Map.Entry<K, V> input) {
                Boolean result = (Boolean)predicate.apply(input.getKey(), input.getValue());
                return result;
            }
        });
    }

    public static <K, V1, V2> Map<K, V2> mapValues(Map<K, V1> original, Functions.Function1<? super V1, V2> transformation) {
        return Maps.transformValues(original, new FunctionDelegate<V1, V2>(transformation));
    }
}

