/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.library.build.tasks.maven;

import com.google.common.base.Charsets;
import io.takari.aether.wagon.OkHttpWagon;
import io.takari.aether.wagon.OkHttpsWagon;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.StreamWagon;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.providers.file.FileWagon;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositoryListener;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.spi.locator.ServiceLocator;
import org.eclipse.aether.transfer.TransferListener;
import org.eclipse.aether.transport.wagon.WagonProvider;
import org.eclipse.aether.transport.wagon.WagonTransporterFactory;
import org.eclipse.core.internal.variables.StringVariableManager;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.jdt.apt.core.util.AptConfig;
import org.eclipse.jdt.apt.core.util.IFactoryPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.search.indexing.IndexManager;
import org.eclipse.tea.core.services.TaskProgressTracker;
import org.eclipse.tea.core.services.TaskingLog;
import org.eclipse.tea.library.build.config.BuildDirectories;
import org.eclipse.tea.library.build.config.TeaBuildConfig;
import org.eclipse.tea.library.build.model.MavenExternalJarBuild;
import org.eclipse.tea.library.build.model.PluginBuild;
import org.eclipse.tea.library.build.model.PluginData;
import org.eclipse.tea.library.build.model.WorkspaceBuild;
import org.eclipse.tea.library.build.tasks.maven.ConsoleRepositoryListener;
import org.eclipse.tea.library.build.tasks.maven.ConsoleTransferListener;
import org.eclipse.tea.library.build.util.FileUtils;
import org.eclipse.tea.library.build.util.StringHelper;

public class SynchronizeMavenArtifact {
    private static final RepositoryPolicy DISABLED_POLICY = new RepositoryPolicy(false, null, null);
    private static final RepositoryPolicy RELEASE_POLICY = new RepositoryPolicy(true, "daily", "warn");
    private static final RepositoryPolicy SNAPSHOT_POLICY = new RepositoryPolicy(true, "always", "warn");
    private static final String MAVEN_DIRNAME = "maven";
    private static String lastExceptionName;
    private MavenConfig properties;

    public String toString() {
        return "Synchronize Maven";
    }

    @Execute
    public void run(TaskingLog log, TaskProgressTracker tracker, TeaBuildConfig cfg, WorkspaceBuild wb) throws Exception {
        this.properties = SynchronizeMavenArtifact.getMavenConfig(log, cfg);
        if (this.properties == null) {
            return;
        }
        ResourcesPlugin.getWorkspace().run(m -> this.runOperation(log, tracker, cfg, wb), null);
    }

    /*
     * Unable to fully structure code
     */
    private void runOperation(TaskingLog log, TaskProgressTracker tracker, TeaBuildConfig cfg, WorkspaceBuild wb) throws CoreException {
        block18: {
            block17: {
                indexManager = JavaModelManager.getIndexManager();
                indexManager.disable();
                SynchronizeMavenArtifact.lastExceptionName = null;
                classpathManipulatorOfPlugin = new HashMap<PluginBuild, MavenAwareClasspathManipulator>();
                try {
                    try {
                        AptConfig.setFactoryPath(null, (IFactoryPath)AptConfig.getFactoryPath(null));
                        locator = SynchronizeMavenArtifact.createServiceLocator(log);
                        system = (RepositorySystem)locator.getService(RepositorySystem.class);
                        session = this.createSession(log, system);
                        remotes = this.createRemoteRepositories();
                        log.info("before synchronizing, inspect classpath for maven artifacts");
                        for (PluginBuild pb : wb.getSourcePlugIns()) {
                            if (pb.getMavenExternalJarDependencies().isEmpty() || ((PluginData)pb.getData()).isBinary()) continue;
                            prj = ((PluginData)pb.getData()).getProject();
                            javaProject = JavaCore.create((IProject)prj);
                            mavenFolder = prj.getFolder("maven");
                            cpManip = MavenAwareClasspathManipulator.of(pb.getPluginName(), javaProject, mavenFolder);
                            classpathManipulatorOfPlugin.put(pb, cpManip);
                        }
                        log.info("before synchronizing, stop indexer for maven artifacts");
                        for (MavenAwareClasspathManipulator cpManip : classpathManipulatorOfPlugin.values()) {
                            cpManip.discardMavenIndexerJobs(indexManager);
                        }
                        log.info("before synchronizing, drop maven artifacts from classpath");
                        for (MavenAwareClasspathManipulator cpManip : classpathManipulatorOfPlugin.values()) {
                            cpManip.setNonMavenClasspath();
                        }
                        ResourcesPlugin.getWorkspace().checkpoint(false);
                        System.gc();
                        System.runFinalization();
                        for (PluginBuild pb : classpathManipulatorOfPlugin.keySet()) {
                            this.runSingle(log, tracker, pb, system, (RepositorySystemSession)session, remotes);
                        }
                        break block17;
                    }
                    catch (Exception e) {
                        log.error("error synchronizing maven artifacts", (Throwable)e);
                        ResourcesPlugin.getWorkspace().checkpoint(false);
                        log.info("after synchronizing, restore classpaths with maven artifacts");
                        ** for (cpManip : classpathManipulatorOfPlugin.values())
                    }
                }
                catch (Throwable var17_27) {
                    ResourcesPlugin.getWorkspace().checkpoint(false);
                    log.info("after synchronizing, restore classpaths with maven artifacts");
                    ** for (cpManip : classpathManipulatorOfPlugin.values())
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        cpManip.setOriginalClasspath();
                    }
                    catch (Exception e) {
                        log.error("error restoring classpath of " + cpManip.getPluginName(), (Throwable)e);
                    }
                    continue;
                }
lbl48:
                // 1 sources

                ResourcesPlugin.getWorkspace().checkpoint(false);
                indexManager.enable();
                break block18;
lbl-1000:
                // 1 sources

                {
                    try {
                        cpManip.setOriginalClasspath();
                    }
                    catch (Exception e) {
                        log.error("error restoring classpath of " + cpManip.getPluginName(), (Throwable)e);
                    }
                    continue;
                }
lbl61:
                // 1 sources

                ResourcesPlugin.getWorkspace().checkpoint(false);
                indexManager.enable();
                throw var17_27;
            }
            ResourcesPlugin.getWorkspace().checkpoint(false);
            log.info("after synchronizing, restore classpaths with maven artifacts");
            for (MavenAwareClasspathManipulator cpManip : classpathManipulatorOfPlugin.values()) {
                try {
                    cpManip.setOriginalClasspath();
                }
                catch (Exception e) {
                    log.error("error restoring classpath of " + cpManip.getPluginName(), (Throwable)e);
                }
            }
            ResourcesPlugin.getWorkspace().checkpoint(false);
            indexManager.enable();
        }
    }

    public static MavenConfig getMavenConfig(TaskingLog log, TeaBuildConfig cfg) throws Exception {
        if (cfg.mavenConfigFilePath == null || StringHelper.isNullOrEmpty(cfg.mavenConfigFilePath)) {
            log.info("Skipping synchronization because no maven configuration has been set");
            return null;
        }
        String expanded = StringVariableManager.getDefault().performStringSubstitution(cfg.mavenConfigFilePath);
        File file = new File(expanded);
        if (!file.isAbsolute()) {
            file = new File(ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile(), expanded);
        }
        if (!file.exists()) {
            log.warn("Maven configuration file " + file + " is missing");
            return null;
        }
        return new MavenConfig(file);
    }

    private void runSingle(TaskingLog log, TaskProgressTracker tracker, PluginBuild hostPlugin, RepositorySystem system, RepositorySystemSession session, List<RemoteRepository> remotes) throws CoreException {
        IProject prj = ((PluginData)hostPlugin.getData()).getProject();
        IFolder folder = prj.getFolder(MAVEN_DIRNAME);
        if (!folder.exists()) {
            folder.create(false, true, null);
            log.warn("creating " + folder.getName() + "; make sure to add to the classpath of " + hostPlugin.getPluginName());
        }
        File target = folder.getRawLocation().toFile();
        TreeSet<File> valid = new TreeSet<File>(Comparator.comparing(File::getName));
        for (MavenExternalJarBuild artifact : hostPlugin.getMavenExternalJarDependencies()) {
            tracker.setTaskName(artifact.getCoordinates());
            tracker.worked(1);
            log.info("synchronize nexus coordinate " + artifact.getCoordinates() + " into " + hostPlugin.getPluginName());
            Coordinate coord = new Coordinate(artifact.getCoordinates());
            DefaultArtifact mvn = new DefaultArtifact(coord.group, coord.artifact, coord.classifier, coord.extension, coord.version);
            ArtifactRequest localrq = new ArtifactRequest().setArtifact((Artifact)mvn);
            boolean remote = false;
            try {
                ArtifactResult local = system.resolveArtifact(session, localrq);
                if (local.isMissing() || !local.isResolved() || local.getArtifact().isSnapshot()) {
                    remote = true;
                }
            }
            catch (Exception e) {
                remote = true;
            }
            ArtifactRequest remoterq = new ArtifactRequest().setArtifact((Artifact)mvn).setRepositories(remote ? remotes : null);
            this.resolveArtifact(log, target, system, session, remoterq, valid);
            try {
                DefaultArtifact srcmvn = new DefaultArtifact(coord.group, coord.artifact, "sources", coord.extension, coord.version);
                ArtifactRequest srcrq = new ArtifactRequest().setArtifact((Artifact)srcmvn).setRepositories(remote ? remotes : null);
                this.resolveArtifact(log, target, system, session, srcrq, valid);
            }
            catch (Exception e) {
                log.warn("No sources available for " + artifact.getCoordinates());
            }
        }
        File[] fileArray = target.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (!file.getName().equals(".gitignore")) {
                boolean isValid = false;
                for (File validFile : valid) {
                    if (!file.equals(validFile)) continue;
                    isValid = true;
                }
                if (!isValid) {
                    log.info("removing old maven artifact: " + file);
                    FileUtils.delete(file);
                }
            }
            ++n2;
        }
        File gitignore = new File(target, ".gitignore");
        if (!gitignore.exists()) {
            try {
                FileUtils.writeFileFromString(gitignore, Charsets.UTF_8, "*.jar");
            }
            catch (IOException e) {
                throw new CoreException(Status.error((String)e.getMessage(), (Throwable)e));
            }
        }
        folder.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
    }

    private void resolveArtifact(TaskingLog log, File target, RepositorySystem system, RepositorySystemSession session, ArtifactRequest rq, Set<File> resolved) {
        Artifact mvn = rq.getArtifact();
        try {
            ArtifactResult result = system.resolveArtifact(session, rq);
            if (result.isMissing() || !result.isResolved()) {
                log.warn("cannot resolve " + mvn.getGroupId() + ":" + mvn.getArtifactId() + ":" + mvn.getVersion() + ":" + mvn.getClassifier());
                if (!result.getExceptions().isEmpty()) {
                    for (Exception e : result.getExceptions()) {
                        e.printStackTrace(log.error());
                    }
                }
                return;
            }
            if (this.properties.isVerboseMavenOutput() && !result.getExceptions().isEmpty()) {
                for (Exception e : result.getExceptions()) {
                    e.printStackTrace(log.debug());
                }
            }
            File file = result.getArtifact().getFile();
            SynchronizeMavenArtifact.addFileToProjectsMavenFolder(log, target, resolved, result, file);
        }
        catch (Exception e) {
            String c = mvn.getClassifier();
            if (!"sources".equals(c)) {
                String classifier = c == null || c.isEmpty() ? "" : ":" + c;
                log.error("cannot resolve " + mvn.getGroupId() + ":" + mvn.getArtifactId() + classifier + ":" + mvn.getVersion());
            }
            throw new RuntimeException("failed to synchronize " + rq.getArtifact().getArtifactId(), e);
        }
    }

    private static void addFileToProjectsMavenFolder(TaskingLog log, File target, Set<File> resolved, ArtifactResult result, File file) throws IOException {
        File targetFile = new File(target, file.getName());
        resolved.add(targetFile);
        if (targetFile.exists() && !result.getArtifact().isSnapshot() && !targetFile.delete()) {
            if (targetFile.length() != file.length()) {
                log.error("cannot update " + targetFile + " to new version, please make sure file is not locked");
            }
            return;
        }
        boolean copyNeeded = true;
        try {
            FileUtils.delete(targetFile);
        }
        catch (IllegalStateException e) {
            if (FileUtils.equals(targetFile, file)) {
                log.info("Could not update file. Probably in use. Can be ignored since contents is the same: " + targetFile);
                copyNeeded = false;
            }
            throw e;
        }
        if (copyNeeded) {
            try {
                targetFile = Files.createSymbolicLink(targetFile.toPath(), file.toPath(), new FileAttribute[0]).toFile();
            }
            catch (IOException e) {
                String exName = e.getClass().getName();
                if (!Objects.equals(exName, lastExceptionName)) {
                    lastExceptionName = exName;
                    String msg = e.getMessage();
                    if (msg != null) {
                        msg = msg.replace("\n", "\\n");
                        msg = msg.replace("\r", "\\r");
                    }
                    log.warn("cannot create symlink for: " + targetFile + " (" + exName + " " + msg + ")");
                }
                FileUtils.copyFileToDirectory(file, target);
            }
        }
    }

    private List<RemoteRepository> createRemoteRepositories() {
        ArrayList<RemoteRepository> repos = new ArrayList<RemoteRepository>();
        for (Map.Entry<String, String> repo : this.properties.getMavenRepos().entrySet()) {
            RemoteRepository.Builder builder = new RemoteRepository.Builder("nexus_" + repo.getKey(), "default", repo.getValue());
            if (repo.getKey().startsWith("snapshot")) {
                builder.setReleasePolicy(DISABLED_POLICY);
                builder.setSnapshotPolicy(SNAPSHOT_POLICY);
            } else if (repo.getKey().startsWith("release")) {
                builder.setSnapshotPolicy(DISABLED_POLICY);
                builder.setReleasePolicy(RELEASE_POLICY);
            }
            repos.add(builder.build());
        }
        return repos;
    }

    private DefaultRepositorySystemSession createSession(TaskingLog log, RepositorySystem system) {
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        LocalRepository repo = new LocalRepository(BuildDirectories.get().getMavenDirectory());
        session.setLocalRepositoryManager(system.newLocalRepositoryManager((RepositorySystemSession)session, repo));
        if (this.properties.isVerboseMavenOutput()) {
            session.setTransferListener((TransferListener)new ConsoleTransferListener(log.debug()));
            session.setRepositoryListener((RepositoryListener)new ConsoleRepositoryListener(log.debug()));
        }
        return session;
    }

    private static ServiceLocator createServiceLocator(final TaskingLog log) {
        DefaultServiceLocator locator = MavenRepositorySystemUtils.newServiceLocator();
        locator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        locator.addService(TransporterFactory.class, WagonTransporterFactory.class);
        locator.addService(WagonProvider.class, InternalWagonProvider.class);
        locator.setErrorHandler(new DefaultServiceLocator.ErrorHandler(){

            public void serviceCreationFailed(Class<?> type, Class<?> impl, Throwable exception) {
                log.error("cannot create service " + type.getName());
                exception.printStackTrace(log.error());
            }
        });
        return locator;
    }

    private static class Coordinate {
        final String group;
        final String artifact;
        final String extension;
        final String classifier;
        final String version;

        public Coordinate(String coord) {
            Matcher matcher = PluginBuild.MAVEN_COORDINATE_PATTERN.matcher(coord);
            if (!matcher.matches()) {
                throw new IllegalStateException("Illegal maven coordinates: " + coord);
            }
            this.group = matcher.group(1);
            this.artifact = matcher.group(2);
            this.extension = Coordinate.get(matcher.group(4), "jar");
            this.classifier = Coordinate.get(matcher.group(6), "");
            this.version = matcher.group(7);
        }

        private static String get(String value, String defaultValue) {
            return value == null || value.length() <= 0 ? defaultValue : value;
        }
    }

    private static class InternalWagonProvider
    implements WagonProvider {
        private InternalWagonProvider() {
        }

        public Wagon lookup(String roleHint) throws Exception {
            switch (roleHint) {
                case "file": {
                    return new FileWagon();
                }
                case "http": {
                    return new OkHttpWagon();
                }
                case "https": {
                    return new OkHttpsWagon();
                }
            }
            return null;
        }

        public void release(Wagon wagon) {
            if (wagon instanceof StreamWagon) {
                try {
                    ((StreamWagon)wagon).closeConnection();
                }
                catch (ConnectionException e) {
                    throw new RuntimeException("Cannot close connection", e);
                }
            }
        }
    }

    private static class MavenAwareClasspathManipulator {
        private final String pluginName;
        private final IJavaProject jp;
        private final IClasspathEntry[] originalCP;
        private final List<IClasspathEntry> mavenCP;
        private final List<IClasspathEntry> nonMavenCP;

        private MavenAwareClasspathManipulator(String pluginName, IJavaProject jp, IClasspathEntry[] originalCP) {
            this.pluginName = pluginName;
            this.jp = jp;
            this.originalCP = originalCP;
            this.mavenCP = new ArrayList<IClasspathEntry>();
            this.nonMavenCP = new ArrayList<IClasspathEntry>();
        }

        static MavenAwareClasspathManipulator of(String pluginName, IJavaProject jp, IFolder mavenFolder) throws JavaModelException {
            IPath mavenPath = mavenFolder.getFullPath();
            IClasspathEntry[] originalCP = jp.getRawClasspath();
            MavenAwareClasspathManipulator ret = new MavenAwareClasspathManipulator(pluginName, jp, originalCP);
            IClasspathEntry[] iClasspathEntryArray = originalCP;
            int n = originalCP.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry cp = iClasspathEntryArray[n2];
                if (cp.getEntryKind() == 1 && mavenPath.isPrefixOf(cp.getPath())) {
                    ret.mavenCP.add(cp);
                } else {
                    ret.nonMavenCP.add(cp);
                }
                ++n2;
            }
            return ret;
        }

        void discardMavenIndexerJobs(IndexManager indexManager) {
            for (IClasspathEntry cp : this.mavenCP) {
                indexManager.discardJobs(cp.getPath().toString());
            }
        }

        void setNonMavenClasspath() throws JavaModelException {
            this.jp.setRawClasspath(this.nonMavenCP.toArray(new IClasspathEntry[this.nonMavenCP.size()]), false, (IProgressMonitor)new NullProgressMonitor());
        }

        void setOriginalClasspath() throws JavaModelException {
            this.jp.setRawClasspath(this.originalCP, false, (IProgressMonitor)new NullProgressMonitor());
        }

        String getPluginName() {
            return this.pluginName;
        }
    }

    public static class MavenConfig {
        private static final String MAVEN_REPO_URL = "maven_repo_url_";
        private static final String MAVEN_REPO_TYPE = "maven_repo_type_";
        protected final Properties props;

        public MavenConfig(File file) throws IOException {
            try (FileInputStream fis = new FileInputStream(file);){
                this.props = new Properties();
                this.props.load(fis);
            }
        }

        public Properties getProps() {
            return this.props;
        }

        public Map<String, String> getMavenRepos() {
            long repoNum = 0L;
            TreeMap<String, String> result = new TreeMap<String, String>();
            for (String key : this.props.stringPropertyNames()) {
                if (key == null || !key.startsWith(MAVEN_REPO_URL)) continue;
                String type = this.props.getProperty(MAVEN_REPO_TYPE + key.substring(MAVEN_REPO_URL.length()));
                result.put(String.valueOf(type) + repoNum++, this.props.getProperty(key));
            }
            return result;
        }

        public boolean isVerboseMavenOutput() {
            String x = this.props.getProperty("maven_verbose");
            return Boolean.parseBoolean(x);
        }
    }
}

