/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.core.internal.context;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.e4.core.contexts.ContextFunction;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IContextFunction;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.IInjector;
import org.eclipse.tea.core.TaskingInjectionHelper;
import org.eclipse.tea.core.services.TaskingLog;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(service={IContextFunction.class}, property={"service.context.key=org.eclipse.tea.core.services.TaskingLog"})
public class TaskingLogLookupContextFunction
extends ContextFunction {
    private final List<TaskingLog> services = new ArrayList<TaskingLog>();

    public Object compute(IEclipseContext context, String contextKey) {
        Boolean headless = TaskingInjectionHelper.isHeadless(context);
        for (TaskingLog s : this.services) {
            TaskingLog.TaskingLogQualifier q = s.getClass().getAnnotation(TaskingLog.TaskingLogQualifier.class);
            if (q == null || q.headless() != headless.booleanValue()) continue;
            context.set(TaskingLog.class, (Object)s);
            ContextInjectionFactory.invoke((Object)s, TaskingLog.TaskingLogInit.class, (IEclipseContext)context);
            return s;
        }
        return IInjector.NOT_A_VALUE;
    }

    @Reference(service=TaskingLog.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    public void addTaskingLog(TaskingLog log) {
        this.services.add(log);
    }

    public void removeTaskingLog(TaskingLog log) {
        this.services.remove(log);
    }
}

