/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.jar;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class InstallJars {
    public static final int BLOCK_SIZE = 512;
    public static final int BLOCK_COUNT = 20;
    public static int bufferSize = 131072;
    protected boolean verbose;
    protected boolean run;
    protected boolean expand;
    protected String propFilename;
    protected String javaParams = "cmd /c java";
    protected static final int OFFSET_NAME = 0;
    protected static final int OFFSET_MODE = 100;
    protected static final int OFFSET_UID = 108;
    protected static final int OFFSET_GID = 116;
    protected static final int OFFSET_SIZE = 124;
    protected static final int OFFSET_MTIME = 136;
    protected static final int OFFSET_CHKSUM = 148;
    protected static final int OFFSET_TYPE = 156;
    protected static final int OFFSET_LINKNAME = 157;
    protected static final int OFFSET_MAGIC = 257;
    protected static final int OFFSET_VERSION = 263;
    protected static final int OFFSET_UNAME = 265;
    protected static final int OFFSET_GNAME = 297;
    protected static final int OFFSET_DEVMAJOR = 329;
    protected static final int OFFSET_DEVMINOR = 337;
    protected static final int OFFSET_PREFIX = 345;
    protected static final int OFFSET_END = 500;
    protected static final String MAGIC = "USTAR";

    public InstallJars() {
        this(true, true, true, "InstallJars.properties", "cmd /c java");
    }

    public InstallJars(boolean bl, boolean bl2, boolean bl3, String string, String string2) {
        this.setExpand(bl);
        this.setVerbose(bl2);
        this.setRunMode(bl3);
        this.setPropFilename(string);
        this.setJavaParams(string2);
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public boolean getRunMode() {
        return this.run;
    }

    public void setRunMode(boolean bl) {
        this.run = bl;
    }

    public boolean getExpand() {
        return this.expand;
    }

    public void setExpand(boolean bl) {
        this.expand = bl;
    }

    public String getPropFilename() {
        return this.propFilename;
    }

    public void setPropFilename(String string) {
        this.propFilename = string;
    }

    public String getJavaParams() {
        return this.javaParams;
    }

    public void setJavaParams(String string) {
        this.javaParams = string;
    }

    protected void print(String string) {
        if (this.verbose) {
            System.out.print(string);
        }
    }

    protected void println(String string) {
        if (this.verbose) {
            System.out.println(string);
        }
    }

    protected void println() {
        this.println("");
    }

    public String install() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        Properties properties = new Properties();
        properties.load(new BufferedInputStream(new FileInputStream(this.propFilename)));
        for (String string : properties.keySet()) {
            String string2 = properties.getProperty(string);
            String string3 = null;
            String string4 = null;
            String string5 = null;
            boolean bl = this.expand;
            boolean bl2 = this.run;
            if (string2 != null && (string2 = string2.trim()).length() > 0) {
                String string6 = string2.substring(0, 1);
                StringTokenizer stringTokenizer = new StringTokenizer(string2.substring(1), string6);
                string3 = stringTokenizer.nextToken();
                string4 = (stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : ".").trim();
                if (string4.length() == 0) {
                    string4 = ".";
                }
                if ((string5 = (stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : string4).trim()).length() == 0) {
                    string5 = string4;
                }
                stringBuffer.append(string5);
                stringBuffer.append(";");
                while (stringTokenizer.hasMoreTokens()) {
                    String string7 = stringTokenizer.nextToken().trim();
                    if (string7.equalsIgnoreCase("expand")) {
                        bl = true;
                        continue;
                    }
                    if (string7.equalsIgnoreCase("noexpand")) {
                        bl = false;
                        continue;
                    }
                    if (string7.equalsIgnoreCase("run")) {
                        bl2 = true;
                        continue;
                    }
                    if (string7.equalsIgnoreCase("norun")) {
                        bl2 = false;
                        continue;
                    }
                    throw new IllegalArgumentException("invalid install property - " + string + "=" + string2);
                }
            }
            if (string3 == null || string3.length() == 0) {
                throw new IllegalArgumentException("missing install property - " + string + "=" + string2);
            }
            System.out.print("\nInstalling " + string);
            if (this.verbose) {
                System.out.print(" using URL=" + string3 + "; target=" + string4 + "; classpath=" + string5 + "; " + (bl ? "expand" : "noexpand") + "; " + (bl2 ? "run" : "norun"));
            }
            System.out.println("...");
            this.installFile(string3, string4, bl, bl2);
        }
        return stringBuffer.toString();
    }

    public void installFile(String string, String string2, boolean bl, boolean bl2) throws IOException {
        String string3 = new File(string2).getCanonicalPath().replace('\\', '/');
        this.println("Installing in " + string3);
        URL uRL = new URL(string);
        URLConnection uRLConnection = uRL.openConnection();
        String string4 = uRLConnection.getContentType();
        this.println("Content type is " + string4);
        String string5 = this.getExtension(string);
        if (string5.equals("class")) {
            this.installClass(uRLConnection, string3, bl, bl2);
        } else if (string5.equalsIgnoreCase("zip")) {
            this.installZip(uRLConnection, string3, bl, bl2);
        } else if (string5.equalsIgnoreCase("gz")) {
            this.installGZip(uRLConnection, string3, bl, bl2);
        } else if (string5.equalsIgnoreCase("jar")) {
            this.installJar(uRLConnection, string3, bl, bl2);
        } else {
            throw new IllegalArgumentException("Unknown extension - " + string5);
        }
    }

    public void installClass(URLConnection uRLConnection, String string, boolean bl, boolean bl2) throws IOException {
        this.print("Installing class file " + string + " from " + uRLConnection.getURL().toExternalForm());
        this.copyStream(uRLConnection, string);
        this.println();
        if (bl2) {
            this.runTarget(string, false);
        }
    }

    protected void runTarget(String string, boolean bl) throws IOException {
        if (bl) {
            System.out.println("runTarget(" + string + "," + bl + ") not currently implemented");
        } else {
            try {
                String string2 = this.removeExtension(this.getFile(string));
                String string3 = "-cp " + this.removeFile(string);
                String string4 = String.valueOf(this.javaParams) + " " + string3 + " " + string2 + " >" + string2 + ".out 2>" + string2 + ".err";
                System.out.println("Running " + string4 + "...");
                Process process = Runtime.getRuntime().exec(string4);
                int n = process.waitFor();
                System.out.println("Return code=" + n);
            }
            catch (Exception exception) {
                System.out.println("Exception - " + exception.getMessage());
            }
        }
    }

    public void installJar(URLConnection uRLConnection, String string, boolean bl, boolean bl2) throws IOException {
        if (bl) {
            this.println("Expanding JAR file " + string + " from " + uRLConnection.getURL().toExternalForm());
            ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(uRLConnection.getInputStream(), 10240));
            int n = 0;
            this.prepDirs(string, true);
            try {
                while (zipInputStream.available() > 0) {
                    ZipEntry zipEntry = zipInputStream.getNextEntry();
                    this.copyEntry(string, zipInputStream, zipEntry);
                    ++n;
                }
            }
            catch (Throwable throwable) {
                try {
                    zipInputStream.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                zipInputStream.close();
            }
            catch (IOException iOException) {}
            this.println("Installed " + n + " files/directories");
        } else {
            this.print("Installing JAR file " + string + " from " + uRLConnection.getURL().toExternalForm());
            this.copyStream(uRLConnection, string);
            this.println();
            if (bl2) {
                this.runTarget(string, true);
            }
        }
    }

    public void installZip(URLConnection uRLConnection, String string, boolean bl, boolean bl2) throws IOException {
        if (bl) {
            String string2 = uRLConnection.getContentType();
            if (!string2.equals("application/zip")) {
                throw new IllegalArgumentException("Unkexpected content type - " + string2);
            }
            this.println("Expanding ZIP file to " + string + " from " + uRLConnection.getURL().toExternalForm());
            ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(uRLConnection.getInputStream(), 10240));
            int n = 0;
            this.prepDirs(string, true);
            try {
                ZipEntry zipEntry = zipInputStream.getNextEntry();
                while (zipEntry != null) {
                    this.copyEntry(string, zipInputStream, zipEntry);
                    ++n;
                    zipEntry = zipInputStream.getNextEntry();
                }
            }
            catch (Throwable throwable) {
                try {
                    zipInputStream.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                zipInputStream.close();
            }
            catch (IOException iOException) {}
            this.println("Installed " + n + " files/directories");
        } else {
            this.print("Installing ZIP file " + string + " from " + uRLConnection.getURL().toExternalForm());
            this.copyStream(uRLConnection, string);
            this.println();
        }
    }

    public void installGZip(URLConnection uRLConnection, String string, boolean bl, boolean bl2) throws IOException {
        if (bl) {
            String string2 = uRLConnection.getContentType();
            if (!string2.equals("application/x-tar")) {
                throw new IllegalArgumentException("Unkexpected content type - " + string2);
            }
            this.print("Expanding GZIP file to " + string + " from " + uRLConnection.getURL().toExternalForm());
            this.prepDirs(string, false);
            GZIPInputStream gZIPInputStream = new GZIPInputStream(new BufferedInputStream(uRLConnection.getInputStream(), 10240));
            try {
                this.pumpGZip(string, gZIPInputStream);
            }
            catch (Throwable throwable) {
                try {
                    gZIPInputStream.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                gZIPInputStream.close();
            }
            catch (IOException iOException) {}
            this.println();
        } else {
            this.print("Installing GZIP file " + string + " from " + uRLConnection.getURL().toExternalForm());
            this.copyStream(uRLConnection, string);
            this.println();
        }
    }

    protected void copyEntry(String string, ZipInputStream zipInputStream, ZipEntry zipEntry) throws IOException {
        String string2 = zipEntry.getName();
        boolean bl = false;
        if (string2.endsWith("/")) {
            string2 = string2.substring(0, string2.length() - 1);
            bl = true;
        }
        String string3 = String.valueOf(string) + File.separator + string2;
        string3 = string3.replace('\\', '/');
        String string4 = zipEntry.getSize() > 0L ? "[" + zipEntry.getCompressedSize() + ":" + zipEntry.getSize() + "]" : "";
        this.print("Expanding " + zipEntry + string4 + " to " + string3);
        this.prepDirs(string3, bl);
        if (!bl) {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string3), 10240);
            try {
                byte[] byArray = new byte[bufferSize];
                int n = zipInputStream.read(byArray, 0, byArray.length);
                int n2 = 0;
                while (n >= 0) {
                    bufferedOutputStream.write(byArray, 0, n);
                    n = zipInputStream.read(byArray, 0, byArray.length);
                    ++n2;
                }
            }
            catch (Throwable throwable) {
                try {
                    bufferedOutputStream.flush();
                    bufferedOutputStream.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                bufferedOutputStream.flush();
                bufferedOutputStream.close();
            }
            catch (IOException iOException) {}
        }
        this.println();
    }

    public void copyStream(URLConnection uRLConnection, String string) throws IOException {
        this.prepDirs(string, false);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(uRLConnection.getInputStream(), 10240);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string), 10240);
        byte[] byArray = new byte[bufferSize];
        int n = bufferedInputStream.read(byArray);
        int n2 = 0;
        while (n >= 0) {
            bufferedOutputStream.write(byArray, 0, n);
            n = bufferedInputStream.read(byArray);
            ++n2;
        }
        bufferedOutputStream.flush();
        bufferedOutputStream.close();
        bufferedInputStream.close();
    }

    protected void pumpGZip(String string, GZIPInputStream gZIPInputStream) throws IOException {
        int n;
        String string2 = null;
        long l = 0L;
        long l2 = 0L;
        char c = '\u0000';
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        BufferedOutputStream bufferedOutputStream = null;
        int n4 = 0;
        int n5 = 0;
        byte[] byArray = new byte[bufferSize];
        block2: while ((n = this.loadBytes(byArray, gZIPInputStream)) >= 0) {
            int n6 = 0;
            while (n6 < n) {
                if (bl && l2 > 0L) {
                    int n7 = Math.min((int)l2, 512);
                    if (bufferedOutputStream != null) {
                        bufferedOutputStream.write(byArray, n6, n7);
                    }
                    l2 -= (long)n7;
                } else {
                    if (bl) {
                        bl = false;
                        if (bufferedOutputStream != null) {
                            try {
                                bufferedOutputStream.flush();
                                bufferedOutputStream.close();
                            }
                            catch (IOException iOException) {}
                            this.println();
                        }
                    }
                    if (this.isEmptyBlock(byArray, n6)) break block2;
                    string2 = this.extractString(byArray, n6 + 0, 100);
                    c = this.extractChar(byArray, n6 + 156);
                    l = this.extractLong(byArray, n6 + 124, 12);
                    l2 = l;
                    if (l2 > Integer.MAX_VALUE) {
                        throw new IOException("entry size too large - " + l2);
                    }
                    String string3 = "";
                    String string4 = this.extractString(byArray, n6 + 257, 6);
                    if (string4.equals(MAGIC)) {
                        string2 = String.valueOf(this.extractString(byArray, n6 + 345, 155)) + string2;
                        this.extractInt(byArray, n6 + 263, 2);
                        n2 = this.extractInt(byArray, n6 + 329, 8);
                        n3 = this.extractInt(byArray, n6 + 337, 8);
                        if (n2 > 0 || n3 > 0) {
                            string3 = "[" + n2 + '.' + n3 + "]";
                        }
                    }
                    String string5 = String.valueOf(string) + File.separator + string2;
                    string5 = string5.replace('\\', '/');
                    bufferedOutputStream = null;
                    if (c == '\u0000' || c == '0') {
                        this.print("Copying " + string2 + string3 + " to " + string5);
                        this.prepDirs(string5, false);
                        bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string5), 10240);
                        bl = true;
                        ++n4;
                    } else if (c == '1' || c == '2') {
                        if (l > 0L) {
                            throw new IOException("link entries cannot have content - " + l);
                        }
                        this.println("Link ignored - " + string2 + string3);
                    } else if (c == '5') {
                        if (string5.endsWith("/")) {
                            string5 = string5.substring(0, string5.length() - 1);
                        }
                        this.println("Mkdir " + string2 + string3 + " to " + string5);
                        this.prepDirs(string5, true);
                        ++n5;
                    } else {
                        if (l > 0L) {
                            bl = true;
                        }
                        this.print("Entry type " + c + " ignored - " + string2 + string3);
                    }
                }
                n6 += 512;
            }
        }
        this.println("Installed " + n4 + " files and " + n5 + " directories");
    }

    protected int loadBytes(byte[] byArray, GZIPInputStream gZIPInputStream) throws IOException {
        int n = -1;
        int n2 = gZIPInputStream.read(byArray, 0, byArray.length);
        int n3 = 0;
        while (n2 > 0) {
            if (n < 0) {
                n = 0;
            }
            n2 = gZIPInputStream.read(byArray, n += n2, byArray.length - n);
            ++n3;
        }
        return n;
    }

    protected boolean isEmptyBlock(byte[] byArray, int n) {
        boolean bl = true;
        int n2 = 0;
        while (bl && n2 < 512) {
            bl = byArray[n++] == 0;
            ++n2;
        }
        return bl;
    }

    protected char extractChar(byte[] byArray, int n) throws IOException {
        return (char)byArray[n];
    }

    protected int extractInt(byte[] byArray, int n, int n2) throws IOException {
        return (int)this.extractLong(byArray, n, n2);
    }

    protected long extractLong(byte[] byArray, int n, int n2) throws IOException {
        String string = this.extractString(byArray, n, n2);
        long l = 0L;
        int n3 = 0;
        while (n3 < string.length()) {
            char c = string.charAt(n3);
            if (c != ' ') {
                if (c < '0' || c > '7') {
                    throw new IOException("non-octal digit found - " + c);
                }
                l = l * 8L + (long)(c - 48);
            }
            ++n3;
        }
        return l;
    }

    protected String extractString(byte[] byArray, int n, int n2) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        int n4 = n;
        while (n3 < n2) {
            byte by = byArray[n4];
            if (by == 0) break;
            stringBuffer.append((char)by);
            ++n3;
            ++n4;
        }
        return stringBuffer.toString();
    }

    protected String getFile(String string) {
        int n = string.lastIndexOf("/");
        return n > 0 ? string.substring(n + 1) : string;
    }

    protected String removeFile(String string) {
        int n = string.lastIndexOf("/");
        return n > 0 ? string.substring(0, n) : string;
    }

    protected String removeExtension(String string) {
        int n = string.lastIndexOf("/");
        int n2 = string.lastIndexOf(".");
        return n2 > 0 && n2 > n ? string.substring(0, n2) : string;
    }

    protected String extraceFile(String string) {
        int n = string.lastIndexOf(File.separator);
        return n >= 0 ? string.substring(n + 1) : null;
    }

    protected String getExtension(String string) {
        int n = string.lastIndexOf(46);
        return n >= 0 ? string.substring(n + 1) : "";
    }

    protected void prepDirs(String string) {
        this.prepDirs(string, this.expand);
    }

    protected void prepDirs(String string, boolean bl) {
        File file = new File(bl ? string : this.removeFile(string));
        file.mkdirs();
    }

    protected void printUsage() {
        this.println("Effective command: " + this.getClass().getName() + " " + this.propFilename + (this.expand ? " -expand" : " -noexpand") + (this.run ? " -run" : " -norun") + " -java \"" + this.javaParams + "\"" + (this.verbose ? " -verbose" : " -quiet "));
    }

    protected static void printHelp() {
        System.out.println();
        System.out.println("Usage: java " + InstallJars.class.getName() + " {propFilename} {-expand | -noexpand} {-run | -norun} {-quiet | -verbose} {-java <params>}");
        System.out.println("Where:");
        System.out.println("  propFilename    path to properties file (default=InstallJars.properties)");
        System.out.println("  -expand         expand any top level JAR/ZIP/GZIP (default)");
        System.out.println("  -noexpand       do not expand any top level JAR/ZIP/GZIP");
        System.out.println("  -run            run class or JAR files (default)");
        System.out.println("  -norun          do not run class or JAR files");
        System.out.println("  -verbose        output progress messages (default)");
        System.out.println("  -quiet          suppress most messages");
        System.out.println("  -java           sets java runtime paramters");
        System.out.println();
        System.out.println("Properties file entry format: name=!url{!target{!classpath{!option}...}}");
        System.out.println("Where:");
        System.out.println("  name      name displayed while installing");
        System.out.println("  url       source of items to download and install");
        System.out.println("  target    root of install directory or file (default=.)");
        System.out.println("  classpath class path entry to use for this directrory or file (default=target}");
        System.out.println("  option    one of the following options: expand, noexpand, run, norun");
        System.out.println("            if omitted, the command line default is used");
        System.out.println("! is a delimiter, the first non-whitespace character is used.");
        System.out.println("Options expand and run may not apply to all types of files.");
    }

    public static void main(String[] stringArray) {
        String string;
        if (stringArray.length == 0) {
            InstallJars.printHelp();
            System.exit(0);
        }
        String string2 = null;
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        String string3 = "cmd /c java";
        int n = 0;
        while (n < stringArray.length) {
            string = stringArray[n];
            if (string.charAt(0) == '-') {
                if ((string = string.substring(1)).equalsIgnoreCase("quiet")) {
                    bl2 = false;
                } else if (string.equalsIgnoreCase("verbose")) {
                    bl2 = true;
                } else if (string.equalsIgnoreCase("expand")) {
                    bl = true;
                } else if (string.equalsIgnoreCase("noexpand")) {
                    bl = false;
                } else if (string.equalsIgnoreCase("run")) {
                    bl3 = true;
                } else if (string.equalsIgnoreCase("norun")) {
                    bl3 = false;
                } else if (string.equalsIgnoreCase("java")) {
                    bl3 = false;
                    if (n < stringArray.length - 1) {
                        string3 = stringArray[++n];
                    }
                } else {
                    System.err.println("Invalid switch - " + string);
                    System.exit(1);
                }
            } else if (string2 == null) {
                string2 = string;
            } else {
                System.err.println("Too many parameters - " + string);
                System.exit(1);
            }
            ++n;
        }
        if (string2 == null) {
            string2 = "InstallJars.properties";
        }
        try {
            InstallJars installJars = new InstallJars(bl, bl2, bl3, string2, string3);
            installJars.printUsage();
            string = installJars.install();
            System.out.println("\nRecomended additions to your classpath - " + string);
        }
        catch (Exception exception) {
            System.err.println("\n" + exception.getClass().getName() + ": " + exception.getMessage());
            if (bl2) {
                exception.printStackTrace();
            }
            System.exit(2);
        }
    }
}

