/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.dom.sgml.impl;

import java.io.IOException;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;
import org.eclipse.actf.model.dom.html.ParseException;
import org.eclipse.actf.model.internal.dom.sgml.ISGMLConstants;
import org.eclipse.actf.model.internal.dom.sgml.impl.AttributeDefinition;
import org.eclipse.actf.model.internal.dom.sgml.impl.DTDParseException;
import org.eclipse.actf.model.internal.dom.sgml.impl.DTDTokenizer;
import org.eclipse.actf.model.internal.dom.sgml.impl.ElementDefinition;
import org.eclipse.actf.model.internal.dom.sgml.impl.SGMLDocTypeDef;
import org.eclipse.actf.model.internal.dom.sgml.impl.SGMLEntityDeclaration;
import org.eclipse.actf.model.internal.dom.sgml.impl.SGMLEntityReference;
import org.eclipse.actf.model.internal.dom.sgml.impl.SGMLParser;
import org.eclipse.actf.model.internal.dom.sgml.modelgroup.AndModelGroup;
import org.eclipse.actf.model.internal.dom.sgml.modelgroup.IModelGroup;
import org.eclipse.actf.model.internal.dom.sgml.modelgroup.OptModelGroup;
import org.eclipse.actf.model.internal.dom.sgml.modelgroup.OrModelGroup;
import org.eclipse.actf.model.internal.dom.sgml.modelgroup.PlusModelGroup;
import org.eclipse.actf.model.internal.dom.sgml.modelgroup.RepModelGroup;
import org.eclipse.actf.model.internal.dom.sgml.modelgroup.SeqModelGroup;

class DTDParser
implements ISGMLConstants {
    private DTDTokenizer tokenizer;
    private Stack<DTDTokenizer> tokenizerStack = new Stack();
    private SGMLDocTypeDef dtd;

    DTDParser(DTDTokenizer dTDTokenizer, SGMLDocTypeDef sGMLDocTypeDef) {
        this.tokenizer = dTDTokenizer;
        this.dtd = sGMLDocTypeDef;
    }

    /*
     * Unable to fully structure code
     */
    final ElementDefinition readDTD() throws ParseException, IOException {
        block22: {
            var1_1 = null;
            block8: while (true) {
                if (this.tokenizer.nextToken() != -1) ** GOTO lbl7
                break block22;
lbl-1000:
                // 1 sources

                {
                    this.tokenizer.nextToken();
lbl7:
                    // 2 sources

                    ** while (this.tokenizer.ttype == 13)
                }
lbl8:
                // 1 sources

                switch (this.tokenizer.ttype) {
                    case 1: {
                        switch (this.tokenizer.nextToken()) {
                            case 11: {
                                var2_2 = this.tokenizer.sval;
                                if (var2_2.equalsIgnoreCase("ELEMENT")) {
                                    var1_1 = this.readElementDefinition();
                                } else if (var2_2.equalsIgnoreCase("ATTLIST")) {
                                    this.readAttributeList();
                                } else if (var2_2.equalsIgnoreCase("ENTITY")) {
                                    this.readEntity();
                                } else {
                                    throw new DTDParseException("Unknown Declaration: " + (String)var2_2);
                                }
                                while (this.tokenizer.nextToken() != 62) {
                                }
                                continue block8;
                            }
                            case 91: {
                                if (this.mark()) {
                                    if (this.tokenizer.nextToken() == 91) {
                                        this.tokenizer.switchTo(0);
                                        var1_1 = this.readDTD();
                                        this.tokenizer.switchTo(1);
                                        if (this.tokenizer.nextToken() == 93 && this.tokenizer.nextToken() == 93 && this.tokenizer.nextToken() == 62) {
                                            continue block8;
                                        }
                                    }
                                } else if (this.tokenizer.nextToken() == 91) {
                                    this.tokenizer.skipToDSC();
                                    if (this.tokenizer.nextToken() == 93 && this.tokenizer.nextToken() == 62) continue block8;
                                }
                                throw new DTDParseException("invalid mark region.");
                            }
                        }
                        throw new DTDParseException("invalid declaration");
                    }
                    case 37: {
                        this.tokenizer.pushBack();
                        var2_2 = this.readEntityReference();
                        var3_3 = var2_2.getEntityDeclaration();
                        if (var3_3 == null) continue block8;
                        this.tokenizerStack.push(this.tokenizer);
                        this.tokenizer = new DTDTokenizer(var3_3.getReplacementReader());
                        this.readDTD();
                        this.tokenizer = this.tokenizerStack.pop();
                        continue block8;
                    }
                }
                break;
            }
            this.tokenizer.pushBack();
        }
        return var1_1;
    }

    private ElementDefinition readElementDefinition() throws ParseException, IOException {
        boolean bl;
        ElementDefinition[] elementDefinitionArray = this.readElementType();
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = bl = this.dtd.toString().indexOf("XHTML") < 0;
        if (bl) {
            bl2 = this.omit();
            bl3 = this.omit();
        }
        IModelGroup iModelGroup = this.exp();
        if (!bl && iModelGroup.toString().equalsIgnoreCase("EMPTY")) {
            bl3 = true;
        }
        int n = 0;
        while (n < elementDefinitionArray.length) {
            elementDefinitionArray[n].setStartTag(bl2);
            elementDefinitionArray[n].setEndTag(bl3);
            elementDefinitionArray[n].setContentModel(iModelGroup);
            ++n;
        }
        if (this.tokenizer.nextToken() == 3) {
            ElementDefinition[] elementDefinitionArray2 = this.inclusion();
            n = 0;
            while (n < elementDefinitionArray.length) {
                elementDefinitionArray[n].setInclusion(elementDefinitionArray2);
                ++n;
            }
        } else if (this.tokenizer.ttype == 4) {
            ElementDefinition[] elementDefinitionArray3 = this.inclusion();
            n = 0;
            while (n < elementDefinitionArray.length) {
                elementDefinitionArray[n].setExclusion(elementDefinitionArray3);
                ++n;
            }
        } else {
            this.tokenizer.pushBack();
        }
        return elementDefinitionArray[0];
    }

    private ElementDefinition[] readElementType() throws ParseException, IOException {
        if (this.tokenizer.nextToken() == 40) {
            Vector<ElementDefinition[]> vector = new Vector<ElementDefinition[]>();
            vector.addElement(this.makeElementArray(this.atom()));
            while (this.tokenizer.nextToken() == 124) {
                vector.addElement(this.makeElementArray(this.atom()));
            }
            if (this.tokenizer.ttype != 41) {
                throw new DTDParseException("invalid ELEMENT type");
            }
            int n = 0;
            ElementDefinition[] elementDefinitionArray = vector.elements();
            while (elementDefinitionArray.hasMoreElements()) {
                n += ((ElementDefinition[])elementDefinitionArray.nextElement()).length;
            }
            elementDefinitionArray = new ElementDefinition[n];
            int n2 = 0;
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                ElementDefinition[] elementDefinitionArray2 = (ElementDefinition[])enumeration.nextElement();
                int n3 = 0;
                while (n3 < elementDefinitionArray2.length) {
                    elementDefinitionArray[n2++] = elementDefinitionArray2[n3];
                    ++n3;
                }
            }
            return elementDefinitionArray;
        }
        this.tokenizer.pushBack();
        return this.makeElementArray(this.atom());
    }

    private void readEntity() throws ParseException, IOException {
        if (this.tokenizer.nextToken() != 37) {
            if (this.tokenizer.ttype == 11) {
                String string = this.tokenizer.sval;
                int n = this.tokenizer.nextToken();
                if (n == 11 && this.tokenizer.sval.equalsIgnoreCase("CDATA")) {
                    if (this.tokenizer.nextToken() == 5) {
                        this.dtd.putEntityDeclaration(string, this.tokenizer.sval);
                        return;
                    }
                } else if (n == 5) {
                    this.dtd.putEntityDeclaration(string, this.tokenizer.sval);
                    return;
                }
            }
            throw new DTDParseException("invalid entity");
        }
        if (this.tokenizer.nextToken() == 11) {
            String string = this.tokenizer.sval;
            if (this.tokenizer.nextToken() != 5) {
                if (this.tokenizer.ttype == 11 && this.tokenizer.sval.equalsIgnoreCase("PUBLIC") && this.tokenizer.nextToken() == 5) {
                    String string2 = this.tokenizer.sval;
                    String string3 = SGMLParser.pubEntityMap.get(string2);
                    if (string3 == null) {
                        System.out.println(String.valueOf(string) + " : " + string2 + " : " + string3);
                        throw new DTDParseException("invalid entity");
                    }
                    this.dtd.putPublicEntity(string, string2, string3);
                    if (this.tokenizer.nextToken() == 62) {
                        this.tokenizer.pushBack();
                        return;
                    }
                    if (this.tokenizer.ttype == 5) {
                        return;
                    }
                }
            } else {
                this.dtd.putEntityDeclaration(string, this.tokenizer.sval);
                return;
            }
        }
        throw new DTDParseException("invalid entity");
    }

    private SGMLEntityReference readEntityReference() throws ParseException, IOException {
        if (this.tokenizer.nextToken() == 37 && (this.tokenizer.nextToken() == 11 || this.tokenizer.ttype == 14)) {
            String string = this.tokenizer.sval;
            if (this.tokenizer.nextToken() != 59) {
                this.tokenizer.pushBack();
            }
            return this.dtd.getEntityReference(string);
        }
        throw new DTDParseException("invalid entity reference");
    }

    private void readToken(AttributeDefinition attributeDefinition) throws ParseException, IOException {
        if (this.tokenizer.nextToken() == 11 || this.tokenizer.ttype == 12) {
            attributeDefinition.addNameToken(this.tokenizer.sval);
        } else if (this.tokenizer.ttype == 37) {
            this.tokenizer.pushBack();
            SGMLEntityReference sGMLEntityReference = this.readEntityReference();
            SGMLEntityDeclaration sGMLEntityDeclaration = sGMLEntityReference.getEntityDeclaration();
            this.tokenizerStack.push(this.tokenizer);
            this.tokenizer = new DTDTokenizer(sGMLEntityDeclaration.getReplacementReader(), 1);
            this.readTokenGroup(attributeDefinition);
            this.tokenizer = this.tokenizerStack.pop();
        } else {
            throw new DTDParseException("invalid token");
        }
    }

    private void readTokenGroup(AttributeDefinition attributeDefinition) throws ParseException, IOException {
        this.readToken(attributeDefinition);
        while (this.tokenizer.nextToken() != 41 && this.tokenizer.ttype != -1) {
            if (this.tokenizer.ttype != 124) {
                throw new DTDParseException("invalid token group");
            }
            this.readToken(attributeDefinition);
        }
    }

    private IModelGroup exp() throws ParseException, IOException {
        IModelGroup iModelGroup = this.term();
        int n = this.tokenizer.nextToken();
        switch (n) {
            case 44: {
                SeqModelGroup seqModelGroup = new SeqModelGroup(iModelGroup);
                seqModelGroup.add(this.term());
                while (this.tokenizer.nextToken() == 44) {
                    seqModelGroup.add(this.term());
                }
                this.tokenizer.pushBack();
                if (seqModelGroup.getChildLength() > this.dtd.maxSeqLength) {
                    this.dtd.maxSeqLength = seqModelGroup.getChildLength();
                }
                return seqModelGroup;
            }
            case 124: {
                iModelGroup = new OrModelGroup(iModelGroup);
                ((OrModelGroup)iModelGroup).add(this.term());
                while (this.tokenizer.nextToken() == 124) {
                    ((OrModelGroup)iModelGroup).add(this.term());
                }
                this.tokenizer.pushBack();
                return iModelGroup;
            }
            case 38: {
                iModelGroup = new AndModelGroup(iModelGroup);
                ((AndModelGroup)iModelGroup).add(this.term());
                while (this.tokenizer.nextToken() == 38) {
                    ((AndModelGroup)iModelGroup).add(this.term());
                }
                this.tokenizer.pushBack();
                return iModelGroup;
            }
        }
        this.tokenizer.pushBack();
        return iModelGroup;
    }

    private IModelGroup term() throws ParseException, IOException {
        IModelGroup iModelGroup = this.factor();
        int n = this.tokenizer.nextToken();
        switch (n) {
            case 63: {
                iModelGroup = new OptModelGroup(iModelGroup);
                break;
            }
            case 43: {
                iModelGroup = new PlusModelGroup(iModelGroup);
                break;
            }
            case 42: {
                iModelGroup = new RepModelGroup(iModelGroup);
                break;
            }
            default: {
                this.tokenizer.pushBack();
            }
        }
        return iModelGroup;
    }

    private IModelGroup factor() throws ParseException, IOException {
        switch (this.tokenizer.nextToken()) {
            case 40: {
                IModelGroup iModelGroup = this.exp();
                if (this.tokenizer.nextToken() != 41) {
                    throw new DTDParseException("ret: " + iModelGroup.toString() + " sval: " + this.tokenizer.sval + " ttype: " + this.tokenizer.ttype);
                }
                return iModelGroup;
            }
            case 2: {
                return SGMLParser.cdata;
            }
            case 12: {
                if (this.tokenizer.sval.equalsIgnoreCase("#PCDATA")) {
                    return SGMLParser.pcdata;
                }
                throw new DTDParseException("sval: " + this.tokenizer.sval + " ttype: " + this.tokenizer.ttype);
            }
        }
        if (this.tokenizer.ttype == 11 && this.tokenizer.sval.equalsIgnoreCase("EMPTY")) {
            return SGMLParser.empty;
        }
        if (this.tokenizer.ttype == 11 && this.tokenizer.sval.equalsIgnoreCase("CDATA")) {
            return SGMLParser.cdata;
        }
        this.tokenizer.pushBack();
        return this.atom();
    }

    private IModelGroup atom() throws ParseException, IOException {
        if (this.tokenizer.nextToken() == 11) {
            return this.dtd.createElementDefinition(this.tokenizer.sval);
        }
        if (this.tokenizer.ttype == 37) {
            this.tokenizer.pushBack();
            SGMLEntityReference sGMLEntityReference = this.readEntityReference();
            SGMLEntityDeclaration sGMLEntityDeclaration = sGMLEntityReference.getEntityDeclaration();
            IModelGroup iModelGroup = sGMLEntityDeclaration.getReplacementSubtree();
            if (iModelGroup == null) {
                this.tokenizerStack.push(this.tokenizer);
                this.tokenizer = new DTDTokenizer(sGMLEntityDeclaration.getReplacementReader(), 1);
                iModelGroup = this.exp();
                sGMLEntityDeclaration.setReplacementSubtree(iModelGroup);
                this.tokenizer = this.tokenizerStack.pop();
            }
            return iModelGroup;
        }
        throw new DTDParseException("sval: " + this.tokenizer.sval + " ttype: " + this.tokenizer.ttype);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void declaredValue(AttributeDefinition attributeDefinition) throws ParseException, IOException {
        if (this.tokenizer.nextToken() == 11) {
            String string = this.tokenizer.sval;
            if (string.equalsIgnoreCase("CDATA")) {
                attributeDefinition.setDeclaredType(1);
                return;
            } else if (string.equalsIgnoreCase("ID")) {
                attributeDefinition.setDeclaredType(2);
                return;
            } else if (string.equalsIgnoreCase("IDREF")) {
                attributeDefinition.setDeclaredType(3);
                return;
            } else if (string.equalsIgnoreCase("IDREFS")) {
                attributeDefinition.setDeclaredType(4);
                return;
            } else if (string.equalsIgnoreCase("NAME")) {
                attributeDefinition.setDeclaredType(6);
                return;
            } else if (string.equalsIgnoreCase("NUMBER")) {
                attributeDefinition.setDeclaredType(5);
                return;
            } else if (string.equalsIgnoreCase("NMTOKEN")) {
                attributeDefinition.setDeclaredType(8);
                return;
            } else {
                if (!string.equalsIgnoreCase("NAMES")) throw new DTDParseException(String.valueOf(this.tokenizer.getCurrentLine()) + ": unknown declared value " + string);
                attributeDefinition.setDeclaredType(9);
            }
            return;
        } else if (this.tokenizer.ttype == 40) {
            attributeDefinition.setDeclaredType(7);
            this.readTokenGroup(attributeDefinition);
            return;
        } else {
            if (this.tokenizer.ttype != 37) throw new DTDParseException("at " + this.tokenizer);
            this.tokenizer.pushBack();
            SGMLEntityReference sGMLEntityReference = this.readEntityReference();
            SGMLEntityDeclaration sGMLEntityDeclaration = sGMLEntityReference.getEntityDeclaration();
            this.tokenizerStack.push(this.tokenizer);
            this.tokenizer = new DTDTokenizer(sGMLEntityDeclaration.getReplacementReader(), 1);
            this.declaredValue(attributeDefinition);
            this.tokenizer = this.tokenizerStack.pop();
        }
    }

    private void defaultValue(AttributeDefinition attributeDefinition) throws ParseException, IOException {
        switch (this.tokenizer.nextToken()) {
            case 11: {
                attributeDefinition.setDefaultValue(this.tokenizer.sval);
                break;
            }
            case 5: {
                String string = this.tokenizer.sval;
                break;
            }
            case 12: {
                String string = this.tokenizer.sval;
                if (string.equalsIgnoreCase("#REQUIRED")) {
                    attributeDefinition.setDefaultType(2);
                    break;
                }
                if (string.equalsIgnoreCase("#IMPLIED")) {
                    attributeDefinition.setDefaultType(3);
                    break;
                }
                if (string.equalsIgnoreCase("#FIXED")) {
                    if (this.tokenizer.nextToken() == -1) {
                        this.tokenizer = this.tokenizerStack.peek();
                    } else {
                        this.tokenizer.pushBack();
                    }
                    if (this.tokenizer.nextToken() != 5) {
                        throw new DTDParseException(String.valueOf(this.tokenizer.getCurrentLine()) + ": STRING must follow #FIXED");
                    }
                    attributeDefinition.setDefaultType(1);
                    string = this.tokenizer.sval;
                    this.tokenizerStack.push(this.tokenizer);
                    this.tokenizer = new DTDTokenizer(new StringReader(string), 1);
                    try {
                        SGMLEntityReference sGMLEntityReference = this.readEntityReference();
                        attributeDefinition.setDefaultValue(sGMLEntityReference.getEntityDeclaration().getReplacementString());
                    }
                    catch (ParseException parseException) {
                        attributeDefinition.setDefaultValue(string);
                    }
                    this.tokenizer = this.tokenizerStack.pop();
                    break;
                }
                attributeDefinition.setDefaultValue(string);
            }
        }
    }

    private void readAttributeList() throws ParseException, IOException {
        this.readAttributeList(this.readElementType());
    }

    private AttributeDefinition[] readAttributeList(ElementDefinition[] elementDefinitionArray) throws ParseException, IOException {
        Object[] objectArray;
        Vector<Object> vector = new Vector<Object>();
        while (this.tokenizer.nextToken() != 62 && this.tokenizer.ttype != -1) {
            this.tokenizer.pushBack();
            objectArray = this.attributeDefinitionList(elementDefinitionArray);
            int n = 0;
            while (n < objectArray.length) {
                vector.addElement(objectArray[n]);
                ++n;
            }
        }
        this.tokenizer.pushBack();
        objectArray = new AttributeDefinition[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private AttributeDefinition[] attributeDefinitionList(ElementDefinition[] elementDefinitionArray) throws ParseException, IOException {
        if (this.tokenizer.nextToken() == 11) {
            AttributeDefinition attributeDefinition = new AttributeDefinition(this.tokenizer.sval);
            this.declaredValue(attributeDefinition);
            this.defaultValue(attributeDefinition);
            int n = 0;
            while (n < elementDefinitionArray.length) {
                elementDefinitionArray[n].addAttributeDefinition(attributeDefinition);
                ++n;
            }
            AttributeDefinition[] attributeDefinitionArray = new AttributeDefinition[]{attributeDefinition};
            return attributeDefinitionArray;
        }
        if (this.tokenizer.ttype == 37) {
            this.tokenizer.pushBack();
            SGMLEntityReference sGMLEntityReference = this.readEntityReference();
            SGMLEntityDeclaration sGMLEntityDeclaration = sGMLEntityReference.getEntityDeclaration();
            this.tokenizerStack.push(this.tokenizer);
            this.tokenizer = new DTDTokenizer(sGMLEntityDeclaration.getReplacementReader(), 1);
            AttributeDefinition[] attributeDefinitionArray = this.readAttributeList(elementDefinitionArray);
            this.tokenizer = this.tokenizerStack.pop();
            return attributeDefinitionArray;
        }
        throw new DTDParseException("illegal attlist.");
    }

    private boolean mark() throws ParseException, IOException {
        if (this.tokenizer.nextToken() == 11) {
            if (this.tokenizer.sval.equalsIgnoreCase("INCLUDE")) {
                return true;
            }
            if (this.tokenizer.sval.equalsIgnoreCase("IGNORE")) {
                return false;
            }
            throw new DTDParseException("last sval: " + this.tokenizer.sval);
        }
        if (this.tokenizer.ttype == 37) {
            this.tokenizer.pushBack();
            SGMLEntityReference sGMLEntityReference = this.readEntityReference();
            SGMLEntityDeclaration sGMLEntityDeclaration = sGMLEntityReference.getEntityDeclaration();
            this.tokenizerStack.push(this.tokenizer);
            this.tokenizer = new DTDTokenizer(sGMLEntityDeclaration.getReplacementReader(), 1);
            boolean bl = this.mark();
            this.tokenizer = this.tokenizerStack.pop();
            return bl;
        }
        throw new DTDParseException("sval: " + this.tokenizer.sval + " ttype: " + this.tokenizer.ttype);
    }

    private ElementDefinition[] makeElementArray(IModelGroup iModelGroup) throws ParseException {
        if (iModelGroup instanceof ElementDefinition) {
            ElementDefinition[] elementDefinitionArray = new ElementDefinition[]{(ElementDefinition)iModelGroup};
            return elementDefinitionArray;
        }
        if (iModelGroup instanceof OrModelGroup) {
            return ((OrModelGroup)iModelGroup).getChildren();
        }
        throw new DTDParseException("sval: " + this.tokenizer.sval + " ttype: " + this.tokenizer.ttype);
    }

    private boolean omit() throws ParseException, IOException {
        switch (this.tokenizer.nextToken()) {
            case 79: {
                return true;
            }
            case 45: {
                return false;
            }
        }
        throw new DTDParseException("'O' or '-' is required at " + this.tokenizer.getCurrentLine());
    }

    private ElementDefinition[] inclusion() throws ParseException, IOException {
        Vector<ElementDefinition[]> vector = new Vector<ElementDefinition[]>();
        vector.addElement(this.makeElementArray(this.atom()));
        while (this.tokenizer.nextToken() == 124) {
            vector.addElement(this.makeElementArray(this.atom()));
        }
        if (this.tokenizer.ttype != 41) {
            throw new DTDParseException("sval: " + this.tokenizer.sval + " ttype: " + this.tokenizer.ttype);
        }
        int n = 0;
        ElementDefinition[] elementDefinitionArray = vector.elements();
        while (elementDefinitionArray.hasMoreElements()) {
            n += ((ElementDefinition[])elementDefinitionArray.nextElement()).length;
        }
        elementDefinitionArray = new ElementDefinition[n];
        int n2 = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ElementDefinition[] elementDefinitionArray2 = (ElementDefinition[])enumeration.nextElement();
            int n3 = 0;
            while (n3 < elementDefinitionArray2.length) {
                elementDefinitionArray[n2++] = elementDefinitionArray2[n3];
                ++n3;
            }
        }
        return elementDefinitionArray;
    }
}

