/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.ui.report.table;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.actf.util.comparator.ChainComparator;
import org.eclipse.actf.visualization.eval.IEvaluationItem;
import org.eclipse.actf.visualization.eval.problem.IProblemItem;
import org.eclipse.actf.visualization.ui.report.table.IResultTableSorter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;

public abstract class ResultTableSorterBase
extends ViewerSorter
implements IResultTableSorter {
    private Pattern pattern = Pattern.compile("\\d+");

    protected int compareScore(IProblemItem iProblemItem, IProblemItem iProblemItem2, int n) {
        int n2;
        block4: {
            Image[] imageArray;
            Image[] imageArray2;
            block5: {
                int[] nArray = iProblemItem.getMetricsScores();
                int[] nArray2 = iProblemItem2.getMetricsScores();
                try {
                    n2 = nArray2[n] - nArray[n];
                    if (n2 != 0) break block4;
                    imageArray2 = iProblemItem.getMetricsIcons();
                    imageArray = iProblemItem2.getMetricsIcons();
                    if (imageArray2[n] != null || imageArray[n] == null) break block5;
                    return 1;
                }
                catch (Exception exception) {
                    return 0;
                }
            }
            if (imageArray2[n] == null || imageArray[n] != null) break block4;
            return -1;
        }
        return n2;
    }

    protected int compareSeverity(IProblemItem iProblemItem, IProblemItem iProblemItem2) {
        return iProblemItem.getSeverity() - iProblemItem2.getSeverity();
    }

    protected int compareGuideline(IProblemItem iProblemItem, IProblemItem iProblemItem2, int n) {
        String string = iProblemItem.getTableDataGuideline()[n];
        String string2 = iProblemItem2.getTableDataGuideline()[n];
        return this.compareString(string, string2);
    }

    protected int compareLine(IProblemItem iProblemItem, IProblemItem iProblemItem2) {
        int n = iProblemItem.getLine();
        int n2 = iProblemItem2.getLine();
        if (n < 0 && n2 > -1) {
            return 1;
        }
        if (n > -1 && n2 < 0) {
            return -1;
        }
        if (n == 0 && n2 == 0) {
            return 0;
        }
        int n3 = iProblemItem.getLine() - iProblemItem2.getLine();
        if (n3 == 0) {
            return iProblemItem.getLineStrMulti().compareTo(iProblemItem2.getLineStrMulti());
        }
        return n3;
    }

    protected int compareString(String string, String string2) {
        if (string.length() == 0 && string2.length() != 0) {
            return 1;
        }
        if (string.length() != 0 && string2.length() == 0) {
            return -1;
        }
        return string.compareTo(string2);
    }

    private int compareEvalItem(String string, String string2) {
        int n;
        String string3;
        int n2;
        String string4;
        if (string.length() == 0) {
            if (string2.length() > 0) {
                return 1;
            }
            return 0;
        }
        if (string2.length() == 0) {
            return -1;
        }
        Matcher matcher = this.pattern.matcher(string);
        Matcher matcher2 = this.pattern.matcher(string2);
        if (matcher.find()) {
            string4 = string.substring(0, matcher.start());
            n2 = Integer.parseInt(matcher.group());
        } else {
            string4 = string;
            n2 = Integer.MIN_VALUE;
        }
        if (matcher2.find()) {
            string3 = string2.substring(0, matcher2.start());
            n = Integer.parseInt(matcher2.group());
        } else {
            string3 = string2;
            n = Integer.MIN_VALUE;
        }
        int n3 = string4.compareTo(string3);
        if (n3 != 0) {
            return n3;
        }
        n3 = Integer.valueOf(n2).compareTo(n);
        if (n3 != 0) {
            return n3;
        }
        return this.compareEvalItem(string.substring(matcher.end()), string2.substring(matcher2.end()));
    }

    protected int compareEvalItem(IEvaluationItem iEvaluationItem, IEvaluationItem iEvaluationItem2) {
        return this.compareEvalItem(iEvaluationItem.getTableDataTechniques(), iEvaluationItem2.getTableDataTechniques());
    }

    public class DescriptionComparator
    extends StringComparator {
        protected int resolve(Object object, Object object2) {
            IProblemItem iProblemItem = (IProblemItem)object;
            IProblemItem iProblemItem2 = (IProblemItem)object2;
            return super.resolve(iProblemItem.getDescription(), iProblemItem2.getDescription());
        }
    }

    public class ErrorIDComparator
    extends StringComparator {
        protected int resolve(Object object, Object object2) {
            IProblemItem iProblemItem = (IProblemItem)object;
            IProblemItem iProblemItem2 = (IProblemItem)object2;
            String string = iProblemItem.getId();
            String string2 = iProblemItem2.getId();
            String[] stringArray = string.split("_");
            String[] stringArray2 = string2.split("_");
            if (stringArray.length < 2 || stringArray2.length < 2) {
                return super.resolve(iProblemItem.getId(), iProblemItem2.getId());
            }
            int n = super.resolve(stringArray[0], stringArray2[0]);
            if (n != 0) {
                return n;
            }
            Double d = new Double(stringArray[1]);
            Double d2 = new Double(stringArray2[1]);
            return d.compareTo(d2);
        }
    }

    public class GuidelineComparator
    extends ChainComparator {
        private int pos;

        public GuidelineComparator(int n) {
            this.pos = n;
        }

        protected int resolve(Object object, Object object2) {
            return ResultTableSorterBase.this.compareGuideline((IProblemItem)object, (IProblemItem)object2, this.pos);
        }
    }

    public class LinesComparator
    extends ChainComparator {
        protected int resolve(Object object, Object object2) {
            return ResultTableSorterBase.this.compareLine((IProblemItem)object, (IProblemItem)object2);
        }
    }

    public class ScoreCompator
    extends ChainComparator {
        private int pos;

        public ScoreCompator(int n) {
            this.pos = n;
        }

        protected int resolve(Object object, Object object2) {
            return ResultTableSorterBase.this.compareScore((IProblemItem)object, (IProblemItem)object2, this.pos);
        }
    }

    public class SeverityComparator
    extends ChainComparator {
        protected int resolve(Object object, Object object2) {
            return ResultTableSorterBase.this.compareSeverity((IProblemItem)object, (IProblemItem)object2);
        }
    }

    public class StringComparator
    extends ChainComparator {
        protected int resolve(Object object, Object object2) {
            String string = (String)object;
            String string2 = (String)object2;
            if (string.length() == 0 && string2.length() != 0) {
                return 1;
            }
            if (string.length() != 0 && string2.length() == 0) {
                return -1;
            }
            return string.compareTo(string2);
        }
    }
}

