/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.eval.html.statistics;

import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.eclipse.actf.util.FileUtils;
import org.eclipse.actf.visualization.eval.html.statistics.FlashData;
import org.eclipse.actf.visualization.eval.html.statistics.HeadingsData;
import org.eclipse.actf.visualization.eval.html.statistics.IPageStatisticsTag;
import org.eclipse.actf.visualization.eval.html.statistics.ImageStatData;
import org.eclipse.actf.visualization.eval.problem.IProblemItem;
import org.eclipse.actf.visualization.eval.problem.IProblemItemVisitor;
import org.eclipse.actf.visualization.internal.eval.XMLStringUtil;
import org.w3c.dom.Element;
import org.w3c.dom.html.HTMLImageElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageData
implements IPageStatisticsTag,
IProblemItemVisitor {
    private int brokenIntraPageLinkNum = 0;
    private int brokenSkipMainNum = 0;
    private Vector<FlashData> flashV = new Vector();
    private int forwardIntraPageLinkNum = 0;
    private Vector<HeadingsData> headingsV = new Vector();
    private Vector<ImageStatData> imageDataV = new Vector();
    private Map<HTMLImageElement, ImageStatData> imageDataMap = new HashMap<HTMLImageElement, ImageStatData>();
    private Map<Element, ImageStatData> linkImageDataMap = new HashMap<Element, ImageStatData>();
    private int imageAltErrorNum = 0;
    private double invalidLinkRatio = 0.0;
    private int maxTime = 0;
    private int orgMaxTime = 0;
    private int missingAltNum = 0;
    private int skipMainNum = 0;
    private int totalImageNumber = 0;
    private int totalLinkNum = 0;
    private int wrongAltNum = 0;
    private boolean hasJavascript = false;
    private boolean hasFrame = false;
    private boolean isError = false;

    public void addFlashData(FlashData flashData) {
        this.flashV.add(flashData);
    }

    public int getBrokenIntraPageLinkNum() {
        return this.brokenIntraPageLinkNum;
    }

    public int getBrokenSkipMainNum() {
        return this.brokenSkipMainNum;
    }

    public Vector<FlashData> getFlashData() {
        return this.flashV;
    }

    public int getForwardIntraPageLinkNum() {
        return this.forwardIntraPageLinkNum;
    }

    public int getHeadingCount() {
        return this.headingsV.size();
    }

    public Vector<HeadingsData> getHeadingsData() {
        return this.headingsV;
    }

    public int getImageAltErrorNum() {
        return this.imageAltErrorNum;
    }

    public double getInvalidLinkRatio() {
        return this.invalidLinkRatio;
    }

    public int getMaxTime() {
        return this.maxTime;
    }

    public int getMissingAltNum() {
        return this.missingAltNum;
    }

    public String getReportFragment() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<Images total=\"" + this.totalImageNumber + "\" " + "error" + "=\"" + this.imageAltErrorNum + "\" " + "missing" + "=\"" + this.missingAltNum + "\" " + "wrong" + "=\"" + this.wrongAltNum + "\" " + ">" + FileUtils.LINE_SEP);
        for (ImageStatData iPageStatisticsTag : this.imageDataV) {
            stringBuffer.append(String.valueOf(iPageStatisticsTag.getItemXML()) + FileUtils.LINE_SEP);
        }
        stringBuffer.append("</Images>");
        stringBuffer.append("<SkipMain valid=\"" + this.skipMainNum + "\" " + "error" + "=\"" + this.brokenSkipMainNum + "\" />" + FileUtils.LINE_SEP);
        stringBuffer.append("<ReachingTime max=\"" + this.maxTime + "\" " + "orgMax" + "=\"" + this.orgMaxTime + "\" />");
        if (this.flashV.size() > 0) {
            stringBuffer.append("<FlashInfo total=\"" + this.flashV.size() + "\">" + FileUtils.LINE_SEP);
            for (FlashData flashData : this.flashV) {
                stringBuffer.append(String.valueOf(flashData.getItemXML()) + FileUtils.LINE_SEP);
            }
            stringBuffer.append("</FlashInfo>" + FileUtils.LINE_SEP);
        }
        stringBuffer.append("<Headings total=\"" + this.headingsV.size() + "\">" + FileUtils.LINE_SEP);
        for (HeadingsData headingsData : this.headingsV) {
            stringBuffer.append(String.valueOf(headingsData.getItemXML()) + FileUtils.LINE_SEP);
        }
        stringBuffer.append("</Headings>" + FileUtils.LINE_SEP);
        stringBuffer.append("<javascript " + this.getAttr("existence", this.hasJavascript) + "/>");
        return stringBuffer.toString();
    }

    private String getAttr(String string, boolean bl) {
        return this.getAttr(string, Boolean.toString(bl));
    }

    private String getAttr(String string, String string2) {
        return String.valueOf(string) + "=\"" + XMLStringUtil.canonicalize(string2) + "\" ";
    }

    public int getSkipMainNum() {
        return this.skipMainNum;
    }

    public int getTotalImageNumber() {
        return this.totalImageNumber;
    }

    public int getTotalLinkNum() {
        return this.totalLinkNum;
    }

    public Vector<ImageStatData> getImageData() {
        return this.imageDataV;
    }

    public void setImageData(Vector<ImageStatData> vector) {
        this.imageDataV = vector;
    }

    public int getWrongAltNum() {
        return this.wrongAltNum;
    }

    public int getOrgMaxTime() {
        return this.orgMaxTime;
    }

    public Map<HTMLImageElement, ImageStatData> getImageDataMap() {
        return this.imageDataMap;
    }

    public Map<Element, ImageStatData> getLinkImageDataMap() {
        return this.linkImageDataMap;
    }

    public boolean hasJavascript() {
        return this.hasJavascript;
    }

    public void setHasJavascript(boolean bl) {
        this.hasJavascript = bl;
    }

    public void setLinkImageDataMap(Map<Element, ImageStatData> map) {
        this.linkImageDataMap = map;
    }

    public void setImageDataMap(Map<HTMLImageElement, ImageStatData> map) {
        this.imageDataMap = map;
    }

    public void setOrgMaxTime(int n) {
        this.orgMaxTime = n;
    }

    public void setBrokenIntraPageLinkNum(int n) {
        this.brokenIntraPageLinkNum = n;
    }

    public void setBrokenSkipMainNum(int n) {
        this.brokenSkipMainNum = n;
    }

    public void setFlashData(Vector<FlashData> vector) {
        this.flashV = vector;
    }

    public void setForwardIntraPageLinkNum(int n) {
        this.forwardIntraPageLinkNum = n;
    }

    public void setHeadingsData(Vector<HeadingsData> vector) {
        this.headingsV = vector;
    }

    public void setImageAltErrorNum(int n) {
        this.imageAltErrorNum = n;
    }

    public void setInvalidLinkRatio(double d) {
        this.invalidLinkRatio = d;
    }

    public void setMaxTime(int n) {
        this.maxTime = n;
    }

    public void setMissingAltNum(int n) {
        this.missingAltNum = n;
    }

    public void setSkipMainNum(int n) {
        this.skipMainNum = n;
    }

    public void setTotalImageNumber(int n) {
        this.totalImageNumber = n;
    }

    public void setTotalLinkNum(int n) {
        this.totalLinkNum = n;
    }

    public void setWrongAltNum(int n) {
        this.wrongAltNum = n;
    }

    public boolean hasFrame() {
        return this.hasFrame;
    }

    public void setHasFrame(boolean bl) {
        this.hasFrame = bl;
    }

    public boolean isError() {
        return this.isError;
    }

    public void setError(boolean bl) {
        this.isError = bl;
    }

    @Override
    public void visit(IProblemItem iProblemItem) {
        ImageStatData imageStatData = this.imageDataMap.get(iProblemItem.getTargetNode());
        if (imageStatData != null) {
            imageStatData.addProblemItem(iProblemItem);
        } else {
            imageStatData = this.linkImageDataMap.get(iProblemItem.getTargetNode());
            if (imageStatData != null) {
                imageStatData.addProblemItem(iProblemItem);
            }
        }
    }
}

