/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.osgi.service.resolver.BundleDelta;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateDelta;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.eclipse.pde.core.IClasspathContributor;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.ClasspathUtilCore;
import org.eclipse.pde.internal.core.IStateDeltaListener;
import org.eclipse.pde.internal.core.PDECore;
import org.osgi.resource.Resource;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(service={IClasspathContributor.class})
public class ApiAnnotationsClasspathContributor
implements IClasspathContributor,
IStateDeltaListener {
    private static final int CHANGE_FLAGS = 7;
    private static final Collection<String> API_TOOLS_ANNOTATIONS = List.of("org.eclipse.pde.api.tools.annotations");
    private ConcurrentMap<String, Collection<IClasspathEntry>> entryMap = new ConcurrentHashMap<String, Collection<IClasspathEntry>>();

    public List<IClasspathEntry> getInitialEntries(BundleDescription project) {
        IPluginModelBase projectModel = PluginRegistry.findModel((Resource)project);
        if (this.hasApiNature(projectModel)) {
            return ApiAnnotationsClasspathContributor.annotations().map(bundleId -> this.entryMap.computeIfAbsent((String)bundleId, id -> ClasspathUtilCore.classpathEntriesForBundle((String)id).toList())).flatMap(Collection::stream).filter(Predicate.not(entry -> ClasspathUtilCore.isEntryForModel((IClasspathEntry)entry, (IPluginModelBase)projectModel))).toList();
        }
        return List.of();
    }

    @Activate
    void registerListener() {
        PDECore.getDefault().getModelManager().addStateDeltaListener((IStateDeltaListener)this);
    }

    @Deactivate
    void undregisterListener() {
        PDECore.getDefault().getModelManager().removeStateDeltaListener((IStateDeltaListener)this);
    }

    private boolean hasApiNature(IPluginModelBase model) {
        IResource resource;
        if (model != null && (resource = model.getUnderlyingResource()) != null) {
            return Util.isApiProject(resource.getProject());
        }
        return false;
    }

    public static Stream<String> annotations() {
        return API_TOOLS_ANNOTATIONS.stream();
    }

    public List<IClasspathEntry> getEntriesForDependency(BundleDescription project, BundleDescription addedDependency) {
        return Collections.emptyList();
    }

    public void stateResolved(StateDelta delta) {
        if (delta == null) {
            this.stateChanged(null);
        } else {
            BundleDelta[] bundleDeltaArray = delta.getChanges(7, false);
            int n = bundleDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                BundleDelta bundleDelta = bundleDeltaArray[n2];
                this.entryMap.remove(bundleDelta.getBundle().getSymbolicName());
                ++n2;
            }
        }
    }

    public void stateChanged(State newState) {
        this.entryMap.clear();
    }
}

