/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.jni;

import org.eclipse.linuxtools.lttng.jni.Jni_C_Common;
import org.eclipse.linuxtools.lttng.jni.common.Jni_C_Pointer_And_Library_Id;
import org.eclipse.linuxtools.lttng.jni.exception.JniException;
import org.eclipse.linuxtools.lttng.jni.exception.JniMarkerFieldException;

public abstract class JniMarkerField
extends Jni_C_Common {
    private Jni_C_Pointer_And_Library_Id thisMarkerFieldPtr = new Jni_C_Pointer_And_Library_Id();
    private String field = "";
    private String format = "";

    protected native String ltt_getField(int var1, long var2);

    protected native int ltt_getType(int var1, long var2);

    protected native long ltt_getOffset(int var1, long var2);

    protected native long ltt_getSize(int var1, long var2);

    protected native long ltt_getAlignment(int var1, long var2);

    protected native long ltt_getAttributes(int var1, long var2);

    protected native int ltt_getStatic_offset(int var1, long var2);

    protected native String ltt_getFormat(int var1, long var2);

    protected native void ltt_printMarkerField(int var1, long var2);

    protected JniMarkerField() {
    }

    public JniMarkerField(JniMarkerField oldMarkerField) {
        this.thisMarkerFieldPtr = oldMarkerField.getMarkerFieldPtr();
        this.field = oldMarkerField.getField();
        this.format = oldMarkerField.getFormat();
    }

    public JniMarkerField(Jni_C_Pointer_And_Library_Id newMarkerFieldPtr) throws JniException {
        this.thisMarkerFieldPtr = newMarkerFieldPtr;
        this.populateMarkerFieldInformation();
    }

    private void populateMarkerFieldInformation() throws JniException {
        if (this.thisMarkerFieldPtr.getPointer() == 0L) {
            throw new JniMarkerFieldException("Pointer is NULL, trace closed? (populateMarkerInformation)");
        }
        this.field = this.ltt_getField(this.thisMarkerFieldPtr.getLibraryId(), this.thisMarkerFieldPtr.getPointer());
        this.format = this.ltt_getFormat(this.thisMarkerFieldPtr.getLibraryId(), this.thisMarkerFieldPtr.getPointer());
    }

    public String getField() {
        return this.field;
    }

    public String getFormat() {
        return this.format;
    }

    public Jni_C_Pointer_And_Library_Id getMarkerFieldPtr() {
        return this.thisMarkerFieldPtr;
    }

    public void printMarkerFieldInformation() {
        this.ltt_printMarkerField(this.thisMarkerFieldPtr.getLibraryId(), this.thisMarkerFieldPtr.getPointer());
    }

    public String toString() {
        String returnData = "";
        returnData = String.valueOf(returnData) + "field                   : " + this.field + "\n";
        returnData = String.valueOf(returnData) + "format                  : " + this.format + "\n";
        return returnData;
    }
}

