/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.gcov.view;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.linuxtools.dataviewers.abstractviewers.AbstractSTTreeViewer;
import org.eclipse.linuxtools.dataviewers.abstractviewers.ISTDataViewersField;
import org.eclipse.linuxtools.gcov.Activator;
import org.eclipse.linuxtools.internal.gcov.model.CovFileTreeElement;
import org.eclipse.linuxtools.internal.gcov.model.CovFunctionTreeElement;
import org.eclipse.linuxtools.internal.gcov.model.TreeElement;
import org.eclipse.linuxtools.internal.gcov.parser.CovManager;
import org.eclipse.linuxtools.internal.gcov.parser.SourceFile;
import org.eclipse.linuxtools.internal.gcov.view.CovFileContentProvider;
import org.eclipse.linuxtools.internal.gcov.view.FieldCoveragePercentage;
import org.eclipse.linuxtools.internal.gcov.view.FieldExecutedLines;
import org.eclipse.linuxtools.internal.gcov.view.FieldInstrumentedLines;
import org.eclipse.linuxtools.internal.gcov.view.FieldName;
import org.eclipse.linuxtools.internal.gcov.view.FieldTotalLines;
import org.eclipse.linuxtools.internal.gcov.view.annotatedsource.OpenSourceFileAction;
import org.eclipse.swt.widgets.Composite;

public class CovViewer
extends AbstractSTTreeViewer {
    private ISTDataViewersField[] fields;

    public CovViewer(Composite parent) {
        super(parent, 68354);
    }

    protected IContentProvider createContentProvider() {
        return CovFileContentProvider.sharedInstance;
    }

    public ISTDataViewersField[] getAllFields() {
        if (this.fields == null) {
            this.fields = new ISTDataViewersField[]{new FieldName(), new FieldTotalLines(), new FieldInstrumentedLines(), new FieldExecutedLines(), new FieldCoveragePercentage()};
        }
        return this.fields;
    }

    public IDialogSettings getDialogSettings() {
        return Activator.getDefault().getDialogSettings();
    }

    protected void handleOpenEvent(OpenEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        TreeElement element = (TreeElement)selection.getFirstElement();
        if (element != null && element.getParent() != null) {
            String sourceLoc = "";
            long lineNumber = 0L;
            if (element.getClass() == CovFileTreeElement.class) {
                sourceLoc = element.getName();
            } else if (element.getClass() == CovFunctionTreeElement.class) {
                sourceLoc = ((CovFunctionTreeElement)element).getSourceFilePath();
                lineNumber = ((CovFunctionTreeElement)element).getFirstLnNmbr();
            }
            CovManager cvm = (CovManager)this.getInput();
            SourceFile sourceFile = cvm.getSourceFile(sourceLoc);
            if (sourceFile != null) {
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                String binaryLoc = cvm.getBinaryPath();
                Path binaryPath = new Path(binaryLoc);
                IFile binary = root.getFileForLocation((IPath)binaryPath);
                IProject project = null;
                if (binary != null) {
                    project = binary.getProject();
                }
                OpenSourceFileAction.sharedInstance.openAnnotatedSourceFile(project, binary, sourceFile, (int)lineNumber);
            }
        }
    }
}

