/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpmstubby;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.linuxtools.internal.rpmstubby.StubbyLog;
import org.eclipse.linuxtools.internal.rpmstubby.StubbyPlugin;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public abstract class AbstractGenerator {
    String projectName;
    String specfileName;

    public void writeContent() {
        String contents = this.generateSpecfile();
        ByteArrayInputStream contentInputStream = new ByteArrayInputStream(contents.getBytes());
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(this.projectName));
        if (!resource.exists() || !(resource instanceof IContainer)) {
            this.logCoreException("Project \"" + this.projectName + "\" does not exist.");
        }
        IContainer container = (IContainer)resource;
        final IFile file = container.getFile((IPath)new Path(this.specfileName));
        try {
            ByteArrayInputStream stream = contentInputStream;
            if (file.exists()) {
                file.setContents((InputStream)stream, true, true, null);
            } else {
                file.create((InputStream)stream, true, null);
            }
            ((InputStream)stream).close();
        }
        catch (IOException e) {
            StubbyLog.logError(e);
        }
        catch (CoreException e) {
            StubbyLog.logError(e);
        }
        StubbyPlugin.getActiveWorkbenchShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                }
                catch (PartInitException e) {
                    StubbyLog.logError(e);
                }
            }
        });
    }

    public abstract String generateSpecfile();

    private void logCoreException(String message) {
        Status status = new Status(4, "org.eclipse.linuxtools.internal.rpmstubby", 0, message, null);
        StubbyLog.logError(new CoreException((IStatus)status));
    }
}

