/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.core.state.experiment;

import org.eclipse.linuxtools.lttng.core.TraceDebug;
import org.eclipse.linuxtools.lttng.core.model.LTTngTreeNode;
import org.eclipse.linuxtools.lttng.core.state.LttngStateException;
import org.eclipse.linuxtools.lttng.core.state.experiment.IStateExperimentManager;
import org.eclipse.linuxtools.lttng.core.state.experiment.StateExperimentManager;
import org.eclipse.linuxtools.lttng.core.state.trace.IStateTraceManager;
import org.eclipse.linuxtools.lttng.core.state.trace.StateTraceManager;
import org.eclipse.linuxtools.tmf.core.experiment.TmfExperiment;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;

public class StateManagerFactory {
    private static IStateExperimentManager experimentManager = null;
    private static Long ftraceCheckPointInterval = null;

    static {
        StateManagerFactory.initCheck();
    }

    public static LTTngTreeNode getManager(ITmfTrace<?> rtrace, LTTngTreeNode experiment) {
        if (rtrace == null) {
            return null;
        }
        String traceUniqueId = rtrace.getName();
        if (traceUniqueId == null) {
            return null;
        }
        LTTngTreeNode managerNode = null;
        managerNode = (LTTngTreeNode)experiment.getChildByName(traceUniqueId);
        if (managerNode != null && managerNode instanceof IStateTraceManager) {
            return managerNode;
        }
        StateTraceManager manager = null;
        try {
            manager = new StateTraceManager(experiment.getNextUniqueId(), experiment, traceUniqueId, rtrace);
            if (ftraceCheckPointInterval != null) {
                manager.setCheckPointInterval(ftraceCheckPointInterval);
            }
        }
        catch (LttngStateException e) {
            e.printStackTrace();
        }
        experiment.addChild(manager);
        return manager;
    }

    public static IStateExperimentManager getExperimentManager() {
        return experimentManager;
    }

    public static void removeManager(ITmfTrace<?> rtrace, LTTngTreeNode rexperiment) {
        if (rtrace == null || rexperiment == null) {
            return;
        }
        if (rexperiment.getValue() instanceof TmfExperiment) {
            LTTngTreeNode childToremove = (LTTngTreeNode)rexperiment.getChildByName(rtrace.getName());
            if (childToremove != null) {
                rexperiment.removeChild(childToremove);
            }
        } else {
            TraceDebug.debug("Invalid arguments to remove manager for trace: " + rtrace.getName());
        }
    }

    private static void initCheck() {
        if (experimentManager == null) {
            Long id = 0L;
            String name = "StateExperimentManager";
            experimentManager = new StateExperimentManager(id, name);
        }
    }

    public static void dispose() {
        if (experimentManager != null) {
            experimentManager = null;
        }
    }

    public static Long getTraceCheckPointInterval() {
        return ftraceCheckPointInterval;
    }

    public static void setTraceCheckPointInterval(Long traceCheckPointInterval) {
        ftraceCheckPointInterval = traceCheckPointInterval;
    }
}

