/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.oprofile.ui.model;

import org.eclipse.linuxtools.oprofile.core.model.OpModelImage;
import org.eclipse.linuxtools.oprofile.core.model.OpModelSession;
import org.eclipse.linuxtools.oprofile.ui.OprofileUiMessages;
import org.eclipse.linuxtools.oprofile.ui.OprofileUiPlugin;
import org.eclipse.linuxtools.oprofile.ui.model.IUiModelElement;
import org.eclipse.linuxtools.oprofile.ui.model.UiModelDependent;
import org.eclipse.linuxtools.oprofile.ui.model.UiModelImage;
import org.eclipse.swt.graphics.Image;

public class UiModelSession
implements IUiModelElement {
    private IUiModelElement _parent;
    private OpModelSession _session;
    private UiModelImage _image;
    private UiModelDependent _dependent;
    private static final String DEFAULT_SESSION_NAME = "current";

    public UiModelSession(IUiModelElement parent, OpModelSession session) {
        this._parent = parent;
        this._session = session;
        this._image = null;
        this._dependent = null;
        this.refreshModel();
    }

    private void refreshModel() {
        OpModelImage dataModelImage = this._session.getImage();
        if (dataModelImage != null) {
            this._image = new UiModelImage(this, dataModelImage, dataModelImage.getCount(), dataModelImage.getDepCount());
            if (dataModelImage.hasDependents()) {
                this._dependent = new UiModelDependent(this, dataModelImage.getDependents(), dataModelImage.getCount(), dataModelImage.getDepCount());
            }
        }
    }

    public String toString() {
        return this._session.getName();
    }

    public boolean isDefaultSession() {
        return this._session.getName().equalsIgnoreCase(DEFAULT_SESSION_NAME);
    }

    public String getLabelText() {
        if (this._session.getName().equals(DEFAULT_SESSION_NAME)) {
            return OprofileUiMessages.getString("UiModelSession_current");
        }
        return this.toString();
    }

    public IUiModelElement[] getChildren() {
        if (this._dependent != null) {
            return new IUiModelElement[]{this._image, this._dependent};
        }
        return new IUiModelElement[]{this._image};
    }

    public boolean hasChildren() {
        return this._image != null;
    }

    public IUiModelElement getParent() {
        return this._parent;
    }

    public Image getLabelImage() {
        return OprofileUiPlugin.getImageDescriptor("icons/session.gif").createImage();
    }
}

