/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.valgrind.massif.charting;

import org.eclipse.core.runtime.IPath;
import org.eclipse.linuxtools.internal.valgrind.massif.charting.HeapChart;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class ChartPNG {
    protected HeapChart cm = null;

    public ChartPNG(HeapChart chart) {
        this.cm = chart;
    }

    public void renderPNG(IPath pngPath) {
        Composite comp = this.cm.getChartControl();
        Display dsp = Display.getCurrent();
        GC gc = new GC((Drawable)comp);
        Image img = new Image((Device)dsp, comp.getSize().x + 1, comp.getSize().y + 1);
        gc.copyArea(img, 0, 0);
        gc.dispose();
        ImageLoader imageLoader = new ImageLoader();
        imageLoader.data = new ImageData[]{img.getImageData()};
        imageLoader.save(pngPath.toOSString(), 5);
    }

    public HeapChart getDesignTimeModel() {
        return this.cm;
    }

    public Object peerInstance() {
        return this;
    }

    public void regenerateChart() {
    }

    public void repaintChart() {
    }

    public void showView() {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                try {
                    IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    activePage.showView("org.eclipse.linuxtools.valgrind.ui.valgrindview");
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

