/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - Jeff Briggs, Henry Hughes, Ryan Morse, Anithra P J
 *******************************************************************************/

package org.eclipse.linuxtools.systemtap.ui.dashboard;


import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;

import org.eclipse.linuxtools.systemtap.ui.logging.LogManager;
import org.eclipse.linuxtools.systemtap.ui.dashboard.views.ActiveModuleBrowserView;
import org.eclipse.linuxtools.systemtap.ui.dashboard.views.DashboardModuleBrowserView;
import org.eclipse.linuxtools.systemtap.ui.dashboard.views.DashboardView;

/**
 * The <code>DashboardPerspective</code> class defines the layout of the Dashboard perspective
 * in the application.
 * @see org.eclipse.ui.IPerspectiveFactory
 * @author Ryan Morse
 */
public class DashboardPerspective implements IPerspectiveFactory {
	public static String ID = "org.eclipse.linuxtools.systemtap.ui.dashboard.DashboardPerspective";
	
	public void createInitialLayout(IPageLayout layout) {
		LogManager.logDebug("Start createInitialLayout:", this);

		//Don't display the editor
		String editorArea = layout.getEditorArea();
		layout.setEditorAreaVisible(false);

		//Create the left hand tabed view
		IFolderLayout browsers = layout.createFolder("browsers", IPageLayout.LEFT, 0.25f, editorArea);
		browsers.addPlaceholder(DashboardModuleBrowserView.ID + ":*");
		browsers.addView(DashboardModuleBrowserView.ID);
		
		
		IFolderLayout browsers2 = layout.createFolder("browsers2", IPageLayout.BOTTOM, 0.5f, "browsers");
		browsers2.addPlaceholder(ActiveModuleBrowserView.ID + ":*");
		browsers2.addView(ActiveModuleBrowserView.ID);

		layout.getViewLayout(DashboardModuleBrowserView.ID).setCloseable(false);
		layout.getViewLayout(ActiveModuleBrowserView.ID).setCloseable(false);
		//DashboardModuleBrowserView.getmoduleNames();
		/*for (int i=0 ; i<moduleNames.size(); i++)
		{
			System.out.println("Dashboard perspective: " + moduleNames.get(i));
		}*/

		//Add the graph content view.
		layout.addStandaloneView(DashboardView.ID, false, IPageLayout.TOP, 1.0f, editorArea);

		layout.getViewLayout(DashboardView.ID).setCloseable(false);
		layout.getViewLayout(DashboardView.ID).setMoveable(false);

		//Add all perspectives to the MainMenu. Window->Show View
		layout.addShowViewShortcut(DashboardView.ID);
		layout.addShowViewShortcut(DashboardModuleBrowserView.ID);
		layout.addShowViewShortcut(ActiveModuleBrowserView.ID);

		//Add a link to the perspective in the MainMenu.  Window->Open Perspective
		layout.addPerspectiveShortcut(ID);

		LogManager.logDebug("End createInitialLayout:", this);
	}
}
