/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.binutils.utils;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.linuxtools.binutils.Activator;
import org.eclipse.linuxtools.binutils.utils.DefaultBinutilsFactory;
import org.eclipse.linuxtools.binutils.utils.ISTBinutilsFactory;

public class STBinutilsFactoryManager {
    public static final STBinutilsFactoryManager sharedInstance = new STBinutilsFactoryManager();
    private final Map<String, ISTBinutilsFactory> map = new HashMap<String, ISTBinutilsFactory>();
    private DefaultBinutilsFactory defaultFactory;

    private STBinutilsFactoryManager() {
    }

    private ISTBinutilsFactory getBinutilsFactoryImpl(String cpu) {
        try {
            IExtension[] exts;
            IExtensionRegistry reg = Platform.getExtensionRegistry();
            IExtensionPoint ep = reg.getExtensionPoint("org.eclipse.linuxtools.binutils.crossCompilerBinutils");
            IExtension[] iExtensionArray = exts = ep.getExtensions();
            int n = exts.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] elems;
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = elems = extension.getConfigurationElements();
                int n3 = elems.length;
                int n4 = 0;
                while (n4 < n3) {
                    ISTBinutilsFactory factory;
                    IConfigurationElement configurationElement = iConfigurationElementArray[n4];
                    String s = configurationElement.getAttribute("CPU");
                    if (cpu.equals(s) && (factory = (ISTBinutilsFactory)configurationElement.createExecutableExtension("binutilsFactory")).testAvailability()) {
                        return factory;
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            Activator.getDefault().getLog().log(e.getStatus());
        }
        if (this.defaultFactory == null) {
            this.defaultFactory = new DefaultBinutilsFactory();
        }
        return this.defaultFactory;
    }

    public ISTBinutilsFactory getBinutilsFactory(String cpu) {
        ISTBinutilsFactory factory = this.map.get(cpu);
        if (factory == null) {
            factory = this.getBinutilsFactoryImpl(cpu);
            this.map.put(cpu, factory);
        }
        return factory;
    }
}

