/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.cdt.libhover;

import java.io.Serializable;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypedefInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String[] templates = new String[0];
    private String typedefName;
    private String transformedType;
    private ArrayList<TypedefInfo> children = null;

    public TypedefInfo(String typedefName, String transformedType) {
        this.typedefName = typedefName;
        this.transformedType = transformedType;
    }

    public String getTypedefName() {
        return this.typedefName;
    }

    public void setTypedefName(String name) {
        this.typedefName = name;
    }

    private String[] getTemplateArgs(String str) {
        ArrayList<String> list = new ArrayList<String>();
        int index = 0;
        int lastIndex = 0;
        int templateCounter = 0;
        while (index < str.length()) {
            char ch = str.charAt(index);
            if (ch == '<') {
                if (templateCounter == 0) {
                    lastIndex = index + 1;
                }
                ++templateCounter;
            } else if (ch == '>') {
                --templateCounter;
            } else if (ch == ',' && templateCounter == 1) {
                list.add(str.substring(lastIndex, index).trim());
                lastIndex = index + 1;
            }
            ++index;
        }
        String[] args = new String[list.size()];
        return list.toArray(args);
    }

    public String getTransformedType(String className) {
        int index = className.indexOf(60);
        if (index > 0) {
            TypedefInfo e = this;
            ArrayList<TypedefInfo> children = this.getChildren();
            int x = 0;
            while (x < children.size()) {
                TypedefInfo child = children.get(x);
                if (className.matches(child.getTypedefName())) {
                    e = child;
                    break;
                }
                ++x;
            }
            String[] templates = e.getTemplates();
            String transformedName = e.transformedType;
            if (templates.length <= 0) {
                return transformedName;
            }
            String[] args = this.getTemplateArgs(className);
            String[] templateArgs = this.getTemplateArgs(e.getTypedefName());
            int j = 0;
            int i = 0;
            while (i < args.length) {
                if (!args[i].equals(templateArgs[i])) {
                    transformedName = transformedName.replaceAll(templates[j], args[i]);
                    ++j;
                }
                ++i;
            }
            return transformedName;
        }
        return this.transformedType;
    }

    public void addTypedef(TypedefInfo typedef) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(typedef);
    }

    public ArrayList<TypedefInfo> getChildren() {
        return this.children;
    }

    public void copyTemplates(String[] newTemplates) {
        this.templates = new String[newTemplates.length];
        int i = 0;
        while (i < this.templates.length) {
            this.templates[i] = newTemplates[i];
            ++i;
        }
    }

    public String[] getTemplates() {
        return this.templates;
    }
}

