/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.dataviewers.annotatedsourceeditor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.linuxtools.dataviewers.annotatedsourceeditor.AbstractSTAnnotatedSourceEditorInput;
import org.eclipse.linuxtools.dataviewers.annotatedsourceeditor.ISTAnnotationColumn;
import org.eclipse.linuxtools.dataviewers.annotatedsourceeditor.STAnnotatedSourceEditorActivator;
import org.eclipse.linuxtools.dataviewers.annotatedsourceeditor.STChangeRulerColumn;
import org.eclipse.linuxtools.dataviewers.annotatedsourceeditor.STContributedRulerColumn;
import org.eclipse.linuxtools.dataviewers.annotatedsourceeditor.STOverviewRuler;
import org.eclipse.linuxtools.dataviewers.annotatedsourceeditor.STTextEditorMessages;
import org.eclipse.swt.custom.LineBackgroundEvent;
import org.eclipse.swt.custom.LineBackgroundListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.StyledTextContent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.internal.texteditor.AnnotationColumn;
import org.eclipse.ui.internal.texteditor.LineNumberColumn;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.MarkerAnnotationPreferences;
import org.eclipse.ui.texteditor.ResourceAction;
import org.eclipse.ui.texteditor.rulers.IColumnSupport;
import org.eclipse.ui.texteditor.rulers.IContributedRulerColumn;
import org.eclipse.ui.texteditor.rulers.RulerColumnDescriptor;
import org.eclipse.ui.texteditor.rulers.RulerColumnRegistry;

public class STAnnotatedCSourceEditor
extends CEditor
implements LineBackgroundListener {
    private static final String ST_RULER = "STRuler";
    protected STContributedRulerColumn fAbstractSTRulerColumn;
    private IColumnSupport fColumnSupport;
    private LineNumberColumn fLineColumn;
    private STContributedRulerColumn fColumn;
    private StyledText fCachedTextWidget;
    private AbstractSTAnnotatedSourceEditorInput fInput;
    private ArrayList<ISTAnnotationColumn> fListColumns;
    private STChangeRulerColumn fSTChangeRulerColumn;

    public void createPartControl(Composite parent) {
        ISourceViewer sv;
        if (this.fInput == null) {
            super.createPartControl(parent);
            return;
        }
        GridLayout layout = new GridLayout();
        layout.numColumns = this.fInput.getColumnCount() + 1;
        layout.horizontalSpacing = 0;
        parent.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = false;
        gd.grabExcessVerticalSpace = true;
        parent.setLayoutData((Object)gd);
        Composite fParentSv = new Composite(parent, 0);
        gd = new GridData(1808);
        gd.horizontalSpan = this.fInput.getColumnCount() + 1;
        gd.verticalIndent = 0;
        gd.horizontalIndent = 0;
        fParentSv.setLayoutData((Object)gd);
        FillLayout fillLayout = new FillLayout(768);
        fillLayout.marginHeight = 0;
        fillLayout.marginWidth = 0;
        fParentSv.setLayout((Layout)fillLayout);
        super.createPartControl(fParentSv);
        STColumnSupport columnSupport = (STColumnSupport)((Object)this.getAdapter(IColumnSupport.class));
        RulerColumnRegistry registry = RulerColumnRegistry.getDefault();
        int i = 1;
        while (i <= this.fInput.getColumnCount()) {
            RulerColumnDescriptor abstractSTColumnDescriptor = registry.getColumnDescriptor("org.eclipse.linuxtools.dataviewers.annotatedsourceeditor.column");
            columnSupport.addSTColumn((CompositeRuler)this.getVerticalRuler(), abstractSTColumnDescriptor, this.fListColumns.get(i - 1));
            ++i;
        }
        CompositeRuler vr = (CompositeRuler)super.getVerticalRuler();
        int count = 0;
        Font font = parent.getFont();
        FontData fd = font.getFontData()[0];
        fd.setStyle(1);
        Iterator iter = vr.getDecoratorIterator();
        while (iter.hasNext()) {
            IVerticalRulerColumn column = (IVerticalRulerColumn)iter.next();
            if (!(column instanceof STContributedRulerColumn)) continue;
            STContributedRulerColumn fSTColumn = (STContributedRulerColumn)column;
            Label label = new Label(parent, 2048);
            gd = new GridData();
            gd.horizontalIndent = ++count == 1 ? 17 : 0;
            gd.widthHint = fSTColumn.getWidth();
            label.setFont(new Font((Device)label.getDisplay(), fd));
            label.setLayoutData((Object)gd);
            label.moveAbove((Control)fParentSv);
            label.setText(fSTColumn.getAnnotationColumn(0).getTitle());
            fSTColumn.setLabelColumn(label);
            if (!fSTColumn.isShowingSTRuler()) continue;
            ToolTipSupport.enableFor(fSTColumn);
        }
        Label label = new Label(parent, 2048);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        label.setFont(new Font((Device)label.getDisplay(), fd));
        label.setLayoutData((Object)gd);
        label.moveAbove((Control)fParentSv);
        label.setText(this.getTitle());
        this.showLinesColored();
        if (this.getViewer() != null && (sv = this.getViewer()).getTextWidget() != null) {
            this.fCachedTextWidget = sv.getTextWidget();
            this.fCachedTextWidget.addLineBackgroundListener((LineBackgroundListener)this);
        }
    }

    protected void rulerContextMenuAboutToShow(IMenuManager menu) {
        super.rulerContextMenuAboutToShow(menu);
        CompositeRuler vr = (CompositeRuler)super.getVerticalRuler();
        Iterator iter = vr.getDecoratorIterator();
        while (iter.hasNext()) {
            IVerticalRulerColumn column = (IVerticalRulerColumn)iter.next();
            if (column instanceof STContributedRulerColumn) {
                STContributedRulerColumn fSTColumn = (STContributedRulerColumn)column;
                IAction stprofcolAction = this.getAction("ST.Toggle");
                stprofcolAction.setChecked(fSTColumn != null && fSTColumn.isShowingSTRuler());
                continue;
            }
            if (!(column instanceof LineNumberColumn)) continue;
            LineNumberColumn fLineColumn = (LineNumberColumn)column;
            IAction lineNumberAction = this.getAction("Linenumbers.Toggle");
            lineNumberAction.setChecked(fLineColumn != null && fLineColumn.isShowingLineNumbers());
        }
        if (this.fInput != null) {
            IAction stAction = this.getAction("ST.Toggle");
            menu.appendToGroup("rulers", stAction);
        }
    }

    public Object getAdapter(Class required) {
        if (IColumnSupport.class.equals((Object)required)) {
            if (this.fColumnSupport == null) {
                this.fColumnSupport = this.createSTColumnSupport();
            }
            return this.fColumnSupport;
        }
        return super.getAdapter(required);
    }

    protected IColumnSupport createSTColumnSupport() {
        return new STColumnSupport(this, RulerColumnRegistry.getDefault());
    }

    protected IVerticalRulerColumn createSTRulerColumn(ISTAnnotationColumn annotationColumn) {
        this.fSTChangeRulerColumn = new STChangeRulerColumn(this.getSharedColors(), annotationColumn);
        this.fSTChangeRulerColumn.setHover((IAnnotationHover)this.createChangeHover());
        this.initializeLineNumberRulerColumn(this.fLineNumberRulerColumn);
        return this.fSTChangeRulerColumn;
    }

    public void lineGetBackground(LineBackgroundEvent event) {
        if (this.fInput != null) {
            StyledTextContent c = (StyledTextContent)event.data;
            int line = c.getLineAtOffset(event.lineOffset);
            event.lineBackground = this.fInput.getColor(line);
        }
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        super.doSetInput(input);
        if (input != null && input instanceof AbstractSTAnnotatedSourceEditorInput) {
            this.fInput = (AbstractSTAnnotatedSourceEditorInput)input;
            this.fListColumns = this.fInput.getColumns();
        }
    }

    protected void createActions() {
        super.createActions();
        ResourceAction action = new ResourceAction(STTextEditorMessages.getBundleForConstructedKeys(), "Editor.ToggleSTColumnAction.", 2){

            public void run() {
                STAnnotatedCSourceEditor.this.toggleSTRuler();
            }
        };
        if (this.fInput != null) {
            action.setActionDefinitionId("org.eclipse.linuxtools.dataviewers.annotatedsourceeditor.STColumnToggle");
            this.setAction("ST.Toggle", (IAction)action);
        }
    }

    private void toggleSTRuler() {
        IPreferenceStore store = EditorsUI.getPreferenceStore();
        store.setValue(ST_RULER, !this.isSTRulerVisible());
    }

    protected boolean isSTRulerVisible() {
        IPreferenceStore store = this.getPreferenceStore();
        return store != null ? store.getBoolean(ST_RULER) : true;
    }

    protected IOverviewRuler createOverviewRuler(ISharedTextColors sharedColors) {
        STOverviewRuler ruler = new STOverviewRuler(this.getAnnotationAccess(), 12, sharedColors);
        MarkerAnnotationPreferences fAnnotationPreferences = EditorsPlugin.getDefault().getMarkerAnnotationPreferences();
        for (AnnotationPreference preference : fAnnotationPreferences.getAnnotationPreferences()) {
            if (!preference.contributesToHeader()) continue;
            ruler.addHeaderAnnotationType(preference.getAnnotationType());
        }
        return ruler;
    }

    private void showLinesColored() {
        STOverviewRuler or = (STOverviewRuler)this.getOverviewRuler();
        AnnotationModel am = (AnnotationModel)or.getModel();
        IDocument doc = this.getSourceViewer().getDocument();
        int lines = doc.getNumberOfLines();
        int i = 0;
        while (i < lines) {
            try {
                Color color = this.fInput.getColor(i);
                int r = color.getRed();
                int g = color.getGreen();
                int b = color.getBlue();
                if (r != 255 || g != 255 || b != 255) {
                    int offset = doc.getLineOffset(i);
                    String type = String.valueOf(STAnnotatedSourceEditorActivator.getUniqueIdentifier()) + STAnnotatedSourceEditorActivator.getAnnotationType();
                    Annotation annotation = new Annotation(type, true, "");
                    or.setAnnotationColor(annotation, color);
                    am.addAnnotation(annotation, new Position(offset));
                }
            }
            catch (BadLocationException e) {
                Status s = new Status(4, "org.eclipse.linuxtools.dataviewers.annotatedsourceeditor", 4, e.getMessage(), (Throwable)e);
                STAnnotatedSourceEditorActivator.getDefault().getLog().log((IStatus)s);
            }
            ++i;
        }
    }

    protected class STColumnSupport
    extends AbstractTextEditor.ColumnSupport {
        private final STAnnotatedCSourceEditor fEditor;
        private final RulerColumnRegistry fRegistry;
        private final ArrayList<ISTAnnotationColumn> fColumns;

        public STColumnSupport(STAnnotatedCSourceEditor editor, RulerColumnRegistry registry) {
            super((AbstractTextEditor)editor, registry);
            this.fEditor = editor;
            this.fRegistry = registry;
            this.fColumns = new ArrayList();
        }

        private int computeIndex(CompositeRuler ruler, RulerColumnDescriptor descriptor) {
            int index = 0;
            List all = this.fRegistry.getColumnDescriptors();
            int newPos = all.indexOf(descriptor);
            Iterator it = ruler.getDecoratorIterator();
            while (it.hasNext()) {
                RulerColumnDescriptor rcd;
                IVerticalRulerColumn column = (IVerticalRulerColumn)it.next();
                if (column instanceof IContributedRulerColumn ? (rcd = ((IContributedRulerColumn)column).getDescriptor()) != null && all.indexOf(rcd) > newPos : "org.eclipse.jface.text.source.projection.ProjectionRulerColumn".equals(column.getClass().getName())) break;
                ++index;
            }
            return index;
        }

        public void addSTColumn(final CompositeRuler ruler, final RulerColumnDescriptor descriptor, final ISTAnnotationColumn annotationColumn) {
            final int idx = this.computeIndex(ruler, descriptor);
            SafeRunnable runnable = new SafeRunnable(){

                public void run() throws Exception {
                    IContributedRulerColumn column = descriptor.createColumn((ITextEditor)STColumnSupport.this.fEditor);
                    STColumnSupport.this.fColumns.add(annotationColumn);
                    STColumnSupport.this.initializeColumn(column);
                    ruler.addDecorator(idx, (IVerticalRulerColumn)column);
                }
            };
            SafeRunner.run((ISafeRunnable)runnable);
        }

        protected void initializeColumn(IContributedRulerColumn column) {
            super.initializeColumn(column);
            RulerColumnDescriptor descriptor = column.getDescriptor();
            IVerticalRuler ruler = STAnnotatedCSourceEditor.this.getVerticalRuler();
            if (ruler instanceof CompositeRuler) {
                if ("org.eclipse.ui.editors.columns.annotations".equals(descriptor.getId())) {
                    ((AnnotationColumn)column).setDelegate(STAnnotatedCSourceEditor.this.createAnnotationRulerColumn((CompositeRuler)ruler));
                } else if ("org.eclipse.ui.editors.columns.linenumbers".equals(descriptor.getId())) {
                    STAnnotatedCSourceEditor.this.fLineColumn = (LineNumberColumn)column;
                    STAnnotatedCSourceEditor.this.fLineColumn.setForwarder(new LineNumberColumn.ICompatibilityForwarder(){

                        public IVerticalRulerColumn createLineNumberRulerColumn() {
                            return STColumnSupport.this.fEditor.createLineNumberRulerColumn();
                        }

                        public boolean isQuickDiffEnabled() {
                            return STColumnSupport.this.fEditor.isPrefQuickDiffAlwaysOn();
                        }

                        public boolean isLineNumberRulerVisible() {
                            return STColumnSupport.this.fEditor.isLineNumberRulerVisible();
                        }
                    });
                }
                if ("org.eclipse.linuxtools.dataviewers.annotatedsourceeditor.column".equals(descriptor.getId())) {
                    STAnnotatedCSourceEditor.this.fColumn = (STContributedRulerColumn)column;
                    STAnnotatedCSourceEditor.this.fColumn.setForwarder(new STContributedRulerColumn.ICompatibilityForwarder(){

                        @Override
                        public IVerticalRulerColumn createSTRulerColumn() {
                            if (STColumnSupport.this.fColumns != null && STColumnSupport.this.fColumns.size() > 0) {
                                IVerticalRulerColumn fDelegate = STColumnSupport.this.fEditor.createSTRulerColumn((ISTAnnotationColumn)STColumnSupport.this.fColumns.get(STColumnSupport.this.fColumns.size() - 1));
                                return fDelegate;
                            }
                            return null;
                        }

                        @Override
                        public boolean isQuickDiffEnabled() {
                            return STColumnSupport.this.fEditor.isPrefQuickDiffAlwaysOn();
                        }

                        @Override
                        public boolean isSTRulerVisible() {
                            return STColumnSupport.this.fEditor.isSTRulerVisible();
                        }
                    });
                }
            }
        }
    }

    private static class ToolTipSupport
    extends DefaultToolTip {
        private STContributedRulerColumn control;

        protected ToolTipSupport(STContributedRulerColumn control, int style, boolean manualActivation) {
            super(control.getControl(), style, manualActivation);
            this.control = control;
        }

        protected Object getToolTipArea(Event event) {
            int line = this.control.toDocumentLineNumber(event.y);
            return new ToolTipArea(line, this.control.getAnnotationColumn(line));
        }

        protected Composite createToolTipContentArea(Event event, Composite parent) {
            Composite comp = new Composite(parent, 0);
            comp.setLayout((Layout)new FillLayout());
            Label b = new Label(comp, 0);
            ToolTipArea area = (ToolTipArea)this.getToolTipArea(event);
            if (area != null && area.getToolTip().trim().length() > 0) {
                b.setText(area.getToolTip());
            }
            return comp;
        }

        public static void enableFor(STContributedRulerColumn control) {
            new ToolTipSupport(control, 2, false);
        }

        static class ToolTipArea {
            final int line;
            final ISTAnnotationColumn ac;

            ToolTipArea(int line, ISTAnnotationColumn ac) {
                this.line = line;
                this.ac = ac;
            }

            public String getToolTip() {
                return this.ac.getTooltip(this.line);
            }
        }
    }
}

