/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.gprof.utils;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.LinkedList;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.utils.Addr64;
import org.eclipse.cdt.utils.BinaryObjectAdapter;
import org.eclipse.cdt.utils.Symbol;
import org.eclipse.cdt.utils.elf.Elf;
import org.eclipse.cdt.utils.elf.parser.ElfBinaryObject;
import org.eclipse.core.runtime.IPath;

public class PPC64ElfBinaryObjectWrapper
extends ElfBinaryObject {
    private Elf.Section dataSection = null;
    private IBinaryParser.ISymbol[] symbols = null;

    public PPC64ElfBinaryObjectWrapper(IBinaryParser parser, IPath path, int type) {
        super(parser, path, type);
    }

    private IAddress fixAddr(IAddress addr) {
        try {
            InputStream input = this.getContents();
            byte[] bytes = new byte[8];
            long index = addr.getValue().longValue() - this.dataSection.sh_addr.getValue().longValue() + this.dataSection.sh_offset;
            input.skip(index);
            input.read(bytes);
            return new Addr64(new BigInteger(bytes));
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public IBinaryParser.ISymbol[] getSymbols() {
        if (this.symbols != null) {
            return this.symbols;
        }
        this.symbols = super.getSymbols();
        try {
            if (this.dataSection == null) {
                Elf elf = new Elf(this.getPath().toOSString());
                this.dataSection = elf.getSectionByName(".data");
            }
        }
        catch (IOException iOException) {}
        if (this.dataSection == null) {
            return this.symbols;
        }
        LinkedList<Object> list = new LinkedList<Object>();
        IBinaryParser.ISymbol[] iSymbolArray = this.symbols;
        int n = this.symbols.length;
        int n2 = 0;
        while (n2 < n) {
            IBinaryParser.ISymbol s = iSymbolArray[n2];
            if (s.getType() == 1 && s instanceof Symbol) {
                IAddress addr = this.fixAddr(s.getAddress());
                if (addr == null) {
                    addr = s.getAddress();
                }
                list.add(new Symbol((BinaryObjectAdapter)s.getBinaryObject(), s.getName(), s.getType(), addr, s.getSize()));
            } else {
                list.add(s);
            }
            ++n2;
        }
        this.symbols = (IBinaryParser.ISymbol[])list.toArray(new Symbol[0]);
        Arrays.sort(this.symbols);
        return this.symbols;
    }
}

