/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.dashboard;

import java.util.ArrayList;
import org.eclipse.linuxtools.systemtap.ui.dashboard.DashboardAdapter;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class DashboardComposite {
    private final Composite[] internal = new Composite[8];
    private final DashboardAdapter[] external = new DashboardAdapter[8];
    private int usedSlotCount = 0;
    private final InternalCompositeDragListener[] dragListeners = new InternalCompositeDragListener[8];
    private final InternalCompositeDropListener[] dropListeners = new InternalCompositeDropListener[8];
    private final ArrayList<DashboardAdapter> externalQueue = new ArrayList();
    private final Composite surface;
    int maximized = 0;
    public final Composite deadComposite;

    public void layout() {
        this.surface.layout(true, true);
    }

    public DashboardComposite(Composite parent, int style) {
        parent.setLayout((Layout)new FormLayout());
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, 0);
        this.surface = new Composite(parent, style);
        this.surface.setLayoutData((Object)data);
        this.surface.setLayout((Layout)new FormLayout());
        this.deadComposite = new Composite(parent, style);
        this.deadComposite.setVisible(false);
        int i = 0;
        while (i < this.internal.length) {
            this.internal[i] = new Composite(this.surface, 0);
            data = new FormData();
            this.internal[i].setLayoutData((Object)data);
            this.internal[i].setVisible(false);
            this.internal[i].setLayout((Layout)new FormLayout());
            this.external[i] = null;
            this.dragListeners[i] = new InternalCompositeDragListener(i);
            this.dropListeners[i] = new InternalCompositeDropListener(i);
            ++i;
        }
    }

    public void add(DashboardAdapter c) {
        int index = this.findLowestOpenSlot();
        if (index == -1) {
            this.externalQueue.add(c);
            return;
        }
        this.external[index] = c;
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, 0);
        c.folder.setParent(this.internal[index]);
        c.folder.setLayoutData((Object)data);
        this.bindDND(index);
        this.calculateUsedSlots();
        this.scale();
        this.surface.layout(true, true);
    }

    public void remove(DashboardAdapter c) {
        int index = -1;
        int i = 0;
        while (i < this.external.length) {
            if (this.external[i] == c) {
                index = i;
            }
            ++i;
        }
        if (index == -1) {
            this.externalQueue.remove(c);
        } else {
            this.external[index].resetDND((DragSourceListener)this.dragListeners[index], (DropTargetListener)this.dropListeners[index]);
            this.external[index] = null;
            this.compact();
            this.reparent();
            this.calculateUsedSlots();
            this.scale();
            this.surface.layout(true, true);
        }
    }

    public void move(int from, int to) {
        DashboardAdapter fromShim = this.external[from];
        DashboardAdapter toShim = this.external[to];
        this.external[to] = fromShim;
        this.external[from] = toShim;
        this.external[to].setParent(this.internal[to]);
        this.external[from].setParent(this.internal[from]);
        fromShim.resetDND((DragSourceListener)this.dragListeners[from], (DropTargetListener)this.dropListeners[from]);
        toShim.resetDND((DragSourceListener)this.dragListeners[to], (DropTargetListener)this.dropListeners[to]);
        this.bindDND(from);
        this.bindDND(to);
    }

    private void bindDND(int slot) {
        this.external[slot].dragSource.addDragListener((DragSourceListener)this.dragListeners[slot]);
        this.external[slot].dropTarget.addDropListener((DropTargetListener)this.dropListeners[slot]);
    }

    private int findLowestOpenSlot() {
        int i = 0;
        while (i < this.external.length) {
            if (this.external[i] == null) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void calculateUsedSlots() {
        int count = 0;
        int i = 0;
        while (i < this.external.length) {
            if (this.external[i] != null) {
                ++count;
            }
            ++i;
        }
        this.usedSlotCount = count;
    }

    /*
     * Unable to fully structure code
     */
    private void compact() {
        i = 0;
        j = 0;
        ** GOTO lbl25
        {
            ++i;
            do {
                if (i < this.external.length && this.external[i] != null) continue block0;
                if (i == this.external.length) break block0;
                if (this.externalQueue.size() > 0) {
                    this.external[i] = this.externalQueue.remove(0);
                    data = new FormData();
                    data.left = new FormAttachment(0, 0);
                    data.right = new FormAttachment(100, 0);
                    data.top = new FormAttachment(0, 0);
                    data.bottom = new FormAttachment(100, 0);
                    this.external[i].setLayoutData(data);
                    continue;
                }
                j = i;
                while (j < this.external.length && this.external[j] == null) {
                    ++j;
                }
                if (j == this.external.length) break block0;
                this.external[i] = this.external[j];
                this.external[j] = null;
                i = j;
lbl25:
                // 3 sources

            } while (i < this.external.length);
        }
    }

    private void reparent() {
        int i = 0;
        while (i < this.internal.length) {
            Control[] c = this.internal[i].getChildren();
            int j = 0;
            while (j < c.length) {
                if (this.external[i] != null && c[j] == this.external[i].folder) {
                    c[j].setVisible(true);
                } else {
                    c[j].setParent(this.deadComposite);
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.external.length) {
            if (this.external[i] != null) {
                this.external[i].setParent(this.internal[i]);
                this.external[i].resetDND(null, null);
                this.bindDND(i);
            }
            ++i;
        }
    }

    public void maximize(DashboardAdapter c) {
        int index = -1;
        int i = 0;
        while (i < this.external.length) {
            if (this.external[i] == c) {
                index = i;
            }
            ++i;
        }
        this.usedSlotCount = 1;
        this.maximized = index;
        this.scale();
        this.surface.layout(true, true);
    }

    public void restore() {
        this.calculateUsedSlots();
        this.maximized = 0;
        this.scale();
        this.surface.layout(true, true);
    }

    public int getusedSlots() {
        return this.usedSlotCount;
    }

    private void scale() {
        switch (this.usedSlotCount) {
            case 7: 
            case 8: {
                int i = 0;
                while (i < 8) {
                    FormData data = new FormData();
                    data.left = new FormAttachment(i % 2 * 50, 0);
                    data.right = new FormAttachment((i % 2 + 1) * 50, 0);
                    data.top = new FormAttachment(i / 2, 4, 0);
                    data.bottom = new FormAttachment(i / 2 + 1, 4, 0);
                    this.internal[i].setLayoutData((Object)data);
                    this.internal[i].setVisible(true);
                    if (this.external[i] != null) {
                        this.external[i].setVisible(true);
                    }
                    ++i;
                }
                break;
            }
            case 5: 
            case 6: {
                int i = 0;
                while (i < 6) {
                    FormData data = new FormData();
                    data.left = new FormAttachment(i % 2 * 50, 0);
                    data.right = new FormAttachment((i % 2 + 1) * 50, 0);
                    data.top = new FormAttachment(i / 2, 3, 0);
                    data.bottom = new FormAttachment(i / 2 + 1, 3, 0);
                    this.internal[i].setLayoutData((Object)data);
                    this.internal[i].setVisible(true);
                    if (this.external[i] != null) {
                        this.external[i].setVisible(true);
                    }
                    ++i;
                }
                i = 6;
                while (i < 8) {
                    this.internal[i].setVisible(false);
                    if (this.external[i] != null) {
                        this.external[i].setVisible(false);
                    }
                    ++i;
                }
                break;
            }
            case 3: 
            case 4: {
                int i = 0;
                while (i < 4) {
                    FormData data = new FormData();
                    data.left = new FormAttachment(i % 2 * 50, 0);
                    data.right = new FormAttachment((i % 2 + 1) * 50, 0);
                    data.top = new FormAttachment(i / 2, 2, 0);
                    data.bottom = new FormAttachment(i / 2 + 1, 2, 0);
                    this.internal[i].setLayoutData((Object)data);
                    this.internal[i].setVisible(true);
                    if (this.external[i] != null) {
                        this.external[i].setVisible(true);
                    }
                    ++i;
                }
                i = 4;
                while (i < 8) {
                    this.internal[i].setVisible(false);
                    if (this.external[i] != null) {
                        this.external[i].setVisible(false);
                    }
                    ++i;
                }
                break;
            }
            case 2: {
                int i = 0;
                while (i < 2) {
                    FormData data = new FormData();
                    data.left = new FormAttachment(0, 3);
                    data.right = new FormAttachment(100, -3);
                    data.top = new FormAttachment(i, 2, 3);
                    data.bottom = new FormAttachment(i + 1, 2, -3);
                    this.internal[i].setLayoutData((Object)data);
                    this.internal[i].setVisible(true);
                    this.external[i].setVisible(true);
                    ++i;
                }
                i = 2;
                while (i < 8) {
                    this.internal[i].setVisible(false);
                    if (this.external[i] != null) {
                        this.external[i].setVisible(false);
                    }
                    ++i;
                }
                break;
            }
            default: {
                FormData data = new FormData();
                data.left = new FormAttachment(0, 0);
                data.right = new FormAttachment(100, 0);
                data.top = new FormAttachment(0, 0);
                data.bottom = new FormAttachment(100, 0);
                this.internal[this.maximized].setLayoutData((Object)data);
                this.internal[this.maximized].setVisible(true);
                if (this.external[this.maximized] != null) {
                    this.external[this.maximized].setVisible(true);
                }
                int i = this.usedSlotCount;
                while (i < 8) {
                    if (i != this.maximized) {
                        this.internal[i].setVisible(false);
                        if (this.external[i] != null) {
                            this.external[i].setVisible(false);
                        }
                    }
                    ++i;
                }
                break block0;
            }
        }
    }

    private class InternalCompositeDragListener
    extends DragSourceAdapter {
        final int sourceID;

        public InternalCompositeDragListener(int k) {
            this.sourceID = k;
        }

        public void dragStart(DragSourceEvent event) {
            super.dragStart(event);
            if (!((DashboardComposite)DashboardComposite.this).external[this.sourceID].folder.isVisible()) {
                event.doit = false;
            }
        }

        public void dragSetData(DragSourceEvent event) {
            super.dragSetData(event);
            event.data = Integer.toString(this.sourceID);
        }
    }

    private class InternalCompositeDropListener
    extends DropTargetAdapter {
        final int sourceID;
        long lastDropTime = 0L;

        public InternalCompositeDropListener(int k) {
            this.sourceID = k;
        }

        public void dragEnter(DropTargetEvent event) {
            event.detail = event.currentDataType != null ? 2 : 0;
        }

        public void dragOperationChanged(DropTargetEvent event) {
            super.dragOperationChanged(event);
        }

        public void drop(DropTargetEvent event) {
            super.drop(event);
            int k = -1;
            long eventTime = (long)event.time & 0xFFFFFFFFL;
            if (eventTime > this.lastDropTime - 100L && eventTime < this.lastDropTime + 100L) {
                return;
            }
            try {
                k = Integer.parseInt((String)event.data);
            }
            catch (NumberFormatException numberFormatException) {}
            if (k > -1 && k < 8 && k != this.sourceID) {
                DashboardComposite.this.move(k, this.sourceID);
                DashboardComposite.this.move(k, k);
                this.lastDropTime = eventTime;
            }
        }
    }
}

