/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.cdt.autotools.ui.actions;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.IAction;
import org.eclipse.linuxtools.internal.cdt.autotools.core.AutotoolsPropertyConstants;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.actions.InvokeAction;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.actions.InvokeMessages;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.actions.TwoInputDialog;
import org.eclipse.swt.widgets.Shell;

public class InvokeAclocalAction
extends InvokeAction {
    private static final String DEFAULT_OPTION = "";
    private static final String DEFAULT_COMMAND = "aclocal";

    public void run(IAction action) {
        IContainer container = this.getSelectedContainer();
        if (container == null) {
            return;
        }
        IPath execDir = this.getExecDir(container);
        String cwd = String.valueOf(InvokeMessages.getString("CWD")) + this.getCWD(container);
        TwoInputDialog optionDialog = new TwoInputDialog(new Shell(), cwd, InvokeMessages.getString("InvokeAclocalAction.windowTitle.options"), InvokeMessages.getString("InvokeAclocalAction.message.options.otherOptions"), InvokeMessages.getString("InvokeAclocalAction.message.options.includeDir"), DEFAULT_OPTION, null);
        optionDialog.open();
        String rawArgList = optionDialog.getValue();
        String[] optionsList = this.separateOptions(rawArgList);
        rawArgList = optionDialog.getSecondValue();
        String[] targetList = this.separateTargets(rawArgList);
        if (targetList == null) {
            this.showError(InvokeMessages.getString("InvokeAction.execute.windowTitle.error"), InvokeMessages.getString("InvokeAction.windowTitle.quoteError"));
            return;
        }
        int iOption = 0;
        if (targetList.length > 0) {
            iOption = 1;
        }
        String[] argumentList = new String[targetList.length + optionsList.length + iOption];
        System.arraycopy(optionsList, 0, argumentList, 0, optionsList.length);
        if (iOption == 1) {
            argumentList[optionsList.length] = "-I";
        }
        System.arraycopy(targetList, 0, argumentList, optionsList.length + iOption, targetList.length);
        if (container != null) {
            String aclocalCommand = null;
            IProject project = this.getSelectedContainer().getProject();
            try {
                aclocalCommand = project.getPersistentProperty(AutotoolsPropertyConstants.ACLOCAL_TOOL);
            }
            catch (CoreException coreException) {}
            if (aclocalCommand == null) {
                aclocalCommand = DEFAULT_COMMAND;
            }
            this.executeConsoleCommand(DEFAULT_COMMAND, aclocalCommand, argumentList, execDir);
        }
    }

    public void dispose() {
    }
}

