/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.graphing.structures;

import java.util.ArrayList;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.linuxtools.systemtap.ui.graphing.internal.GraphingPlugin;
import org.eclipse.linuxtools.systemtap.ui.graphing.internal.Localization;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.nonui.datasets.IDataSet;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.nonui.structures.GraphData;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.chart.widget.ChartCanvas;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.charts.AbstractChartBuilder;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.datadisplay.DataGrid;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.widgets.GraphComposite;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.wizards.dataset.DataSetFactory;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.wizards.graph.GraphFactory;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.wizards.graph.SelectGraphWizard;
import org.eclipse.linuxtools.systemtap.ui.logging.LogManager;
import org.eclipse.linuxtools.systemtap.ui.structures.UpdateManager;
import org.eclipse.linuxtools.systemtap.ui.structures.listeners.ITabListener;
import org.eclipse.linuxtools.systemtap.ui.structures.listeners.IUpdateListener;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class GraphDisplaySet {
    private int lastSelectedTab;
    private IDataSet dataSet;
    private CTabFolder folder;
    private ButtonClickListener listener;
    private UpdateManager updater;
    private ArrayList tabListeners;
    private ArrayList builders;

    public GraphDisplaySet(Composite parent, IDataSet data) {
        LogManager.logDebug((String)"Start GraphSelectorView:", (Object)this);
        LogManager.logInfo((String)"Initializing", (Object)this);
        IPreferenceStore p = GraphingPlugin.getDefault().getPreferenceStore();
        int delay = p.getInt("GraphUpdateDelay");
        this.dataSet = data;
        this.updater = new UpdateManager(delay);
        this.updater.addUpdateListener(new IUpdateListener(){

            public void handleUpdateEvent() {
            }
        });
        this.createPartControl(parent);
        this.builders = new ArrayList();
        this.tabListeners = new ArrayList();
        LogManager.logDebug((String)"End GraphSelectorView:", (Object)this);
    }

    public void createPartControl(Composite parent) {
        LogManager.logDebug((String)("Start createPartControl: parent-" + parent), (Object)this);
        parent.setLayout((Layout)new FormLayout());
        FormData data1 = new FormData();
        Composite cmpCoolBar = new Composite(parent, 0);
        data1.left = new FormAttachment(0, 0);
        data1.top = new FormAttachment(0, 0);
        data1.right = new FormAttachment(100, 0);
        data1.bottom = new FormAttachment(0, 10);
        cmpCoolBar.setLayoutData((Object)data1);
        FormData data2 = new FormData();
        data2.left = new FormAttachment(0, 0);
        data2.top = new FormAttachment((Control)cmpCoolBar);
        data2.right = new FormAttachment(100, 0);
        data2.bottom = new FormAttachment(100, 0);
        Composite cmpGraph = new Composite(parent, 0);
        cmpGraph.setLayoutData((Object)data2);
        cmpGraph.setLayout((Layout)new FormLayout());
        this.folder = new CTabFolder(cmpGraph, 0);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment(100, 0);
        this.folder.setLayoutData((Object)data);
        this.listener = new ButtonClickListener();
        this.folder.addSelectionListener((SelectionListener)this.listener);
        this.folder.addCTabFolder2Listener(new CTabFolder2Listener(){

            public void restore(CTabFolderEvent e) {
            }

            public void showList(CTabFolderEvent e) {
            }

            public void minimize(CTabFolderEvent e) {
            }

            public void maximize(CTabFolderEvent e) {
            }

            public void close(CTabFolderEvent e) {
                int selected = GraphDisplaySet.this.folder.indexOf((CTabItem)e.item) - 2;
                if (GraphDisplaySet.this.updater != null) {
                    GraphDisplaySet.this.updater.removeUpdateListener((IUpdateListener)((AbstractChartBuilder)GraphDisplaySet.this.builders.get(selected)));
                }
                GraphDisplaySet.this.builders.remove(selected);
                GraphDisplaySet.this.fireTabCloseEvent();
            }
        });
        CTabItem newGraph = new CTabItem(this.folder, 0);
        newGraph.setImage(GraphingPlugin.getImageDescriptor("icons/actions/new_wiz.gif").createImage());
        CTabItem item = new CTabItem(this.folder, 0);
        item.setText(Localization.getString("GraphDisplaySet.DataView"));
        Composite c = new Composite((Composite)this.folder, 0);
        GridLayout grid = new GridLayout();
        grid.marginHeight = 0;
        grid.marginWidth = 0;
        c.setLayout((Layout)grid);
        GridData gd = new GridData(4, 4, true, true);
        DataGrid table = DataSetFactory.getDataGrid((Composite)c, (IDataSet)this.dataSet);
        if (this.updater != null) {
            this.updater.addUpdateListener((IUpdateListener)table);
        }
        table.getControl().setLayoutData((Object)gd);
        item.setControl((Control)c);
        this.folder.setSelection(item);
        this.lastSelectedTab = 1;
        LogManager.logDebug((String)"End createPartControl", (Object)this);
    }

    public IDataSet getDataSet() {
        return this.dataSet;
    }

    public ChartCanvas getActiveGraph() {
        if (this.builders.size() == 0 || this.folder.getSelectionIndex() < 2) {
            return null;
        }
        return (ChartCanvas)this.builders.get(this.folder.getSelectionIndex() - 2);
    }

    public void setFocus() {
    }

    public void dispose() {
        LogManager.logDebug((String)"Start dispose:", (Object)this);
        LogManager.logInfo((String)"Disposing", (Object)this);
        if (this.updater != null) {
            this.updater.dispose();
        }
        this.updater = null;
        this.dataSet = null;
        if (this.folder != null) {
            this.folder.removeSelectionListener((SelectionListener)this.listener);
            this.folder.dispose();
            this.folder = null;
        }
        this.listener = null;
        LogManager.logDebug((String)"End dispose:", (Object)this);
    }

    public void addTabListener(ITabListener listener) {
        this.tabListeners.add(listener);
    }

    public void removeTabListener(ITabListener listener) {
        this.tabListeners.remove(listener);
    }

    private void fireTabCloseEvent() {
        int i = 0;
        while (i < this.tabListeners.size()) {
            ((ITabListener)this.tabListeners.get(i)).tabClosed();
            ++i;
        }
    }

    private void fireTabOpenEvent() {
        int i = 0;
        while (i < this.tabListeners.size()) {
            ((ITabListener)this.tabListeners.get(i)).tabOpened();
            ++i;
        }
    }

    private void fireTabChangedEvent() {
        int i = 0;
        while (i < this.tabListeners.size()) {
            ((ITabListener)this.tabListeners.get(i)).tabChanged();
            ++i;
        }
    }

    public class ButtonClickListener
    implements SelectionListener {
        public void widgetDefaultSelected(SelectionEvent event) {
        }

        public void widgetSelected(SelectionEvent event) {
            CTabFolder folder = (CTabFolder)event.getSource();
            if (folder.getSelectionIndex() == 0) {
                folder.setSelection(GraphDisplaySet.this.lastSelectedTab);
                SelectGraphWizard wizard = new SelectGraphWizard(GraphDisplaySet.this.dataSet);
                IWorkbench workbench = PlatformUI.getWorkbench();
                wizard.init(workbench, null);
                WizardDialog dialog = new WizardDialog(workbench.getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
                dialog.create();
                dialog.open();
                GraphData gd = wizard.getGraphData();
                if (gd != null) {
                    CTabItem item = new CTabItem(folder, 64);
                    item.setText(GraphFactory.getGraphName((String)gd.graphID));
                    GraphComposite gc = new GraphComposite((Composite)folder, 4, gd, GraphDisplaySet.this.dataSet);
                    gc.setLayoutData((Object)new GridData(4, 4, true, true));
                    folder.setSelection(item);
                    AbstractChartBuilder g = gc.getCanvas();
                    item.setControl((Control)gc);
                    if (g != null) {
                        if (GraphDisplaySet.this.updater != null) {
                            GraphDisplaySet.this.updater.addUpdateListener((IUpdateListener)g);
                        }
                        GraphDisplaySet.this.builders.add(g);
                    }
                }
                wizard.dispose();
                GraphDisplaySet.this.fireTabOpenEvent();
            }
            GraphDisplaySet.this.lastSelectedTab = folder.getSelectionIndex();
            GraphDisplaySet.this.fireTabChangedEvent();
        }
    }
}

