/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.iot.tiaki.domain;

import org.eclipse.iot.tiaki.utils.ValidatorUtil;

public class DnsCertPrefix {
    private int port;
    private String protocol;

    public DnsCertPrefix() {
        this.setDefaultValues();
    }

    public DnsCertPrefix(String initString) {
        this.parseInitString(initString);
    }

    public void reinitialize() {
        this.reinitialize(null);
    }

    public void reinitialize(String initString) {
        this.parseInitString(initString);
    }

    public int getPort() {
        return this.port;
    }

    public String getProtocol() {
        return this.protocol;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseInitString(String initString) {
        if (initString == null || initString.trim().isEmpty()) {
            this.setDefaultValues();
            return;
        } else {
            int delimiterIndex = (initString = initString.trim()).indexOf(58);
            if (delimiterIndex == -1) {
                this.protocol = "tcp";
                if (!ValidatorUtil.isValidPort(initString)) throw new IllegalArgumentException("invalid port value");
                this.port = Integer.parseInt(initString);
                return;
            } else if (delimiterIndex == 0) {
                this.port = 0;
                this.protocol = initString.substring(1);
                return;
            } else {
                String portString = initString.substring(0, delimiterIndex);
                if (!ValidatorUtil.isValidPort(portString)) {
                    throw new IllegalArgumentException("invalid port value");
                }
                this.port = Integer.parseInt(portString);
                this.protocol = initString.substring(delimiterIndex + 1);
                this.protocol = this.protocol.length() > 0 ? this.protocol : "tcp";
            }
        }
    }

    private void setDefaultValues() {
        this.port = 0;
        this.protocol = "tcp";
    }

    public String toString() {
        return "_" + this.port + "." + "_" + this.protocol;
    }
}

