/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.mutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.LazyIntIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.block.function.primitive.ByteFunction0;
import org.eclipse.collections.api.block.function.primitive.ByteToByteFunction;
import org.eclipse.collections.api.block.function.primitive.IntByteToByteFunction;
import org.eclipse.collections.api.block.function.primitive.IntToByteFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectByteToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.IntBytePredicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.block.procedure.primitive.IntByteProcedure;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.collection.primitive.MutableByteCollection;
import org.eclipse.collections.api.iterator.IntIterator;
import org.eclipse.collections.api.iterator.MutableByteIterator;
import org.eclipse.collections.api.iterator.MutableIntIterator;
import org.eclipse.collections.api.map.primitive.ImmutableIntByteMap;
import org.eclipse.collections.api.map.primitive.IntByteMap;
import org.eclipse.collections.api.map.primitive.MutableByteIntMap;
import org.eclipse.collections.api.map.primitive.MutableIntByteMap;
import org.eclipse.collections.api.set.primitive.ByteSet;
import org.eclipse.collections.api.set.primitive.IntSet;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.api.tuple.primitive.IntBytePair;
import org.eclipse.collections.impl.SpreadFunctions;
import org.eclipse.collections.impl.bag.mutable.primitive.ByteHashBag;
import org.eclipse.collections.impl.factory.primitive.ByteIntMaps;
import org.eclipse.collections.impl.factory.primitive.IntByteMaps;
import org.eclipse.collections.impl.iterator.UnmodifiableIntIterator;
import org.eclipse.collections.impl.lazy.AbstractLazyIterable;
import org.eclipse.collections.impl.lazy.primitive.AbstractLazyIntIterable;
import org.eclipse.collections.impl.map.mutable.primitive.AbstractMutableByteValuesMap;
import org.eclipse.collections.impl.map.mutable.primitive.AbstractMutableIntKeySet;
import org.eclipse.collections.impl.map.mutable.primitive.ImmutableIntMapKeySet;
import org.eclipse.collections.impl.map.mutable.primitive.MutableIntKeysMap;
import org.eclipse.collections.impl.map.mutable.primitive.SynchronizedIntByteMap;
import org.eclipse.collections.impl.map.mutable.primitive.UnmodifiableIntByteMap;
import org.eclipse.collections.impl.set.mutable.primitive.IntHashSet;
import org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;

public class IntByteHashMap
extends AbstractMutableByteValuesMap
implements MutableIntByteMap,
Externalizable,
MutableIntKeysMap {
    private static final byte EMPTY_VALUE = 0;
    private static final long serialVersionUID = 1L;
    private static final int EMPTY_KEY = 0;
    private static final int REMOVED_KEY = 1;
    private static final int CACHE_LINE_SIZE = 64;
    private static final int KEY_SIZE = 4;
    private static final int INITIAL_LINEAR_PROBE = 8;
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private int[] keys;
    private byte[] values;
    private int occupiedWithData;
    private int occupiedWithSentinels;
    private AbstractMutableByteValuesMap.SentinelValues sentinelValues;
    private boolean copyKeysOnWrite;

    public IntByteHashMap() {
        this.allocateTable(16);
    }

    public IntByteHashMap(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        int capacity = this.smallestPowerOfTwoGreaterThan(initialCapacity << 1);
        this.allocateTable(capacity);
    }

    public IntByteHashMap(IntByteMap map) {
        if (map instanceof IntByteHashMap && ((IntByteHashMap)map).occupiedWithSentinels == 0) {
            IntByteHashMap hashMap = (IntByteHashMap)map;
            this.occupiedWithData = hashMap.occupiedWithData;
            if (hashMap.sentinelValues != null) {
                this.sentinelValues = hashMap.sentinelValues.copy();
            }
            this.keys = Arrays.copyOf(hashMap.keys, hashMap.keys.length);
            this.values = Arrays.copyOf(hashMap.values, hashMap.values.length);
        } else {
            int capacity = this.smallestPowerOfTwoGreaterThan(Math.max(map.size(), 8) << 1);
            this.allocateTable(capacity);
            this.putAll(map);
        }
    }

    public static IntByteHashMap newWithKeysValues(int key1, byte value1) {
        return new IntByteHashMap(1).withKeyValue(key1, value1);
    }

    public static IntByteHashMap newWithKeysValues(int key1, byte value1, int key2, byte value2) {
        return new IntByteHashMap(2).withKeysValues(key1, value1, key2, value2);
    }

    public static IntByteHashMap newWithKeysValues(int key1, byte value1, int key2, byte value2, int key3, byte value3) {
        return new IntByteHashMap(3).withKeysValues(key1, value1, key2, value2, key3, value3);
    }

    public static IntByteHashMap newWithKeysValues(int key1, byte value1, int key2, byte value2, int key3, byte value3, int key4, byte value4) {
        return new IntByteHashMap(4).withKeysValues(key1, value1, key2, value2, key3, value3, key4, value4);
    }

    private int smallestPowerOfTwoGreaterThan(int n) {
        return n > 1 ? Integer.highestOneBit(n - 1) << 1 : 1;
    }

    @Override
    protected int getOccupiedWithData() {
        return this.occupiedWithData;
    }

    @Override
    protected AbstractMutableByteValuesMap.SentinelValues getSentinelValues() {
        return this.sentinelValues;
    }

    @Override
    protected void setSentinelValuesNull() {
        this.sentinelValues = null;
    }

    @Override
    protected byte getEmptyValue() {
        return 0;
    }

    @Override
    protected int getTableSize() {
        return this.values.length;
    }

    @Override
    protected byte getValueAtIndex(int index) {
        return this.values[index];
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IntByteMap)) {
            return false;
        }
        IntByteMap other = (IntByteMap)obj;
        if (this.size() != other.size()) {
            return false;
        }
        if (this.sentinelValues == null) {
            if (other.containsKey(0) || other.containsKey(1)) {
                return false;
            }
        } else {
            if (this.sentinelValues.containsZeroKey && (!other.containsKey(0) || this.sentinelValues.zeroValue != other.getOrThrow(0))) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && (!other.containsKey(1) || this.sentinelValues.oneValue != other.getOrThrow(1))) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            int key = this.keys[i];
            if (!IntByteHashMap.isNonSentinel(key) || other.containsKey(key) && this.values[i] == other.getOrThrow(key)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int result = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result += 0 ^ this.sentinelValues.zeroValue;
            }
            if (this.sentinelValues.containsOneKey) {
                result += 1 ^ this.sentinelValues.oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntByteHashMap.isNonSentinel(this.keys[i])) continue;
            result += this.keys[i] ^ this.values[i];
        }
        return result;
    }

    @Override
    public String toString() {
        StringBuilder appendable = new StringBuilder();
        appendable.append("{");
        boolean first = true;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                appendable.append(0).append("=").append(this.sentinelValues.zeroValue);
                first = false;
            }
            if (this.sentinelValues.containsOneKey) {
                if (!first) {
                    appendable.append(", ");
                }
                appendable.append(1).append("=").append(this.sentinelValues.oneValue);
                first = false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            int key = this.keys[i];
            if (!IntByteHashMap.isNonSentinel(key)) continue;
            if (!first) {
                appendable.append(", ");
            }
            appendable.append(key).append("=").append(this.values[i]);
            first = false;
        }
        appendable.append("}");
        return appendable.toString();
    }

    @Override
    public MutableByteIterator byteIterator() {
        return new InternalByteIterator();
    }

    public <V> V injectInto(V injectedValue, ObjectByteToObjectFunction<? super V, ? extends V> function) {
        V result = injectedValue;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result = function.valueOf(result, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                result = function.valueOf(result, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntByteHashMap.isNonSentinel(this.keys[i])) continue;
            result = function.valueOf(result, this.values[i]);
        }
        return result;
    }

    @Override
    public void clear() {
        this.sentinelValues = null;
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        if (this.copyKeysOnWrite) {
            this.copyKeys();
        }
        Arrays.fill(this.keys, 0);
        Arrays.fill(this.values, (byte)0);
    }

    @Override
    public void put(int key, byte value) {
        if (IntByteHashMap.isEmptyKey(key)) {
            this.putForEmptySentinel(value);
            return;
        }
        if (IntByteHashMap.isRemovedKey(key)) {
            this.putForRemovedSentinel(value);
            return;
        }
        int index = this.probe(key);
        int keyAtIndex = this.keys[index];
        if (keyAtIndex == key) {
            this.values[index] = value;
        } else {
            this.addKeyValueAtIndex(key, value, index);
        }
    }

    private void putForRemovedSentinel(byte value) {
        if (this.sentinelValues == null) {
            this.sentinelValues = new AbstractMutableByteValuesMap.SentinelValues();
        }
        this.addRemovedKeyValue(value);
    }

    private void putForEmptySentinel(byte value) {
        if (this.sentinelValues == null) {
            this.sentinelValues = new AbstractMutableByteValuesMap.SentinelValues();
        }
        this.addEmptyKeyValue(value);
    }

    @Override
    public void putAll(IntByteMap map) {
        map.forEachKeyValue(this::put);
    }

    @Override
    public void updateValues(IntByteToByteFunction function) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue = function.valueOf(0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue = function.valueOf(1, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntByteHashMap.isNonSentinel(this.keys[i])) continue;
            this.values[i] = function.valueOf(this.keys[i], this.values[i]);
        }
    }

    @Override
    public void removeKey(int key) {
        if (IntByteHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return;
            }
            this.removeEmptyKey();
            return;
        }
        if (IntByteHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return;
            }
            this.removeRemovedKey();
            return;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.removeKeyAtIndex(index);
        }
    }

    @Override
    public void remove(int key) {
        this.removeKey(key);
    }

    @Override
    public byte removeKeyIfAbsent(int key, byte value) {
        if (IntByteHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return value;
            }
            byte oldValue = this.sentinelValues.zeroValue;
            this.removeEmptyKey();
            return oldValue;
        }
        if (IntByteHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return value;
            }
            byte oldValue = this.sentinelValues.oneValue;
            this.removeRemovedKey();
            return oldValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            byte oldValue = this.values[index];
            this.removeKeyAtIndex(index);
            return oldValue;
        }
        return value;
    }

    @Override
    public byte getIfAbsentPut(int key, byte value) {
        if (IntByteHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableByteValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            this.addEmptyKeyValue(value);
            return value;
        }
        if (IntByteHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableByteValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    @Override
    public byte getIfAbsentPut(int key, ByteFunction0 function) {
        if (IntByteHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                byte value = function.value();
                this.sentinelValues = new AbstractMutableByteValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            byte value = function.value();
            this.addEmptyKeyValue(value);
            return value;
        }
        if (IntByteHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                byte value = function.value();
                this.sentinelValues = new AbstractMutableByteValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            byte value = function.value();
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        byte value = function.value();
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    @Override
    public <P> byte getIfAbsentPutWith(int key, ByteFunction<? super P> function, P parameter) {
        if (IntByteHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                byte value = function.byteValueOf(parameter);
                this.sentinelValues = new AbstractMutableByteValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            byte value = function.byteValueOf(parameter);
            this.addEmptyKeyValue(value);
            return value;
        }
        if (IntByteHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                byte value = function.byteValueOf(parameter);
                this.sentinelValues = new AbstractMutableByteValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            byte value = function.byteValueOf(parameter);
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        byte value = function.byteValueOf(parameter);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    @Override
    public byte getIfAbsentPutWithKey(int key, IntToByteFunction function) {
        if (IntByteHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                byte value = function.valueOf(key);
                this.sentinelValues = new AbstractMutableByteValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            byte value = function.valueOf(key);
            this.addEmptyKeyValue(value);
            return value;
        }
        if (IntByteHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                byte value = function.valueOf(key);
                this.sentinelValues = new AbstractMutableByteValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            byte value = function.valueOf(key);
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        byte value = function.valueOf(key);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    @Override
    public byte addToValue(int key, byte toBeAdded) {
        if (IntByteHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableByteValuesMap.SentinelValues();
                this.addEmptyKeyValue(toBeAdded);
            } else if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue = (byte)(this.sentinelValues.zeroValue + toBeAdded);
            } else {
                this.addEmptyKeyValue(toBeAdded);
            }
            return this.sentinelValues.zeroValue;
        }
        if (IntByteHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableByteValuesMap.SentinelValues();
                this.addRemovedKeyValue(toBeAdded);
            } else if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue = (byte)(this.sentinelValues.oneValue + toBeAdded);
            } else {
                this.addRemovedKeyValue(toBeAdded);
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            int n = index;
            this.values[n] = (byte)(this.values[n] + toBeAdded);
            return this.values[index];
        }
        this.addKeyValueAtIndex(key, toBeAdded, index);
        return toBeAdded;
    }

    private void addKeyValueAtIndex(int key, byte value, int index) {
        if (this.keys[index] == 1) {
            --this.occupiedWithSentinels;
        }
        if (this.copyKeysOnWrite) {
            this.copyKeys();
        }
        this.keys[index] = key;
        this.values[index] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData + this.occupiedWithSentinels > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
    }

    private void removeKeyAtIndex(int index) {
        if (this.copyKeysOnWrite) {
            this.copyKeys();
        }
        this.keys[index] = 1;
        this.values[index] = 0;
        --this.occupiedWithData;
        ++this.occupiedWithSentinels;
    }

    private void copyKeys() {
        int[] copy = new int[this.keys.length];
        System.arraycopy(this.keys, 0, copy, 0, this.keys.length);
        this.keys = copy;
        this.copyKeysOnWrite = false;
    }

    @Override
    public byte updateValue(int key, byte initialValueIfAbsent, ByteToByteFunction function) {
        if (IntByteHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableByteValuesMap.SentinelValues();
                this.addEmptyKeyValue(function.valueOf(initialValueIfAbsent));
            } else if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue = function.valueOf(this.sentinelValues.zeroValue);
            } else {
                this.addEmptyKeyValue(function.valueOf(initialValueIfAbsent));
            }
            return this.sentinelValues.zeroValue;
        }
        if (IntByteHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableByteValuesMap.SentinelValues();
                this.addRemovedKeyValue(function.valueOf(initialValueIfAbsent));
            } else if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue = function.valueOf(this.sentinelValues.oneValue);
            } else {
                this.addRemovedKeyValue(function.valueOf(initialValueIfAbsent));
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.values[index] = function.valueOf(this.values[index]);
            return this.values[index];
        }
        byte value = function.valueOf(initialValueIfAbsent);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    @Override
    public IntByteHashMap withKeyValue(int key1, byte value1) {
        this.put(key1, value1);
        return this;
    }

    public IntByteHashMap withKeysValues(int key1, byte value1, int key2, byte value2) {
        this.put(key1, value1);
        this.put(key2, value2);
        return this;
    }

    public IntByteHashMap withKeysValues(int key1, byte value1, int key2, byte value2, int key3, byte value3) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        return this;
    }

    public IntByteHashMap withKeysValues(int key1, byte value1, int key2, byte value2, int key3, byte value3, int key4, byte value4) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        this.put(key4, value4);
        return this;
    }

    @Override
    public IntByteHashMap withoutKey(int key) {
        this.removeKey(key);
        return this;
    }

    @Override
    public IntByteHashMap withoutAllKeys(IntIterable keys) {
        keys.forEach(this::removeKey);
        return this;
    }

    @Override
    public MutableIntByteMap asUnmodifiable() {
        return new UnmodifiableIntByteMap(this);
    }

    @Override
    public MutableIntByteMap asSynchronized() {
        return new SynchronizedIntByteMap(this);
    }

    @Override
    public ImmutableIntByteMap toImmutable() {
        return IntByteMaps.immutable.ofAll(this);
    }

    @Override
    public byte get(int key) {
        return this.getIfAbsent(key, (byte)0);
    }

    @Override
    public byte getIfAbsent(int key, byte ifAbsent) {
        if (IntByteHashMap.isEmptyKey(key) || IntByteHashMap.isRemovedKey(key)) {
            return this.getForSentinel(key, ifAbsent);
        }
        if (this.occupiedWithSentinels == 0) {
            return this.fastGetIfAbsent(key, ifAbsent);
        }
        return this.slowGetIfAbsent(key, ifAbsent);
    }

    private byte getForSentinel(int key, byte ifAbsent) {
        if (IntByteHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return ifAbsent;
            }
            return this.sentinelValues.zeroValue;
        }
        if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
            return ifAbsent;
        }
        return this.sentinelValues.oneValue;
    }

    private byte slowGetIfAbsent(int key, byte ifAbsent) {
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        return ifAbsent;
    }

    private byte fastGetIfAbsent(int key, byte ifAbsent) {
        int index = this.mask(key);
        for (int i = 0; i < 8; ++i) {
            int keyAtIndex = this.keys[index];
            if (keyAtIndex == key) {
                return this.values[index];
            }
            if (keyAtIndex == 0) {
                return ifAbsent;
            }
            index = index + 1 & this.keys.length - 1;
        }
        return this.slowGetIfAbsentTwo(key, ifAbsent);
    }

    private byte slowGetIfAbsentTwo(int key, byte ifAbsent) {
        int index = this.probeTwo(key, -1);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        return ifAbsent;
    }

    @Override
    public byte getOrThrow(int key) {
        if (IntByteHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.zeroValue;
        }
        if (IntByteHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (IntByteHashMap.isNonSentinel(this.keys[index])) {
            return this.values[index];
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    @Override
    public boolean containsKey(int key) {
        if (IntByteHashMap.isEmptyKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsZeroKey;
        }
        if (IntByteHashMap.isRemovedKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsOneKey;
        }
        return this.keys[this.probe(key)] == key;
    }

    @Override
    public void forEachKey(IntProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(0);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(1);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntByteHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.keys[i]);
        }
    }

    @Override
    public void forEachKeyValue(IntByteProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(1, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntByteHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.keys[i], this.values[i]);
        }
    }

    @Override
    public LazyIntIterable keysView() {
        return new KeysView();
    }

    @Override
    public RichIterable<IntBytePair> keyValuesView() {
        return new KeyValuesView();
    }

    @Override
    public MutableByteIntMap flipUniqueValues() {
        MutableByteIntMap result = ByteIntMaps.mutable.empty();
        this.forEachKeyValue((key, value) -> {
            if (result.containsKey(value)) {
                throw new IllegalStateException("Duplicate value: " + value + " found at key: " + result.get(value) + " and key: " + key);
            }
            result.put(value, key);
        });
        return result;
    }

    @Override
    public IntByteHashMap select(IntBytePredicate predicate) {
        IntByteHashMap result = new IntByteHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(0, this.sentinelValues.zeroValue)) {
                result.put(0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(1, this.sentinelValues.oneValue)) {
                result.put(1, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntByteHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    @Override
    public IntByteHashMap reject(IntBytePredicate predicate) {
        IntByteHashMap result = new IntByteHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(0, this.sentinelValues.zeroValue)) {
                result.put(0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(1, this.sentinelValues.oneValue)) {
                result.put(1, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntByteHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size());
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                out.writeInt(0);
                out.writeByte(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                out.writeInt(1);
                out.writeByte(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntByteHashMap.isNonSentinel(this.keys[i])) continue;
            out.writeInt(this.keys[i]);
            out.writeByte(this.values[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.put(in.readInt(), in.readByte());
        }
    }

    public void compact() {
        this.rehash(this.smallestPowerOfTwoGreaterThan(this.size()));
    }

    private void rehashAndGrow() {
        int max = this.maxOccupiedWithData();
        int newCapacity = Math.max(max, this.smallestPowerOfTwoGreaterThan(this.occupiedWithData + 1 << 1));
        if (this.occupiedWithSentinels > 0 && (max >> 1) + (max >> 2) < this.occupiedWithData) {
            newCapacity <<= 1;
        }
        this.rehash(newCapacity);
    }

    private void rehash(int newCapacity) {
        int oldLength = this.keys.length;
        int[] old = this.keys;
        byte[] oldValues = this.values;
        this.allocateTable(newCapacity);
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        for (int i = 0; i < oldLength; ++i) {
            if (!IntByteHashMap.isNonSentinel(old[i])) continue;
            this.put(old[i], oldValues[i]);
        }
    }

    int probe(int element) {
        int index = this.mask(element);
        int keyAtIndex = this.keys[index];
        if (keyAtIndex == element || keyAtIndex == 0) {
            return index;
        }
        int removedIndex = keyAtIndex == 1 ? index : -1;
        for (int i = 1; i < 8; ++i) {
            int nextIndex = index + i & this.keys.length - 1;
            keyAtIndex = this.keys[nextIndex];
            if (keyAtIndex == element) {
                return nextIndex;
            }
            if (keyAtIndex == 0) {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (keyAtIndex != 1 || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return this.probeTwo(element, removedIndex);
    }

    int probeTwo(int element, int removedIndex) {
        int index = this.spreadTwoAndMask(element);
        for (int i = 0; i < 8; ++i) {
            int nextIndex = index + i & this.keys.length - 1;
            int keyAtIndex = this.keys[nextIndex];
            if (keyAtIndex == element) {
                return nextIndex;
            }
            if (keyAtIndex == 0) {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (keyAtIndex != 1 || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return this.probeThree(element, removedIndex);
    }

    int probeThree(int element, int removedIndex) {
        int nextIndex = SpreadFunctions.intSpreadOne(element);
        int spreadTwo = Integer.reverse(SpreadFunctions.intSpreadTwo(element)) | 1;
        int keyAtIndex;
        while ((keyAtIndex = this.keys[nextIndex = this.mask(nextIndex + spreadTwo)]) != element) {
            if (keyAtIndex == 0) {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (keyAtIndex != 1 || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return nextIndex;
    }

    int spreadAndMask(int element) {
        int code = SpreadFunctions.intSpreadOne(element);
        return this.mask(code);
    }

    int spreadTwoAndMask(int element) {
        int code = SpreadFunctions.intSpreadTwo(element);
        return this.mask(code);
    }

    private int mask(int spread) {
        return spread & this.keys.length - 1;
    }

    protected void allocateTable(int sizeToAllocate) {
        this.keys = new int[sizeToAllocate];
        this.values = new byte[sizeToAllocate];
    }

    private static boolean isEmptyKey(int key) {
        return key == 0;
    }

    private static boolean isRemovedKey(int key) {
        return key == 1;
    }

    private static boolean isNonSentinel(int key) {
        return !IntByteHashMap.isEmptyKey(key) && !IntByteHashMap.isRemovedKey(key);
    }

    @Override
    protected boolean isNonSentinelAtIndex(int index) {
        return !IntByteHashMap.isEmptyKey(this.keys[index]) && !IntByteHashMap.isRemovedKey(this.keys[index]);
    }

    private int maxOccupiedWithData() {
        return this.keys.length >> 1;
    }

    @Override
    public MutableIntSet keySet() {
        return new KeySet();
    }

    @Override
    public MutableByteCollection values() {
        return new ValuesCollection();
    }

    static /* synthetic */ int[] access$302(IntByteHashMap x0, int[] x1) {
        x0.keys = x1;
        return x1;
    }

    static /* synthetic */ byte[] access$502(IntByteHashMap x0, byte[] x1) {
        x0.values = x1;
        return x1;
    }

    private class InternalByteIterator
    implements MutableByteIterator {
        private int count;
        private int position;
        private int lastKey;
        private boolean handledZero;
        private boolean handledOne;
        private boolean canRemove;

        private InternalByteIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.count < IntByteHashMap.this.size();
        }

        @Override
        public byte next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            this.canRemove = true;
            if (!this.handledZero) {
                this.handledZero = true;
                if (IntByteHashMap.this.containsKey(0)) {
                    this.lastKey = 0;
                    return IntByteHashMap.this.get(0);
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (IntByteHashMap.this.containsKey(1)) {
                    this.lastKey = 1;
                    return IntByteHashMap.this.get(1);
                }
            }
            int[] keys = IntByteHashMap.this.keys;
            while (!IntByteHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            this.lastKey = keys[this.position];
            byte result = IntByteHashMap.this.values[this.position];
            ++this.position;
            return result;
        }

        @Override
        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException();
            }
            IntByteHashMap.this.removeKey(this.lastKey);
            --this.count;
            this.canRemove = false;
        }
    }

    private class KeySet
    extends AbstractMutableIntKeySet {
        private KeySet() {
        }

        @Override
        protected MutableIntKeysMap getOuter() {
            return IntByteHashMap.this;
        }

        @Override
        protected AbstractMutableByteValuesMap.SentinelValues getSentinelValues() {
            return IntByteHashMap.this.sentinelValues;
        }

        @Override
        protected int getKeyAtIndex(int index) {
            return IntByteHashMap.this.keys[index];
        }

        @Override
        protected int getTableSize() {
            return IntByteHashMap.this.keys.length;
        }

        @Override
        public MutableIntIterator intIterator() {
            return new KeySetIterator();
        }

        @Override
        public boolean retainAll(IntIterable source) {
            int oldSize = IntByteHashMap.this.size();
            IntSet sourceSet = source instanceof IntSet ? (IntSet)source : source.toSet();
            IntByteHashMap retained = IntByteHashMap.this.select((int key, byte value) -> sourceSet.contains(key));
            if (retained.size() != oldSize) {
                IntByteHashMap.access$302(IntByteHashMap.this, retained.keys);
                IntByteHashMap.access$502(IntByteHashMap.this, retained.values);
                IntByteHashMap.this.sentinelValues = retained.sentinelValues;
                IntByteHashMap.this.occupiedWithData = retained.occupiedWithData;
                IntByteHashMap.this.occupiedWithSentinels = retained.occupiedWithSentinels;
                return true;
            }
            return false;
        }

        @Override
        public boolean retainAll(int ... source) {
            return this.retainAll(IntHashSet.newSetWith(source));
        }

        @Override
        public IntSet freeze() {
            IntByteHashMap.this.copyKeysOnWrite = true;
            boolean containsZeroKey = false;
            boolean containsOneKey = false;
            if (IntByteHashMap.this.sentinelValues != null) {
                containsZeroKey = ((IntByteHashMap)IntByteHashMap.this).sentinelValues.containsZeroKey;
                containsOneKey = ((IntByteHashMap)IntByteHashMap.this).sentinelValues.containsOneKey;
            }
            return new ImmutableIntMapKeySet(IntByteHashMap.this.keys, IntByteHashMap.this.occupiedWithData, containsZeroKey, containsOneKey);
        }

        @Override
        public MutableIntSet newEmpty() {
            return new IntHashSet();
        }
    }

    private class KeySetIterator
    implements MutableIntIterator {
        private int count;
        private int position;
        private int lastKey;
        private boolean handledZero;
        private boolean handledOne;
        private boolean canRemove;

        private KeySetIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.count < IntByteHashMap.this.size();
        }

        @Override
        public int next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            this.canRemove = true;
            if (!this.handledZero) {
                this.handledZero = true;
                if (IntByteHashMap.this.containsKey(0)) {
                    this.lastKey = 0;
                    return this.lastKey;
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (IntByteHashMap.this.containsKey(1)) {
                    this.lastKey = 1;
                    return this.lastKey;
                }
            }
            int[] keys = IntByteHashMap.this.keys;
            while (!IntByteHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            this.lastKey = keys[this.position];
            ++this.position;
            return this.lastKey;
        }

        @Override
        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException();
            }
            IntByteHashMap.this.removeKey(this.lastKey);
            --this.count;
            this.canRemove = false;
        }
    }

    private class KeyValuesView
    extends AbstractLazyIterable<IntBytePair> {
        private KeyValuesView() {
        }

        @Override
        public void each(Procedure<? super IntBytePair> procedure) {
            if (IntByteHashMap.this.sentinelValues != null) {
                if (((IntByteHashMap)IntByteHashMap.this).sentinelValues.containsZeroKey) {
                    procedure.value(PrimitiveTuples.pair(0, ((IntByteHashMap)IntByteHashMap.this).sentinelValues.zeroValue));
                }
                if (((IntByteHashMap)IntByteHashMap.this).sentinelValues.containsOneKey) {
                    procedure.value(PrimitiveTuples.pair(1, ((IntByteHashMap)IntByteHashMap.this).sentinelValues.oneValue));
                }
            }
            for (int i = 0; i < IntByteHashMap.this.keys.length; ++i) {
                if (!IntByteHashMap.isNonSentinel(IntByteHashMap.this.keys[i])) continue;
                procedure.value(PrimitiveTuples.pair(IntByteHashMap.this.keys[i], IntByteHashMap.this.values[i]));
            }
        }

        @Override
        public void forEachWithIndex(ObjectIntProcedure<? super IntBytePair> objectIntProcedure) {
            int index = 0;
            if (IntByteHashMap.this.sentinelValues != null) {
                if (((IntByteHashMap)IntByteHashMap.this).sentinelValues.containsZeroKey) {
                    objectIntProcedure.value(PrimitiveTuples.pair(0, ((IntByteHashMap)IntByteHashMap.this).sentinelValues.zeroValue), index);
                    ++index;
                }
                if (((IntByteHashMap)IntByteHashMap.this).sentinelValues.containsOneKey) {
                    objectIntProcedure.value(PrimitiveTuples.pair(1, ((IntByteHashMap)IntByteHashMap.this).sentinelValues.oneValue), index);
                    ++index;
                }
            }
            for (int i = 0; i < IntByteHashMap.this.keys.length; ++i) {
                if (!IntByteHashMap.isNonSentinel(IntByteHashMap.this.keys[i])) continue;
                objectIntProcedure.value(PrimitiveTuples.pair(IntByteHashMap.this.keys[i], IntByteHashMap.this.values[i]), index);
                ++index;
            }
        }

        @Override
        public <P> void forEachWith(Procedure2<? super IntBytePair, ? super P> procedure, P parameter) {
            if (IntByteHashMap.this.sentinelValues != null) {
                if (((IntByteHashMap)IntByteHashMap.this).sentinelValues.containsZeroKey) {
                    procedure.value(PrimitiveTuples.pair(0, ((IntByteHashMap)IntByteHashMap.this).sentinelValues.zeroValue), parameter);
                }
                if (((IntByteHashMap)IntByteHashMap.this).sentinelValues.containsOneKey) {
                    procedure.value(PrimitiveTuples.pair(1, ((IntByteHashMap)IntByteHashMap.this).sentinelValues.oneValue), parameter);
                }
            }
            for (int i = 0; i < IntByteHashMap.this.keys.length; ++i) {
                if (!IntByteHashMap.isNonSentinel(IntByteHashMap.this.keys[i])) continue;
                procedure.value(PrimitiveTuples.pair(IntByteHashMap.this.keys[i], IntByteHashMap.this.values[i]), parameter);
            }
        }

        @Override
        public Iterator<IntBytePair> iterator() {
            return new InternalKeyValuesIterator();
        }

        public class InternalKeyValuesIterator
        implements Iterator<IntBytePair> {
            private int count;
            private int position;
            private boolean handledZero;
            private boolean handledOne;

            @Override
            public IntBytePair next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("next() called, but the iterator is exhausted");
                }
                ++this.count;
                if (!this.handledZero) {
                    this.handledZero = true;
                    if (IntByteHashMap.this.containsKey(0)) {
                        return PrimitiveTuples.pair(0, ((IntByteHashMap)IntByteHashMap.this).sentinelValues.zeroValue);
                    }
                }
                if (!this.handledOne) {
                    this.handledOne = true;
                    if (IntByteHashMap.this.containsKey(1)) {
                        return PrimitiveTuples.pair(1, ((IntByteHashMap)IntByteHashMap.this).sentinelValues.oneValue);
                    }
                }
                int[] keys = IntByteHashMap.this.keys;
                while (!IntByteHashMap.isNonSentinel(keys[this.position])) {
                    ++this.position;
                }
                IntBytePair result = PrimitiveTuples.pair(keys[this.position], IntByteHashMap.this.values[this.position]);
                ++this.position;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
            }

            @Override
            public boolean hasNext() {
                return this.count != IntByteHashMap.this.size();
            }
        }
    }

    private class KeysView
    extends AbstractLazyIntIterable {
        private KeysView() {
        }

        @Override
        public IntIterator intIterator() {
            return new UnmodifiableIntIterator(new KeySetIterator());
        }

        @Override
        public void each(IntProcedure procedure) {
            IntByteHashMap.this.forEachKey(procedure);
        }
    }

    private class ValuesCollection
    extends AbstractMutableByteValuesMap.AbstractByteValuesCollection {
        private ValuesCollection() {
            super(IntByteHashMap.this);
        }

        @Override
        public MutableByteIterator byteIterator() {
            return IntByteHashMap.this.byteIterator();
        }

        @Override
        public boolean remove(byte item) {
            int oldSize = IntByteHashMap.this.size();
            if (IntByteHashMap.this.sentinelValues != null && ((IntByteHashMap)IntByteHashMap.this).sentinelValues.containsZeroKey && item == ((IntByteHashMap)IntByteHashMap.this).sentinelValues.zeroValue) {
                IntByteHashMap.this.removeKey(0);
            }
            if (IntByteHashMap.this.sentinelValues != null && ((IntByteHashMap)IntByteHashMap.this).sentinelValues.containsOneKey && item == ((IntByteHashMap)IntByteHashMap.this).sentinelValues.oneValue) {
                IntByteHashMap.this.removeKey(1);
            }
            for (int i = 0; i < IntByteHashMap.this.keys.length; ++i) {
                if (!IntByteHashMap.isNonSentinel(IntByteHashMap.this.keys[i]) || item != IntByteHashMap.this.values[i]) continue;
                IntByteHashMap.this.removeKey(IntByteHashMap.this.keys[i]);
            }
            return oldSize != IntByteHashMap.this.size();
        }

        @Override
        public boolean retainAll(ByteIterable source) {
            int oldSize = IntByteHashMap.this.size();
            ByteSet sourceSet = source instanceof ByteSet ? (ByteSet)source : source.toSet();
            IntByteHashMap retained = IntByteHashMap.this.select((int key, byte value) -> sourceSet.contains(value));
            if (retained.size() != oldSize) {
                IntByteHashMap.access$302(IntByteHashMap.this, retained.keys);
                IntByteHashMap.access$502(IntByteHashMap.this, retained.values);
                IntByteHashMap.this.sentinelValues = retained.sentinelValues;
                IntByteHashMap.this.occupiedWithData = retained.occupiedWithData;
                IntByteHashMap.this.occupiedWithSentinels = retained.occupiedWithSentinels;
                return true;
            }
            return false;
        }

        @Override
        public MutableByteCollection newEmpty() {
            return new ByteHashBag();
        }
    }
}

