/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.runtime.core;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.titan.runtime.core.AdditionalFunctions;
import org.eclipse.titan.runtime.core.Base_Template;
import org.eclipse.titan.runtime.core.Base_Type;
import org.eclipse.titan.runtime.core.JSON;
import org.eclipse.titan.runtime.core.JSON_Tokenizer;
import org.eclipse.titan.runtime.core.Param_Types;
import org.eclipse.titan.runtime.core.RAW;
import org.eclipse.titan.runtime.core.TTCN_Buffer;
import org.eclipse.titan.runtime.core.TTCN_EncDec;
import org.eclipse.titan.runtime.core.TTCN_EncDec_ErrorContext;
import org.eclipse.titan.runtime.core.TTCN_Logger;
import org.eclipse.titan.runtime.core.Text_Buf;
import org.eclipse.titan.runtime.core.TitanCharString_Element;
import org.eclipse.titan.runtime.core.TitanComponent;
import org.eclipse.titan.runtime.core.TitanComponent_template;
import org.eclipse.titan.runtime.core.TitanInteger;
import org.eclipse.titan.runtime.core.TitanUniversalChar;
import org.eclipse.titan.runtime.core.TitanUniversalCharString;
import org.eclipse.titan.runtime.core.TitanUniversalCharString_Element;
import org.eclipse.titan.runtime.core.TtcnError;
import org.eclipse.titan.runtime.core.cfgparser.StringToTTCNAnalyzer;

public class TitanCharString
extends Base_Type {
    public static final RAW.TTCN_RAWdescriptor TitanCharString_raw_ = new RAW.TTCN_RAWdescriptor(0, RAW.raw_sign_t.SG_NO, TTCN_EncDec.raw_order_t.ORDER_LSB, TTCN_EncDec.raw_order_t.ORDER_LSB, TTCN_EncDec.raw_order_t.ORDER_LSB, TTCN_EncDec.raw_order_t.ORDER_LSB, RAW.ext_bit_t.EXT_BIT_NO, TTCN_EncDec.raw_order_t.ORDER_LSB, TTCN_EncDec.raw_order_t.ORDER_LSB, RAW.top_bit_order_t.TOP_BIT_INHERITED, 0, 0, 0, 8, 0, null, -1, CharCoding.UNKNOWN, null, false);
    public static final JSON.TTCN_JSONdescriptor TitanCharString_json_ = new JSON.TTCN_JSONdescriptor(false, null, false, null, false, false, false, 0, null, false, JSON.json_string_escaping.ESCAPE_AS_SHORT);
    public static final Base_Type.TTCN_Typedescriptor TitanCharString_descr_ = new Base_Type.TTCN_Typedescriptor("charstring", null, TitanCharString_raw_, TitanCharString_json_, null);
    private StringBuilder val_ptr;

    public TitanCharString() {
    }

    public TitanCharString(StringBuilder otherValue) {
        this.val_ptr = new StringBuilder(otherValue);
    }

    public TitanCharString(String otherValue) {
        this.copy_value(otherValue);
    }

    public TitanCharString(TitanCharString otherValue) {
        otherValue.must_bound("Copying an unbound charstring value.");
        this.val_ptr = new StringBuilder(otherValue.val_ptr);
    }

    public TitanCharString(TitanCharString_Element otherValue) {
        otherValue.must_bound("Copying an unbound charstring value.");
        this.val_ptr = new StringBuilder(1);
        this.val_ptr.append(otherValue.get_char());
    }

    public TitanCharString(TitanUniversalCharString otherValue) {
        otherValue.must_bound("Copying an unbound universal charstring to a charstring.");
        this.operator_assign(otherValue);
    }

    public StringBuilder get_value() {
        this.must_bound("Getting an unbound charstring value as string.");
        return this.val_ptr;
    }

    private void copy_value(String aOtherValue) {
        this.val_ptr = new StringBuilder(aOtherValue);
    }

    private void copy_value(StringBuilder aOtherValue) {
        this.val_ptr = new StringBuilder(aOtherValue);
    }

    public TitanCharString operator_assign(String otherValue) {
        this.clean_up();
        this.val_ptr = otherValue == null ? new StringBuilder() : new StringBuilder(otherValue);
        return this;
    }

    public TitanCharString operator_assign(TitanCharString otherValue) {
        otherValue.must_bound("Assignment of an unbound charstring value.");
        if (otherValue != this) {
            this.copy_value(otherValue.val_ptr);
        }
        return this;
    }

    public TitanCharString operator_assign(TitanCharString_Element otherValue) {
        otherValue.must_bound("Assignment of an unbound charstring element to a charstring.");
        this.clean_up();
        this.val_ptr = new StringBuilder(1);
        this.val_ptr.append(otherValue.get_char());
        return this;
    }

    public TitanCharString operator_assign(TitanUniversalCharString otherValue) {
        otherValue.must_bound("Assignment of an unbound universal charstring to a charstring.");
        if (otherValue.charstring) {
            return this.operator_assign(otherValue.cstr.toString());
        }
        this.clean_up();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < otherValue.val_ptr.size(); ++i) {
            TitanUniversalChar uc = otherValue.val_ptr.get(i);
            if (uc.getUc_group() != '\u0000' || uc.getUc_plane() != '\u0000' || uc.getUc_row() != '\u0000') {
                throw new TtcnError(MessageFormat.format("Multiple-byte characters cannot be assigned to a charstring, invalid character char({0},{1}, {2}, {3}) at index {4}.", otherValue));
            }
            sb.append(uc.getUc_cell());
        }
        this.val_ptr = sb;
        return this;
    }

    @Override
    public TitanCharString operator_assign(Base_Type otherValue) {
        if (otherValue instanceof TitanCharString) {
            return this.operator_assign((TitanCharString)otherValue);
        }
        throw new TtcnError(MessageFormat.format("Internal Error: value `{0}'' can not be cast to charstring", otherValue));
    }

    @Override
    public boolean is_bound() {
        return this.val_ptr != null;
    }

    @Override
    public boolean is_present() {
        return this.is_bound();
    }

    @Override
    public boolean is_value() {
        return this.val_ptr != null;
    }

    public TitanInteger lengthof() {
        this.must_bound("Performing lengthof operation on an unbound charstring value.");
        return new TitanInteger(this.val_ptr.length());
    }

    @Override
    public void log() {
        if (this.val_ptr != null) {
            States state = States.INIT;
            StringBuilder buffer = new StringBuilder();
            for (int i = 0; i < this.val_ptr.length(); ++i) {
                char c = this.val_ptr.charAt(i);
                if (TTCN_Logger.is_printable(c)) {
                    switch (state) {
                        case NPCHAR: {
                            buffer.append(" & ");
                        }
                        case INIT: {
                            buffer.append("\"");
                        }
                        case PCHAR: {
                            TTCN_Logger.log_char_escaped(c, buffer);
                        }
                    }
                    state = States.PCHAR;
                    continue;
                }
                switch (state) {
                    case PCHAR: {
                        buffer.append("\"");
                    }
                    case NPCHAR: {
                        buffer.append(" & ");
                    }
                    case INIT: {
                        buffer.append(MessageFormat.format("char(0, 0, 0, {0})", c));
                    }
                }
                state = States.NPCHAR;
            }
            switch (state) {
                case INIT: {
                    buffer.append("\"\"");
                    break;
                }
                case PCHAR: {
                    buffer.append("\"");
                    break;
                }
            }
            TTCN_Logger.log_event_str(buffer.toString());
        } else {
            TTCN_Logger.log_event_unbound();
        }
    }

    @Override
    public void encode_text(Text_Buf text_buf) {
        this.must_bound("Text encoder: Encoding an unbound charstring value.");
        int n_chars = this.val_ptr.length();
        text_buf.push_int(n_chars);
        if (n_chars > 0) {
            byte[] temp = new byte[n_chars];
            for (int i = 0; i < n_chars; ++i) {
                temp[i] = (byte)this.val_ptr.charAt(i);
            }
            text_buf.push_raw(temp);
        }
    }

    @Override
    public void decode_text(Text_Buf text_buf) {
        this.clean_up();
        int n_chars = text_buf.pull_int().get_int();
        if (n_chars < 0) {
            throw new TtcnError("Text decoder: Invalid length was received for a charstring.");
        }
        this.val_ptr = new StringBuilder(n_chars);
        if (n_chars > 0) {
            byte[] temp = new byte[n_chars];
            text_buf.pull_raw(n_chars, temp);
            for (int i = 0; i < n_chars; ++i) {
                this.val_ptr.append((char)temp[i]);
            }
        }
    }

    public TitanCharString operator_concatenate(TitanCharString other_value) {
        this.must_bound("Unbound left operand of charstring addition.");
        other_value.must_bound("Unbound right operand of charstring addition.");
        TitanCharString result = new TitanCharString(this.val_ptr);
        result.val_ptr.append((CharSequence)other_value.val_ptr);
        return result;
    }

    public TitanCharString operator_concatenate(String other_value) {
        this.must_bound("Unbound operand of charstring concatenation.");
        TitanCharString ret_val = new TitanCharString(this.val_ptr);
        if (other_value != null && other_value.length() > 0) {
            ret_val.val_ptr.append(other_value);
        }
        return ret_val;
    }

    public TitanCharString operator_concatenate(TitanCharString_Element other_value) {
        this.must_bound("Unbound operand of charstring concatenation.");
        other_value.must_bound("Unbound operand of charstring element concatenation.");
        TitanCharString ret_val = new TitanCharString(this);
        ret_val.val_ptr.append(other_value.get_char());
        return ret_val;
    }

    public TitanUniversalCharString operator_concatenate(TitanUniversalCharString other_value) {
        this.must_bound("The left operand of concatenation is an unbound charstring value.");
        other_value.must_bound("The right operand of concatenation is an unbound universal charstring value.");
        if (this.val_ptr.length() == 0) {
            return new TitanUniversalCharString(other_value);
        }
        if (other_value.charstring) {
            StringBuilder ret_val = new StringBuilder(this.get_value());
            ret_val.append(other_value.cstr.toString());
            return new TitanUniversalCharString(ret_val);
        }
        ArrayList<TitanUniversalChar> ret_val = new ArrayList<TitanUniversalChar>();
        for (int i = 0; i < this.val_ptr.length(); ++i) {
            ret_val.add(new TitanUniversalChar('\u0000', '\u0000', '\u0000', this.val_ptr.charAt(i)));
        }
        ret_val.addAll(other_value.get_value());
        return new TitanUniversalCharString(ret_val);
    }

    public TitanCharString append(String aOtherValue) {
        this.must_bound(" Appending a string literal to an unbound charstring value.");
        if (aOtherValue != null && aOtherValue.length() > 0) {
            this.val_ptr.append(aOtherValue);
        }
        return this;
    }

    public TitanCharString append(TitanCharString_Element aOtherValue) {
        this.must_bound("Appending a charstring value to an unbound charstring value.");
        aOtherValue.must_bound("Appending an unbound charstring value to another charstring value.");
        this.val_ptr.append(aOtherValue.get_char());
        return this;
    }

    public TitanCharString append(TitanCharString aOtherValue) {
        this.must_bound("Appending a charstring value to an unbound charstring value.");
        aOtherValue.must_bound("Appending an unbound charstring value to another charstring value.");
        this.val_ptr.append((CharSequence)aOtherValue.get_value());
        return this;
    }

    public boolean operator_equals(TitanCharString otherValue) {
        this.must_bound("Unbound left operand of charstring comparison.");
        otherValue.must_bound("Unbound right operand of charstring comparison.");
        return this.val_ptr.toString().equals(otherValue.val_ptr.toString());
    }

    public boolean operator_equals(TitanUniversalCharString otherValue) {
        this.must_bound("The left operand of comparison is an unbound charstring value.");
        otherValue.must_bound("The right operand of comparison is an unbound universal charstring value.");
        if (otherValue.charstring) {
            return this.val_ptr.toString().equals(otherValue.cstr.toString());
        }
        if (this.val_ptr.length() != otherValue.val_ptr.size()) {
            return false;
        }
        for (int i = 0; i < this.val_ptr.length(); ++i) {
            char tempLeft = this.val_ptr.charAt(i);
            TitanUniversalChar tempRight = otherValue.val_ptr.get(i);
            if (tempRight.getUc_group() == '\u0000' && tempRight.getUc_plane() == '\u0000' && tempRight.getUc_row() == '\u0000' && tempRight.getUc_cell() == tempLeft) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean operator_equals(Base_Type otherValue) {
        if (otherValue instanceof TitanCharString) {
            return this.operator_equals((TitanCharString)otherValue);
        }
        if (otherValue instanceof TitanUniversalCharString) {
            return this.operator_equals((TitanUniversalCharString)otherValue);
        }
        throw new TtcnError(MessageFormat.format("Internal Error: value `{0}'' can not be cast to charstring", otherValue));
    }

    public boolean operator_equals(String otherValue) {
        this.must_bound("Unbound operand of charstring comparison.");
        if (otherValue == null) {
            return this.val_ptr.length() == 0;
        }
        return this.val_ptr.toString().equals(otherValue);
    }

    public boolean operator_equals(TitanCharString_Element otherValue) {
        otherValue.must_bound("Unbound operand of charstring element comparison.");
        this.must_bound("Unbound operand of charstring comparison.");
        if (this.val_ptr.length() != 1) {
            return false;
        }
        return this.val_ptr.charAt(0) == otherValue.get_char();
    }

    public boolean operator_equals(TitanUniversalCharString_Element otherValue) {
        this.must_bound("The left operand of comparison is an unbound charstring value.");
        otherValue.must_bound("The right operand of comparison is an unbound universal charstring value");
        if (this.val_ptr.length() != 1) {
            return false;
        }
        TitanUniversalChar uc = otherValue.get_char();
        return uc.getUc_group() == '\u0000' && uc.getUc_plane() == '\u0000' && uc.getUc_row() == '\u0000' && uc.getUc_cell() == this.val_ptr.charAt(0);
    }

    public boolean operator_not_equals(TitanCharString otherValue) {
        return !this.operator_equals(otherValue);
    }

    public boolean operator_not_equals(TitanCharString_Element otherValue) {
        otherValue.must_bound("Unbound operand of charstring element comparison.");
        this.must_bound("Unbound operand of charstring comparison.");
        if (this.val_ptr.length() == 1) {
            return false;
        }
        return this.val_ptr.charAt(0) != otherValue.get_char();
    }

    public boolean operator_not_equals(String otherValue) {
        this.must_bound("Unbound operand of charstring comparison.");
        if (otherValue != null) {
            return this.val_ptr.length() == 0;
        }
        return this.val_ptr.toString().equals(otherValue);
    }

    public boolean operator_not_equals(TitanUniversalCharString otherValue) {
        return !this.operator_equals(otherValue);
    }

    @Override
    public void clean_up() {
        this.val_ptr = null;
    }

    public TitanCharString rotate_left(int rotate_count) {
        this.must_bound("Unbound charstring operand of rotate left operator.");
        if (this.val_ptr.length() == 0) {
            return new TitanCharString(this);
        }
        if (rotate_count >= 0) {
            if ((rotate_count %= this.val_ptr.length()) == 0) {
                return new TitanCharString(this);
            }
            StringBuilder rValue = new StringBuilder(this.val_ptr.length());
            for (int i = 0; i < this.val_ptr.length(); ++i) {
                rValue.append(this.val_ptr.charAt((i + rotate_count) % this.val_ptr.length()));
            }
            return new TitanCharString(rValue);
        }
        return this.rotate_right(-rotate_count);
    }

    public TitanCharString rotate_left(TitanInteger rotate_count) {
        rotate_count.must_bound("Unbound integer operand of rotate left operator.");
        return this.rotate_left(rotate_count.get_int());
    }

    public TitanCharString rotate_right(int rotate_count) {
        this.must_bound("Unbound charstring operand of rotate right operator.");
        if (this.val_ptr.length() == 0) {
            return new TitanCharString(this);
        }
        if (rotate_count >= 0) {
            int i;
            if ((rotate_count %= this.val_ptr.length()) == 0) {
                return new TitanCharString(this);
            }
            StringBuilder rValue = new StringBuilder(this.val_ptr.length());
            for (i = 0; i < rotate_count; ++i) {
                rValue.append(this.val_ptr.charAt(i + this.val_ptr.length() - rotate_count));
            }
            for (i = rotate_count; i < this.val_ptr.length(); ++i) {
                rValue.append(this.val_ptr.charAt(i - rotate_count));
            }
            return new TitanCharString(rValue);
        }
        return this.rotate_left(-rotate_count);
    }

    public TitanCharString rotate_right(TitanInteger rotate_count) {
        rotate_count.must_bound("Unbound integer operand of rotate right operator.");
        return this.rotate_right(rotate_count.get_int());
    }

    public TitanCharString_Element get_at(int index_value) {
        if (this.val_ptr == null && index_value == 0) {
            this.val_ptr = new StringBuilder();
            return new TitanCharString_Element(false, this, 0);
        }
        this.must_bound("Accessing an element of an unbound charstring value.");
        if (index_value < 0) {
            throw new TtcnError("Accessing an charstring element using a negative index (" + index_value + ").");
        }
        int n_nibbles = this.val_ptr.length();
        if (index_value > n_nibbles) {
            throw new TtcnError("Index overflow when accessing a charstring element: The index is " + index_value + ", but the string has only " + n_nibbles + " characters.");
        }
        if (index_value == n_nibbles) {
            this.val_ptr.setLength(index_value + 1);
            return new TitanCharString_Element(false, this, index_value);
        }
        return new TitanCharString_Element(true, this, index_value);
    }

    public TitanCharString_Element get_at(TitanInteger index_value) {
        index_value.must_bound("Indexing a charstring value with an unbound integer value.");
        return this.get_at(index_value.get_int());
    }

    public TitanCharString_Element constGet_at(int index_value) {
        this.must_bound("Accessing an element of an unbound charstring value.");
        if (index_value < 0) {
            throw new TtcnError("Accessing an charstring element using a negative index (" + index_value + ").");
        }
        int n_nibbles = this.val_ptr.length();
        if (index_value >= n_nibbles) {
            throw new TtcnError("Index overflow when accessing a charstring element: The index is " + index_value + ", but the string has only " + n_nibbles + " characters.");
        }
        return new TitanCharString_Element(true, this, index_value);
    }

    public TitanCharString_Element constGet_at(TitanInteger index_value) {
        index_value.must_bound("Indexing a charstring value with an unbound integer value.");
        return this.constGet_at(index_value.get_int());
    }

    public String toString() {
        if (this.val_ptr == null) {
            return "<unbound>";
        }
        return this.val_ptr.toString();
    }

    public static boolean operator_equals(String stringValue, TitanCharString otherValue) {
        otherValue.must_bound("Unbound operand of charstring comparison.");
        if (stringValue == null) {
            return otherValue.val_ptr.length() == 0;
        }
        return otherValue.val_ptr.toString().equals(stringValue);
    }

    public static boolean operator_equals(String stringValue, TitanCharString_Element otherValue) {
        otherValue.must_bound("Unbound operand of charstring element comparison.");
        if (stringValue.length() != 1) {
            return false;
        }
        return stringValue.charAt(0) == otherValue.get_char();
    }

    public static boolean operator_not_equals(String stringValue, TitanCharString otherValue) {
        return !TitanCharString.operator_equals(stringValue, otherValue);
    }

    public static boolean operator_not_equals(String stringValue, TitanCharString_Element otherValue) {
        return !TitanCharString.operator_equals(stringValue, otherValue);
    }

    public static TitanCharString operator_concatenate(String stringValue, TitanCharString other_value) {
        other_value.must_bound("Unbound operand of charstring concatenation.");
        TitanCharString ret_val = new TitanCharString(stringValue);
        return ret_val.operator_concatenate(other_value);
    }

    public static TitanCharString operator_concatenate(String stringValue, TitanCharString_Element other_value) {
        other_value.must_bound("Unbound operand of charstring element concatenation.");
        TitanCharString ret_val = new TitanCharString(stringValue);
        return ret_val.operator_concatenate(other_value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encode(Base_Type.TTCN_Typedescriptor p_td, TTCN_Buffer p_buf, TTCN_EncDec.coding_type p_coding, int flavour) {
        switch (p_coding) {
            case CT_RAW: {
                TTCN_EncDec_ErrorContext errorContext = new TTCN_EncDec_ErrorContext("While RAW-encoding type '%s': ", p_td.name);
                try {
                    if (p_td.raw == null) {
                        TTCN_EncDec_ErrorContext.error_internal("No RAW descriptor available for type '%s'.", p_td.name);
                    }
                    RAW.RAW_enc_tr_pos tree_position = new RAW.RAW_enc_tr_pos(0, null);
                    RAW.RAW_enc_tree root = new RAW.RAW_enc_tree(true, null, tree_position, 1, p_td.raw);
                    this.RAW_encode(p_td, root);
                    root.put_to_buf(p_buf);
                    break;
                }
                finally {
                    errorContext.leave_context();
                }
            }
            case CT_JSON: {
                TTCN_EncDec_ErrorContext errorContext = new TTCN_EncDec_ErrorContext("While JSON-encoding type '%s': ", p_td.name);
                try {
                    if (p_td.json == null) {
                        TTCN_EncDec_ErrorContext.error_internal("No JSON descriptor available for type '%s'.", p_td.name);
                    }
                    JSON_Tokenizer tok = new JSON_Tokenizer(flavour != 0);
                    this.JSON_encode(p_td, tok);
                    StringBuilder temp = tok.get_buffer();
                    for (int i = 0; i < temp.length(); ++i) {
                        char temp2 = temp.charAt(i);
                        p_buf.put_c((byte)temp2);
                    }
                    break;
                }
                finally {
                    errorContext.leave_context();
                }
            }
            default: {
                throw new TtcnError(MessageFormat.format("Unknown coding method requested to encode type `{0}''", p_td.name));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void decode(Base_Type.TTCN_Typedescriptor p_td, TTCN_Buffer p_buf, TTCN_EncDec.coding_type p_coding, int flavour) {
        switch (p_coding) {
            case CT_RAW: {
                TTCN_EncDec_ErrorContext errorContext = new TTCN_EncDec_ErrorContext("While RAW-decoding type '%s': ", p_td.name);
                try {
                    TTCN_EncDec.raw_order_t order;
                    if (p_td.raw == null) {
                        TTCN_EncDec_ErrorContext.error_internal("No RAW descriptor available for type '%s'.", p_td.name);
                    }
                    TTCN_EncDec.raw_order_t raw_order_t2 = order = p_td.raw.top_bit_order == RAW.top_bit_order_t.TOP_BIT_LEFT ? TTCN_EncDec.raw_order_t.ORDER_LSB : TTCN_EncDec.raw_order_t.ORDER_MSB;
                    if (this.RAW_decode(p_td, p_buf, p_buf.get_len() * 8, order) >= 0) break;
                    TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_INCOMPL_MSG, "Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
                    break;
                }
                finally {
                    errorContext.leave_context();
                }
            }
            case CT_JSON: {
                TTCN_EncDec_ErrorContext errorContext = new TTCN_EncDec_ErrorContext("While JSON-decoding type '%s': ", p_td.name);
                try {
                    if (p_td.json == null) {
                        TTCN_EncDec_ErrorContext.error_internal("No JSON descriptor available for type '%s'.", p_td.name);
                    }
                    byte[] data = p_buf.get_data();
                    char[] temp = new char[data.length];
                    for (int i = 0; i < data.length; ++i) {
                        temp[i] = (char)data[i];
                    }
                    JSON_Tokenizer tok = new JSON_Tokenizer(new String(temp), p_buf.get_len());
                    if (this.JSON_decode(p_td, tok, false) < 0) {
                        TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_INCOMPL_MSG, "Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
                    }
                    p_buf.set_pos(tok.get_buf_pos());
                    break;
                }
                finally {
                    errorContext.leave_context();
                }
            }
            default: {
                throw new TtcnError(MessageFormat.format("Unknown coding method requested to decode type `{0}''", p_td.name));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int RAW_encode(Base_Type.TTCN_Typedescriptor p_td, RAW.RAW_enc_tree myleaf) {
        int bl = this.val_ptr.length() * 8;
        int align_length = p_td.raw.fieldlength > 0 ? p_td.raw.fieldlength - bl : 0;
        TTCN_EncDec_ErrorContext errorContext = new TTCN_EncDec_ErrorContext();
        try {
            if (!this.is_bound()) {
                TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_UNBOUND, "Encoding an unbound value.", new Object[0]);
            }
            if (bl + align_length < this.val_ptr.length() * 8) {
                TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_LEN_ERR, "There is no sufficient bits to encode '%s':", p_td.name);
                bl = p_td.raw.fieldlength;
                align_length = 0;
            }
            if (p_td.raw.fieldlength >= 0) {
                char[] temp = this.val_ptr.toString().toCharArray();
                myleaf.data_array = new byte[temp.length];
                for (int i = 0; i < temp.length; ++i) {
                    myleaf.data_array[i] = (byte)temp[i];
                }
            } else {
                myleaf.data_array = new byte[this.val_ptr.length() + 1];
                for (int i = 0; i < this.val_ptr.length(); ++i) {
                    myleaf.data_array[i] = (byte)this.val_ptr.charAt(i);
                }
                myleaf.data_array[this.val_ptr.length()] = 48;
                bl += 8;
            }
            myleaf.align = p_td.raw.endianness == TTCN_EncDec.raw_order_t.ORDER_MSB ? -align_length : align_length;
            myleaf.coding_par.csn1lh = p_td.raw.csn1lh;
        }
        finally {
            errorContext.leave_context();
        }
        myleaf.length = bl + align_length;
        return myleaf.length;
    }

    @Override
    public int RAW_decode(Base_Type.TTCN_Typedescriptor p_td, TTCN_Buffer buff, int limit, TTCN_EncDec.raw_order_t top_bit_ord) {
        return this.RAW_decode(p_td, buff, limit, top_bit_ord, false, -1, true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int RAW_decode(Base_Type.TTCN_Typedescriptor p_td, TTCN_Buffer buff, int limit, TTCN_EncDec.raw_order_t top_bit_ord, boolean no_err, int sel_field, boolean first_call, RAW.RAW_Force_Omit force_omit) {
        int prepaddlength = buff.increase_pos_padd(p_td.raw.prepadding);
        int decode_length = p_td.raw.fieldlength <= 0 ? (limit -= prepaddlength) / 8 * 8 : p_td.raw.fieldlength;
        TTCN_EncDec_ErrorContext errorContext = new TTCN_EncDec_ErrorContext();
        try {
            boolean orders;
            if (decode_length > limit || decode_length > buff.unread_len_bit()) {
                if (no_err) {
                    int n = -TTCN_EncDec.error_type.ET_LEN_ERR.ordinal();
                    return n;
                }
                TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_LEN_ERR, "There is not enough bits in the buffer to decode type '%s.'", p_td.name);
                decode_length = (limit > buff.unread_len_bit() ? buff.unread_len_bit() : limit) / 8 * 8;
            }
            RAW.RAW_coding_par cp = new RAW.RAW_coding_par();
            boolean bl = orders = p_td.raw.bitorderinoctet == TTCN_EncDec.raw_order_t.ORDER_MSB;
            if (p_td.raw.bitorderinfield == TTCN_EncDec.raw_order_t.ORDER_MSB) {
                orders = !orders;
            }
            cp.bitorder = orders ? TTCN_EncDec.raw_order_t.ORDER_MSB : TTCN_EncDec.raw_order_t.ORDER_LSB;
            boolean bl2 = orders = p_td.raw.byteorder == TTCN_EncDec.raw_order_t.ORDER_MSB;
            if (p_td.raw.bitorderinfield == TTCN_EncDec.raw_order_t.ORDER_MSB) {
                orders = !orders;
            }
            cp.byteorder = orders ? TTCN_EncDec.raw_order_t.ORDER_MSB : TTCN_EncDec.raw_order_t.ORDER_LSB;
            cp.fieldorder = p_td.raw.fieldorder;
            cp.hexorder = TTCN_EncDec.raw_order_t.ORDER_LSB;
            cp.csn1lh = p_td.raw.csn1lh;
            if (p_td.raw.fieldlength >= 0) {
                this.clean_up();
                this.val_ptr = new StringBuilder(decode_length / 8);
                byte[] val_tmp = new byte[decode_length / 8];
                buff.get_b(decode_length, val_tmp, cp, top_bit_ord);
                for (int i = 0; i < val_tmp.length; ++i) {
                    this.val_ptr.append((char)(val_tmp[i] & 0xFF));
                }
            } else {
                int str_len;
                TTCN_Buffer temp_buff = new TTCN_Buffer();
                byte[] ch = new byte[]{0};
                boolean null_found = false;
                for (str_len = 0; str_len < decode_length; str_len += 8) {
                    buff.get_b(8, ch, cp, top_bit_ord);
                    if (ch[0] == 0) {
                        null_found = true;
                        break;
                    }
                    temp_buff.put_c(ch[0]);
                }
                if (!null_found) {
                    int n = -1;
                    return n;
                }
                temp_buff.get_string(this);
                decode_length = str_len + 8;
            }
            if (p_td.raw.length_restrition != -1 && decode_length > p_td.raw.length_restrition && p_td.raw.endianness == TTCN_EncDec.raw_order_t.ORDER_MSB) {
                this.val_ptr.insert(0, this.val_ptr.toString().toCharArray(), 0, this.val_ptr.length());
            }
        }
        finally {
            errorContext.leave_context();
        }
        return (decode_length += buff.increase_pos_padd(p_td.raw.padding)) + prepaddlength;
    }

    @Override
    public int JSON_encode(Base_Type.TTCN_Typedescriptor p_td, JSON_Tokenizer p_tok, boolean p_parent_is_map) {
        if (!this.is_bound()) {
            TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_UNBOUND, "Encoding an unbound charstring value.", new Object[0]);
            return -1;
        }
        String tmp_str = TitanCharString.to_JSON_string(this.val_ptr, p_td.json.getEscaping());
        int enc_len = p_tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_STRING, tmp_str);
        return enc_len;
    }

    @Override
    public int JSON_decode(Base_Type.TTCN_Typedescriptor p_td, JSON_Tokenizer p_tok, boolean p_silent, boolean p_parent_is_map, int p_chosen_field) {
        if (p_td.json.getActualDefaultValue() != null && 0 == p_tok.get_buffer_length()) {
            this.operator_assign(p_td.json.getActualDefaultValue());
            return 0;
        }
        AtomicReference<JSON_Tokenizer.json_token_t> token = new AtomicReference<JSON_Tokenizer.json_token_t>(JSON_Tokenizer.json_token_t.JSON_TOKEN_NONE);
        StringBuilder value = new StringBuilder();
        AtomicInteger value_len = new AtomicInteger(0);
        int dec_len = p_tok.get_next_token(token, value, value_len);
        if (JSON_Tokenizer.json_token_t.JSON_TOKEN_ERROR == token.get()) {
            if (!p_silent) {
                TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_INVAL_MSG, "Failed to extract valid token, invalid JSON format%s", "");
            }
            return -2;
        }
        if (JSON_Tokenizer.json_token_t.JSON_TOKEN_STRING == token.get()) {
            if (!this.from_JSON_string(value.toString(), true)) {
                if (!p_silent) {
                    TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_INVAL_MSG, "Invalid JSON %s format, expecting %s value", "string", "charstring");
                }
                this.clean_up();
                return -2;
            }
        } else {
            return -1;
        }
        return dec_len;
    }

    static String to_JSON_string(StringBuilder cstr, JSON.json_string_escaping mode) {
        StringBuilder json_str = new StringBuilder();
        json_str.append('\"');
        for (int i = 0; i < cstr.length(); ++i) {
            char c = cstr.charAt(i);
            if (mode != JSON.json_string_escaping.ESCAPE_AS_USI) {
                switch (c) {
                    case '\n': {
                        json_str.append("\\n");
                        break;
                    }
                    case '\t': {
                        json_str.append("\\t");
                        break;
                    }
                    case '\r': {
                        json_str.append("\\r");
                        break;
                    }
                    case '\f': {
                        json_str.append("\\f");
                        break;
                    }
                    case '\b': {
                        json_str.append("\\b");
                        break;
                    }
                    case '\"': {
                        json_str.append("\\\"");
                        break;
                    }
                    case '\\': {
                        if (mode == JSON.json_string_escaping.ESCAPE_AS_SHORT) {
                            json_str.append("\\\\");
                            break;
                        }
                    }
                    case '/': {
                        if (mode == JSON.json_string_escaping.ESCAPE_AS_SHORT) {
                            json_str.append("\\/");
                            break;
                        }
                    }
                    default: {
                        if (c >= '\u0000' && c <= '\u001f' || c == '\u007f') {
                            json_str.append("\\u00");
                            json_str.append(Integer.toHexString(c / 16).toUpperCase());
                            json_str.append(Integer.toHexString(c % 16).toUpperCase());
                            break;
                        }
                        json_str.append(cstr.charAt(i));
                        break;
                    }
                }
                continue;
            }
            if (c <= ' ' || c == '\"' || c == '\\' || c == '\u007f') {
                json_str.append("\\u00");
                json_str.append(Integer.toHexString(c / 16).toUpperCase());
                json_str.append(Integer.toHexString(c % 16).toUpperCase());
                continue;
            }
            json_str.append(cstr.charAt(i));
        }
        json_str.append('\"');
        return json_str.toString();
    }

    static boolean from_JSON_string(String p_value, boolean check_quotes, StringBuilder str) {
        int p_value_len;
        int start = 0;
        int end = p_value_len = p_value.length();
        if (check_quotes) {
            start = 1;
            end = p_value_len - 1;
            if (p_value.charAt(0) != '\"' || p_value.charAt(p_value_len - 1) != '\"') {
                return false;
            }
        }
        boolean error = false;
        for (int i = start; i < end; ++i) {
            char c = p_value.charAt(i);
            if (c < '\u0000' || c >= '\u0080') {
                error = true;
                break;
            }
            if ('\\' == p_value.charAt(i)) {
                if (i == end - 1) {
                    error = true;
                    break;
                }
                switch (p_value.charAt(i + 1)) {
                    case 'n': {
                        str.append('\n');
                        break;
                    }
                    case 't': {
                        str.append('\t');
                        break;
                    }
                    case 'r': {
                        str.append('\r');
                        break;
                    }
                    case 'f': {
                        str.append('\f');
                        break;
                    }
                    case 'b': {
                        str.append('\b');
                        break;
                    }
                    case '\\': {
                        str.append('\\');
                        break;
                    }
                    case '\"': {
                        str.append('\"');
                        break;
                    }
                    case '/': {
                        str.append('/');
                        break;
                    }
                    case 'u': {
                        if (end - i >= 6 && '0' == p_value.charAt(i + 2) && '0' == p_value.charAt(i + 3)) {
                            byte upper_nibble = AdditionalFunctions.char_to_hexdigit(p_value.charAt(i + 4));
                            byte lower_nibble = AdditionalFunctions.char_to_hexdigit(p_value.charAt(i + 5));
                            if (7 >= upper_nibble && 15 >= lower_nibble) {
                                str.append((char)(upper_nibble << 4 | lower_nibble));
                                i += 4;
                                break;
                            }
                            i = end;
                            error = true;
                            break;
                        }
                        i = end;
                        error = true;
                        break;
                    }
                    default: {
                        i = end;
                        error = true;
                    }
                }
                ++i;
            } else {
                str.append(p_value.charAt(i));
            }
            if (!check_quotes || i != p_value_len - 1) continue;
            error = true;
        }
        return !error;
    }

    private boolean from_JSON_string(String p_value, boolean check_quotes) {
        StringBuilder out = new StringBuilder();
        boolean success = TitanCharString.from_JSON_string(p_value, check_quotes, out);
        if (success) {
            this.val_ptr = out;
        }
        return success;
    }

    protected boolean set_param_internal(Param_Types.Module_Parameter param, boolean allow_pattern, AtomicBoolean is_nocase_pattern) {
        boolean is_pattern = false;
        param.basic_check(Param_Types.Module_Parameter.basic_check_bits_t.BC_VALUE.getValue() | Param_Types.Module_Parameter.basic_check_bits_t.BC_LIST.getValue(), "charstring value");
        Param_Types.Module_Parameter mp = param;
        if (param.get_type() == Param_Types.Module_Parameter.type_t.MP_Reference) {
            mp = param.get_referenced_param().get();
        }
        block0 : switch (mp.get_type()) {
            case MP_Universal_Charstring: 
            case MP_Charstring: {
                switch (param.get_operation_type()) {
                    case OT_ASSIGN: {
                        this.clean_up();
                    }
                    case OT_CONCAT: {
                        TitanUniversalCharString ucs = new TitanUniversalCharString();
                        ucs.set_param(mp);
                        if (ucs.charstring) {
                            if (this.is_bound()) {
                                this.operator_assign(this.operator_concatenate(ucs));
                                break block0;
                            }
                            this.operator_assign(ucs);
                            break block0;
                        }
                        for (int i = 0; i < ucs.val_ptr.size(); ++i) {
                            TitanUniversalChar uc = ucs.val_ptr.get(i);
                            if ('\u0000' == uc.getUc_group() && '\u0000' == uc.getUc_plane() && '\u0000' == uc.getUc_row()) continue;
                            param.error("Type mismatch: a charstring value without multi-octet characters was expected.", new Object[0]);
                        }
                        TitanCharString new_cs = new TitanCharString(ucs);
                        if (this.is_bound()) {
                            this.operator_assign(this.operator_concatenate(new_cs));
                            break block0;
                        }
                        this.operator_assign(new_cs);
                        break block0;
                    }
                }
                throw new TtcnError("Internal error: TitanCharString.set_param()");
            }
            case MP_Expression: {
                if (mp.get_expr_type() == Param_Types.Module_Parameter.expression_operand_t.EXPR_CONCATENATE) {
                    TitanCharString operand1 = new TitanCharString();
                    TitanCharString operand2 = new TitanCharString();
                    is_pattern = operand1.set_param_internal(mp.get_operand1(), allow_pattern, is_nocase_pattern);
                    operand2.set_param(mp.get_operand2());
                    if (param.get_operation_type() == Param_Types.Module_Parameter.operation_type_t.OT_CONCAT) {
                        this.operator_assign(this.operator_concatenate(operand1));
                        this.operator_assign(this.operator_concatenate(operand2));
                        break;
                    }
                    this.operator_assign(operand1);
                    this.operator_assign(this.operator_concatenate(operand2));
                    break;
                }
                param.expr_type_error("a charstring");
                break;
            }
            case MP_Pattern: {
                if (allow_pattern) {
                    this.operator_assign(new TitanCharString(mp.get_pattern()));
                    is_pattern = true;
                    if (is_nocase_pattern == null) break;
                    is_nocase_pattern.set(mp.get_nocase());
                    break;
                }
            }
            default: {
                param.type_error("charstring value");
            }
        }
        return is_pattern;
    }

    protected boolean set_param_internal(Param_Types.Module_Parameter param, boolean allow_pattern) {
        return this.set_param_internal(param, allow_pattern, null);
    }

    @Override
    public void set_param(Param_Types.Module_Parameter param) {
        this.set_param_internal(param, false);
    }

    public static TitanCharString convert_to_CharString(TitanCharString otherValue) {
        return otherValue;
    }

    public static TitanCharString convert_to_CharString(TitanCharString_Element otherValue) {
        return new TitanCharString(otherValue);
    }

    @Override
    public Param_Types.Module_Parameter get_param(Param_Types.Module_Param_Name param_name) {
        if (!this.is_bound()) {
            return new Param_Types.Module_Param_Unbound();
        }
        return new Param_Types.Module_Param_Charstring(this);
    }

    public static TitanCharString ttcn_to_string(Base_Type ttcn_data) {
        TTCN_Logger.set_log_format(TTCN_Logger.data_log_format_t.LF_TTCN);
        TTCN_Logger.begin_event_log2str();
        ttcn_data.log();
        TTCN_Logger.set_log_format(TTCN_Logger.data_log_format_t.LF_LEGACY);
        return TTCN_Logger.end_event_log2str();
    }

    public static void string_to_ttcn(TitanCharString ttcn_string, Base_Type ttcn_value) {
        boolean isComponent = ttcn_value instanceof TitanComponent;
        Param_Types.Module_Parameter mp = StringToTTCNAnalyzer.process_config_string2ttcn(ttcn_string.toString(), isComponent);
        ttcn_value.set_param(mp);
    }

    public static void string_to_ttcn(TitanCharString ttcn_string, Base_Template ttcn_value) {
        boolean isComponent = ttcn_value instanceof TitanComponent_template;
        Param_Types.Module_Parameter mp = StringToTTCNAnalyzer.process_config_string2ttcn(ttcn_string.toString(), isComponent);
        ttcn_value.set_param(mp);
    }

    private static enum States {
        INIT,
        PCHAR,
        NPCHAR;

    }

    public static enum CharCoding {
        UNKNOWN,
        ASCII,
        UTF_8,
        UTF16,
        UTF16BE,
        UTF16LE,
        UTF32,
        UTF32BE,
        UTF32LE;

    }
}

