/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.types;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IReferenceChainElement;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.TTCN3.TTCN3Scope;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_FunctionBase;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.definitions.VisibilityModifier;
import org.eclipse.titan.designer.AST.TTCN3.types.Class_Type;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class ClassTypeBody
extends TTCN3Scope
implements IReferenceChainElement,
ILocateableNode,
IIncrementallyUpdateable {
    public static final String MEMBERNOTVISIBLE = "Member `{0}'' in class type `{1}'' is not visible in this scope";
    public static final String LOCALINHERITANCECOLLISION = "Local Definiton `{0}'' collides with definition inherited from class type `{1}''";
    public static final String INHERITEDLOCATION = "Inherited definition of `{0}'' is here";
    public static final String INHERITANCECOLLISION = "Definition `{0}'' inherited from class type `{1}'' collides with definition inherited from `{2}''";
    public static final String INHERITEDDEFINITIONLOCATION = "Definition `{0}'' inherited from class type `{1}'' is here";
    public static final String HIDINGSCOPEELEMENT = "The name of the inherited definition `{0}'' is not unique in the scope hierarchy";
    public static final String HIDDENSCOPEELEMENT = "Previous definition with identifier `{0}'' in higher scope unit is here";
    public static final String HIDINGMODULEIDENTIFIER = "Inherited definition with name `{0}'' hides a module identifier";
    public static final String FORMALPARAMSDIFFER = "Formal parameter list differs from previous definition";
    public static final String OVERRIDDENFORMALPARAM = "Definition is overridden with different formal parameters";
    public static final String PUBLICOVERRIDEPUBLIC = "Public method can only be overriden by a public method";
    public static final String PROTECTEDOVERRIDE = "Protected method can only be overriden by a public or protected method";
    public static final String RETURNTYPEMISMATCH = "Return type differs from the overridden method's return type";
    public static final String OVERRIDDENRETURNTYPE = "Method is overridden with a different return type";
    public static final String VISIBILITYPRIVATEPROTECTED = "Class field visibility must be private or protected";
    public static final String TRAITMETHODSONLY = "Trait classes can only declare methods";
    public static final String TRAITMETHODHASBODY = "Trait method cannot have a function body";
    public static final String TRAITCONSTRUCTOR = "Trait classes cannot have a constructor";
    public static final String TRAITMETHODABSTRACT = "Trait classes can only declare abstract methods";
    public static final String ABSTRACTMETHODHASBODY = "Abstract method cannot have a function body";
    public static final String FIELDNOOVERRIDE = "A field of any visibility cannot be overriden by a subclass";
    public static final String BADSUPERREF = "Reference to `super' in class type `{0}'', which has no base class";
    public static final String DEFNOTVISIBLE = "The {0} definition `{1}'' in class type `{2}'' is not visible in this scope";
    private Class_Type parentClass;

    public ClassTypeBody(Class_Type parentClass) {
        this.parentClass = parentClass;
    }

    @Override
    public Location getLocation() {
        return this.parentClass.getLocation();
    }

    @Override
    public void setLocation(Location location) {
    }

    public Class_Type getParentClass() {
        return this.parentClass;
    }

    public void setMyScope(Scope scope) {
        this.setParentScope(this.parentClass.getMyScope());
    }

    public int getDefinitionsLocation() {
        int maxoffset = this.getLocation().getOffset();
        for (Definition def : this.parentClass.getDefinitions()) {
            if (def.getLocation().getEndOffset() <= maxoffset) continue;
            maxoffset = def.getLocation().getEndOffset();
        }
        return maxoffset + 1;
    }

    @Override
    public Assignment getAssBySRef(CompilationTimeStamp timestamp, Reference reference, IReferenceChain refChain) {
        if (reference.getModuleIdentifier() != null) {
            return this.getParentScope().getAssBySRef(timestamp, reference);
        }
        Identifier identifier = reference.getId();
        Definition definition = this.parentClass.getDefinitionMap().getLocalAssignmentByID(timestamp, identifier);
        if (definition != null) {
            return definition;
        }
        return this.getParentScope().getAssBySRef(timestamp, reference);
    }

    @Override
    public boolean hasAssignmentWithId(CompilationTimeStamp timestamp, Identifier identifier) {
        Definition definition = this.parentClass.getDefinitionMap().getLocalAssignmentByID(timestamp, identifier);
        if (definition != null) {
            return true;
        }
        return super.hasAssignmentWithId(timestamp, identifier);
    }

    public Assignment getAssByIdentifier(CompilationTimeStamp timestamp, Identifier identifier) {
        Definition definition = this.parentClass.getDefinitionMap().getLocalAssignmentByID(timestamp, identifier);
        if (definition != null) {
            return definition;
        }
        return null;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        for (Definition definition : this.parentClass.getDefinitions()) {
            definition.updateSyntax(reparser, false);
            reparser.updateLocation(definition.getLocation());
            if (definition.getLocation().equals(definition.getCumulativeDefinitionLocation())) continue;
            reparser.updateLocation(definition.getCumulativeDefinitionLocation());
        }
    }

    @Override
    public boolean accept(ASTVisitor v) {
        switch (v.visit(this)) {
            case 2: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        if (this.parentClass.getDefinitions() != null) {
            for (Definition def : this.parentClass.getDefinitions()) {
                if (def.accept(v)) continue;
                return false;
            }
        }
        return v.leave(this) != 2;
    }

    @Override
    public Class_Type getScopeClass() {
        return this.parentClass;
    }

    @Override
    public String chainedDescription() {
        return null;
    }

    @Override
    public Location getChainLocation() {
        return null;
    }

    @Override
    public Assignment getEnclosingAssignment(int offset) {
        return null;
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
    }

    @Override
    public Assignment getAssBySRef(CompilationTimeStamp timestamp, Reference reference) {
        if (this.parentClass.isBuiltIn()) {
            return null;
        }
        if (reference == null || this.getParentScope() == null) {
            // empty if block
        }
        this.parentClass.check(timestamp);
        if (reference.getModuleIdentifier() == null) {
            Identifier id = reference.getId();
            if (reference.getReferenceType() == Reference.Ref_Type.REF_SUPER) {
                if (this.parentClass.getBaseType() == null) {
                    reference.getLocation().reportSemanticError(MessageFormat.format(BADSUPERREF, this.parentClass.getIdentifier().getDisplayName()));
                    return null;
                }
                reference.setReferenceType(Reference.Ref_Type.REF_THIS);
                Assignment ass = this.parentClass.getBaseClass().getClassTypeBody().getAssBySRef(timestamp, reference);
                reference.setReferenceType(Reference.Ref_Type.REF_SUPER);
                return ass;
            }
            if (id == null && reference.getReferenceType() == Reference.Ref_Type.REF_THIS) {
                return this.parentClass.getDefiningAssignment();
            }
            if (id != null && this.parentClass.hasLocalAssignemtWithID(timestamp, id)) {
                Assignment ass = this.parentClass.getLocalAssignmentByID(timestamp, id);
                if (ass == null) {
                    // empty if block
                }
                if (this.checkVisibility(timestamp, ass, reference.getLocation(), reference.getMyScope())) {
                    return ass;
                }
                return null;
            }
        }
        return this.getParentScope().getAssBySRef(timestamp, reference);
    }

    private boolean checkVisibility(CompilationTimeStamp timestamp, Assignment ass, Location usageLoc, Scope usageScope) {
        if (ass.getVisibility() == VisibilityModifier.Public) {
            return true;
        }
        Class_Type refScopeClass = usageScope.getScopeClass();
        Class_Type assScopeClass = ass.getMyScope().getScopeClass();
        if (refScopeClass != null && ass.getVisibility() == VisibilityModifier.Protected && refScopeClass.isParentClass(timestamp, assScopeClass)) {
            return true;
        }
        usageLoc.reportSemanticError(MessageFormat.format(DEFNOTVISIBLE, ass instanceof Def_FunctionBase ? "method" : "member", ass.getIdentifier().getDisplayName(), this.parentClass.getIdentifier()));
        return false;
    }

    @Override
    public boolean isClassScope() {
        return true;
    }

    public Assignment getAssFromParents(CompilationTimeStamp timestamp, Reference reference) {
        return null;
    }

    @Override
    public Assignment getScopeBreadcrumbDefinition() {
        return this.parentClass.getDefiningAssignment();
    }
}

