/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.types;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.compiler.ProjectSourceCompiler;

public final class PortGenerator {
    private PortGenerator() {
    }

    public static void generateClass(JavaGenData aData, StringBuilder source, IProject project, PortDefinition portDefinition) {
        int i;
        procedureSignatureInfo info;
        int i2;
        aData.addImport("java.util.Arrays");
        aData.addImport("java.text.MessageFormat");
        aData.addBuiltinTypeImport("TitanComponent");
        aData.addBuiltinTypeImport("TitanFloat");
        aData.addBuiltinTypeImport("TitanOctetString");
        aData.addBuiltinTypeImport("Base_Type");
        aData.addBuiltinTypeImport("Base_Template.template_sel");
        aData.addBuiltinTypeImport("TTCN_Logger");
        aData.addBuiltinTypeImport("TitanLoggerApi");
        aData.addCommonLibraryImport("Text_Buf");
        aData.addBuiltinTypeImport("TtcnError");
        aData.addBuiltinTypeImport("TitanCharString");
        if (portDefinition.testportType != TestportType.ADDRESS) {
            aData.addBuiltinTypeImport("TitanComponent_template");
        }
        boolean hasIncomingReply = false;
        for (int i3 = 0; i3 < portDefinition.outProcedures.size(); ++i3) {
            procedureSignatureInfo info2 = portDefinition.outProcedures.get(i3);
            if (info2.isNoBlock) continue;
            hasIncomingReply = true;
        }
        boolean hasIncomingException = false;
        for (i2 = 0; i2 < portDefinition.outProcedures.size(); ++i2) {
            info = portDefinition.outProcedures.get(i2);
            if (!info.hasExceptions) continue;
            hasIncomingException = true;
        }
        PortGenerator.generateDeclaration(aData, source, project, portDefinition);
        for (i2 = 0; i2 < portDefinition.outMessages.size(); ++i2) {
            MessageMappedTypeInfo outType = portDefinition.outMessages.get(i2);
            PortGenerator.generateSend(aData, source, i2, outType, portDefinition);
        }
        if (!portDefinition.inMessages.isEmpty()) {
            aData.addBuiltinTypeImport("TitanAlt_Status");
            aData.addBuiltinTypeImport("TitanCharString");
            aData.addBuiltinTypeImport("TitanComponent_template");
            aData.addBuiltinTypeImport("Index_Redirect");
            aData.addBuiltinTypeImport("Value_Redirect_Interface");
            PortGenerator.generateGenericReceive(source, portDefinition, false, false);
            PortGenerator.generateGenericReceive(source, portDefinition, true, false);
            PortGenerator.generateGenericTrigger(source, portDefinition, false);
            if (portDefinition.testportType == TestportType.ADDRESS) {
                PortGenerator.generateGenericReceive(source, portDefinition, false, true);
                PortGenerator.generateGenericReceive(source, portDefinition, true, true);
                PortGenerator.generateGenericTrigger(source, portDefinition, true);
            }
            PortGenerator.generateProcessMessage(source, portDefinition);
        }
        for (i2 = 0; i2 < portDefinition.inMessages.size(); ++i2) {
            messageTypeInfo inType = portDefinition.inMessages.get(i2);
            PortGenerator.generateTypedReceive(source, portDefinition, i2, inType, false);
            PortGenerator.generateTypedReceive(source, portDefinition, i2, inType, true);
            PortGenerator.generateTypeTrigger(source, portDefinition, i2, inType);
        }
        for (i2 = 0; i2 < portDefinition.outProcedures.size(); ++i2) {
            info = portDefinition.outProcedures.get(i2);
            PortGenerator.generateCallFunction(source, i2, info, portDefinition);
        }
        for (i2 = 0; i2 < portDefinition.inProcedures.size(); ++i2) {
            info = portDefinition.inProcedures.get(i2);
            PortGenerator.generateReplyFunction(source, i2, info, portDefinition);
        }
        for (i2 = 0; i2 < portDefinition.inProcedures.size(); ++i2) {
            info = portDefinition.inProcedures.get(i2);
            PortGenerator.generateRaiseFunction(source, i2, info, portDefinition);
        }
        if (portDefinition.portType == PortType.USER) {
            aData.addBuiltinTypeImport("TitanPort");
            source.append("\t\tpublic TitanPort get_provider_port() {\n");
            source.append("\t\t\tget_default_destination();\n");
            if (portDefinition.legacy) {
                source.append("\t\t\treturn this;\n");
            } else {
                for (i2 = 0; i2 < portDefinition.providerMessageOutList.size(); ++i2) {
                    source.append(MessageFormat.format("\t\t\tfor (int i = 0; i < n_{0}; i++) '{'\n", i2));
                    source.append(MessageFormat.format("\t\t\t\tif (p_{0}.get(i) != null) '{'\n", i2));
                    source.append(MessageFormat.format("\t\t\t\treturn p_{0}.get(i);\n", i2));
                    source.append("\t\t\t\t}\n");
                    source.append("\t\t\t}\n");
                }
                source.append("\t\t\treturn null;\n");
            }
            source.append("\t\t}\n\n");
        }
        if (portDefinition.portType == PortType.USER && !portDefinition.legacy) {
            String name;
            aData.addBuiltinTypeImport("TitanPort");
            source.append("\t\tpublic void add_port(final TitanPort port) {\n");
            for (i2 = 0; i2 < portDefinition.providerMessageOutList.size(); ++i2) {
                name = portDefinition.providerMessageOutList.get(i2).name;
                source.append(MessageFormat.format("\t\t\tif (port instanceof {0}) '{'\n", name));
                source.append(MessageFormat.format("\t\t\t\tif (p_{0} == null) '{'\n", i2));
                source.append(MessageFormat.format("\t\t\t\t\tp_{0} = new ArrayList<{1}>();\n", i2, name));
                source.append("\t\t\t\t}\n");
                source.append(MessageFormat.format("\t\t\t\tn_{0}++;\n", i2));
                source.append(MessageFormat.format("\t\t\t\tp_{0}.add(({1}) port);\n", i2, name));
                source.append("\t\t\t\treturn;\n");
                source.append("\t\t\t}\n");
            }
            source.append("\t\t\tthrow new TtcnError(\"Internal error: Adding invalid port type.\");\n");
            source.append("\t\t}\n\n");
            source.append("\t\tpublic void remove_port(final TitanPort port) {\n");
            for (i2 = 0; i2 < portDefinition.providerMessageOutList.size(); ++i2) {
                name = portDefinition.providerMessageOutList.get(i2).name;
                source.append(MessageFormat.format("\t\t\tif (port instanceof {0}) '{'\n", name));
                source.append(MessageFormat.format("\t\t\t\tif (p_{0} ==  null) '{'\n", i2));
                source.append("\t\t\t\t\treturn;\n");
                source.append("\t\t\t\t}\n");
                source.append(MessageFormat.format("\t\t\t\tif (p_{0}.remove(port)) '{'\n", i2));
                source.append(MessageFormat.format("\t\t\t\t\tn_{0}--;\n", i2));
                source.append("\t\t\t\t}\n");
                source.append(MessageFormat.format("\t\t\t\tif (n_{0} == 0) '{'\n", i2));
                source.append(MessageFormat.format("\t\t\t\t\tp_{0} = null;\n", i2));
                source.append("\t\t\t\t}\n");
                source.append("\t\t\t\treturn;\n");
                source.append("\t\t\t}\n");
            }
            source.append("\t\t\tthrow new TtcnError(\"Internal error: Removing invalid port type.\");\n");
            source.append("\t\t}\n\n");
            source.append("\t\tpublic boolean in_translation_mode() {\n");
            source.append("\t\t\treturn ");
            for (i2 = 0; i2 < portDefinition.providerMessageOutList.size(); ++i2) {
                if (i2 > 0) {
                    source.append(" || ");
                }
                source.append(MessageFormat.format("n_{0} != 0", i2));
            }
            source.append(";\n");
            source.append("\t\t}\n\n");
            source.append("\t\tpublic void change_port_state(final translation_port_state state) {\n");
            source.append("\t\t\tport_state = state;\n");
            source.append("\t\t}\n\n");
            source.append("\t\tprotected void reset_port_variables() {\n");
            for (i2 = 0; i2 < portDefinition.providerMessageOutList.size(); ++i2) {
                source.append(MessageFormat.format("\t\t\tfor (int i = 0; i < n_{0}; i++) '{'\n", i2));
                source.append(MessageFormat.format("\t\t\t\tp_{0}.get(i).remove_port(this);\n", i2));
                source.append("\t\t\t}\n");
                source.append(MessageFormat.format("\t\t\tp_{0} = null;\n", i2));
                source.append(MessageFormat.format("\t\t\tn_{0} = 0;\n", i2));
            }
            source.append("\t\t}\n\n");
        }
        if (portDefinition.portType == PortType.PROVIDER) {
            aData.addBuiltinTypeImport("TitanPort");
            source.append("\t\tpublic void add_port(final TitanPort port) {\n");
            source.append("\t\t\tmapped_ports.add(port);\n");
            source.append("\t\t}\n\n");
            source.append("\t\tpublic void remove_port(final TitanPort port) {\n");
            source.append("\t\t\tmapped_ports.remove(port);\n");
            source.append("\t\t}\n\n");
            source.append("\t\tprotected void reset_port_variables() {\n");
            source.append("\t\t\tmapped_ports = new ArrayList<TitanPort>();\n");
            source.append("\t\t}\n\n");
        }
        if (!(portDefinition.testportType == TestportType.INTERNAL && portDefinition.legacy || portDefinition.portType != PortType.REGULAR && (portDefinition.portType != PortType.USER || portDefinition.legacy))) {
            StringBuilder body;
            procedureSignatureInfo info3;
            int k;
            MessageMappedTypeInfo outMessage;
            int i4;
            if (portDefinition.testportType == TestportType.INTERNAL && !portDefinition.legacy) {
                source.append("\t\tpublic void set_parameter(final String parameter_name, final String parameter_value) {}\n");
            }
            HashSet<String> used = new HashSet<String>();
            for (i4 = 0; i4 < portDefinition.outMessages.size(); ++i4) {
                outMessage = portDefinition.outMessages.get(i4);
                boolean found = used.contains(outMessage.mJavaTypeName);
                if (found) continue;
                if (portDefinition.testportType != TestportType.INTERNAL || portDefinition.legacy) {
                    StringBuilder comment = new StringBuilder();
                    StringBuilder body2 = new StringBuilder();
                    comment.append("\t\t/**\n");
                    comment.append(MessageFormat.format("\t\t * Sends a(n) {0} message to the system (SUT).\n", outMessage.mDisplayName));
                    comment.append("\t\t * <p>\n");
                    comment.append("\t\t * Will also be called if the port does not have connections or mappings,\n");
                    comment.append("\t\t * but a message is sent on it.\n");
                    comment.append("\t\t *\n");
                    comment.append("\t\t * @param send_par\n");
                    comment.append("\t\t *            the value to be sent.\n");
                    body2.append(MessageFormat.format("\t\tprotected abstract void outgoing_send(final {0} send_par", outMessage.mJavaTypeName));
                    if (portDefinition.testportType == TestportType.ADDRESS) {
                        comment.append("\t\t * @param destination_address\n");
                        comment.append("\t\t *            the address to send the message to.\n");
                        body2.append(MessageFormat.format(", final {0} destination_address", portDefinition.addressName));
                    }
                    if (portDefinition.realtime) {
                        comment.append("\t\t * @param timestamp_redirect\n");
                        comment.append("\t\t *            the redirected timestamp if any.\n");
                        body2.append(", final TitanFloat timestamp_redirect");
                    }
                    comment.append("\t\t * */\n");
                    body2.append(");\n\n");
                    source.append((CharSequence)comment);
                    source.append((CharSequence)body2);
                }
                if (portDefinition.portType == PortType.USER && !portDefinition.legacy) {
                    int j;
                    source.append(MessageFormat.format("\t\tpublic void outgoing_mapped_send(final {0} send_par", outMessage.mJavaTypeName));
                    if (portDefinition.testportType == TestportType.ADDRESS) {
                        source.append(MessageFormat.format(", final {0} destination_address", portDefinition.addressName));
                    }
                    if (portDefinition.realtime) {
                        source.append(", final TitanFloat timestamp_redirect");
                    }
                    source.append(") {\n");
                    for (j = 0; j < portDefinition.providerMessageOutList.size(); ++j) {
                        portMessageProvider tempMessageProvider = portDefinition.providerMessageOutList.get(j);
                        found = false;
                        for (k = 0; k < tempMessageProvider.outMessageTypeNames.size(); ++k) {
                            if (!outMessage.mJavaTypeName.equals(tempMessageProvider.outMessageTypeNames.get(k))) continue;
                            found = true;
                            break;
                        }
                        if (!found) continue;
                        source.append(MessageFormat.format("\t\t\tfor (int i = 0; i < n_{0}; i++) '{'\n", j));
                        source.append(MessageFormat.format("\t\t\t\tif (p_{0}.get(i) != null) '{'\n", j));
                        source.append(MessageFormat.format("\t\t\t\t\tp_{0}.get(i).outgoing_public_send(send_par", j));
                        if (tempMessageProvider.realtime) {
                            if (portDefinition.realtime) {
                                source.append(", timestamp_redirect");
                            } else {
                                source.append(", null");
                            }
                        }
                        source.append(");\n");
                        source.append("\t\t\t\t\treturn;\n");
                        source.append("\t\t\t\t}\n");
                        source.append("\t\t\t}\n");
                    }
                    found = false;
                    for (j = 0; j < portDefinition.outMessages.size(); ++j) {
                        if (!portDefinition.outMessages.get(j).mJavaTypeName.equals(outMessage.mJavaTypeName)) continue;
                        found = true;
                        break;
                    }
                    if (found && (portDefinition.testportType != TestportType.INTERNAL || portDefinition.legacy)) {
                        source.append("\t\t\toutgoing_send(send_par");
                        if (portDefinition.realtime) {
                            source.append(", timestamp_redirect");
                        }
                        source.append(");\n");
                    } else if (portDefinition.testportType == TestportType.INTERNAL && !portDefinition.legacy) {
                        source.append("\t\t\tthrow new TtcnError(\"Cannot send message without successful mapping on a internal port with translation capability.\");\n");
                    } else {
                        source.append(MessageFormat.format("\t\t\tthrow new TtcnError(\"Cannot send message correctly with type {0}.\");\n", outMessage.mJavaTypeName));
                    }
                    source.append("\t\t}\n\n");
                }
                used.add(outMessage.mJavaTypeName);
            }
            if (portDefinition.portType == PortType.USER && !portDefinition.legacy) {
                for (i4 = 0; i4 < portDefinition.outMessages.size(); ++i4) {
                    outMessage = portDefinition.outMessages.get(i4);
                    for (int j = 0; j < outMessage.targets.size(); ++j) {
                        MessageTypeMappingTarget target = (MessageTypeMappingTarget)outMessage.targets.get(j);
                        boolean found = used.contains(target.targetName);
                        if (found) continue;
                        source.append(MessageFormat.format("\t\tpublic void outgoing_mapped_send(final {0} send_par", target.targetName));
                        if (portDefinition.testportType == TestportType.ADDRESS) {
                            source.append(MessageFormat.format(", final {0} destination_address", portDefinition.addressName));
                        }
                        if (portDefinition.realtime) {
                            source.append(", final TitanFloat timestamp_redirect");
                        }
                        source.append(") {\n");
                        for (k = 0; k < portDefinition.providerMessageOutList.size(); ++k) {
                            portMessageProvider tempMessageProvider = portDefinition.providerMessageOutList.get(k);
                            found = false;
                            for (int l = 0; l < tempMessageProvider.outMessageTypeNames.size(); ++l) {
                                if (!target.targetName.equals(tempMessageProvider.outMessageTypeNames.get(l))) continue;
                                found = true;
                                break;
                            }
                            if (!found) continue;
                            source.append(MessageFormat.format("\t\t\tfor (int i = 0; i < n_{0}; i++) '{'\n", k));
                            source.append(MessageFormat.format("\t\t\t\tif (p_{0}.get(i) != null) '{'\n", k));
                            source.append(MessageFormat.format("\t\t\t\t\tp_{0}.get(i).outgoing_public_send(send_par", k));
                            if (tempMessageProvider.realtime) {
                                if (portDefinition.realtime) {
                                    source.append(", timestamp_redirect");
                                } else {
                                    source.append(", null");
                                }
                            }
                            source.append(");\n");
                            source.append("\t\t\t\t\treturn;\n");
                            source.append("\t\t\t\t}\n");
                            source.append("\t\t\t}\n");
                        }
                        found = false;
                        for (k = 0; k < portDefinition.outMessages.size(); ++k) {
                            if (!portDefinition.outMessages.get(k).mJavaTypeName.equals(target.targetName)) continue;
                            found = true;
                            break;
                        }
                        if (found) {
                            source.append("\t\t\toutgoing_send(send_par");
                            if (portDefinition.realtime) {
                                source.append(", timestamp_redirect");
                            }
                            source.append(");\n");
                        } else {
                            source.append(MessageFormat.format("\t\t\tthrow new TtcnError(\"Cannot send message correctly {0}.\");\n", target.targetName));
                        }
                        source.append("\t\t}\n\n");
                        used.add(target.targetName);
                    }
                }
            }
            for (i4 = 0; i4 < portDefinition.outProcedures.size(); ++i4) {
                info3 = portDefinition.outProcedures.get(i4);
                StringBuilder comment = new StringBuilder();
                body = new StringBuilder();
                comment.append("\t\t/**\n");
                comment.append(MessageFormat.format("\t\t * Calls a(n) {0} signature of the system (SUT).\n", info3.mDisplayName));
                comment.append("\t\t *\n");
                comment.append("\t\t * @param call_par\n");
                comment.append("\t\t *            the signature to be called\n");
                body.append(MessageFormat.format("\t\tpublic abstract void outgoing_call(final {0}_call call_par", info3.mJavaTypeName));
                if (portDefinition.testportType == TestportType.ADDRESS) {
                    comment.append("\t\t * @param destination_address\n");
                    comment.append("\t\t *            the address to call the signature on.\n");
                    body.append(MessageFormat.format(", final {0} destination_address", portDefinition.addressName));
                }
                if (portDefinition.realtime) {
                    comment.append("\t\t * @param timestamp_redirect\n");
                    comment.append("\t\t *            the redirected timestamp if any.\n");
                    body.append(", final TitanFloat timestamp_redirect");
                }
                comment.append("\t\t * */\n");
                body.append(");\n\n");
                source.append((CharSequence)comment);
                source.append((CharSequence)body);
            }
            for (i4 = 0; i4 < portDefinition.inProcedures.size(); ++i4) {
                info3 = portDefinition.inProcedures.get(i4);
                if (info3.isNoBlock) continue;
                StringBuilder comment = new StringBuilder();
                body = new StringBuilder();
                comment.append("\t\t/**\n");
                comment.append(MessageFormat.format("\t\t * Replies to a(n) {0} signature of the system (SUT).\n", info3.mDisplayName));
                comment.append("\t\t *\n");
                comment.append("\t\t * @param reply_template\n");
                comment.append("\t\t *            the signature to be replied\n");
                body.append(MessageFormat.format("\t\tpublic abstract void outgoing_reply(final {0}_reply reply_par", info3.mJavaTypeName));
                if (portDefinition.testportType == TestportType.ADDRESS) {
                    comment.append("\t\t * @param destination_address\n");
                    comment.append("\t\t *            the address to reply to.\n");
                    body.append(MessageFormat.format(", final {0} destination_address", portDefinition.addressName));
                }
                if (portDefinition.realtime) {
                    comment.append("\t\t * @param timestamp_redirect\n");
                    comment.append("\t\t *            the redirected timestamp if any.\n");
                    body.append(", final TitanFloat timestamp_redirect");
                }
                comment.append("\t\t * */\n");
                body.append(");\n\n");
                source.append((CharSequence)comment);
                source.append((CharSequence)body);
            }
            for (i4 = 0; i4 < portDefinition.inProcedures.size(); ++i4) {
                info3 = portDefinition.inProcedures.get(i4);
                if (!info3.hasExceptions) continue;
                StringBuilder comment = new StringBuilder();
                body = new StringBuilder();
                comment.append("\t\t/**\n");
                comment.append(MessageFormat.format("\t\t * Raise the exception of {0} signature of the system (SUT).\n", info3.mDisplayName));
                comment.append("\t\t *\n");
                comment.append("\t\t * @param raise_exception\n");
                comment.append("\t\t *            the exception to be raised\n");
                body.append(MessageFormat.format("\t\tpublic abstract void outgoing_raise(final {0}_exception raise_exception", info3.mJavaTypeName));
                if (portDefinition.testportType == TestportType.ADDRESS) {
                    comment.append("\t\t * @param destination_address\n");
                    comment.append("\t\t *            the address to raise the exception to.\n");
                    body.append(MessageFormat.format(", final {0} destination_address", portDefinition.addressName));
                }
                if (portDefinition.realtime) {
                    comment.append("\t\t * @param timestamp_redirect\n");
                    comment.append("\t\t *            the redirected timestamp if any.\n");
                    body.append(", final TitanFloat timestamp_redirect");
                }
                comment.append("\t\t * */\n");
                body.append(");\n\n");
                source.append((CharSequence)comment);
                source.append((CharSequence)body);
            }
        }
        if (portDefinition.portType == PortType.PROVIDER) {
            for (int i5 = 0; i5 < portDefinition.outMessages.size(); ++i5) {
                source.append(MessageFormat.format("\t\tpublic void outgoing_public_send(final {0} send_par", portDefinition.outMessages.get(i5).mJavaTypeName));
                if (portDefinition.realtime) {
                    source.append(", final TitanFloat timestamp_redirect");
                }
                source.append(") {\n");
                source.append("\t\t\toutgoing_send(send_par");
                if (portDefinition.realtime) {
                    source.append(", timestamp_redirect");
                }
                source.append(");\n");
                source.append("\t\t}\n\n");
            }
        }
        if (!portDefinition.inProcedures.isEmpty()) {
            aData.addBuiltinTypeImport("Index_Redirect");
            aData.addBuiltinTypeImport("TitanAlt_Status");
            PortGenerator.generateGenericGetcall(aData, source, portDefinition, false, false);
            PortGenerator.generateGenericGetcall(aData, source, portDefinition, true, false);
            if (portDefinition.testportType == TestportType.ADDRESS) {
                PortGenerator.generateGenericGetcall(aData, source, portDefinition, false, true);
                PortGenerator.generateGenericGetcall(aData, source, portDefinition, true, true);
            }
            for (int i6 = 0; i6 < portDefinition.inProcedures.size(); ++i6) {
                procedureSignatureInfo info4 = portDefinition.inProcedures.get(i6);
                PortGenerator.generateTypedGetcall(aData, source, portDefinition, i6, info4, false, false);
                PortGenerator.generateTypedGetcall(aData, source, portDefinition, i6, info4, true, false);
                if (portDefinition.testportType != TestportType.ADDRESS) continue;
                PortGenerator.generateTypedGetcall(aData, source, portDefinition, i6, info4, false, true);
                PortGenerator.generateTypedGetcall(aData, source, portDefinition, i6, info4, true, true);
            }
        }
        if (hasIncomingReply) {
            aData.addBuiltinTypeImport("TitanAlt_Status");
            aData.addBuiltinTypeImport("Index_Redirect");
            PortGenerator.generateGenericGetreply(aData, source, portDefinition, false, false);
            PortGenerator.generateGenericGetreply(aData, source, portDefinition, true, false);
            if (portDefinition.testportType == TestportType.ADDRESS) {
                PortGenerator.generateGenericGetreply(aData, source, portDefinition, false, true);
                PortGenerator.generateGenericGetreply(aData, source, portDefinition, true, true);
            }
            for (int i7 = 0; i7 < portDefinition.outProcedures.size(); ++i7) {
                procedureSignatureInfo info5 = portDefinition.outProcedures.get(i7);
                if (portDefinition.outProcedures.get(i7).isNoBlock) continue;
                PortGenerator.generateTypedGetreply(aData, source, portDefinition, i7, info5, false, false);
                PortGenerator.generateTypedGetreply(aData, source, portDefinition, i7, info5, true, false);
                if (portDefinition.testportType != TestportType.ADDRESS) continue;
                PortGenerator.generateTypedGetreply(aData, source, portDefinition, i7, info5, false, true);
                PortGenerator.generateTypedGetreply(aData, source, portDefinition, i7, info5, true, true);
            }
        }
        if (hasIncomingException) {
            aData.addBuiltinTypeImport("TitanAlt_Status");
            PortGenerator.generateGenericGetexception(aData, source, portDefinition, false, false);
            PortGenerator.generateGenericGetexception(aData, source, portDefinition, true, false);
            if (portDefinition.testportType == TestportType.ADDRESS) {
                PortGenerator.generateGenericGetexception(aData, source, portDefinition, false, true);
                PortGenerator.generateGenericGetexception(aData, source, portDefinition, true, true);
            }
            for (int i8 = 0; i8 < portDefinition.outProcedures.size(); ++i8) {
                procedureSignatureInfo info6 = portDefinition.outProcedures.get(i8);
                if (!portDefinition.outProcedures.get(i8).hasExceptions) continue;
                PortGenerator.generateTypedGetexception(aData, source, portDefinition, i8, info6, false, false);
                PortGenerator.generateTypedGetexception(aData, source, portDefinition, i8, info6, true, false);
                if (portDefinition.testportType != TestportType.ADDRESS) continue;
                PortGenerator.generateTypedGetexception(aData, source, portDefinition, i8, info6, false, true);
                PortGenerator.generateTypedGetexception(aData, source, portDefinition, i8, info6, true, true);
            }
        }
        if (portDefinition.portType == PortType.USER) {
            for (i = 0; i < portDefinition.providerInMessages.size(); ++i) {
                MessageMappedTypeInfo inType = portDefinition.providerInMessages.get(i);
                PortGenerator.generateTypedIncommingMessageUser(aData, source, i, inType, portDefinition);
            }
            if (!portDefinition.legacy && !portDefinition.providerInMessages.isEmpty()) {
                source.append("@Override\n");
                source.append("public boolean incoming_message_handler(final Base_Type message_ptr, final String message_type, final int sender_component, final TitanFloat timestamp) {\n");
                for (i = 0; i < portDefinition.providerInMessages.size(); ++i) {
                    MessageMappedTypeInfo inType = portDefinition.providerInMessages.get(i);
                    if (i > 0) {
                        source.append(" else ");
                    }
                    source.append(MessageFormat.format("if (\"{0}\".equals(message_type)) '{'\n", inType.mDisplayName));
                    source.append(MessageFormat.format("if (message_ptr instanceof {0}) '{'\n", inType.mJavaTypeName));
                    source.append(MessageFormat.format("incoming_message(({0})message_ptr, sender_component);\n", inType.mJavaTypeName));
                    source.append("return true;\n");
                    source.append("}\n");
                    source.append(MessageFormat.format("throw new TtcnError(\"Internal error: Type of message in incoming message handler function is not the indicated `{0}''.\");\n", inType.mDisplayName));
                    source.append('}');
                }
                source.append('\n');
                source.append("return false;\n");
                source.append("}\n\n");
            }
        } else {
            for (i = 0; i < portDefinition.inMessages.size(); ++i) {
                messageTypeInfo inType = portDefinition.inMessages.get(i);
                PortGenerator.generateTypedIncommingMessageProvider(aData, source, i, inType, portDefinition);
            }
        }
        for (i = 0; i < portDefinition.inProcedures.size(); ++i) {
            procedureSignatureInfo info7 = portDefinition.inProcedures.get(i);
            PortGenerator.generateTypedIcomingCall(source, i, info7, portDefinition);
        }
        for (i = 0; i < portDefinition.outProcedures.size(); ++i) {
            procedureSignatureInfo info8 = portDefinition.outProcedures.get(i);
            if (info8.isNoBlock) continue;
            PortGenerator.generateTypedIcomingReply(source, i, info8, portDefinition);
        }
        for (i = 0; i < portDefinition.outProcedures.size(); ++i) {
            procedureSignatureInfo info9 = portDefinition.outProcedures.get(i);
            if (!info9.hasExceptions) continue;
            PortGenerator.generateTypedIcomingException(source, i, info9, portDefinition);
        }
        if (!portDefinition.inProcedures.isEmpty()) {
            PortGenerator.generateProcessCall(source, portDefinition);
        }
        if (hasIncomingReply) {
            PortGenerator.generateProcessReply(source, portDefinition);
        }
        if (hasIncomingException) {
            PortGenerator.generateProcessException(source, portDefinition);
        }
        source.append("\t}\n\n");
    }

    public static String getClassName(JavaGenData aData, StringBuilder source, PortDefinition portDefinition, Scope myScope) {
        String className;
        if (portDefinition.testportType == TestportType.INTERNAL) {
            StringBuilder returnValue = new StringBuilder();
            Module myModule = myScope.getModuleScopeGen();
            if (!myModule.equals(aData.getModuleScope())) {
                returnValue.append(myModule.getName()).append('.');
                aData.addInterModuleImport(myModule.getName());
            }
            returnValue.append(portDefinition.javaName);
            className = returnValue.toString();
        } else {
            switch (portDefinition.portType) {
                case USER: {
                    if (portDefinition.legacy) {
                        StringBuilder returnValue = new StringBuilder();
                        Module myModule = myScope.getModuleScopeGen();
                        if (!myModule.equals(aData.getModuleScope())) {
                            returnValue.append(myModule.getName()).append('.');
                            aData.addInterModuleImport(myModule.getName());
                        }
                        returnValue.append(portDefinition.javaName);
                        className = returnValue.toString();
                        break;
                    }
                }
                case REGULAR: {
                    className = portDefinition.javaName;
                    IProject generatingProject = myScope.getModuleScopeGen().getProject();
                    aData.addImport(ProjectSourceCompiler.getPackageUserProvidedRoot(generatingProject) + "." + portDefinition.javaName);
                    break;
                }
                case PROVIDER: {
                    StringBuilder returnValue = new StringBuilder();
                    Module myModule = myScope.getModuleScopeGen();
                    if (!myModule.equals(aData.getModuleScope())) {
                        returnValue.append(myModule.getName()).append('.');
                        aData.addInterModuleImport(myModule.getName());
                    }
                    returnValue.append(portDefinition.javaName);
                    className = returnValue.toString();
                    break;
                }
                default: {
                    className = "invalid port type";
                }
            }
        }
        return className;
    }

    private static void generateDeclaration(JavaGenData aData, StringBuilder source, IProject project, PortDefinition portDefinition) {
        int i;
        boolean hasProcedureQueue;
        String name;
        int i2;
        String baseClassName;
        String className;
        String abstractNess = "";
        if (portDefinition.testportType == TestportType.INTERNAL) {
            className = portDefinition.javaName;
            baseClassName = "TitanPort";
            aData.addBuiltinTypeImport("TitanPort");
        } else {
            switch (portDefinition.portType) {
                case USER: {
                    if (portDefinition.legacy) {
                        className = portDefinition.javaName;
                        baseClassName = portDefinition.providerMessageOutList.get(0).name + "_PROVIDER";
                        aData.addImport(ProjectSourceCompiler.getPackageUserProvidedRoot(project) + "." + baseClassName);
                        break;
                    }
                }
                case REGULAR: {
                    className = portDefinition.javaName + "_BASE";
                    baseClassName = "TitanPort";
                    abstractNess = " abstract";
                    aData.addBuiltinTypeImport("TitanPort");
                    break;
                }
                case PROVIDER: {
                    className = portDefinition.javaName;
                    baseClassName = portDefinition.javaName + "_PROVIDER";
                    aData.addImport(ProjectSourceCompiler.getPackageUserProvidedRoot(project) + "." + baseClassName);
                    break;
                }
                default: {
                    className = "invalid port type";
                    baseClassName = "invalid port type";
                }
            }
        }
        source.append(MessageFormat.format("\tpublic static{0} class {1} extends {2} '{'\n", abstractNess, className, baseClassName));
        if (!portDefinition.outMessages.isEmpty()) {
            source.append("\t\tprivate static final byte[][] out_message_names = new byte[][]{");
            for (i2 = 0; i2 < portDefinition.outMessages.size(); ++i2) {
                if (i2 > 0) {
                    source.append("\t\t, ");
                }
                name = portDefinition.outMessages.get((int)i2).mDisplayName;
                source.append(MessageFormat.format("{0}//{1}\n", PortGenerator.nameToByteArray(name), name));
            }
            source.append("\t\t};\n");
        }
        if (!portDefinition.inMessages.isEmpty()) {
            source.append("\t\tenum message_selection { ");
            for (i2 = 0; i2 < portDefinition.inMessages.size(); ++i2) {
                if (i2 > 0) {
                    source.append(", ");
                }
                source.append(MessageFormat.format("MESSAGE_{0}", i2));
            }
            source.append("};\n");
            source.append("\t\tprivate static final byte[][] in_message_names = new byte[][]{");
            for (i2 = 0; i2 < portDefinition.inMessages.size(); ++i2) {
                if (i2 > 0) {
                    source.append("\t\t, ");
                }
                name = portDefinition.inMessages.get(i2).mDisplayName;
                source.append(MessageFormat.format("{0}//{1}\n", PortGenerator.nameToByteArray(name), name));
            }
            source.append("\t\t};\n");
            source.append("\t\tprivate class Message_queue_item {\n");
            source.append("\t\t\tmessage_selection item_selection;\n");
            source.append("\t\t\t// base type could be: ");
            for (i2 = 0; i2 < portDefinition.inMessages.size(); ++i2) {
                messageTypeInfo inType = portDefinition.inMessages.get(i2);
                if (i2 > 0) {
                    source.append(", ");
                }
                source.append(inType.mJavaTypeName);
            }
            source.append('\n');
            source.append("\t\t\tBase_Type message;\n");
            source.append("\t\t\tint sender_component;\n");
            if (portDefinition.testportType == TestportType.ADDRESS) {
                source.append(MessageFormat.format("\t\t\t{0} sender_address;\n", portDefinition.addressName));
            }
            if (portDefinition.realtime) {
                source.append("\t\t\tTitanFloat timestamp;\n");
            }
            source.append("\t\t}\n");
            if (portDefinition.has_sliding) {
                source.append("\t\tTitanOctetString sliding_buffer;\n");
            }
            aData.addImport("java.util.LinkedList");
            source.append("\t\tprivate final LinkedList<Message_queue_item> message_queue = new LinkedList<Message_queue_item>();\n\n");
            source.append("\t\tprivate void remove_msg_queue_head() {\n");
            source.append("\t\t\tmessage_queue.removeFirst();\n");
            source.append("\t\t}\n\n");
        }
        boolean hasIncomingCall = !portDefinition.inProcedures.isEmpty();
        boolean hasIncomingReply = false;
        for (int i3 = 0; i3 < portDefinition.outProcedures.size(); ++i3) {
            if (portDefinition.outProcedures.get(i3).isNoBlock) continue;
            hasIncomingReply = true;
        }
        boolean hasIncomingException = false;
        for (int i4 = 0; i4 < portDefinition.outProcedures.size(); ++i4) {
            if (!portDefinition.outProcedures.get(i4).hasExceptions) continue;
            hasIncomingException = true;
        }
        boolean bl = hasProcedureQueue = hasIncomingCall || hasIncomingReply || hasIncomingException;
        if (hasProcedureQueue) {
            procedureSignatureInfo info;
            String name2;
            int i5;
            source.append("\t\tenum proc_selection { ");
            boolean isFirst = true;
            for (i5 = 0; i5 < portDefinition.inProcedures.size(); ++i5) {
                if (!isFirst) {
                    source.append(", ");
                }
                isFirst = false;
                source.append(MessageFormat.format("CALL_{0}", i5));
            }
            for (i5 = 0; i5 < portDefinition.outProcedures.size(); ++i5) {
                if (portDefinition.outProcedures.get(i5).isNoBlock) continue;
                if (!isFirst) {
                    source.append(", ");
                }
                isFirst = false;
                source.append(MessageFormat.format("REPLY_{0}", i5));
            }
            for (i5 = 0; i5 < portDefinition.outProcedures.size(); ++i5) {
                if (!portDefinition.outProcedures.get(i5).hasExceptions) continue;
                if (!isFirst) {
                    source.append(", ");
                }
                isFirst = false;
                source.append(MessageFormat.format("EXCEPTION_{0}", i5));
            }
            source.append("};\n");
            source.append("\t\tprivate static final byte[][] in_procedure_names = new byte[][]{");
            for (i5 = 0; i5 < portDefinition.inProcedures.size(); ++i5) {
                if (i5 > 0) {
                    source.append("\t\t, ");
                }
                name2 = portDefinition.inProcedures.get(i5).mDisplayName;
                source.append(MessageFormat.format("{0}//{1}\n", PortGenerator.nameToByteArray(name2), name2));
            }
            source.append("\t\t};\n");
            source.append("\t\tprivate static final byte[][] out_procedure_names = new byte[][]{");
            for (i5 = 0; i5 < portDefinition.outProcedures.size(); ++i5) {
                if (i5 > 0) {
                    source.append("\t\t, ");
                }
                name2 = portDefinition.outProcedures.get(i5).mDisplayName;
                source.append(MessageFormat.format("{0}//{1}\n", PortGenerator.nameToByteArray(name2), name2));
            }
            source.append("\t\t};\n");
            source.append("\t\tprivate class Procedure_queue_item {\n");
            source.append("\t\t\tproc_selection item_selection;\n");
            source.append("\t\t\t// TODO check if an object would be enough \n");
            for (i5 = 0; i5 < portDefinition.inProcedures.size(); ++i5) {
                source.append(MessageFormat.format("\t\t\t{0}_call call_{1};\n", portDefinition.inProcedures.get(i5).mJavaTypeName, i5));
            }
            for (i5 = 0; i5 < portDefinition.outProcedures.size(); ++i5) {
                info = portDefinition.outProcedures.get(i5);
                if (info.isNoBlock) continue;
                source.append(MessageFormat.format("\t\t\t{0}_reply reply_{1};\n", info.mJavaTypeName, i5));
            }
            for (i5 = 0; i5 < portDefinition.outProcedures.size(); ++i5) {
                info = portDefinition.outProcedures.get(i5);
                if (!info.hasExceptions) continue;
                source.append(MessageFormat.format("\t\t\t{0}_exception exception_{1};\n", info.mJavaTypeName, i5));
            }
            source.append("\t\t\tint sender_component;\n");
            if (portDefinition.testportType == TestportType.ADDRESS) {
                source.append(MessageFormat.format("\t\t\t{0} sender_address;\n", portDefinition.addressName));
            }
            if (portDefinition.realtime) {
                source.append("\t\t\tTitanFloat timestamp;\n");
            }
            source.append("\t\t}\n");
            if (portDefinition.has_sliding) {
                source.append("\t\tTitanOctetString sliding_buffer;\n");
            }
            aData.addImport("java.util.LinkedList");
            source.append("\t\tprivate final LinkedList<Procedure_queue_item> procedure_queue = new LinkedList<Procedure_queue_item>();\n");
            source.append("\t\tprivate void remove_proc_queue_head() {\n");
            source.append("\t\t\tprocedure_queue.removeFirst();\n");
            source.append("\t\t\tTTCN_Logger.log_port_queue(TitanLoggerApi.Port__Queue_operation.enum_type.extract__op, get_name(), 0 , ++proc_head_count, new TitanCharString(\"\"), new TitanCharString(\"\"));\n");
            source.append("\t\t}\n\n");
        }
        if (!portDefinition.inMessages.isEmpty() || hasProcedureQueue) {
            source.append("\t\tprotected void clear_queue() {\n");
            if (!portDefinition.inMessages.isEmpty()) {
                source.append("\t\t\tmessage_queue.clear();\n");
            }
            if (hasProcedureQueue) {
                source.append("\t\t\tprocedure_queue.clear();\n");
            }
            if (portDefinition.has_sliding) {
                source.append("\t\t\tsliding_buffer = new TitanOctetString(\"\");\n");
            }
            source.append("\t\t}\n\n");
        }
        if (portDefinition.portType == PortType.USER && !portDefinition.legacy) {
            for (i = 0; i < portDefinition.providerMessageOutList.size(); ++i) {
                source.append(MessageFormat.format("\t\tprivate ArrayList<{0}> p_{1};\n", portDefinition.providerMessageOutList.get(i).name, i));
                source.append(MessageFormat.format("\t\tprivate int n_{0};\n", i));
            }
            source.append("\t\tprivate translation_port_state port_state = translation_port_state.UNSET;\n");
            if (portDefinition.varDefs != null) {
                source.append(portDefinition.varDefs);
            }
            if (portDefinition.varInit != null) {
                source.append('\n');
                source.append("\t\t@Override\n");
                source.append("\t\tprotected void init_port_variables() {\n");
                source.append(portDefinition.varInit);
                source.append("\t\t}\n\n");
            }
            source.append("\t\t//translation functions with port clause belonging to this port type\n");
            source.append(portDefinition.translationFunctions);
        }
        if (portDefinition.portType == PortType.PROVIDER) {
            aData.addBuiltinTypeImport("TitanPort");
            source.append("\t\tprivate ArrayList<TitanPort> mapped_ports;\n");
        }
        source.append("\t\t/**\n");
        source.append("\t\t * Constructor of the Test Port.\n");
        source.append("\t\t * <p>\n");
        source.append("\t\t * The name of the port is set to \"<unknown>\". The port is not start or\n");
        source.append("\t\t * active.\n");
        source.append("\t\t *\n");
        source.append("\t\t * @param port_name\n");
        source.append("\t\t *                the name of the port to be used, {@code null} can be\n");
        source.append("\t\t *                used to indicate unnamed ports.\n");
        source.append("\t\t * */\n");
        source.append(MessageFormat.format("\t\tpublic {0}( final String port_name) '{'\n", className));
        source.append("\t\t\tsuper(port_name);\n");
        if (portDefinition.has_sliding) {
            source.append("\t\t\tsliding_buffer = new TitanOctetString(\"\");\n");
        }
        if (portDefinition.portType == PortType.USER && !portDefinition.legacy) {
            for (i = 0; i < portDefinition.providerMessageOutList.size(); ++i) {
                source.append(MessageFormat.format("\t\t\tp_{0} = null;\n", i));
                source.append(MessageFormat.format("\t\t\tn_{0} = 0;\n", i));
            }
            source.append("\t\t\tport_state = translation_port_state.UNSET;\n");
        }
        if (portDefinition.portType == PortType.PROVIDER) {
            source.append("\t\t\tmapped_ports = new ArrayList<TitanPort>();\n");
        }
        source.append("\t\t}\n\n");
        source.append(MessageFormat.format("\t\tpublic {0}( ) '{'\n", className));
        source.append(MessageFormat.format("\t\t\tthis((String)null);\n", className));
        source.append("\t\t}\n\n");
    }

    private static void generateSendMapping(JavaGenData aData, StringBuilder source, PortDefinition portDefinition, MessageMappedTypeInfo mappedType, boolean hasAddress) {
        boolean hasBuffer = false;
        boolean hasDiscard = false;
        boolean reportError = false;
        if (portDefinition.testportType == TestportType.INTERNAL && portDefinition.legacy) {
            source.append("\t\t\tif (destination_component.get_component() == TitanComponent.SYSTEM_COMPREF) {\n");
            source.append("\t\t\t\tthrow new TtcnError(MessageFormat.format(\"Message cannot be sent to system on internal port {0}.\", get_name()));\n");
            source.append("\t\t\t}\n");
        }
        for (int i = 0; i < mappedType.targets.size(); ++i) {
            MessageTypeMappingTarget target = (MessageTypeMappingTarget)mappedType.targets.get(i);
            boolean hasCondition = false;
            if (target.mappingType == MessageMappingType_type.DISCARD) {
                hasDiscard = true;
                break;
            }
            if (target.mappingType == MessageMappingType_type.DECODE && !hasBuffer) {
                aData.addBuiltinTypeImport("TTCN_Buffer");
                source.append("\t\t\tTTCN_Buffer ttcn_buffer = new TTCN_Buffer(send_par);\n");
            }
            if (!portDefinition.legacy && portDefinition.portType == PortType.USER) {
                source.append("\t\t\tif (false");
                for (int j = 0; j < portDefinition.providerMessageOutList.size(); ++j) {
                    portMessageProvider provider = portDefinition.providerMessageOutList.get(j);
                    for (int k = 0; k < provider.outMessageTypeNames.size(); ++k) {
                        if (!target.targetName.equals(provider.outMessageTypeNames.get(k))) continue;
                        source.append(MessageFormat.format(" || n_{0} != 0", j));
                    }
                }
                source.append(") {\n");
                source.append("\t\t\t\tdo {\n");
                source.append("\t\t\t\t\tTTCN_Runtime.set_translation_mode(true, this);\n");
                source.append("\t\t\t\t\tTTCN_Runtime.set_port_state(-1, \"by test environment\", true);\n");
            }
            if (mappedType.targets.size() > 1) {
                source.append("{\n");
            }
            block0 : switch (target.mappingType) {
                case FUNCTION: {
                    source.append(MessageFormat.format("\t\t\t// out mapping with a prototype({0}) function\n", target.functionPrototype.name()));
                    switch (target.functionPrototype) {
                        case CONVERT: {
                            source.append(MessageFormat.format("\t\t\tfinal {0} mapped_par = {1}(send_par);\n", target.targetName, target.functionName));
                            break block0;
                        }
                        case FAST: {
                            source.append(MessageFormat.format("\t\t\tfinal {0} mapped_par = new {0}();\n", target.targetName));
                            source.append(MessageFormat.format("\t\t\t{0}(send_par, mapped_par);\n", target.functionName));
                            if (portDefinition.legacy) break block0;
                            hasCondition = true;
                            break block0;
                        }
                        case SLIDING: {
                            aData.addBuiltinTypeImport("TitanOctetString");
                            source.append(MessageFormat.format("\t\t\tfinal {0} mapped_par = new {0}();\n", target.targetName));
                            source.append("\t\t\tTitanOctetString send_copy = new TitanOctetString(send_par);\n");
                            source.append(MessageFormat.format("\t\t\tif ({0}(send_copy, mapped_par).operator_not_equals(1)) '{'\n", target.functionName));
                            hasCondition = true;
                            break block0;
                        }
                        case BACKTRACK: {
                            source.append(MessageFormat.format("\t\t\tfinal {0} mapped_par = new {0}();\n", target.targetName));
                            source.append(MessageFormat.format("\t\t\tif({0}(send_par, mapped_par).operator_equals(0)) '{'\n", target.functionName));
                            hasCondition = true;
                            break block0;
                        }
                    }
                    break;
                }
                case ENCODE: {
                    aData.addBuiltinTypeImport("TTCN_Buffer");
                    aData.addBuiltinTypeImport("TTCN_EncDec");
                    source.append("\t\t\t// out mapping with a built-in encoder\n");
                    source.append(target.encdecErrorBehaviour);
                    source.append("\t\t\tfinal TTCN_Buffer ttcn_buffer = new TTCN_Buffer();\n");
                    if (target.encdecEncodingOptions == null) {
                        source.append(MessageFormat.format("\t\t\tsend_par.encode({0}_descr_, ttcn_buffer, TTCN_EncDec.coding_type.CT_{1}, 0);\n", target.encdecTypedesriptorName, target.encdecEncodingType));
                    } else {
                        source.append(MessageFormat.format("\t\t\tsend_par.encode({0}_descr_, ttcn_buffer, TTCN_EncDec.coding_type.CT_{1}, {2});\n", target.encdecTypedesriptorName, target.encdecEncodingType, target.encdecEncodingOptions));
                    }
                    source.append(MessageFormat.format("\t\t\t{0} mapped_par = new {0}();\n", target.targetName));
                    source.append("\t\t\tttcn_buffer.get_string(mapped_par);\n");
                    break;
                }
                case DECODE: {
                    aData.addBuiltinTypeImport("TTCN_Buffer");
                    aData.addBuiltinTypeImport("TTCN_EncDec");
                    source.append("\t\t\t// out mapping with a built-in decoder\n");
                    if (hasBuffer) {
                        source.append("\t\t\tttcn_buffer.rewind();\n");
                    } else {
                        hasBuffer = true;
                    }
                    source.append(target.encdecErrorBehaviour);
                    source.append("\t\t\tTTCN_EncDec.clear_error();\n");
                    source.append(MessageFormat.format("\t\t\tfinal {0} mapped_par = new {0}();\n", target.targetName));
                    if (target.encdecEncodingOptions == null) {
                        source.append(MessageFormat.format("\t\t\tmapped_par.decode({0}_descr_, ttcn_buffer, TTCN_EncDec.coding_type.CT_{1}, 0);\n", target.encdecTypedesriptorName, target.encdecEncodingType));
                    } else {
                        source.append(MessageFormat.format("\t\t\tmapped_par.decode({0}_descr_, ttcn_buffer, TTCN_EncDec.coding_type.CT_{1}, {2});\n", target.encdecTypedesriptorName, target.encdecEncodingType, target.encdecEncodingOptions));
                    }
                    source.append("\t\t\tif (TTCN_EncDec.get_last_error_type() == TTCN_EncDec.error_type.ET_NONE) {\n");
                    hasCondition = true;
                    break;
                }
            }
            if (!portDefinition.legacy && portDefinition.portType == PortType.USER) {
                source.append("\t\t\tTTCN_Runtime.set_translation_mode(false, null);\n");
                source.append("\t\t\tif (port_state == translation_port_state.TRANSLATED || port_state == translation_port_state.PARTIALLY_TRANSLATED) {\n");
            }
            source.append("\t\t\tif (TTCN_Logger.log_this_event(TTCN_Logger.Severity.PORTEVENT_DUALSEND)) {\n");
            source.append("\t\t\t\tTTCN_Logger.begin_event(TTCN_Logger.Severity.PORTEVENT_DUALSEND);\n");
            source.append("\t\t\t\tmapped_par.log();\n");
            source.append(MessageFormat.format("\t\t\t\tTTCN_Logger.log_dualport_map(false, \"{0}\", TTCN_Logger.end_event_log2str(), 0);\n", target.targetDisplayName));
            source.append("\t\t\t}\n");
            if (hasAddress) {
                source.append("\t\t\toutgoing_send(mapped_par, destination_address);\n");
            } else {
                if (portDefinition.testportType != TestportType.INTERNAL || !portDefinition.legacy) {
                    source.append("\t\t\tif (destination_component.get_component() == TitanComponent.SYSTEM_COMPREF) {\n");
                    source.append(MessageFormat.format("\t\t\t\toutgoing_{0}send(mapped_par", portDefinition.portType == PortType.USER && !portDefinition.legacy ? "mapped_" : ""));
                    if (portDefinition.testportType == TestportType.ADDRESS) {
                        source.append(", null");
                    }
                    source.append(");\n");
                    source.append("\t\t\t} else {\n");
                }
                source.append("\t\t\t\tfinal Text_Buf text_buf = new Text_Buf();\n");
                source.append(MessageFormat.format("\t\t\t\tprepare_message(text_buf, \"{0}\".getBytes());\n", target.targetDisplayName));
                source.append("\t\t\t\tsend_par.encode_text(text_buf);\n");
                source.append("\t\t\t\tsend_data(text_buf, destination_component);\n");
                if (portDefinition.testportType != TestportType.INTERNAL || !portDefinition.legacy) {
                    source.append("\t\t\t}\n");
                }
            }
            if (hasCondition) {
                if (!portDefinition.legacy && portDefinition.portType == PortType.USER) {
                    source.append("\t\t\tif (port_state != translation_port_state.PARTIALLY_TRANSLATED) {\n");
                    source.append("\t\t\t\treturn;\n");
                    source.append("\t\t\t}\n");
                } else {
                    source.append("\t\t\treturn;\n");
                }
                if (portDefinition.legacy) {
                    source.append("\t\t\t}\n");
                }
                reportError = true;
            }
            if (!portDefinition.legacy && portDefinition.portType == PortType.USER) {
                source.append("\t\t\t} else if (port_state == translation_port_state.FRAGMENTED || port_state == translation_port_state.DISCARDED) {\n");
                source.append("\t\t\t\treturn;\n");
                source.append("\t\t\t} else if (port_state == translation_port_state.UNSET) {\n");
                source.append(MessageFormat.format("\t\t\t\tthrow new TtcnError(MessageFormat.format(\"The state of the port '{'0'}' remained unset after the mapping function {0} finished.\", get_name()));\n", target.functionDisplayName));
                source.append("\t\t\t}\n");
            }
            if (mappedType.targets.size() > 1) {
                source.append("\t\t\t}\n");
            }
            if (portDefinition.legacy || portDefinition.portType != PortType.USER) continue;
            source.append("\t\t\t\t} while (port_state == translation_port_state.PARTIALLY_TRANSLATED);\n");
            source.append("\t\t\t}\n");
        }
        if (hasDiscard) {
            if (mappedType.targets.size() > 1) {
                source.append(MessageFormat.format("\t\t\tTTCN_Logger.log_dualport_discard(false, \"{0}\", get_name(), true);\n", mappedType.mDisplayName));
            } else {
                source.append(MessageFormat.format("\t\t\tTTCN_Logger.log_dualport_discard(false, \"{0}\", get_name(), false);\n", mappedType.mDisplayName));
            }
        } else if (reportError) {
            source.append(MessageFormat.format("\t\t\tthrow new TtcnError(MessageFormat.format(\"Outgoing message of type {0} could not be handled by the type mapping rules on port '{'0'}'.\", get_name()));\n", mappedType.mDisplayName));
        }
    }

    private static void generateSend(JavaGenData aData, StringBuilder source, int index, MessageMappedTypeInfo outType, PortDefinition portDefinition) {
        source.append("\t\t/**\n");
        source.append(MessageFormat.format("\t\t * Sends a(n) {0} message to the provided component.\n", outType.mDisplayName));
        source.append("\t\t * <p>\n");
        source.append("\t\t * When timestamp redirection is support the timestamp will be made\n");
        source.append("\t\t * available in the timestamp_Redirect parameter.\n");
        source.append("\t\t *\n");
        source.append("\t\t * @param send_par\n");
        source.append("\t\t *            the value to be sent.\n");
        source.append("\t\t * @param destination_component\n");
        source.append("\t\t *            the target component to send the message to.\n");
        source.append("\t\t * @param timestamp_redirect\n");
        source.append("\t\t *            the redirected timestamp if any.\n");
        source.append("\t\t * */\n");
        source.append(MessageFormat.format("\t\tpublic void send(final {0} send_par, final TitanComponent destination_component, final TitanFloat timestamp_redirect) '{'\n", outType.mJavaTypeName));
        source.append("\t\t\tif (!is_started) {\n");
        source.append("\t\t\t\tthrow new TtcnError(MessageFormat.format(\"Sending a message on port {0}, which is not started.\", get_name()));\n");
        source.append("\t\t\t}\n");
        source.append("\t\t\tif (!destination_component.is_bound()) {\n");
        source.append("\t\t\t\tthrow new TtcnError(\"Unbound component reference in the to clause of send operation.\");\n");
        source.append("\t\t\t}\n");
        source.append("\t\t\tfinal TTCN_Logger.Severity log_severity = destination_component.get_component() == TitanComponent.SYSTEM_COMPREF ? TTCN_Logger.Severity.PORTEVENT_MMSEND : TTCN_Logger.Severity.PORTEVENT_MCSEND;\n");
        source.append("\t\t\tif (TTCN_Logger.log_this_event(log_severity)) {\n");
        source.append("\t\t\t\tTTCN_Logger.begin_event(log_severity);\n");
        source.append(MessageFormat.format("\t\t\t\tTTCN_Logger.log_event_str(\" {0} : \");\n", outType.mDisplayName));
        source.append("\t\t\t\tsend_par.log();\n");
        source.append("\t\t\t\tTTCN_Logger.log_msgport_send(get_name(), destination_component.get_component(), TTCN_Logger.end_event_log2str());\n");
        source.append("\t\t\t}\n");
        if (portDefinition.portType != PortType.USER || outType.targets.size() == 1 && ((MessageTypeMappingTarget)outType.targets.get(0)).mappingType == MessageMappingType_type.SIMPLE || portDefinition.portType == PortType.USER && !portDefinition.legacy) {
            if (portDefinition.portType == PortType.USER && !portDefinition.legacy && (outType.targets.size() > 1 || !outType.targets.isEmpty() && ((MessageTypeMappingTarget)outType.targets.get(0)).mappingType != MessageMappingType_type.SIMPLE)) {
                source.append("if (!in_translation_mode()) {\n");
            }
            source.append("\t\t\tif (destination_component.get_component() == TitanComponent.SYSTEM_COMPREF) {\n");
            if (portDefinition.testportType == TestportType.INTERNAL) {
                source.append("\t\t\t\tthrow new TtcnError(MessageFormat.format(\"Message cannot be sent to system on internal port {0}.\", get_name()));\n");
            } else {
                source.append("\t\t\t\tget_default_destination();\n");
                source.append(MessageFormat.format("\t\t\t\toutgoing_{0}send(send_par", portDefinition.portType == PortType.USER && !portDefinition.legacy ? "mapped_" : ""));
                if (portDefinition.testportType == TestportType.ADDRESS) {
                    source.append(", null");
                }
                if (portDefinition.realtime) {
                    source.append(", timestamp_redirect");
                }
                source.append(");\n");
            }
            source.append("\t\t\t} else {\n");
            source.append("\t\t\t\tfinal Text_Buf text_buf = new Text_Buf();\n");
            source.append(MessageFormat.format("\t\t\t\t//\"{0}\"\n", outType.mDisplayName));
            source.append(MessageFormat.format("\t\t\t\tprepare_message(text_buf, out_message_names[{0}]);\n", index));
            source.append("\t\t\t\tsend_par.encode_text(text_buf);\n");
            source.append("\t\t\t\tsend_data(text_buf, destination_component);\n");
            source.append("\t\t\t}\n");
            if (portDefinition.portType == PortType.USER && !portDefinition.legacy && (outType.targets.size() > 1 || !outType.targets.isEmpty() && ((MessageTypeMappingTarget)outType.targets.get(0)).mappingType != MessageMappingType_type.SIMPLE)) {
                source.append("} else {\n");
                PortGenerator.generateSendMapping(aData, source, portDefinition, outType, false);
                source.append("}\n");
            }
        } else {
            PortGenerator.generateSendMapping(aData, source, portDefinition, outType, false);
        }
        source.append("\t\t}\n\n");
        if (portDefinition.testportType == TestportType.ADDRESS) {
            source.append(MessageFormat.format("\t\tpublic void send(final {0} send_par, final {1} destination_address, final TitanFloat timestamp_redirect) '{'\n", outType.mJavaTypeName, portDefinition.addressName));
            source.append("\t\t\tif (!is_started) {\n");
            source.append("\t\t\t\tthrow new TtcnError(MessageFormat.format(\"Sending a message on port {0}, which is not started.\", get_name()));\n");
            source.append("\t\t\t}\n");
            source.append("\t\t\tif (TTCN_Logger.log_this_event(TTCN_Logger.Severity.PORTEVENT_DUALSEND)) {\n");
            source.append("\t\t\t\tTTCN_Logger.begin_event(TTCN_Logger.Severity.PORTEVENT_DUALSEND);\n");
            source.append("\t\t\t\tsend_par.log();\n");
            source.append(MessageFormat.format("\t\t\t\tTTCN_Logger.log_dualport_map(false, \"{0}\", TTCN_Logger.end_event_log2str(), 0);\n ", outType.mDisplayName));
            source.append("\t\t\t}\n\n");
            source.append("\t\t\tget_default_destination();\n");
            if (portDefinition.portType != PortType.USER || outType.targets.size() == 1 && ((MessageTypeMappingTarget)outType.targets.get(0)).mappingType == MessageMappingType_type.SIMPLE) {
                source.append("\t\t\toutgoing_send(send_par, destination_address");
                if (portDefinition.realtime) {
                    source.append(", timestamp_redirect");
                }
                source.append(");\n");
            } else {
                PortGenerator.generateSendMapping(aData, source, portDefinition, outType, true);
            }
            source.append("\t\t}\n\n");
        }
        source.append("\t\t/**\n");
        source.append(MessageFormat.format("\t\t * Sends a(n) {0} message to the default component.\n", outType.mDisplayName));
        source.append("\t\t * <p>\n");
        source.append("\t\t * When timestamp redirection is support the timestamp will be made\n");
        source.append("\t\t * available in the timestamp_Redirect parameter.\n");
        source.append("\t\t *\n");
        source.append("\t\t * @param send_par\n");
        source.append("\t\t *            the value to be sent.\n");
        source.append("\t\t * @param timestamp_redirect\n");
        source.append("\t\t *            the redirected timestamp if any.\n");
        source.append("\t\t * */\n");
        source.append(MessageFormat.format("\t\tpublic void send(final {0} send_par, final TitanFloat timestamp_redirect) '{'\n", outType.mJavaTypeName));
        source.append("\t\t\tsend(send_par, new TitanComponent(get_default_destination()), timestamp_redirect);\n");
        source.append("\t\t}\n\n");
        source.append("\t\t/**\n");
        source.append(MessageFormat.format("\t\t * Sends a(n) {0} template message to the provided component.\n", outType.mDisplayName));
        source.append("\t\t * <p>\n");
        source.append("\t\t * When timestamp redirection is support the timestamp will be made\n");
        source.append("\t\t * available in the timestamp_Redirect parameter.\n");
        source.append("\t\t *\n");
        source.append("\t\t * @param send_par\n");
        source.append("\t\t *            the template to be sent.\n");
        source.append("\t\t * @param destination_component\n");
        source.append("\t\t *            the target component to send the message to.\n");
        source.append("\t\t * @param timestamp_redirect\n");
        source.append("\t\t *            the redirected timestamp if any.\n");
        source.append("\t\t * */\n");
        source.append(MessageFormat.format("\t\tpublic void send(final {0} send_par, final TitanComponent destination_component, final TitanFloat timestamp_redirect) '{'\n", outType.mJavaTemplateName));
        source.append(MessageFormat.format("\t\t\tfinal {0} send_par_value = send_par.valueof();\n", outType.mJavaTypeName));
        source.append("\t\t\tsend(send_par_value, destination_component, timestamp_redirect);\n");
        source.append("\t\t}\n\n");
        if (portDefinition.testportType == TestportType.ADDRESS) {
            source.append(MessageFormat.format("\t\tpublic void send(final {0} send_par, final {1} destination_address, final TitanFloat timestamp_redirect) '{'\n", outType.mJavaTemplateName, portDefinition.addressName));
            source.append(MessageFormat.format("\t\t\tfinal {0} send_par_value = send_par.valueof();\n", outType.mJavaTypeName));
            source.append("\t\t\tsend(send_par_value, destination_address, timestamp_redirect);\n");
            source.append("\t\t}\n\n");
        }
        source.append("\t\t/**\n");
        source.append(MessageFormat.format("\t\t * Sends a(n) {0} template message to the default component.\n", outType.mDisplayName));
        source.append("\t\t * <p>\n");
        source.append("\t\t * When timestamp redirection is support the timestamp will be made\n");
        source.append("\t\t * available in the timestamp_Redirect parameter.\n");
        source.append("\t\t *\n");
        source.append("\t\t * @param send_par\n");
        source.append("\t\t *            the template to be sent.\n");
        source.append("\t\t * @param timestamp_redirect\n");
        source.append("\t\t *            the redirected timestamp if any.\n");
        source.append("\t\t * */\n");
        source.append(MessageFormat.format("\t\tpublic void send(final {0} send_par, final TitanFloat timestamp_redirect) '{'\n", outType.mJavaTemplateName));
        source.append(MessageFormat.format("\t\t\tfinal {0} send_par_value = send_par.valueof();\n", outType.mJavaTypeName));
        source.append("\t\t\tsend(send_par_value, new TitanComponent(get_default_destination()), timestamp_redirect);\n");
        source.append("\t\t}\n\n");
    }

    private static void generateGenericReceive(StringBuilder source, PortDefinition portDefinition, boolean isCheck, boolean isAddress) {
        String functionName = isCheck ? "check_receive" : "receive";
        String senderType = isAddress ? portDefinition.addressName : "TitanComponent";
        String logger_operation = isCheck ? "check__receive__op" : "receive__op";
        source.append(MessageFormat.format("\t\tpublic TitanAlt_Status {0}(final {1}_template sender_template, final {1} sender_pointer, final TitanFloat timestamp_redirect, final Index_Redirect index_redirect) '{'\n", functionName, senderType));
        source.append("\t\t\tfinal Message_queue_item my_head = message_queue.peekFirst();\n");
        source.append("\t\t\tif (my_head == null) {\n");
        source.append("\t\t\t\tif (is_started) {\n");
        source.append("\t\t\t\t\treturn TitanAlt_Status.ALT_MAYBE;\n");
        source.append("\t\t\t\t} else {\n");
        source.append("\t\t\t\t\tTTCN_Logger.log_str(TTCN_Logger.Severity.MATCHING_PROBLEM, MessageFormat.format(\"Matching on port {0} failed: Port is not started and the queue is empty.\", get_name()));\n");
        source.append("\t\t\t\t\treturn TitanAlt_Status.ALT_NO;\n");
        source.append("\t\t\t\t}\n");
        source.append("\t\t\t}\n");
        if (isAddress) {
            source.append("\t\t\tif (my_head.sender_component != TitanComponent.SYSTEM_COMPREF) {\n");
            source.append("\t\t\t\tTTCN_Logger.log_str(TTCN_Logger.Severity.MATCHING_MMUNSUCC, MessageFormat.format(\"Matching on port {0} failed: Sender of the first message in the queue is not the system.\" ,get_name()));\n");
            source.append("\t\t\t\treturn TitanAlt_Status.ALT_NO;\n");
            source.append("\t\t\t} else if (my_head.sender_address == null) {\n");
            source.append(MessageFormat.format("\t\t\t\tthrow new TtcnError(MessageFormat.format(\"{0} operation on port '{'0'}' requires the address of the sender, which was not given by the test port.\", get_name()));\n", functionName));
            source.append("\t\t\t} else if (!sender_template.match(my_head.sender_address, false)) {\n");
            source.append("\t\t\t\tif(TTCN_Logger.log_this_event(TTCN_Logger.Severity.MATCHING_MMUNSUCC)) {\n");
            source.append("\t\t\t\t\tTTCN_Logger.begin_event(TTCN_Logger.Severity.MATCHING_MMUNSUCC);\n");
            source.append("\t\t\t\t\tTTCN_Logger.log_event(\"Matching on port {0}: Sender address of the first message in the queue does not match the from clause: \", get_name());\n");
            source.append("\t\t\t\t\tsender_template.log_match(my_head.sender_address, false);\n");
            source.append("\t\t\t\t\tTTCN_Logger.end_event();\n");
            source.append("\t\t\t\t\tTTCN_Logger.begin_event_log2str();\n");
            source.append("\t\t\t\t\tsender_template.log_match(my_head.sender_address, false);\n");
            source.append("\t\t\t\t\tTTCN_Logger.log_matching_failure(TitanLoggerApi.PortType.enum_type.message__, port_name, my_head.sender_component, TitanLoggerApi.MatchingFailureType_reason.enum_type.message__does__not__match__template, TTCN_Logger.end_event_log2str());\n");
            source.append("\t\t\t\t}\n");
            source.append("\t\t\t\treturn TitanAlt_Status.ALT_NO;\n");
            source.append("\t\t\t}");
        } else {
            source.append("\t\t\tif (!sender_template.match(my_head.sender_component, false)) {\n");
            source.append("\t\t\t\tfinal TTCN_Logger.Severity log_sev = my_head.sender_component == TitanComponent.SYSTEM_COMPREF ? TTCN_Logger.Severity.MATCHING_MMUNSUCC:TTCN_Logger.Severity.MATCHING_MCUNSUCC;\n");
            source.append("\t\t\t\tif (TTCN_Logger.log_this_event(log_sev)) {\n");
            source.append("\t\t\t\t\tTTCN_Logger.begin_event(log_sev);\n");
            source.append("\t\t\t\t\tTTCN_Logger.log_event(\"Matching on port {0}: Sender of the first message in the queue does not match the from clause:\", get_name());\n");
            source.append("\t\t\t\t\tsender_template.log_match(new TitanComponent(my_head.sender_component), false);\n");
            source.append("\t\t\t\t\tTTCN_Logger.end_event();\n");
            source.append("\t\t\t\t}\n");
            source.append("\t\t\t\treturn TitanAlt_Status.ALT_NO;\n");
            source.append("\t\t\t}");
        }
        source.append(" else {\n");
        if (portDefinition.realtime) {
            source.append("\t\t\t\tif (timestamp_redirect != null && my_head.timestamp.is_bound()) {\n");
            source.append("\t\t\t\t\ttimestamp_redirect.operator_assign(my_head.timestamp);\n");
            source.append("\t\t\t\t}\n");
        }
        source.append("\t\t\t\tif (sender_pointer != null) {\n");
        if (isAddress) {
            source.append("\t\t\t\t\tsender_pointer.operator_assign(my_head.sender_address);\n");
        } else {
            source.append("\t\t\t\t\tsender_pointer.operator_assign(my_head.sender_component);\n");
        }
        source.append("\t\t\t\t}\n");
        if (isAddress) {
            source.append("\t\t\t\tTTCN_Logger.log(TTCN_Logger.Severity.MATCHING_MMSUCCESS,  MessageFormat.format(\"Matching on port {0} succeeded.\", get_name()));\n");
            source.append("\t\t\t\tif (TTCN_Logger.log_this_event(TTCN_Logger.Severity.PORTEVENT_MMRECV)) {\n");
            source.append("\t\t\t\tTTCN_Logger.begin_event_log2str();\n");
            source.append("\t\t\t\tmy_head.sender_address.log();\n");
            source.append(MessageFormat.format("\t\t\t\tTTCN_Logger.log_msgport_recv(get_name(), TitanLoggerApi.Msg__port__recv_operation.enum_type.{0} , TitanComponent.SYSTEM_COMPREF, new TitanCharString(\"\") ,", logger_operation));
            source.append("\t\t\t\tTTCN_Logger.end_event_log2str(), msg_head_count+1);\n");
            source.append("\t\t\t}\n");
        } else {
            source.append("\t\t\t\tTTCN_Logger.log(my_head.sender_component == TitanComponent.SYSTEM_COMPREF ? TTCN_Logger.Severity.MATCHING_MMSUCCESS : TTCN_Logger.Severity.MATCHING_MCSUCCESS, ");
            source.append("MessageFormat.format(\"Matching on port {0} succeeded.\", get_name()));\n");
            source.append("\t\t\t\tfinal TTCN_Logger.Severity log_sev = my_head.sender_component==TitanComponent.SYSTEM_COMPREF ? TTCN_Logger.Severity.PORTEVENT_MMRECV : TTCN_Logger.Severity.PORTEVENT_MCRECV;\n");
            source.append("\t\t\t\tif (TTCN_Logger.log_this_event(log_sev)) {\n");
            source.append("\t\t\t\t\tswitch (my_head.item_selection) {\n");
            for (int msg_idx = 0; msg_idx < portDefinition.inMessages.size(); ++msg_idx) {
                messageTypeInfo message_type = portDefinition.inMessages.get(msg_idx);
                source.append(MessageFormat.format("\t\t\t\t\tcase MESSAGE_{0}:\n", msg_idx));
                source.append("\t\t\t\t\t\tTTCN_Logger.begin_event(log_sev);\n");
                source.append(MessageFormat.format("\t\t\t\t\t\tTTCN_Logger.log_event_str(\": {0}: \");\n", message_type.mDisplayName));
                source.append("\t\t\t\t\t\tmy_head.message.log();\n");
                source.append(MessageFormat.format("\t\t\t\t\t\tTTCN_Logger.log_msgport_recv(get_name(), TitanLoggerApi.Msg__port__recv_operation.enum_type.{0}, ", logger_operation));
                source.append("my_head.sender_component, new TitanCharString(\"\"),");
                source.append(MessageFormat.format("TTCN_Logger.end_event_log2str(), msg_head_count+1);\n", msg_idx));
                source.append("\t\t\t\t\tbreak;\n");
            }
            source.append("\t\t\t\t\tdefault:\n");
            source.append("\t\t\t\t\t\tthrow new TtcnError(\"Internal error: unknown message\");\n");
            source.append("\t\t\t\t\t}\n");
            source.append("\t\t\t\t}\n");
        }
        if (!isCheck) {
            source.append("\t\t\t\tremove_msg_queue_head();\n");
        }
        source.append("\t\t\t\treturn TitanAlt_Status.ALT_YES;\n");
        source.append("\t\t\t}\n");
        source.append("\t\t}\n\n");
    }

    private static void generateGenericTrigger(StringBuilder source, PortDefinition portDefinition, boolean isAddress) {
        String senderType = isAddress ? portDefinition.addressName : "TitanComponent";
        source.append(MessageFormat.format("\t\tpublic TitanAlt_Status trigger(final {0}_template sender_template, final {0} sender_pointer, final TitanFloat timestamp_redirect, final Index_Redirect index_redirect) '{'\n", senderType));
        source.append("\t\t\tfinal Message_queue_item my_head = message_queue.peekFirst();\n");
        source.append("\t\t\tif (my_head == null) {\n");
        source.append("\t\t\t\tif (is_started) {\n");
        source.append("\t\t\t\t\treturn TitanAlt_Status.ALT_MAYBE;\n");
        source.append("\t\t\t\t} else {\n");
        source.append("\t\t\t\t\tTTCN_Logger.log_str(TTCN_Logger.Severity.MATCHING_PROBLEM, MessageFormat.format(\"Matching on port {0} failed: Port is not started and the queue is empty.\", get_name()));\n");
        source.append("\t\t\t\t\treturn TitanAlt_Status.ALT_NO;\n");
        source.append("\t\t\t\t}\n");
        source.append("\t\t\t}\n");
        if (isAddress) {
            source.append("\t\t\tif (my_head.sender_component != TitanComponent.SYSTEM_COMPREF) {\n");
            source.append("\t\t\t\tTTCN_Logger.log(TTCN_Logger.Severity.MATCHING_MMUNSUCC, \"Matching on port {0} will drop a message: Sender of the first message in the queue is not the system.\", get_name());\n ");
            source.append("\t\t\t\tremove_msg_queue_head();\n");
            source.append("\t\t\t\treturn TitanAlt_Status.ALT_NO;\n");
            source.append("\t\t\t} else if (my_head.sender_address == null) {\n");
            source.append("\t\t\t\tthrow new TtcnError(MessageFormat.format(\"Trigger operation on port {0} requires the address of the sender, which was not given by the test port.\", get_name()));\n");
            source.append("\t\t\t} else if (!sender_template.match(my_head.sender_address, false)) {\n");
            source.append("\t\t\t\tif (TTCN_Logger.log_this_event(TTCN_Logger.Severity.MATCHING_MMUNSUCC)) {\n");
            source.append("\t\t\t\t\tTTCN_Logger.begin_event(TTCN_Logger.Severity.MATCHING_MMUNSUCC);\n");
            source.append("\t\t\t\t\tTTCN_Logger.log_event(\"Matching on port {0}: Sender address of the first message in the queue does not match the from clause: \", port_name);\n");
            source.append("\t\t\t\t\tsender_template.log_match(new TitanComponent(my_head.sender_component), false);\n");
            source.append("\t\t\t\t\tTTCN_Logger.end_event();\n");
            source.append("\t\t\t\t\tTTCN_Logger.begin_event_log2str();\n");
            source.append("\t\t\t\t\tsender_template.log_match(my_head.sender_address, false);\n");
            source.append("\t\t\t\t\tTTCN_Logger.log_matching_failure(TitanLoggerApi.PortType.enum_type.message__, port_name, my_head.sender_component, TitanLoggerApi.MatchingFailureType_reason.enum_type.message__does__not__match__template, TTCN_Logger.end_event_log2str());\n");
            source.append("\t\t\t\t}\n");
            source.append("\t\t\t\tremove_msg_queue_head();\n");
            source.append("\t\t\t\treturn TitanAlt_Status.ALT_REPEAT;\n");
            source.append("\t\t\t}");
        } else {
            source.append("\t\t\tif (!sender_template.match(my_head.sender_component, false)) {\n");
            source.append("\t\t\t\tfinal TTCN_Logger.Severity log_sev = my_head.sender_component == TitanComponent.SYSTEM_COMPREF ? TTCN_Logger.Severity.MATCHING_MMUNSUCC:TTCN_Logger.Severity.MATCHING_MCUNSUCC;\n");
            source.append("\t\t\t\tif (TTCN_Logger.log_this_event(log_sev)) {\n");
            source.append("\t\t\t\t\tTTCN_Logger.begin_event(log_sev);\n");
            source.append("\t\t\t\t\tTTCN_Logger.log_event(\"Matching on port {0}  will drop a message: Sender of the first message in the queue does not match the from clause: \" , get_name());\n");
            source.append("\t\t\t\t\tsender_template.log_match( new TitanComponent(my_head.sender_component), false);\n");
            source.append("\t\t\t\t\tTTCN_Logger.end_event();\n");
            source.append("\t\t\t\t}\n");
            source.append("\t\t\t\tremove_msg_queue_head();\n");
            source.append("\t\t\t\treturn TitanAlt_Status.ALT_REPEAT;\n");
            source.append("\t\t\t}");
        }
        source.append(" else {\n");
        if (portDefinition.realtime) {
            source.append("\t\t\t\tif (timestamp_redirect != null && my_head.timestamp.is_bound()) {\n");
            source.append("\t\t\t\t\ttimestamp_redirect.operator_assign(my_head.timestamp);\n");
            source.append("\t\t\t\t}\n");
        }
        source.append("\t\t\t\tif (sender_pointer != null) {\n");
        if (isAddress) {
            source.append("\t\t\t\t\tsender_pointer.operator_assign(my_head.sender_address);\n");
        } else {
            source.append("\t\t\t\t\tsender_pointer.operator_assign(my_head.sender_component);\n");
        }
        source.append("\t\t\t\t}\n");
        if (isAddress) {
            source.append("\t\t\t\tTTCN_Logger.log(TTCN_Logger.Severity.MATCHING_MMSUCCESS,  MessageFormat.format(\"Matching on port {0} succeeded.\", get_name()));\n");
            source.append("\t\t\t\tif (TTCN_Logger.log_this_event(TTCN_Logger.Severity.PORTEVENT_MMRECV)) {\n");
            source.append("\t\t\t\t\tTTCN_Logger.begin_event(TTCN_Logger.Severity.PORTEVENT_MMRECV);\n");
            source.append("\t\t\t\t\tmy_head.sender_address.log();\n");
            source.append("\t\t\t\t\tTTCN_Logger.log_msgport_recv(get_name(), TitanLoggerApi.Msg__port__recv_operation.enum_type.trigger__op, TitanComponent.SYSTEM_COMPREF, new TitanCharString(\"\"), TTCN_Logger.end_event_log2str(), msg_head_count+1);\n");
        } else {
            source.append("\t\t\t\tTTCN_Logger.log(my_head.sender_component == TitanComponent.SYSTEM_COMPREF ? TTCN_Logger.Severity.MATCHING_MMSUCCESS : TTCN_Logger.Severity.MATCHING_MCSUCCESS, ");
            source.append(" MessageFormat.format(\"Matching on port {0} succeeded.\", get_name()));\n");
            source.append("\t\t\t\tfinal TTCN_Logger.Severity log_sev = my_head.sender_component==TitanComponent.SYSTEM_COMPREF ? TTCN_Logger.Severity.PORTEVENT_MMRECV : TTCN_Logger.Severity.PORTEVENT_MCRECV;\n");
            source.append("\t\t\t\tif (TTCN_Logger.log_this_event(log_sev)) {\n");
            source.append("\t\t\t\t\tswitch (my_head.item_selection) {\n");
            for (int msg_idx = 0; msg_idx < portDefinition.inMessages.size(); ++msg_idx) {
                messageTypeInfo message_type = portDefinition.inMessages.get(msg_idx);
                source.append(MessageFormat.format("\t\t\t\t\tcase MESSAGE_{0}:\n", msg_idx));
                source.append("\t\t\t\t\t\tTTCN_Logger.begin_event(log_sev);\n");
                source.append(MessageFormat.format("\t\t\t\t\t\tTTCN_Logger.log_event_str(\": {0}: \");\n", message_type.mDisplayName));
                source.append("\t\t\t\t\t\tmy_head.message.log();\n");
                source.append("\t\t\t\t\t\tTTCN_Logger.log_msgport_recv(get_name(), TitanLoggerApi.Msg__port__recv_operation.enum_type.trigger__op, ");
                source.append("my_head.sender_component, new TitanCharString(\"\"),");
                source.append(MessageFormat.format("TTCN_Logger.end_event_log2str(), msg_head_count+1);\n", msg_idx));
                source.append("\t\t\t\t\tbreak;\n");
            }
            source.append("\t\t\t\t\tdefault:\n");
            source.append("\t\t\t\t\t\tthrow new TtcnError(\"Internal error: unknown message\");\n");
            source.append("\t\t\t\t\t}\n");
        }
        source.append("\t\t\t\t}\n");
        source.append("\t\t\t\tremove_msg_queue_head();\n");
        source.append("\t\t\t\treturn TitanAlt_Status.ALT_YES;\n");
        source.append("\t\t\t}\n");
        source.append("\t\t}\n\n");
    }

    private static void generateTypedReceive(StringBuilder source, PortDefinition portDefinition, int index, messageTypeInfo inType, boolean isCheck) {
        String typeValueName = inType.mJavaTypeName;
        String typeTemplateName = inType.mJavaTemplateName;
        String functionName = isCheck ? "check_receive" : "receive";
        String printedFunctionName = isCheck ? "Check-receive" : "Receive";
        String operationName = isCheck ? "check__receive__op" : "receive__op";
        source.append(MessageFormat.format("\t\tpublic TitanAlt_Status {0}(final {1} value_template, final Value_Redirect_Interface value_redirect, final TitanComponent_template sender_template, final TitanComponent sender_pointer, final TitanFloat timestamp_redirect, final Index_Redirect index_redirect) '{'\n", functionName, typeTemplateName));
        source.append("\t\t\tif (value_template.get_selection() == template_sel.ANY_OR_OMIT) {\n");
        source.append(MessageFormat.format("\t\t\t\tthrow new TtcnError(\"{0} operation using ''*'' as matching template\");\n", printedFunctionName));
        source.append("\t\t\t}\n");
        source.append("\t\t\tfinal Message_queue_item my_head = message_queue.peekFirst();\n");
        source.append("\t\t\tif (my_head == null) {\n");
        source.append("\t\t\t\tif (is_started) {\n");
        source.append("\t\t\t\t\treturn TitanAlt_Status.ALT_MAYBE;\n");
        source.append("\t\t\t\t} else {\n");
        source.append("\t\t\t\t\tTTCN_Logger.log_str(TTCN_Logger.Severity.MATCHING_PROBLEM, MessageFormat.format(\"Matching on port {0} failed: Port is not started and the queue is empty.\", get_name()));\n");
        source.append("\t\t\t\t\treturn TitanAlt_Status.ALT_NO;\n");
        source.append("\t\t\t\t}\n");
        source.append("\t\t\t} else if (!sender_template.match(my_head.sender_component, false)) {\n");
        source.append("\t\t\t\tfinal TTCN_Logger.Severity log_sev = my_head.sender_component == TitanComponent.SYSTEM_COMPREF ? TTCN_Logger.Severity.MATCHING_MMUNSUCC : TTCN_Logger.Severity.MATCHING_MCUNSUCC;\n");
        source.append("\t\t\t\tif (TTCN_Logger.log_this_event(log_sev)) {\n");
        source.append("\t\t\t\t\tTTCN_Logger.begin_event(log_sev);\n");
        source.append("\t\t\t\t\tTTCN_Logger.log_event_str(MessageFormat.format(\"Matching on port {0} failed: Sender of the first message in the queue does not match the from clause: \", get_name()));\n");
        source.append("\t\t\t\t\tsender_template.log_match(new TitanComponent(my_head.sender_component), false);\n");
        source.append("\t\t\t\t\tTTCN_Logger.end_event();\n");
        source.append("\t\t\t\t}\n");
        source.append("\t\t\t\treturn TitanAlt_Status.ALT_NO;\n");
        source.append(MessageFormat.format("\t\t\t} else if (my_head.item_selection != message_selection.MESSAGE_{0} || !(my_head.message instanceof {1})) '{'\n", index, typeValueName));
        source.append(MessageFormat.format("\t\t\t\tTTCN_Logger.log_str(my_head.sender_component == TitanComponent.SYSTEM_COMPREF ? TTCN_Logger.Severity.MATCHING_MMUNSUCC : TTCN_Logger.Severity.MATCHING_MCUNSUCC, MessageFormat.format(\"Matching on port '{'0'}' failed: Type of the first message in the queue is not {0}.\", get_name()));\n", typeValueName));
        source.append("\t\t\t\treturn TitanAlt_Status.ALT_NO;\n");
        source.append(MessageFormat.format("\t\t\t'}' else if (!value_template.match(({0}) my_head.message, false)) '{'\n", typeValueName));
        source.append("\t\t\t\tfinal TTCN_Logger.Severity log_sev = TTCN_Logger.Severity.MATCHING_MMUNSUCC;\n");
        source.append("\t\t\t\tif (TTCN_Logger.log_this_event(log_sev)) {\n");
        source.append("\t\t\t\t\tTTCN_Logger.begin_event(log_sev);\n");
        source.append("\t\t\t\t\tvalue_template.log_match(my_head.message, false);\n");
        source.append("\t\t\t\t\tTTCN_Logger.log_matching_failure(TitanLoggerApi.PortType.enum_type.message__, get_name(), my_head.sender_component, TitanLoggerApi.MatchingFailureType_reason.enum_type.message__does__not__match__template, TTCN_Logger.end_event_log2str());\n");
        source.append("\t\t\t\t}\n");
        source.append("\t\t\t\treturn TitanAlt_Status.ALT_NO;\n");
        source.append("\t\t\t} else {\n");
        source.append("\t\t\t\tif (value_redirect != null) {\n");
        source.append(MessageFormat.format("\t\t\t\t\tvalue_redirect.set_values(({0}) my_head.message);\n", typeValueName));
        source.append("\t\t\t\t}\n");
        if (portDefinition.realtime) {
            source.append("\t\t\t\tif (timestamp_redirect != null && my_head.timestamp.is_bound()) {\n");
            source.append("\t\t\t\t\ttimestamp_redirect.operator_assign(my_head.timestamp);\n");
            source.append("\t\t\t\t}\n");
        }
        source.append("\t\t\t\tif (sender_pointer != null) {\n");
        source.append("\t\t\t\t\tsender_pointer.operator_assign(my_head.sender_component);\n");
        source.append("\t\t\t\t}\n");
        source.append("\t\t\t\tTTCN_Logger.Severity log_severity = my_head.sender_component == TitanComponent.SYSTEM_COMPREF ? TTCN_Logger.Severity.MATCHING_MMSUCCESS : TTCN_Logger.Severity.MATCHING_MCSUCCESS;\n");
        source.append("\t\t\t\tif (TTCN_Logger.log_this_event(log_severity)) {\n");
        source.append("\t\t\t\t\tTTCN_Logger.begin_event_log2str();\n");
        source.append("\t\t\t\t\tvalue_template.log_match(my_head.message, true);\n");
        source.append("\t\t\t\t\tfinal TitanCharString temp = TTCN_Logger.end_event_log2str();\n");
        source.append("\t\t\t\t\tTTCN_Logger.log_matching_success(TitanLoggerApi.PortType.enum_type.message__, port_name, my_head.sender_component, temp);\n");
        source.append("\t\t\t\t}\n");
        source.append("\t\t\t\tlog_severity = my_head.sender_component == TitanComponent.SYSTEM_COMPREF ? TTCN_Logger.Severity.PORTEVENT_MMRECV : TTCN_Logger.Severity.PORTEVENT_MCRECV;\n");
        source.append("\t\t\t\tif (TTCN_Logger.log_this_event(log_severity)) {\n");
        source.append("\t\t\t\t\tTTCN_Logger.begin_event_log2str();\n");
        source.append(MessageFormat.format("\t\t\t\t\tTTCN_Logger.log_event_str(\": {0} : \");\n", inType.mDisplayName));
        source.append("\t\t\t\t\tmy_head.message.log();\n");
        source.append("\t\t\t\t\tfinal TitanCharString temp = TTCN_Logger.end_event_log2str();\n");
        source.append(MessageFormat.format("\t\t\t\t\tTTCN_Logger.log_msgport_recv(port_name, TitanLoggerApi.Msg__port__recv_operation.enum_type.{0}, my_head.sender_component, new TitanCharString(\"\"), temp, msg_head_count + 1);\n", operationName));
        source.append("\t\t\t\t}\n");
        if (!isCheck) {
            source.append("\t\t\t\tremove_msg_queue_head();\n");
        }
        source.append("\t\t\t\treturn TitanAlt_Status.ALT_YES;\n");
        source.append("\t\t\t}\n");
        source.append("\t\t}\n\n");
    }

    private static void generateTypeTrigger(StringBuilder source, PortDefinition portDefinition, int index, messageTypeInfo inType) {
        String typeValueName = inType.mJavaTypeName;
        String typeTemplateName = inType.mJavaTemplateName;
        source.append(MessageFormat.format("\t\tpublic TitanAlt_Status trigger(final {0} value_template, final Value_Redirect_Interface value_redirect, final TitanComponent_template sender_template, final TitanComponent sender_pointer, final TitanFloat timestamp_redirect, final Index_Redirect index_redirect) '{'\n", typeTemplateName));
        source.append("\t\t\tif (value_template.get_selection() == template_sel.ANY_OR_OMIT) {\n");
        source.append("\t\t\t\tthrow new TtcnError(\"Trigger operation using '*' as matching template\");\n");
        source.append("\t\t\t}\n");
        source.append("\t\t\tfinal Message_queue_item my_head = message_queue.peekFirst();\n");
        source.append("\t\t\tif (my_head == null) {\n");
        source.append("\t\t\t\tif (is_started) {\n");
        source.append("\t\t\t\t\treturn TitanAlt_Status.ALT_MAYBE;\n");
        source.append("\t\t\t\t} else {\n");
        source.append("\t\t\t\t\tTTCN_Logger.log(TTCN_Logger.Severity.MATCHING_PROBLEM, \"Matching on port {0} will drop a message: Port is not started and the queue is empty.\", get_name());\n");
        source.append("\t\t\t\t\treturn TitanAlt_Status.ALT_NO;\n");
        source.append("\t\t\t\t}\n");
        source.append("\t\t\t} else if (!sender_template.match(my_head.sender_component, false)) {\n");
        source.append("\t\t\t\tfinal TTCN_Logger.Severity log_sev = my_head.sender_component == TitanComponent.SYSTEM_COMPREF ? TTCN_Logger.Severity.MATCHING_MMUNSUCC : TTCN_Logger.Severity.MATCHING_MCUNSUCC;\n");
        source.append("\t\t\t\tif (TTCN_Logger.log_this_event(log_sev)) {\n");
        source.append("\t\t\t\t\tTTCN_Logger.begin_event(log_sev);\n");
        source.append("\t\t\t\t\tTTCN_Logger.log_event(\"Matching on port {0} will drop a message: Sender of the first message in the queue does not match the from clause: \", get_name());\n");
        source.append("\t\t\t\t\tsender_template.log_match(new TitanComponent(my_head.sender_component), false);\n");
        source.append("\t\t\t\t\tTTCN_Logger.end_event();\n");
        source.append("\t\t\t\t}\n");
        source.append("\t\t\t\tremove_msg_queue_head();\n");
        source.append("\t\t\t\treturn TitanAlt_Status.ALT_REPEAT;\n");
        source.append(MessageFormat.format("\t\t\t} else if (my_head.item_selection != message_selection.MESSAGE_{0} || !(my_head.message instanceof {1})) '{'\n", index, typeValueName));
        source.append("\t\t\t\tTTCN_Logger.log(my_head.sender_component == TitanComponent.SYSTEM_COMPREF ? TTCN_Logger.Severity.MATCHING_MMUNSUCC : TTCN_Logger.Severity.MATCHING_MCUNSUCC, \"Matching on port {0} will drop a message: ");
        source.append(MessageFormat.format("\t\t\t\tType of the first message in the queue is not {0}.\", get_name());\n", typeValueName));
        source.append("\t\t\t\tremove_msg_queue_head();\n");
        source.append("\t\t\t\treturn TitanAlt_Status.ALT_REPEAT;\n");
        source.append(MessageFormat.format("\t\t\t'}' else if (!value_template.match(({0}) my_head.message, false)) '{'\n", typeValueName));
        source.append("\t\t\t\tfinal TTCN_Logger.Severity log_sev = my_head.sender_component == TitanComponent.SYSTEM_COMPREF ? TTCN_Logger.Severity.MATCHING_MMUNSUCC : TTCN_Logger.Severity.MATCHING_MCUNSUCC;\n");
        source.append("\t\t\t\tif (TTCN_Logger.log_this_event(log_sev)) {\n");
        source.append("\t\t\t\t\tTTCN_Logger.begin_event(log_sev);\n");
        source.append(MessageFormat.format("\t\t\t\t\tvalue_template.log_match(my_head.message, false);\n", index));
        source.append("\t\t\t\t\tTTCN_Logger.log_matching_failure(TitanLoggerApi.PortType.enum_type.message__, get_name(), my_head.sender_component, TitanLoggerApi.MatchingFailureType_reason.enum_type.message__does__not__match__template, TTCN_Logger.end_event_log2str());\n");
        source.append("\t\t\t\t}\n");
        source.append("\t\t\t\tremove_msg_queue_head();\n");
        source.append("\t\t\t\treturn TitanAlt_Status.ALT_REPEAT;\n");
        source.append("\t\t\t} else {\n");
        source.append("\t\t\t\tif (value_redirect != null) {\n");
        source.append(MessageFormat.format("\t\t\t\t\tvalue_redirect.set_values(({0}) my_head.message);\n", typeValueName));
        source.append("\t\t\t\t}\n");
        if (portDefinition.realtime) {
            source.append("\t\t\t\tif (timestamp_redirect != null && my_head.timestamp.is_bound()) {\n");
            source.append("\t\t\t\t\ttimestamp_redirect.operator_assign(my_head.timestamp);\n");
            source.append("\t\t\t\t}\n");
        }
        source.append("\t\t\t\tif (sender_pointer != null) {\n");
        source.append("\t\t\t\t\tsender_pointer.operator_assign(my_head.sender_component);\n");
        source.append("\t\t\t\t}\n");
        source.append("\t\t\t\tTTCN_Logger.Severity log_severity = my_head.sender_component == TitanComponent.SYSTEM_COMPREF ? TTCN_Logger.Severity.MATCHING_MMSUCCESS : TTCN_Logger.Severity.MATCHING_MCSUCCESS;\n");
        source.append("\t\t\t\tif (TTCN_Logger.log_this_event(log_severity)) {\n");
        source.append("\t\t\t\t\tTTCN_Logger.begin_event_log2str();\n");
        source.append("\t\t\t\t\tvalue_template.log_match(my_head.message, true);\n");
        source.append("\t\t\t\t\tfinal TitanCharString temp = TTCN_Logger.end_event_log2str();\n");
        source.append("\t\t\t\t\tTTCN_Logger.log_matching_success(TitanLoggerApi.PortType.enum_type.message__, port_name, my_head.sender_component, temp);\n");
        source.append("\t\t\t\t}\n");
        source.append("\t\t\t\tlog_severity = my_head.sender_component == TitanComponent.SYSTEM_COMPREF ? TTCN_Logger.Severity.PORTEVENT_MMRECV : TTCN_Logger.Severity.PORTEVENT_MCRECV;\n");
        source.append("\t\t\t\tif (TTCN_Logger.log_this_event(log_severity)) {\n");
        source.append("\t\t\t\t\tTTCN_Logger.begin_event_log2str();\n");
        source.append(MessageFormat.format("\t\t\t\t\tTTCN_Logger.log_event_str(\": {0} : \");\n", inType.mDisplayName));
        source.append("\t\t\t\t\tmy_head.message.log();\n");
        source.append("\t\t\t\t\tfinal TitanCharString temp = TTCN_Logger.end_event_log2str();\n");
        source.append("\t\t\t\t\tTTCN_Logger.log_msgport_recv(port_name, TitanLoggerApi.Msg__port__recv_operation.enum_type.trigger__op, my_head.sender_component, new TitanCharString(\"\"), temp, msg_head_count + 1);\n");
        source.append("\t\t\t\t}\n");
        source.append("\t\t\t\tremove_msg_queue_head();\n");
        source.append("\t\t\t\treturn TitanAlt_Status.ALT_YES;\n");
        source.append("\t\t\t}\n");
        source.append("\t\t}\n\n");
    }

    private static void generateIncomingMapping(JavaGenData aData, StringBuilder source, PortDefinition portDefinition, MessageMappedTypeInfo mappedType, boolean hasSimple) {
        int start = hasSimple ? 1 : 0;
        boolean hasBuffer = false;
        boolean hasDiscard = false;
        boolean reportError = false;
        boolean isSliding = false;
        for (int i = start; i < mappedType.targets.size(); ++i) {
            MessageTypeMappingTarget target = (MessageTypeMappingTarget)mappedType.targets.get(i);
            boolean hasCondition = false;
            if (target.mappingType == MessageMappingType_type.DISCARD) {
                hasDiscard = true;
                break;
            }
            if (target.mappingType == MessageMappingType_type.DECODE && !hasBuffer) {
                aData.addBuiltinTypeImport("TTCN_Buffer");
                if (isSliding) {
                    source.append("\t\t\tTTCN_Buffer ttcn_buffer = new TTCN_Buffer(slider);\n");
                } else {
                    source.append("\t\t\tTTCN_Buffer ttcn_buffer = new TTCN_Buffer(incoming_par);\n");
                }
            }
            if (!portDefinition.legacy && portDefinition.portType == PortType.USER) {
                aData.addBuiltinTypeImport("TTCN_Runtime");
                source.append("\t\t\tTTCN_Runtime.set_translation_mode(true, this);\n");
                source.append("\t\t\tTTCN_Runtime.set_port_state(-1, \"by test environment.\", true);\n");
            }
            if (mappedType.targets.size() > 1) {
                source.append("\t\t\t{\n");
            }
            block0 : switch (target.mappingType) {
                case FUNCTION: {
                    source.append(MessageFormat.format("\t\t\t// in mapping with a prototype({0}) function\n", target.functionPrototype.name()));
                    switch (target.functionPrototype) {
                        case CONVERT: {
                            source.append(MessageFormat.format("\t\t\tfinal {0} mapped_par = new {0}({1}(incoming_par));\n", target.targetName, target.functionName));
                            break block0;
                        }
                        case FAST: {
                            source.append(MessageFormat.format("\t\t\tfinal {0} mapped_par = new {0}();\n", target.targetName));
                            source.append(MessageFormat.format("\t\t\t{0}(incoming_par, mapped_par);\n", target.functionName));
                            if (portDefinition.legacy) break block0;
                            hasCondition = true;
                            break block0;
                        }
                        case SLIDING: {
                            if (!isSliding) {
                                source.append("\t\t\tslider.operator_assign(slider.operator_concatenate(incoming_par));\n");
                                isSliding = true;
                            }
                            source.append("\t\t\tfor (;;) {\n");
                            source.append(MessageFormat.format("\t\t\t\tfinal {0} mapped_par = new {0}();\n", target.targetName));
                            source.append(MessageFormat.format("\t\t\t\tint decoding_result = {0}(slider, mapped_par).get_int();\n", target.functionName));
                            source.append("\t\t\t\tif (decoding_result == 0) {\n");
                            hasCondition = true;
                            break block0;
                        }
                        case BACKTRACK: {
                            source.append(MessageFormat.format("\t\t\tfinal {0} mapped_par = new {0}();\n", target.targetName));
                            source.append(MessageFormat.format("\t\t\tboolean success_flag = {0}(incoming_par, mapped_par).operator_equals(0);\n", target.functionName));
                            source.append("\t\t\tif (success_flag) {\n");
                            hasCondition = true;
                            break block0;
                        }
                    }
                    break;
                }
                case ENCODE: {
                    aData.addBuiltinTypeImport("TTCN_Buffer");
                    aData.addBuiltinTypeImport("TTCN_EncDec");
                    source.append("\t\t\t// in mapping with a built-in encoder\n");
                    source.append(target.encdecErrorBehaviour);
                    source.append("\t\t\tfinal TTCN_Buffer ttcn_buffer = new TTCN_Buffer();\n");
                    if (target.encdecEncodingOptions == null) {
                        source.append(MessageFormat.format("\t\t\tsend_par.encode({0}_descr_, ttcn_buffer, TTCN_EncDec.coding_type.CT_{1}, 0);\n", target.encdecTypedesriptorName, target.encdecEncodingType));
                    } else {
                        source.append(MessageFormat.format("\t\t\tsend_par.encode({0}_descr_, ttcn_buffer, TTCN_EncDec.coding_type.CT_{1}, {2});\n", target.encdecTypedesriptorName, target.encdecEncodingType, target.encdecEncodingOptions));
                    }
                    source.append(MessageFormat.format("\t\t\tfinal {0} mapped_par = new {0}();\n", target.targetName));
                    source.append("\t\t\tttcn_buffer.get_string(mapped_par);\n");
                    break;
                }
                case DECODE: {
                    aData.addBuiltinTypeImport("TTCN_Buffer");
                    aData.addBuiltinTypeImport("TTCN_EncDec");
                    source.append("\t\t\t// in mapping with a built-in decoder\n");
                    if (hasBuffer) {
                        source.append("\t\t\tttcn_buffer.rewind();\n");
                    } else {
                        hasBuffer = true;
                    }
                    source.append(target.encdecErrorBehaviour);
                    source.append("\t\t\tTTCN_EncDec.clear_error();\n");
                    source.append(MessageFormat.format("\t\t\tfinal {0} mapped_par = new {0}();\n", target.targetName));
                    if (target.encdecEncodingOptions == null) {
                        source.append(MessageFormat.format("\t\t\tmapped_par.decode({0}_descr_, ttcn_buffer, TTCN_EncDec.coding_type.CT_{1}, 0);\n", target.encdecTypedesriptorName, target.encdecEncodingType));
                    } else {
                        source.append(MessageFormat.format("\t\t\tmapped_par.decode({0}_descr_, ttcn_buffer, TTCN_EncDec.coding_type.CT_{1}, {2});\n", target.encdecTypedesriptorName, target.encdecEncodingType, target.encdecEncodingOptions));
                    }
                    source.append("\t\t\tif (TTCN_EncDec.get_last_error_type() == TTCN_EncDec.error_type.ET_NONE) {\n");
                    hasCondition = true;
                    break;
                }
            }
            if (!portDefinition.legacy && portDefinition.portType == PortType.USER) {
                source.append("\t\t\tTTCN_Runtime.set_translation_mode(false, null);\n");
                source.append("\t\t\tif (port_state == translation_port_state.TRANSLATED || port_state == translation_port_state.PARTIALLY_TRANSLATED) {\n");
            }
            source.append("\t\t\tmsg_tail_count++;\n");
            source.append("\t\t\tif (TTCN_Logger.log_this_event(TTCN_Logger.Severity.PORTEVENT_DUALRECV)) {\n");
            source.append("\t\t\t\tTTCN_Logger.begin_event(TTCN_Logger.Severity.PORTEVENT_DUALRECV);\n");
            source.append("\t\t\t\tmapped_par.log();\n");
            source.append(MessageFormat.format("\t\t\t\tTTCN_Logger.log_dualport_map(true, \"{0}\", TTCN_Logger.end_event_log2str(), msg_tail_count);\n", target.targetDisplayName));
            source.append("\t\t\t}\n");
            source.append("\t\t\tfinal Message_queue_item new_item = new Message_queue_item();\n");
            source.append(MessageFormat.format("\t\t\tnew_item.item_selection = message_selection.MESSAGE_{0};\n", target.targetIndex));
            source.append(MessageFormat.format("\t\t\tnew_item.message = new {0}(mapped_par);\n", target.targetName));
            source.append("\t\t\tnew_item.sender_component = sender_component;\n");
            if (portDefinition.testportType == TestportType.ADDRESS) {
                source.append("\t\t\tif (sender_address != null) {\n");
                source.append(MessageFormat.format("\t\t\t\tnew_item.sender_address = new {0}(sender_address);\n", portDefinition.addressName));
                source.append("\t\t\t} else {\n");
                source.append("\t\t\t\tnew_item.sender_address = null;\n");
                source.append("\t\t\t}\n");
            }
            source.append("\t\t\tmessage_queue.addLast(new_item);\n");
            if (hasCondition) {
                if (portDefinition.has_sliding && target.mappingType == MessageMappingType_type.FUNCTION && target.functionPrototype == FunctionPrototype_Type.SLIDING) {
                    source.append("\t\t\t\t\tcontinue;\n");
                    source.append("\t\t\t\t}\n");
                    source.append("\t\t\t\tif (decoding_result == 2) {\n");
                    source.append("\t\t\t\t\treturn;\n");
                    source.append("\t\t\t\t}\n");
                    source.append("\t\t\t}\n");
                } else {
                    if (isSliding) {
                        source.append("\t\t\t\tslider.operator_assign(new TitanOctetString(\"\"));\n");
                    }
                    source.append("\t\t\t\treturn;\n");
                    source.append("\t\t\t}");
                    if (portDefinition.portType == PortType.USER && !portDefinition.legacy) {
                        source.append(" else if (port_state == translation_port_state.FRAGMENTED || port_state == translation_port_state.DISCARDED) {\n");
                        source.append("\t\t\t\treturn;\n");
                        source.append("\t\t\t} else if (port_state == translation_port_state.UNSET) {\n");
                        source.append(MessageFormat.format("\t\t\t\tthrow new TtcnError(MessageFormat.format(\"The state of the port '{'0'}' remained unset after the mapping function {0} finished..\", get_name()));\n", target.functionDisplayName));
                        source.append("\t\t\t}");
                    }
                }
                reportError = true;
            }
            if (mappedType.targets.size() <= 1) continue;
            source.append("\t\t\t}\n");
        }
        if (hasDiscard) {
            if (mappedType.targets.size() > 1) {
                source.append(MessageFormat.format("\t\t\tTTCN_Logger.log_dualport_discard(true, \"{0}\", get_name(), true);\n", mappedType.mDisplayName));
            } else {
                source.append(MessageFormat.format("\t\t\tTTCN_Logger.log_dualport_discard(true, \"{0}\", get_name(), false);\n", mappedType.mDisplayName));
            }
        } else if (reportError && !hasSimple && !isSliding) {
            source.append(MessageFormat.format("\t\t\tthrow new TtcnError(MessageFormat.format(\"Incomming message of type {0} could not be handled by the type mapping rules on port '{'0'}'.\", get_name()));\n", mappedType.mDisplayName));
        }
    }

    private static void generateTypedIncommingMessageUser(JavaGenData aData, StringBuilder source, int index, MessageMappedTypeInfo mappedType, PortDefinition portDefinition) {
        String typeValueName = mappedType.mJavaTypeName;
        boolean isSimple = (!portDefinition.legacy || mappedType.targets.size() == 1) && ((MessageTypeMappingTarget)mappedType.targets.get(0)).mappingType == MessageMappingType_type.SIMPLE;
        StringBuilder comment = new StringBuilder();
        StringBuilder header = new StringBuilder();
        comment.append("\t\t/**\n");
        comment.append(MessageFormat.format("\t\t * Inserts a message of {0} type into the incoming message queue of this\n", mappedType.mDisplayName));
        comment.append("\t\t * Test Port.\n");
        comment.append("\t\t *\n");
        comment.append("\t\t * @param incoming_par\n");
        comment.append("\t\t *            the value to be inserted.\n");
        comment.append("\t\t * @param sender_component\n");
        comment.append("\t\t *            the sender component.\n");
        header.append(MessageFormat.format("\t\tprivate void incoming_message(final {0} incoming_par, final int sender_component", typeValueName));
        if (portDefinition.has_sliding) {
            comment.append("\t\t * @param slider\n");
            comment.append("\t\t *            the sliding buffer.\n");
            header.append(", final TitanOctetString slider");
        }
        if (portDefinition.testportType == TestportType.ADDRESS) {
            comment.append("\t\t * @param sender_address\n");
            comment.append("\t\t *            the address of the sender.\n");
            header.append(MessageFormat.format(", final {0} sender_address", portDefinition.addressName));
        }
        if (portDefinition.realtime) {
            comment.append("\t\t * @param timestamp\n");
            comment.append("\t\t *            the timestamp to return.\n");
            header.append(", final TitanFloat timestamp");
        }
        comment.append("\t\t * */\n");
        source.append((CharSequence)comment);
        source.append((CharSequence)header);
        source.append(") {\n");
        source.append("\t\t\tif (!is_started) {\n");
        source.append("\t\t\t\tif(is_halted) {\n");
        source.append("\t\t\t\t\tTtcnError.TtcnWarning(MessageFormat.format(\"A message that arrived on port {0} has been discarded, because the port is not started.\", get_name()));\n");
        source.append("\t\t\t\t\treturn;\n");
        source.append("\t\t\t\t} else {\n");
        source.append("\t\t\t\t\tthrow new TtcnError(MessageFormat.format(\"Port {0} is not started but a message has arrived on it.\", get_name()));\n");
        source.append("\t\t\t\t}\n");
        source.append("\t\t\t}\n");
        if (isSimple) {
            source.append("\t\t\tmsg_tail_count++;\n");
        }
        source.append("\t\t\tif (TTCN_Logger.log_this_event(TTCN_Logger.Severity.PORTEVENT_MQUEUE)) {\n");
        if (portDefinition.testportType == TestportType.ADDRESS) {
            source.append("\t\t\t\tTTCN_Logger.begin_event(TTCN_Logger.Severity.PORTEVENT_MQUEUE);\n");
            source.append("\t\t\t\tTTCN_Logger.log_char('(');\n");
            source.append("\t\t\t\tsender_address.log();\n");
            source.append("\t\t\t\tTTCN_Logger.log_char(')');\n");
            source.append("\t\t\t\tfinal TitanCharString log_sender_address = TTCN_Logger.end_event_log2str();\n");
        } else {
            source.append("\t\t\t\tfinal TitanCharString log_sender_address = new TitanCharString(\"\");\n");
        }
        source.append("\t\t\t\tTTCN_Logger.begin_event(TTCN_Logger.Severity.PORTEVENT_MQUEUE);\n");
        source.append(MessageFormat.format("\t\t\t\tTTCN_Logger.log_event_str(\" {0} : \");\n", mappedType.mDisplayName));
        source.append("\t\t\t\tincoming_par.log();\n");
        source.append("\t\t\t\tfinal TitanCharString log_parameter = TTCN_Logger.end_event_log2str();\n");
        if (isSimple) {
            source.append("\t\t\t\tTTCN_Logger.log_port_queue(TitanLoggerApi.Port__Queue_operation.enum_type.enqueue__msg, port_name, sender_component, msg_tail_count, log_sender_address, log_parameter);\n");
        } else {
            source.append("\t\t\t\tTTCN_Logger.log_port_queue(TitanLoggerApi.Port__Queue_operation.enum_type.enqueue__msg, port_name, sender_component, msg_tail_count + 1, log_sender_address, log_parameter);\n");
        }
        source.append("\t\t\t}\n");
        if (!portDefinition.legacy) {
            if (!isSimple && !mappedType.targets.isEmpty() || isSimple && mappedType.targets.size() > 1) {
                source.append("\t\t\tif (in_translation_mode()) {\n");
                PortGenerator.generateIncomingMapping(aData, source, portDefinition, mappedType, isSimple);
                source.append("\t\t\t}\n");
            } else {
                PortGenerator.generateIncomingMapping(aData, source, portDefinition, mappedType, isSimple);
            }
        } else if (!isSimple) {
            PortGenerator.generateIncomingMapping(aData, source, portDefinition, mappedType, isSimple);
        }
        if (isSimple) {
            source.append("\t\t\tfinal Message_queue_item new_item = new Message_queue_item();\n");
            source.append(MessageFormat.format("\t\t\tnew_item.item_selection = message_selection.MESSAGE_{0};\n", index));
            source.append(MessageFormat.format("\t\t\tnew_item.message = new {0}(incoming_par);\n", typeValueName));
            source.append("\t\t\tnew_item.sender_component = sender_component;\n");
            if (portDefinition.realtime) {
                source.append("\t\t\tif(timestamp.is_bound()) {\n");
                source.append("\t\t\t\tnew_item.timestamp.operator_assign(timestamp);\n");
                source.append("\t\t\t}\n");
            }
            if (portDefinition.testportType == TestportType.ADDRESS) {
                source.append("\t\t\tif (sender_address != null) {\n");
                source.append(MessageFormat.format("\t\t\t\tnew_item.sender_address = new {0}(sender_address);\n", portDefinition.addressName));
                source.append("\t\t\t} else {\n");
                source.append("\t\t\t\tnew_item.sender_address = null;\n");
                source.append("\t\t\t}\n");
            }
            source.append("\t\t\tmessage_queue.addLast(new_item);\n");
        }
        source.append("\t\t}\n\n");
        if (portDefinition.testportType != TestportType.INTERNAL) {
            if (portDefinition.testportType == TestportType.ADDRESS) {
                source.append("\t\t/**\n");
                source.append(MessageFormat.format("\t\t * Inserts a message of {0} type into the incoming message queue of this\n", mappedType.mDisplayName));
                source.append("\t\t * Test Port.\n");
                source.append("\t\t *\n");
                source.append("\t\t * @param incoming_par\n");
                source.append("\t\t *            the value to be inserted.\n");
                source.append("\t\t * @param sender_address\n");
                source.append("\t\t *            the address of the sender.\n");
                source.append("\t\t * */\n");
                source.append(MessageFormat.format("\t\tprotected void incoming_message(final {0} incoming_par, final {1} sender_address) '{'\n", typeValueName, portDefinition.addressName));
                source.append(MessageFormat.format("\t\t\tincoming_message(incoming_par, TitanComponent.SYSTEM_COMPREF{0}, sender_address", portDefinition.realtime ? ", new TitanFloat()" : ""));
                if (portDefinition.has_sliding) {
                    source.append(", sliding_buffer");
                }
                source.append(");\n");
                source.append("\t\t}\n");
                source.append("\t\t/**\n");
                source.append(MessageFormat.format("\t\t * Inserts a message of {0} type into the incoming message queue of this\n", mappedType.mDisplayName));
                source.append("\t\t * Test Port.\n");
                source.append("\t\t *\n");
                source.append("\t\t * @param incoming_par\n");
                source.append("\t\t *            the value to be inserted.\n");
                source.append("\t\t * */\n");
                source.append(MessageFormat.format("\t\tprotected void incoming_message(final {0} incoming_par) '{'\n", typeValueName));
                source.append(MessageFormat.format("\t\t\tincoming_message(incoming_par, TitanComponent.SYSTEM_COMPREF{0}, null", portDefinition.realtime ? ", new TitanFloat()" : ""));
            } else {
                source.append("\t\t/**\n");
                source.append(MessageFormat.format("\t\t * Inserts a message of {0} type into the incoming message queue of this\n", mappedType.mDisplayName));
                source.append("\t\t * Test Port.\n");
                source.append("\t\t *\n");
                source.append("\t\t * @param incoming_par\n");
                source.append("\t\t *            the value to be inserted.\n");
                source.append("\t\t * */\n");
                source.append(MessageFormat.format("\t\tprotected void incoming_message(final {0} incoming_par) '{'\n", typeValueName));
                source.append(MessageFormat.format("\t\t\tincoming_message(incoming_par, TitanComponent.SYSTEM_COMPREF{0}", portDefinition.realtime ? ", new TitanFloat()" : ""));
            }
            if (portDefinition.has_sliding) {
                source.append(", sliding_buffer");
            }
            source.append(");\n");
            source.append("\t\t}\n");
        }
    }

    private static void generateTypedIncommingMessageProvider(JavaGenData aData, StringBuilder source, int index, messageTypeInfo inType, PortDefinition portDefinition) {
        String typeValueName = inType.mJavaTypeName;
        StringBuilder comment = new StringBuilder();
        StringBuilder header = new StringBuilder();
        comment.append("\t\t/**\n");
        comment.append(MessageFormat.format("\t\t * Inserts a message of {0} type into the incoming message queue of this\n", inType.mDisplayName));
        comment.append("\t\t * Test Port.\n");
        comment.append("\t\t *\n");
        comment.append("\t\t * @param incoming_par\n");
        comment.append("\t\t *            the value to be inserted.\n");
        comment.append("\t\t * @param sender_component\n");
        comment.append("\t\t *            the sender component.\n");
        header.append(MessageFormat.format("\t\tprivate void incoming_message(final {0} incoming_par, final int sender_component", typeValueName));
        if (portDefinition.testportType == TestportType.ADDRESS) {
            comment.append("\t\t * @param sender_address\n");
            comment.append("\t\t *            the address of the sender.\n");
            header.append(MessageFormat.format(", final {0} sender_address", portDefinition.addressName));
        }
        if (portDefinition.realtime) {
            comment.append("\t\t * @param timestamp\n");
            comment.append("\t\t *            the timestamp to return.\n");
            header.append(", final TitanFloat timestamp");
        }
        comment.append("\t\t * */\n");
        source.append((CharSequence)comment);
        source.append((CharSequence)header);
        source.append(") {\n");
        if (portDefinition.portType == PortType.PROVIDER) {
            source.append("\t\t\tfor (int i = 0; i < mapped_ports.size(); i++) {\n");
            source.append(MessageFormat.format("\t\t\t\tif (mapped_ports.get(i) != null && mapped_ports.get(i).incoming_message_handler(incoming_par, \"{0}\", sender_component, {1})) '{'\n", inType.mDisplayName, portDefinition.realtime ? "timestamp" : "new TitanFloat()"));
            source.append("\t\t\t\t\treturn;\n");
            source.append("\t\t\t\t}\n");
            source.append("\t\t\t}\n");
        }
        source.append("\t\t\tif (!is_started) {\n");
        source.append("\t\t\t\tif(is_halted) {\n");
        source.append("\t\t\t\t\tTtcnError.TtcnWarning(MessageFormat.format(\"A message that arrived on port {0} has been discarded, because the port is not started.\", get_name()));\n");
        source.append("\t\t\t\t\treturn;\n");
        source.append("\t\t\t\t} else {\n");
        source.append("\t\t\t\t\tthrow new TtcnError(MessageFormat.format(\"Port {0} is not started but a message has arrived on it.\", get_name()));\n");
        source.append("\t\t\t\t}\n");
        source.append("\t\t\t}\n");
        source.append("\t\t\tmsg_tail_count++;\n");
        source.append("\t\t\tif (TTCN_Logger.log_this_event(TTCN_Logger.Severity.PORTEVENT_MQUEUE)) {\n");
        if (portDefinition.testportType == TestportType.ADDRESS) {
            source.append("\t\t\t\tTTCN_Logger.begin_event(TTCN_Logger.Severity.PORTEVENT_MQUEUE);\n");
            source.append("\t\t\t\tTTCN_Logger.log_char('(');\n");
            source.append("\t\t\t\tsender_address.log();\n");
            source.append("\t\t\t\tTTCN_Logger.log_char(')');\n");
            source.append("\t\t\t\tfinal TitanCharString log_sender_address = TTCN_Logger.end_event_log2str();\n");
        } else {
            source.append("\t\t\t\tfinal TitanCharString log_sender_address = new TitanCharString(\"\");\n");
        }
        source.append("\t\t\t\tTTCN_Logger.begin_event(TTCN_Logger.Severity.PORTEVENT_MQUEUE);\n");
        source.append(MessageFormat.format("\t\t\t\tTTCN_Logger.log_event_str(\" {0} : \");\n", inType.mDisplayName));
        source.append("\t\t\t\tincoming_par.log();\n");
        source.append("\t\t\t\tfinal TitanCharString log_parameter = TTCN_Logger.end_event_log2str();\n");
        source.append("\t\t\t\tTTCN_Logger.log_port_queue(TitanLoggerApi.Port__Queue_operation.enum_type.enqueue__msg, port_name, sender_component, msg_tail_count, log_sender_address, log_parameter);\n");
        source.append("\t\t\t}\n");
        source.append("\t\t\tfinal Message_queue_item new_item = new Message_queue_item();\n");
        source.append(MessageFormat.format("\t\t\tnew_item.item_selection = message_selection.MESSAGE_{0};\n", index));
        source.append(MessageFormat.format("\t\t\tnew_item.message = new {0}(incoming_par);\n", typeValueName));
        source.append("\t\t\tnew_item.sender_component = sender_component;\n");
        if (portDefinition.realtime) {
            source.append("\t\t\tif(timestamp.is_bound()) {\n");
            source.append("\t\t\t\tnew_item.timestamp = new TitanFloat(timestamp);\n");
            source.append("\t\t\t}\n");
        }
        if (portDefinition.testportType == TestportType.ADDRESS) {
            source.append("\t\t\tif (sender_address != null) {\n");
            source.append(MessageFormat.format("\t\t\t\tnew_item.sender_address = new {0}(sender_address);\n", portDefinition.addressName));
            source.append("\t\t\t} else {\n");
            source.append("\t\t\t\tnew_item.sender_address = null;\n");
            source.append("\t\t\t}\n");
        }
        source.append("\t\t\tmessage_queue.addLast(new_item);\n");
        source.append("\t\t}\n\n");
        if (portDefinition.testportType != TestportType.INTERNAL) {
            if (portDefinition.testportType == TestportType.ADDRESS) {
                source.append("\t\t/**\n");
                source.append(MessageFormat.format("\t\t * Inserts a message of {0} type into the incoming message queue of this\n", inType.mDisplayName));
                source.append("\t\t * Test Port.\n");
                source.append("\t\t *\n");
                source.append("\t\t * @param incoming_par\n");
                source.append("\t\t *            the value to be inserted.\n");
                source.append("\t\t * @param sender_address\n");
                source.append("\t\t *            the address of the sender.\n");
                source.append("\t\t * */\n");
                source.append(MessageFormat.format("\t\tprotected void incoming_message(final {0} incoming_par, final {1} sender_address) '{'\n", typeValueName, portDefinition.addressName));
                source.append(MessageFormat.format("\t\t\tincoming_message(incoming_par, TitanComponent.SYSTEM_COMPREF{0}, sender_address", portDefinition.realtime ? ", new TitanFloat()" : ""));
                if (portDefinition.has_sliding) {
                    source.append(", sliding_buffer");
                }
                source.append(");\n");
                source.append("\t\t}\n");
                source.append("\t\t/**\n");
                source.append(MessageFormat.format("\t\t * Inserts a message of {0} type into the incoming message queue of this\n", inType.mDisplayName));
                source.append("\t\t * Test Port.\n");
                source.append("\t\t *\n");
                source.append("\t\t * @param incoming_par\n");
                source.append("\t\t *            the value to be inserted.\n");
                source.append("\t\t * */\n");
                source.append(MessageFormat.format("\t\tprotected void incoming_message(final {0} incoming_par) '{'\n", typeValueName));
                source.append(MessageFormat.format("\t\t\tincoming_message(incoming_par, TitanComponent.SYSTEM_COMPREF{0}, null", portDefinition.realtime ? ", new TitanFloat()" : ""));
            } else {
                source.append("\t\t/**\n");
                source.append(MessageFormat.format("\t\t * Inserts a message of {0} type into the incoming message queue of this\n", inType.mDisplayName));
                source.append("\t\t * Test Port.\n");
                source.append("\t\t *\n");
                source.append("\t\t * @param incoming_par\n");
                source.append("\t\t *            the value to be inserted.\n");
                source.append("\t\t * */\n");
                source.append(MessageFormat.format("\t\tprotected void incoming_message(final {0} incoming_par) '{'\n", typeValueName));
                source.append(MessageFormat.format("\t\t\tincoming_message(incoming_par, TitanComponent.SYSTEM_COMPREF{0}", portDefinition.realtime ? ", new TitanFloat()" : ""));
            }
            if (portDefinition.has_sliding) {
                source.append(", sliding_buffer");
            }
            source.append(");\n");
            source.append("\t\t}\n");
        }
    }

    private static void generateProcessMessage(StringBuilder source, PortDefinition portDefinition) {
        source.append("\t\t@Override\n");
        source.append("\t\tprotected boolean process_message(final byte[] message_type, final Text_Buf incoming_buf, final int sender_component, final TitanOctetString slider) {\n");
        source.append("\t\t\t");
        if (portDefinition.portType == PortType.USER) {
            for (int i = 0; i < portDefinition.providerInMessages.size(); ++i) {
                MessageMappedTypeInfo inType = portDefinition.providerInMessages.get(i);
                source.append(MessageFormat.format("if (Arrays.equals(\"{0}\".getBytes(), message_type)) '{'\n", inType.mDisplayName));
                source.append(MessageFormat.format("\t\t\t\tfinal {0} incoming_par = new {0}();\n", inType.mJavaTypeName));
                source.append("\t\t\t\tincoming_par.decode_text(incoming_buf);\n");
                source.append(MessageFormat.format("\t\t\t\tincoming_message(incoming_par, sender_component{0}", portDefinition.realtime ? ", new TitanFloat()" : ""));
                if (portDefinition.has_sliding) {
                    source.append(", slider");
                }
                if (portDefinition.testportType == TestportType.ADDRESS) {
                    source.append(", null");
                }
                source.append(");\n");
                source.append("\t\t\t\treturn true;\n");
                source.append("\t\t\t} else ");
            }
        } else {
            for (int i = 0; i < portDefinition.inMessages.size(); ++i) {
                messageTypeInfo inType = portDefinition.inMessages.get(i);
                source.append(MessageFormat.format("if (Arrays.equals(in_message_names[{0}], message_type)) '{'\n", i));
                source.append(MessageFormat.format("\t\t\t\t//\"{0}\"\n", inType.mDisplayName));
                source.append(MessageFormat.format("\t\t\t\tfinal {0} incoming_par = new {0}();\n", inType.mJavaTypeName));
                source.append("\t\t\t\tincoming_par.decode_text(incoming_buf);\n");
                source.append(MessageFormat.format("\t\t\t\tincoming_message(incoming_par, sender_component{0}", portDefinition.realtime ? ", new TitanFloat()" : ""));
                if (portDefinition.has_sliding) {
                    source.append(", slider");
                }
                if (portDefinition.testportType == TestportType.ADDRESS) {
                    source.append(", null");
                }
                source.append(");\n");
                source.append("\t\t\t\treturn true;\n");
                source.append("\t\t\t} else ");
            }
        }
        source.append("{\n");
        source.append("\t\t\t\treturn false;\n");
        source.append("\t\t\t}\n");
        source.append("\t\t}\n\n");
    }

    private static void generateCallFunction(StringBuilder source, int index, procedureSignatureInfo info, PortDefinition portDefinition) {
        source.append("\t\t/**\n");
        source.append(MessageFormat.format("\t\t * Calls a(n) {0} signature on the provided component.\n", info.mDisplayName));
        source.append("\t\t * <p>\n");
        source.append("\t\t * When timestamp redirection is support the timestamp will be made\n");
        source.append("\t\t * available in the timestamp_Redirect parameter.\n");
        source.append("\t\t *\n");
        source.append("\t\t * @param call_template\n");
        source.append("\t\t *            the signature to be called\n");
        source.append("\t\t * @param destination_component\n");
        source.append("\t\t *            the target component to send the message to.\n");
        source.append("\t\t * @param timestamp_redirect\n");
        source.append("\t\t *            the redirected timestamp if any.\n");
        source.append("\t\t * */\n");
        source.append(MessageFormat.format("\t\tpublic void call(final {0}_template call_template, final TitanComponent destination_component, final TitanFloat timestamp_redirect) '{'\n", info.mJavaTypeName));
        source.append("\t\t\tif (!is_started) {\n");
        source.append("\t\t\t\tthrow new TtcnError(MessageFormat.format(\"Calling a signature on port {0}, which is not started.\", get_name()));\n");
        source.append("\t\t\t}\n");
        source.append("\t\t\tif (!destination_component.is_bound()) {\n");
        source.append("\t\t\t\tthrow new TtcnError(\"Unbound component reference in the to clause of call operation.\");\n");
        source.append("\t\t\t}\n\n");
        source.append(MessageFormat.format("\t\t\tfinal {0}_call call_temp = call_template.create_call();\n", info.mJavaTypeName));
        source.append("\t\t\tfinal TTCN_Logger.Severity log_sev = destination_component.get_component() == TitanComponent.SYSTEM_COMPREF ? TTCN_Logger.Severity.PORTEVENT_PMOUT : TTCN_Logger.Severity.PORTEVENT_PCOUT;\n");
        source.append("\t\t\tif (TTCN_Logger.log_this_event(log_sev)) {\n");
        source.append("\t\t\t\tTTCN_Logger.begin_event(TTCN_Logger.Severity.PORTEVENT_PMOUT);\n");
        source.append("\t\t\t\tcall_temp.log();\n");
        source.append("\t\t\t\tTTCN_Logger.log_procport_send(get_name(), TitanLoggerApi.Port__oper.enum_type.call__op, destination_component.get_component(), new TitanCharString(\"\"), TTCN_Logger.end_event_log2str());\n");
        source.append("\t\t\t}\n");
        source.append("\t\t\tif (destination_component.get_component() == TitanComponent.SYSTEM_COMPREF) {\n");
        if (portDefinition.testportType == TestportType.INTERNAL) {
            source.append("\t\t\t\tthrow new TtcnError(MessageFormat.format(\"Internal port {0} cannot send call to system.\", get_name()));\n");
        } else {
            source.append("\t\t\t\toutgoing_call(call_temp");
            if (portDefinition.testportType == TestportType.ADDRESS) {
                source.append(", null");
            }
            if (portDefinition.realtime) {
                source.append(", timestamp_redirect");
            }
            source.append(");\n");
        }
        source.append("\t\t\t} else {\n");
        source.append("\t\t\t\tfinal Text_Buf text_buf = new Text_Buf();\n");
        source.append(MessageFormat.format("\t\t\t\tprepare_call(text_buf, out_procedure_names[{0}]);\n", index));
        source.append(MessageFormat.format("\t\t\t\t//\"{0}\"\n", info.mDisplayName));
        source.append("\t\t\t\tcall_temp.encode_text(text_buf);\n");
        source.append("\t\t\t\tsend_data(text_buf, destination_component);\n");
        source.append("\t\t\t}\n");
        source.append("\t\t}\n\n");
        if (portDefinition.testportType == TestportType.ADDRESS) {
            source.append(MessageFormat.format("\t\tpublic void call(final {0}_template call_template, final {1} destination_address, final TitanFloat timestamp_redirect) '{'\n", info.mJavaTypeName, portDefinition.addressName));
            source.append("\t\t\tif (!is_started) {\n");
            source.append("\t\t\t\tthrow new TtcnError(MessageFormat.format(\"Calling a signature on port {0}, which is not started.\", get_name()));\n");
            source.append("\t\t\t}\n");
            source.append("\t\t\tif (TTCN_Logger.log_this_event(TTCN_Logger.Severity.PORTEVENT_PMOUT)) {");
            source.append("\t\t\t\tTTCN_Logger.begin_event(TTCN_Logger.Severity.PORTEVENT_PMOUT);\n");
            source.append("\t\t\t\tdestination_address.log();\n");
            source.append("\t\t\t\tfinal TitanCharString log_temp = TTCN_Logger.end_event_log2str();\n");
            source.append("\t\t\t\tTTCN_Logger.begin_event(TTCN_Logger.Severity.PORTEVENT_PMOUT);\n");
            source.append("\t\t\t\tcall_template.log();\n");
            source.append("\t\t\t\tTTCN_Logger.log_procport_send(get_name(), TitanLoggerApi.Port__oper.enum_type.call__op, TitanComponent.SYSTEM_COMPREF, log_temp, TTCN_Logger.end_event_log2str());\n");
            source.append("\t\t\t}\n");
            source.append(MessageFormat.format("\t\t\tfinal {0}_call call_temp = call_template.create_call();\n", info.mJavaTypeName));
            source.append("\t\t\toutgoing_call(call_temp, destination_address");
            if (portDefinition.realtime) {
                source.append(", timestamp_redirect");
            }
            source.append(");\n");
            source.append("\t\t}\n\n");
        }
        source.append("\t\t/**\n");
        source.append(MessageFormat.format("\t\t * Calls a(n) {0} signature on the default component.\n", info.mDisplayName));
        source.append("\t\t * <p>\n");
        source.append("\t\t * When timestamp redirection is support the timestamp will be made\n");
        source.append("\t\t * available in the timestamp_Redirect parameter.\n");
        source.append("\t\t *\n");
        source.append("\t\t * @param call_template\n");
        source.append("\t\t *            the signature to be called\n");
        source.append("\t\t * @param timestamp_redirect\n");
        source.append("\t\t *            the redirected timestamp if any.\n");
        source.append("\t\t * */\n");
        source.append(MessageFormat.format("\t\tpublic void call(final {0}_template call_template, final TitanFloat timestamp_redirect) '{'\n", info.mJavaTypeName));
        source.append("\t\t\tcall(call_template, new TitanComponent(get_default_destination()), timestamp_redirect);\n");
        source.append("\t\t}\n\n");
    }

    private static void generateReplyFunction(StringBuilder source, int index, procedureSignatureInfo info, PortDefinition portDefinition) {
        if (!info.isNoBlock) {
            source.append("\t\t/**\n");
            source.append(MessageFormat.format("\t\t * Replies to a(n) {0} signature on the provided component.\n", info.mDisplayName));
            source.append("\t\t * <p>\n");
            source.append("\t\t * When timestamp redirection is support the timestamp will be made\n");
            source.append("\t\t * available in the timestamp_Redirect parameter.\n");
            source.append("\t\t *\n");
            source.append("\t\t * @param reply_template\n");
            source.append("\t\t *            the signature to be replied\n");
            source.append("\t\t * @param destination_component\n");
            source.append("\t\t *            the target component to send the message to.\n");
            source.append("\t\t * @param timestamp_redirect\n");
            source.append("\t\t *            the redirected timestamp if any.\n");
            source.append("\t\t * */\n");
            source.append(MessageFormat.format("\t\tpublic void reply(final {0}_template reply_template, final TitanComponent destination_component, final TitanFloat timestamp_redirect) '{'\n", info.mJavaTypeName));
            source.append("\t\t\tif (!is_started) {\n");
            source.append("\t\t\t\tthrow new TtcnError(MessageFormat.format(\"Replying to a signature on port {0}, which is not started.\", get_name()));\n");
            source.append("\t\t\t}\n");
            source.append("\t\t\tif (!destination_component.is_bound()) {\n");
            source.append("\t\t\t\tthrow new TtcnError(\"Unbound component reference in the to clause of reply operation.\");\n");
            source.append("\t\t\t}\n\n");
            source.append(MessageFormat.format("\t\t\tfinal {0}_reply reply_temp = reply_template.create_reply();\n", info.mJavaTypeName));
            source.append("\t\t\tfinal TTCN_Logger.Severity log_sev = destination_component.get_component() == TitanComponent.SYSTEM_COMPREF ? TTCN_Logger.Severity.PORTEVENT_PMOUT : TTCN_Logger.Severity.PORTEVENT_PCOUT;\n");
            source.append("\t\t\tif (TTCN_Logger.log_this_event(log_sev)) {\n");
            source.append("\t\t\t\tTTCN_Logger.begin_event(TTCN_Logger.Severity.PORTEVENT_PMOUT);\n");
            source.append("\t\t\t\treply_temp.log();\n");
            source.append("\t\t\t\tTTCN_Logger.log_procport_send(get_name(), TitanLoggerApi.Port__oper.enum_type.reply__op, destination_component.get_component(), new TitanCharString(\"\"), TTCN_Logger.end_event_log2str());\n");
            source.append("\t\t\t}\n");
            source.append("\t\t\tif (destination_component.get_component() == TitanComponent.SYSTEM_COMPREF) {\n");
            if (portDefinition.testportType == TestportType.INTERNAL) {
                source.append("\t\t\t\tthrow new TtcnError(MessageFormat.format(\"Internal port {0} cannot reply to system.\", get_name()));\n");
            } else {
                source.append("\t\t\t\toutgoing_reply(reply_temp");
                if (portDefinition.testportType == TestportType.ADDRESS) {
                    source.append(", null");
                }
                if (portDefinition.realtime) {
                    source.append(", timestamp_redirect");
                }
                source.append(");\n");
            }
            source.append("\t\t\t} else {\n");
            source.append("\t\t\t\tfinal Text_Buf text_buf = new Text_Buf();\n");
            source.append(MessageFormat.format("\t\t\t\tprepare_reply(text_buf, in_procedure_names[{0}]);\n", index));
            source.append(MessageFormat.format("\t\t\t\t//\"{0}\"\n", info.mDisplayName));
            source.append("\t\t\t\treply_temp.encode_text(text_buf);\n");
            source.append("\t\t\t\tsend_data(text_buf, destination_component);\n");
            source.append("\t\t\t}\n");
            source.append("\t\t}\n\n");
            if (portDefinition.testportType == TestportType.ADDRESS) {
                source.append(MessageFormat.format("\t\tpublic void reply(final {0}_template reply_template, final {1} destination_address, final TitanFloat timestamp_redirect) '{'\n", info.mJavaTypeName, portDefinition.addressName));
                source.append("\t\t\tif (!is_started) {\n");
                source.append("\t\t\t\tthrow new TtcnError(MessageFormat.format(\"Replying to a signature on port {0}, which is not started.\", get_name()));\n");
                source.append("\t\t\t}\n");
                source.append("\t\t\tif (TTCN_Logger.log_this_event(TTCN_Logger.Severity.PORTEVENT_PMOUT)) {");
                source.append("\t\t\t\tTTCN_Logger.begin_event(TTCN_Logger.Severity.PORTEVENT_PMOUT);\n");
                source.append("\t\t\t\tdestination_address.log();\n");
                source.append("\t\t\t\tfinal TitanCharString log_temp = TTCN_Logger.end_event_log2str();\n");
                source.append("\t\t\t\tTTCN_Logger.begin_event(TTCN_Logger.Severity.PORTEVENT_PMOUT);\n");
                source.append("\t\t\t\treply_template.log();\n");
                source.append("\t\t\t\tTTCN_Logger.log_procport_send(get_name(), TitanLoggerApi.Port__oper.enum_type.reply__op, TitanComponent.SYSTEM_COMPREF, log_temp, TTCN_Logger.end_event_log2str());\n");
                source.append("\t\t\t}\n");
                source.append(MessageFormat.format("\t\t\tfinal {0}_reply reply_temp = reply_template.create_reply();\n", info.mJavaTypeName));
                source.append("\t\t\toutgoing_reply(reply_temp, destination_address");
                if (portDefinition.realtime) {
                    source.append(", timestamp_redirect");
                }
                source.append(");\n");
                source.append("\t\t}\n\n");
            }
            source.append("\t\t/**\n");
            source.append(MessageFormat.format("\t\t * Replies to a(n) {0} signature on the default component.\n", info.mDisplayName));
            source.append("\t\t * <p>\n");
            source.append("\t\t * When timestamp redirection is support the timestamp will be made\n");
            source.append("\t\t * available in the timestamp_Redirect parameter.\n");
            source.append("\t\t *\n");
            source.append("\t\t * @param reply_template\n");
            source.append("\t\t *            the signature to be replied\n");
            source.append("\t\t * @param timestamp_redirect\n");
            source.append("\t\t *            the redirected timestamp if any.\n");
            source.append("\t\t * */\n");
            source.append(MessageFormat.format("\t\tpublic void reply(final {0}_template reply_template, final TitanFloat timestamp_redirect) '{'\n", info.mJavaTypeName));
            source.append("\t\t\treply(reply_template, new TitanComponent(get_default_destination()), timestamp_redirect);\n");
            source.append("\t\t}\n\n");
        }
    }

    private static void generateRaiseFunction(StringBuilder source, int index, procedureSignatureInfo info, PortDefinition portDefinition) {
        if (info.hasExceptions) {
            source.append("\t\t/**\n");
            source.append(MessageFormat.format("\t\t * Raise the exception of {0} signature on the provided component.\n", info.mDisplayName));
            source.append("\t\t * <p>\n");
            source.append("\t\t * When timestamp redirection is support the timestamp will be made\n");
            source.append("\t\t * available in the timestamp_Redirect parameter.\n");
            source.append("\t\t *\n");
            source.append("\t\t * @param raise_exception\n");
            source.append("\t\t *            the exception to be raised\n");
            source.append("\t\t * @param destination_component\n");
            source.append("\t\t *            the target component to send the message to.\n");
            source.append("\t\t * @param timestamp_redirect\n");
            source.append("\t\t *            the redirected timestamp if any.\n");
            source.append("\t\t * */\n");
            source.append(MessageFormat.format("\t\tpublic void raise(final {0}_exception raise_exception, final TitanComponent destination_component, final TitanFloat timestamp_redirect) '{'\n", info.mJavaTypeName));
            source.append("\t\t\tif (!is_started) {\n");
            source.append("\t\t\t\tthrow new TtcnError(MessageFormat.format(\"Raising an exception on port {0}, which is not started.\", get_name()));\n");
            source.append("\t\t\t}\n");
            source.append("\t\t\tif (!destination_component.is_bound()) {\n");
            source.append("\t\t\t\tthrow new TtcnError(\"Unbound component reference in the to clause of raise operation.\");\n");
            source.append("\t\t\t}\n\n");
            source.append("\t\t\tfinal TTCN_Logger.Severity log_sev = destination_component.get_component() == TitanComponent.SYSTEM_COMPREF ? TTCN_Logger.Severity.PORTEVENT_PMOUT : TTCN_Logger.Severity.PORTEVENT_PCOUT;\n");
            source.append("\t\t\tif (TTCN_Logger.log_this_event(log_sev)) {\n");
            source.append("\t\t\t\tTTCN_Logger.begin_event(TTCN_Logger.Severity.PORTEVENT_PMOUT);\n");
            source.append("\t\t\t\traise_exception.log();\n");
            source.append("\t\t\t\tTTCN_Logger.log_procport_send(get_name(), TitanLoggerApi.Port__oper.enum_type.exception__op, destination_component.get_component(), new TitanCharString(\"\"), TTCN_Logger.end_event_log2str());\n");
            source.append("\t\t\t}\n");
            source.append("\t\t\tif (destination_component.get_component() == TitanComponent.SYSTEM_COMPREF) {\n");
            if (portDefinition.testportType == TestportType.INTERNAL) {
                source.append("\t\t\t\tthrow new TtcnError(MessageFormat.format(\"Internal port {0} cannot raise an exception to system.\", get_name()));\n");
            } else {
                source.append("\t\t\t\toutgoing_raise(raise_exception");
                if (portDefinition.testportType == TestportType.ADDRESS) {
                    source.append(", null");
                }
                if (portDefinition.realtime) {
                    source.append(", timestamp_redirect");
                }
                source.append(");\n");
            }
            source.append("\t\t\t} else {\n");
            source.append("\t\t\t\tfinal Text_Buf text_buf = new Text_Buf();\n");
            source.append(MessageFormat.format("\t\t\t\tprepare_exception(text_buf, in_procedure_names[{0}]);\n", index));
            source.append(MessageFormat.format("\t\t\t\t//\"{0}\"\n", info.mDisplayName));
            source.append("\t\t\t\traise_exception.encode_text(text_buf);\n");
            source.append("\t\t\t\tsend_data(text_buf, destination_component);\n");
            source.append("\t\t\t}\n");
            source.append("\t\t}\n\n");
            if (portDefinition.testportType == TestportType.ADDRESS) {
                source.append(MessageFormat.format("\t\tpublic void raise(final {0}_exception raise_exception, final {1} destination_address, final TitanFloat timestamp_redirect) '{'\n", info.mJavaTypeName, portDefinition.addressName));
                source.append("\t\t\tif (!is_started) {\n");
                source.append("\t\t\t\tthrow new TtcnError(MessageFormat.format(\"Raising an exception on port {0}, which is not started.\", get_name()));\n");
                source.append("\t\t\t}\n");
                source.append("\t\t\tif (TTCN_Logger.log_this_event(TTCN_Logger.Severity.PORTEVENT_PMOUT)) {");
                source.append("\t\t\t\tTTCN_Logger.begin_event(TTCN_Logger.Severity.PORTEVENT_PMOUT);\n");
                source.append("\t\t\t\tdestination_address.log();\n");
                source.append("\t\t\t\tfinal TitanCharString log_temp = TTCN_Logger.end_event_log2str();\n");
                source.append("\t\t\t\tTTCN_Logger.begin_event(TTCN_Logger.Severity.PORTEVENT_PMOUT);\n");
                source.append("\t\t\t\traise_exception.log();\n");
                source.append("\t\t\t\tTTCN_Logger.log_procport_send(get_name(), TitanLoggerApi.Port__oper.enum_type.exception__op, TitanComponent.SYSTEM_COMPREF, log_temp, TTCN_Logger.end_event_log2str());\n");
                source.append("\t\t\t}\n");
                source.append("\t\t\toutgoing_raise(raise_exception, destination_address");
                if (portDefinition.realtime) {
                    source.append(", timestamp_redirect");
                }
                source.append(");\n");
                source.append("\t\t}\n\n");
            }
            source.append("\t\t/**\n");
            source.append(MessageFormat.format("\t\t * Raise the exception of {0} signature on the default component.\n", info.mDisplayName));
            source.append("\t\t * <p>\n");
            source.append("\t\t * When timestamp redirection is support the timestamp will be made\n");
            source.append("\t\t * available in the timestamp_Redirect parameter.\n");
            source.append("\t\t *\n");
            source.append("\t\t * @param raise_exception\n");
            source.append("\t\t *            the exception to be raised\n");
            source.append("\t\t * @param timestamp_redirect\n");
            source.append("\t\t *            the redirected timestamp if any.\n");
            source.append("\t\t * */\n");
            source.append(MessageFormat.format("\t\tpublic void raise(final {0}_exception raise_exception, final TitanFloat timestamp_redirect) '{'\n", info.mJavaTypeName));
            source.append("\t\t\traise(raise_exception, new TitanComponent(get_default_destination()), timestamp_redirect);\n");
            source.append("\t\t}\n\n");
        }
    }

    private static void generateGenericGetcall(JavaGenData aData, StringBuilder source, PortDefinition portDefinition, boolean isCheck, boolean isAddress) {
        String functionName = isCheck ? "check_getcall" : "getcall";
        String printedFunctionName = isCheck ? "Check-getcall" : "Getcall";
        String senderType = isAddress ? portDefinition.addressName : "TitanComponent";
        String allowOmitInValueList = aData.getAllowOmitInValueList() ? "true" : "false";
        source.append(MessageFormat.format("\t\tpublic TitanAlt_Status {0}(final {1}_template sender_template, final {1} sender_pointer, final TitanFloat timestamp_redirect, final Index_Redirect index_redirect) '{'\n", functionName, senderType));
        source.append("\t\t\tif (procedure_queue.size() == 0) {\n");
        source.append("\t\t\t\tif(is_started) {\n");
        source.append("\t\t\t\t\treturn TitanAlt_Status.ALT_MAYBE;\n");
        source.append("\t\t\t\t} else {\n");
        source.append("\t\t\t\t\tTTCN_Logger.log_str(TTCN_Logger.Severity.MATCHING_PROBLEM, MessageFormat.format(\"Matching on port {0} failed: Port is not started and the queue is empty.\", get_name()));\n");
        source.append("\t\t\t\t\treturn TitanAlt_Status.ALT_NO;\n");
        source.append("\t\t\t\t}\n");
        source.append("\t\t\t}\n");
        source.append("\t\t\tfinal Procedure_queue_item head = procedure_queue.getFirst();\n");
        if (isAddress) {
            source.append("\t\t\tif (head.sender_component != TitanComponent.SYSTEM_COMPREF) {\n");
            source.append("\t\t\t\tTTCN_Logger.log_str(TTCN_Logger.Severity.MATCHING_PMUNSUCC, MessageFormat.format(\"Matching on port {0} failed: Sender of the first entity in the queue is not the system.\", get_name()));\n");
            source.append("\t\t\t\treturn TitanAlt_Status.ALT_NO;\n");
            source.append("\t\t\t} else if (head.sender_address == null) {\n");
            source.append(MessageFormat.format("\t\t\t\tthrow new TtcnError(MessageFormat.format(\"{0} operation on port '{'0'}' requires the address of the sender, which was not given by the test port.\", get_name()));\n", printedFunctionName));
            source.append(MessageFormat.format("\t\t\t} else if (!sender_template.match(head.sender_address, {0})) '{'\n", allowOmitInValueList));
            source.append("\t\t\t\tif (TTCN_Logger.log_this_event(TTCN_Logger.Severity.MATCHING_PMUNSUCC)) {\n");
            source.append("\t\t\t\t\tTTCN_Logger.begin_event(TTCN_Logger.Severity.MATCHING_PMUNSUCC);\n");
            source.append(MessageFormat.format("\t\t\t\t\tsender_template.log_match(head.sender_address, {0});\n", allowOmitInValueList));
            source.append("\t\t\t\t\tTTCN_Logger.log_matching_failure(TitanLoggerApi.PortType.enum_type.procedure__, get_name(), TitanComponent.SYSTEM_COMPREF, TitanLoggerApi.MatchingFailureType_reason.enum_type.sender__does__not__match__from__clause, TTCN_Logger.end_event_log2str());\n");
            source.append("\t\t\t\t}\n");
            source.append("\t\t\t\treturn TitanAlt_Status.ALT_NO;\n");
            source.append("\t\t\t}\n");
        } else {
            source.append(MessageFormat.format("\t\t\tif (!sender_template.match(head.sender_component, {0})) '{'\n", allowOmitInValueList));
            source.append("\t\t\t\tfinal TTCN_Logger.Severity log_sev = head.sender_component == TitanComponent.SYSTEM_COMPREF ? TTCN_Logger.Severity.MATCHING_PMUNSUCC : TTCN_Logger.Severity.MATCHING_PCUNSUCC;\n");
            source.append("\t\t\t\tif (TTCN_Logger.log_this_event(log_sev)) {\n");
            source.append("\t\t\t\t\tTTCN_Logger.begin_event(log_sev);\n");
            source.append("\t\t\t\t\tTTCN_Logger.log_event_str(MessageFormat.format(\"Matching on port {0} failed: Sender of the first entity in the queue does not match the from clause: \", get_name()));\n");
            source.append(MessageFormat.format("\t\t\t\t\tsender_template.log_match(new TitanComponent(head.sender_component), {0});\n", allowOmitInValueList));
            source.append("\t\t\t\t\tTTCN_Logger.end_event();\n");
            source.append("\t\t\t\t}\n");
            source.append("\t\t\t\treturn TitanAlt_Status.ALT_NO;\n");
            source.append("\t\t\t}\n");
        }
        source.append("\t\t\tswitch (head.item_selection) {\n");
        for (int i = 0; i < portDefinition.inProcedures.size(); ++i) {
            source.append(MessageFormat.format("\t\t\tcase CALL_{0}:\n", i));
        }
        source.append("\t\t\t{\n");
        if (portDefinition.realtime) {
            source.append("\t\t\t\tif (timestamp_redirect != null && head.timestamp.is_bound()) {\n");
            source.append("\t\t\t\t\ttimestamp_redirect.operator_assign(head.timestamp);\n");
            source.append("\t\t\t\t}\n");
        }
        source.append("\t\t\t\tif (sender_pointer != null) {\n");
        if (isAddress) {
            source.append("\t\t\t\t\tsender_pointer.operator_assign(head.sender_address);\n");
        } else {
            source.append("\t\t\t\t\tsender_pointer.operator_assign(head.sender_component);\n");
        }
        source.append("\t\t\t\t}\n");
        if (isAddress) {
            source.append("\t\t\t\tTTCN_Logger.log(TTCN_Logger.Severity.MATCHING_PMSUCCESS,  MessageFormat.format(\"Matching on port {0} succeeded.\", get_name()));\n");
            source.append("\t\t\t\tif (TTCN_Logger.log_this_event(TTCN_Logger.Severity.PORTEVENT_PMIN)) {\n");
            source.append(MessageFormat.format("\t\t\t\t\tTTCN_Logger.log_procport_recv(get_name(), TitanLoggerApi.Port__oper.enum_type.call__op, head.sender_component, {0}, new TitanCharString(\"\"), msg_head_count+1);\n", isCheck ? "true" : "false"));
            source.append("\t\t\t\t}\n");
        } else {
            source.append("\t\t\t\tTTCN_Logger.log(head.sender_component == TitanComponent.SYSTEM_COMPREF ? TTCN_Logger.Severity.MATCHING_PMSUCCESS : TTCN_Logger.Severity.MATCHING_PCSUCCESS,  MessageFormat.format(\"Matching on port {0} succeeded.\", get_name()));\n");
            source.append("\t\t\t\tfinal TTCN_Logger.Severity log_sev = head.sender_component ==  TitanComponent.SYSTEM_COMPREF ? TTCN_Logger.Severity.PORTEVENT_PMIN : TTCN_Logger.Severity.PORTEVENT_PCIN;\n");
            source.append("\t\t\t\tif (TTCN_Logger.log_this_event(log_sev)) {\n");
            source.append(MessageFormat.format("\t\t\t\t\tTTCN_Logger.log_procport_recv(get_name(), TitanLoggerApi.Port__oper.enum_type.call__op, head.sender_component, {0} ,new TitanCharString(\"\"), msg_head_count+1);\n", isCheck ? "true" : "false"));
            source.append("\t\t\t\t}\n");
        }
        if (!isCheck) {
            source.append("\t\t\t\tremove_proc_queue_head();\n");
        }
        source.append("\t\t\t\treturn TitanAlt_Status.ALT_YES;\n");
        source.append("\t\t\t}\n");
        source.append("\t\t\tdefault:\n");
        source.append(MessageFormat.format("\t\t\t\tTTCN_Logger.log({0}, MessageFormat.format(\"Matching on port '{'0'}' failed: First entity in the queue is not a call.\", get_name()));\n", isAddress ? "TTCN_Logger.Severity.MATCHING_PMUNSUCC" : "head.sender_component == TitanComponent.SYSTEM_COMPREF ? TTCN_Logger.Severity.MATCHING_PMUNSUCC : TTCN_Logger.Severity.MATCHING_PCUNSUCC"));
        source.append("\t\t\t\treturn TitanAlt_Status.ALT_NO;\n");
        source.append("\t\t\t}\n");
        source.append("\t\t}\n\n");
    }

    private static void generateTypedGetcall(JavaGenData aData, StringBuilder source, PortDefinition portDefinition, int index, procedureSignatureInfo info, boolean isCheck, boolean isAddress) {
        String functionName = isCheck ? "check_getcall" : "getcall";
        String printedFunctionName = isCheck ? "Check-getcall" : "Getcall";
        String senderType = isAddress ? portDefinition.addressName : "TitanComponent";
        String allowOmitInValueList = aData.getAllowOmitInValueList() ? "true" : "false";
        source.append(MessageFormat.format("\t\tpublic TitanAlt_Status {0}(final {1}_template getcall_template, final {2}_template sender_template, final {1}_call_redirect param_ref, final {2} sender_pointer, final TitanFloat timestamp_redirect, final Index_Redirect index_redirect) '{'\n", functionName, info.mJavaTypeName, senderType));
        source.append("\t\t\tif (procedure_queue.size() == 0) {\n");
        source.append("\t\t\t\tif(is_started) {\n");
        source.append("\t\t\t\t\treturn TitanAlt_Status.ALT_MAYBE;\n");
        source.append("\t\t\t\t} else {\n");
        source.append("\t\t\t\t\tTTCN_Logger.log_str(TTCN_Logger.Severity.MATCHING_PROBLEM, MessageFormat.format(\"Matching on port {0} failed: Port is not started and the queue is empty.\", get_name()));\n");
        source.append("\t\t\t\t\treturn TitanAlt_Status.ALT_NO;\n");
        source.append("\t\t\t\t}\n");
        source.append("\t\t\t}\n");
        source.append("\t\t\tfinal Procedure_queue_item head = procedure_queue.getFirst();\n");
        if (isAddress) {
            source.append("\t\t\tif (head.sender_component != TitanComponent.SYSTEM_COMPREF) {\n");
            source.append("\t\t\t\tTTCN_Logger.log_matching_failure(TitanLoggerApi.PortType.enum_type.procedure__, get_name(), head.sender_component, TitanLoggerApi.MatchingFailureType_reason.enum_type.sender__is__not__system, new TitanCharString(\"\"));\n");
            source.append("\t\t\t\treturn TitanAlt_Status.ALT_NO;\n");
            source.append("\t\t\t} else if (head.sender_address == null) {\n");
            source.append(MessageFormat.format("\t\t\t\tthrow new TtcnError(MessageFormat.format(\"{0} operation on port '{'0'}' requires the address of the sender, which was not given by the test port.\", get_name()));\n", printedFunctionName));
            source.append(MessageFormat.format("\t\t\t'}' else if (!sender_template.match(head.sender_address, {0} )) '{'\n", allowOmitInValueList));
            source.append("\t\t\t\tif (TTCN_Logger.log_this_event(TTCN_Logger.Severity.MATCHING_PMUNSUCC)) {\n");
            source.append("\t\t\t\t\tTTCN_Logger.begin_event(TTCN_Logger.Severity.MATCHING_PMUNSUCC);\n");
            source.append(MessageFormat.format("\t\t\t\t\tsender_template.log_match(head.sender_address, {0} );\n", allowOmitInValueList));
            source.append("\t\t\t\t\tTTCN_Logger.log_matching_failure(TitanLoggerApi.PortType.enum_type.procedure__, get_name(), TitanComponent.SYSTEM_COMPREF, TitanLoggerApi.MatchingFailureType_reason.enum_type.sender__does__not__match__from__clause, TTCN_Logger.end_event_log2str());\n");
            source.append("\t\t\t\t}\n");
            source.append("\t\t\t\treturn TitanAlt_Status.ALT_NO;\n");
            source.append("\t\t\t}");
        } else {
            source.append(MessageFormat.format("\t\t\tif (!sender_template.match(head.sender_component, {0} )) '{'\n", allowOmitInValueList));
            source.append("\t\t\t\tfinal TTCN_Logger.Severity log_sev = head.sender_component == TitanComponent.SYSTEM_COMPREF ? TTCN_Logger.Severity.MATCHING_PMUNSUCC : TTCN_Logger.Severity.MATCHING_PCUNSUCC;\n");
            source.append("\t\t\t\tif (TTCN_Logger.log_this_event(log_sev)) {\n");
            source.append("\t\t\t\t\tTTCN_Logger.begin_event(log_sev);\n");
            source.append(MessageFormat.format("\t\t\t\t\tsender_template.log_match(new TitanComponent(head.sender_component), {0} );\n", allowOmitInValueList));
            source.append("\t\t\t\t\tTTCN_Logger.log_matching_failure(TitanLoggerApi.PortType.enum_type.procedure__, get_name(), head.sender_component, TitanLoggerApi.MatchingFailureType_reason.enum_type.sender__does__not__match__from__clause, TTCN_Logger.end_event_log2str());\n");
            source.append("\t\t\t\t}\n");
            source.append("\t\t\t\treturn TitanAlt_Status.ALT_NO;\n");
            source.append("\t\t\t}");
        }
        source.append(MessageFormat.format(" else if (head.item_selection != proc_selection.CALL_{0}) '{'\n", index));
        source.append(MessageFormat.format("\t\t\t\tTTCN_Logger.log({0}, MessageFormat.format(\"Matching on port '{'0'}' failed: The first entity in the queue is not a call for signature {1}.\", get_name()));\n", isAddress ? "TTCN_Logger.Severity.MATCHING_PMUNSUCC" : "head.sender_component == TitanComponent.SYSTEM_COMPREF ? TTCN_Logger.Severity.MATCHING_PMUNSUCC : TTCN_Logger.Severity.MATCHING_PCUNSUCC", portDefinition.displayName));
        source.append("\t\t\t\treturn TitanAlt_Status.ALT_NO;\n");
        source.append(MessageFormat.format("\t\t\t'}' else if (!getcall_template.match_call(head.call_{0}, {1})) '{'\n", index, allowOmitInValueList));
        source.append(MessageFormat.format("\t\t\t\tfinal TTCN_Logger.Severity log_sev = {0};\n", isAddress ? "TTCN_Logger.Severity.MATCHING_PMUNSUCC" : "head.sender_component == TitanComponent.SYSTEM_COMPREF ? TTCN_Logger.Severity.MATCHING_PMUNSUCC : TTCN_Logger.Severity.MATCHING_PCUNSUCC"));
        source.append("\t\t\t\tif (TTCN_Logger.log_this_event(log_sev)) {\n");
        source.append("\t\t\t\t\tTTCN_Logger.begin_event(log_sev);\n");
        source.append(MessageFormat.format("\t\t\t\t\tgetcall_template.log_match_call(head.call_{0}, {1});\n", index, allowOmitInValueList));
        source.append("\t\t\t\t\tTTCN_Logger.log_matching_failure(TitanLoggerApi.PortType.enum_type.procedure__, get_name(), head.sender_component, TitanLoggerApi.MatchingFailureType_reason.enum_type.parameters__of__call__do__not__match__template, TTCN_Logger.end_event_log2str());\n");
        source.append("\t\t\t\t}\n");
        source.append("\t\t\t\treturn TitanAlt_Status.ALT_NO;\n");
        source.append("\t\t\t} else {\n");
        source.append(MessageFormat.format("\t\t\t\tparam_ref.set_parameters(head.call_{0});\n", index));
        if (portDefinition.realtime) {
            source.append("\t\t\t\tif (timestamp_redirect != null && head.timestamp.is_bound()) {\n");
            source.append("\t\t\t\t\ttimestamp_redirect.operator_assign(head.timestamp);\n");
            source.append("\t\t\t\t}\n");
        }
        source.append("\t\t\t\tif (sender_pointer != null) {\n");
        if (isAddress) {
            source.append("\t\t\t\t\tsender_pointer.operator_assign(head.sender_address);\n");
        } else {
            source.append("\t\t\t\t\tsender_pointer.operator_assign(head.sender_component);\n");
        }
        source.append("\t\t\t\t}\n");
        PortGenerator.generate_proc_incoming_data_logging(source, "call", "getcall_template.log_match_call", isAddress, isCheck, index);
        if (!isCheck) {
            source.append("\t\t\t\tremove_proc_queue_head();\n");
        }
        source.append("\t\t\t\treturn TitanAlt_Status.ALT_YES;\n");
        source.append("\t\t\t}\n");
        source.append("\t\t}\n\n");
    }

    private static void generateGenericGetreply(JavaGenData aData, StringBuilder source, PortDefinition portDefinition, boolean isCheck, boolean isAddress) {
        String functionName = isCheck ? "check_getreply" : "getreply";
        String printedFunctionName = isCheck ? "Check-getreply" : "Getreply";
        String senderType = isAddress ? portDefinition.addressName : "TitanComponent";
        String allowOmitInValueList = aData.getAllowOmitInValueList() ? "true" : "false";
        source.append(MessageFormat.format("\t\tpublic TitanAlt_Status {0}(final {1}_template sender_template, final {1} sender_pointer, final TitanFloat timestamp_redirect, final Index_Redirect index_redirect) '{'\n", functionName, senderType));
        source.append("\t\t\tif (procedure_queue.size() == 0) {\n");
        source.append("\t\t\t\tif(is_started) {\n");
        source.append("\t\t\t\t\treturn TitanAlt_Status.ALT_MAYBE;\n");
        source.append("\t\t\t\t} else {\n");
        source.append("\t\t\t\t\tTTCN_Logger.log_str(TTCN_Logger.Severity.MATCHING_PROBLEM, MessageFormat.format(\"Matching on port {0} failed: Port is not started and the queue is empty.\", get_name()));\n");
        source.append("\t\t\t\t\treturn TitanAlt_Status.ALT_NO;\n");
        source.append("\t\t\t\t}\n");
        source.append("\t\t\t}\n");
        source.append("\t\t\tfinal Procedure_queue_item head = procedure_queue.getFirst();\n");
        if (isAddress) {
            source.append("\t\t\tif (head.sender_component != TitanComponent.SYSTEM_COMPREF) {\n");
            source.append("\t\t\t\tTTCN_Logger.log_str(TTCN_Logger.Severity.MATCHING_PMUNSUCC, MessageFormat.format(\"Matching on port {0} failed: Sender of the first entity in the queue is not the system.\", get_name()));\n");
            source.append("\t\t\t\treturn TitanAlt_Status.ALT_NO;\n");
            source.append("\t\t\t} else if (head.sender_address == null) {\n");
            source.append(MessageFormat.format("\t\t\t\tthrow new TtcnError(MessageFormat.format(\"{0} operation on port '{'0'}' requires the address of the sender, which was not given by the test port.\", get_name()));\n", printedFunctionName));
            source.append(MessageFormat.format("\t\t\t} else if (!sender_template.match(head.sender_address, {0})) '{'\n", allowOmitInValueList));
            source.append("\t\t\t\tif (TTCN_Logger.log_this_event(TTCN_Logger.Severity.MATCHING_PMUNSUCC)) {\n");
            source.append("\t\t\t\t\tTTCN_Logger.begin_event(TTCN_Logger.Severity.MATCHING_PMUNSUCC);\n");
            source.append(MessageFormat.format("\t\t\t\t\tsender_template.log_match(head.sender_address, {0});\n", allowOmitInValueList));
            source.append("\t\t\t\t\tTTCN_Logger.log_matching_failure(TitanLoggerApi.PortType.enum_type.procedure__, get_name(), TitanComponent.SYSTEM_COMPREF, TitanLoggerApi.MatchingFailureType_reason.enum_type.sender__does__not__match__from__clause, TTCN_Logger.end_event_log2str());\n");
            source.append("\t\t\t\t}\n");
            source.append("\t\t\t\treturn TitanAlt_Status.ALT_NO;\n");
            source.append("\t\t\t}\n");
        } else {
            source.append(MessageFormat.format("\t\t\tif (!sender_template.match(head.sender_component, {0})) '{'\n", allowOmitInValueList));
            source.append("\t\t\t\tfinal TTCN_Logger.Severity log_sev = head.sender_component == TitanComponent.SYSTEM_COMPREF ? TTCN_Logger.Severity.MATCHING_PMUNSUCC : TTCN_Logger.Severity.MATCHING_PCUNSUCC;\n");
            source.append("\t\t\t\tif (TTCN_Logger.log_this_event(log_sev)) {\n");
            source.append("\t\t\t\t\tTTCN_Logger.begin_event(log_sev);\n");
            source.append("\t\t\t\t\tTTCN_Logger.log_event_str(MessageFormat.format(\"Matching on port {0} failed: Sender of the first entity in the queue does not match the from clause: \", get_name()));\n");
            source.append(MessageFormat.format("\t\t\t\t\tsender_template.log_match(new TitanComponent(head.sender_component), {0});\n", allowOmitInValueList));
            source.append("\t\t\t\t\tTTCN_Logger.end_event();\n");
            source.append("\t\t\t\t}\n");
            source.append("\t\t\t\treturn TitanAlt_Status.ALT_NO;\n");
            source.append("\t\t\t}\n");
        }
        source.append("\t\t\tswitch (head.item_selection) {\n");
        for (int i = 0; i < portDefinition.outProcedures.size(); ++i) {
            if (portDefinition.outProcedures.get(i).isNoBlock) continue;
            source.append(MessageFormat.format("\t\t\tcase REPLY_{0}:\n", i));
        }
        source.append("\t\t\t{\n");
        if (portDefinition.realtime) {
            source.append("\t\t\t\tif (timestamp_redirect != null && head.timestamp.is_bound()) {\n");
            source.append("\t\t\t\t\ttimestamp_redirect.operator_assign(head.timestamp);\n");
            source.append("\t\t\t\t}\n");
        }
        source.append("\t\t\t\tif (sender_pointer != null) {\n");
        if (isAddress) {
            source.append("\t\t\t\t\tsender_pointer.operator_assign(head.sender_address);\n");
        } else {
            source.append("\t\t\t\t\tsender_pointer.operator_assign(head.sender_component);\n");
        }
        source.append("\t\t\t\t}\n");
        if (isAddress) {
            source.append("\t\t\t\tTTCN_Logger.log(TTCN_Logger.Severity.MATCHING_PMSUCCESS,  MessageFormat.format(\"Matching on port {0} succeeded.\", get_name()));\n");
            source.append("\t\t\t\tif (TTCN_Logger.log_this_event(TTCN_Logger.Severity.PORTEVENT_PMIN)) {\n");
            source.append(MessageFormat.format("\t\t\t\t\tTTCN_Logger.log_procport_recv(get_name(), TitanLoggerApi.Port__oper.enum_type.reply__op, head.sender_component, {0}, new TitanCharString(\"\"), msg_head_count+1);\n", isCheck ? "true" : "false"));
            source.append("\t\t\t\t}\n");
        } else {
            source.append("\t\t\t\tTTCN_Logger.log(head.sender_component == TitanComponent.SYSTEM_COMPREF ? TTCN_Logger.Severity.MATCHING_PMSUCCESS : TTCN_Logger.Severity.MATCHING_PCSUCCESS,  MessageFormat.format(\"Matching on port {0} succeeded.\", get_name()));\n");
            source.append("\t\t\t\tfinal TTCN_Logger.Severity log_sev = head.sender_component ==  TitanComponent.SYSTEM_COMPREF ? TTCN_Logger.Severity.PORTEVENT_PMIN : TTCN_Logger.Severity.PORTEVENT_PCIN;\n");
            source.append("\t\t\t\tif (TTCN_Logger.log_this_event(log_sev)) {\n");
            source.append(MessageFormat.format("\t\t\t\t\tTTCN_Logger.log_procport_recv(get_name(), TitanLoggerApi.Port__oper.enum_type.reply__op, head.sender_component, {0} ,new TitanCharString(\"\"), msg_head_count+1);\n", isCheck ? "true" : "false"));
            source.append("\t\t\t\t}\n");
        }
        if (!isCheck) {
            source.append("\t\t\t\tremove_proc_queue_head();\n");
        }
        source.append("\t\t\t\treturn TitanAlt_Status.ALT_YES;\n");
        source.append("\t\t\t}\n");
        source.append("\t\t\tdefault:\n");
        source.append(MessageFormat.format("\t\t\t\tTTCN_Logger.log({0}, MessageFormat.format(\"Matching on port '{'0'}' failed: First entity in the queue is not a reply.\", get_name()));\n", isAddress ? "TTCN_Logger.Severity.MATCHING_PMUNSUCC" : "head.sender_component == TitanComponent.SYSTEM_COMPREF ? TTCN_Logger.Severity.MATCHING_PMUNSUCC : TTCN_Logger.Severity.MATCHING_PCUNSUCC"));
        source.append("\t\t\t\treturn TitanAlt_Status.ALT_NO;\n");
        source.append("\t\t\t}\n");
        source.append("\t\t}\n\n");
    }

    private static void generateTypedGetreply(JavaGenData aData, StringBuilder source, PortDefinition portDefinition, int index, procedureSignatureInfo info, boolean isCheck, boolean isAddress) {
        String functionName = isCheck ? "check_getreply" : "getreply";
        String printedFunctionName = isCheck ? "Check-getreply" : "Getreply";
        String senderType = isAddress ? portDefinition.addressName : "TitanComponent";
        String allowOmitInValueList = aData.getAllowOmitInValueList() ? "true" : "false";
        source.append(MessageFormat.format("\t\tpublic TitanAlt_Status {0}(final {1}_template getreply_template, final {2}_template sender_template, final {1}_reply_redirect param_ref, final {2} sender_pointer, final TitanFloat timestamp_redirect, final Index_Redirect index_redirect) '{'\n", functionName, info.mJavaTypeName, senderType));
        if (info.hasReturnValue) {
            source.append("\t\t\tif (getreply_template.return_value().get_selection() == template_sel.ANY_OR_OMIT) {\n");
            source.append(MessageFormat.format("\t\t\t\tthrow new TtcnError(\"{0} operation using '''*''' as return value matching template\");\n", printedFunctionName));
            source.append("\t\t\t}\n");
        }
        source.append("\t\t\tif (procedure_queue.size() == 0) {\n");
        source.append("\t\t\t\tif(is_started) {\n");
        source.append("\t\t\t\t\treturn TitanAlt_Status.ALT_MAYBE;\n");
        source.append("\t\t\t\t} else {\n");
        source.append("\t\t\t\t\tTTCN_Logger.log_str(TTCN_Logger.Severity.MATCHING_PROBLEM, MessageFormat.format(\"Matching on port {0} failed: Port is not started and the queue is empty.\", get_name()));\n");
        source.append("\t\t\t\t\treturn TitanAlt_Status.ALT_NO;\n");
        source.append("\t\t\t\t}\n");
        source.append("\t\t\t}\n");
        source.append("\t\t\tfinal Procedure_queue_item head = procedure_queue.getFirst();\n");
        if (isAddress) {
            source.append("\t\t\tif (head.sender_component != TitanComponent.SYSTEM_COMPREF) {\n");
            source.append("\t\t\t\tTTCN_Logger.log_str(TTCN_Logger.Severity.MATCHING_PMUNSUCC, MessageFormat.format(\"Matching on port {0} failed: Sender of the first entity in the queue is not the system.\", get_name()));\n");
            source.append("\t\t\t\treturn TitanAlt_Status.ALT_NO;\n");
            source.append("\t\t\t} else if (head.sender_address == null) {\n");
            source.append(MessageFormat.format("\t\t\t\tthrow new TtcnError(MessageFormat.format(\"{0} operation on port '{'0'}' requires the address of the sender, which was not given by the test port.\", get_name()));\n", printedFunctionName));
            source.append(MessageFormat.format("\t\t\t} else if (!sender_template.match(head.sender_address, {0})) '{'\n", allowOmitInValueList));
            source.append("\t\t\t\tif (TTCN_Logger.log_this_event(TTCN_Logger.Severity.MATCHING_PMUNSUCC)) {\n");
            source.append("\t\t\t\t\tTTCN_Logger.begin_event(TTCN_Logger.Severity.MATCHING_PMUNSUCC);\n");
            source.append(MessageFormat.format("\t\t\t\t\tsender_template.log_match(head.sender_address, {0});\n", allowOmitInValueList));
            source.append("\t\t\t\t\tTTCN_Logger.log_matching_failure(TitanLoggerApi.PortType.enum_type.procedure__, get_name(), TitanComponent.SYSTEM_COMPREF, TitanLoggerApi.MatchingFailureType_reason.enum_type.sender__does__not__match__from__clause, TTCN_Logger.end_event_log2str());\n");
            source.append("\t\t\t\t}\n");
            source.append("\t\t\t\treturn TitanAlt_Status.ALT_NO;\n");
            source.append("\t\t\t}");
        } else {
            source.append(MessageFormat.format("\t\t\tif (!sender_template.match(head.sender_component, {0})) '{'\n", allowOmitInValueList));
            source.append("\t\t\t\tfinal TTCN_Logger.Severity log_sev = head.sender_component == TitanComponent.SYSTEM_COMPREF ? TTCN_Logger.Severity.MATCHING_PMUNSUCC : TTCN_Logger.Severity.MATCHING_PCUNSUCC;\n");
            source.append("\t\t\t\tif (TTCN_Logger.log_this_event(log_sev)) {\n");
            source.append("\t\t\t\t\tTTCN_Logger.begin_event(log_sev);\n");
            source.append("\t\t\t\t\tTTCN_Logger.log_event_str(MessageFormat.format(\"Matching on port {0} failed: Sender of the first entity in the queue does not match the from clause: \", get_name()));\n");
            source.append(MessageFormat.format("\t\t\t\t\tsender_template.log_match(new TitanComponent(head.sender_component), {0});\n", allowOmitInValueList));
            source.append("\t\t\t\t\tTTCN_Logger.end_event();\n");
            source.append("\t\t\t\t}\n");
            source.append("\t\t\t\treturn TitanAlt_Status.ALT_NO;\n");
            source.append("\t\t\t}");
        }
        source.append(MessageFormat.format(" else if (head.item_selection != proc_selection.REPLY_{0}) '{'\n", index));
        source.append(MessageFormat.format("\t\t\t\tTTCN_Logger.log({0}, MessageFormat.format(\"Matching on port '{'0'}' failed: The first entity in the queue is not a reply for signature {1}.\", get_name()));\n ", isAddress ? "TTCN_Logger.Severity.MATCHING_PMUNSUCC" : "head.sender_component == TitanComponent.SYSTEM_COMPREF ? TTCN_Logger.Severity.MATCHING_PMUNSUCC : TTCN_Logger.Severity.MATCHING_PCUNSUCC", portDefinition.displayName));
        source.append("\t\t\t\treturn TitanAlt_Status.ALT_NO;\n");
        source.append(MessageFormat.format("\t\t\t'}' else if (!getreply_template.match_reply(head.reply_{0}, {1})) '{'\n", index, allowOmitInValueList));
        source.append(MessageFormat.format("\t\t\t\tfinal TTCN_Logger.Severity log_sev = {0};\n", isAddress ? "TTCN_Logger.Severity.MATCHING_PMUNSUCC" : "head.sender_component == TitanComponent.SYSTEM_COMPREF ? TTCN_Logger.Severity.MATCHING_PMUNSUCC : TTCN_Logger.Severity.MATCHING_PCUNSUCC"));
        source.append("\t\t\t\tif (TTCN_Logger.log_this_event(log_sev)) {\n");
        source.append("\t\t\t\t\tTTCN_Logger.begin_event(log_sev);\n");
        source.append(MessageFormat.format("\t\t\t\t\tgetreply_template.log_match_reply(head.reply_{0}, {1});\n", index, allowOmitInValueList));
        source.append("\t\t\t\t\tTTCN_Logger.log_matching_failure(TitanLoggerApi.PortType.enum_type.procedure__, get_name(), head.sender_component, TitanLoggerApi.MatchingFailureType_reason.enum_type.parameters__of__reply__do__not__match__template, TTCN_Logger.end_event_log2str());\n");
        source.append("\t\t\t\t}\n");
        source.append("\t\t\t\treturn TitanAlt_Status.ALT_NO;\n");
        source.append("\t\t\t} else {\n");
        source.append(MessageFormat.format("\t\t\t\tparam_ref.set_parameters(head.reply_{0});\n", index));
        if (portDefinition.realtime) {
            source.append("\t\t\t\tif (timestamp_redirect != null && head.timestamp.is_bound()) {\n");
            source.append("\t\t\t\t\ttimestamp_redirect.operator_assign(head.timestamp);\n");
            source.append("\t\t\t\t}\n");
        }
        source.append("\t\t\t\tif (sender_pointer != null) {\n");
        if (isAddress) {
            source.append("\t\t\t\t\tsender_pointer.operator_assign(head.sender_address);\n");
        } else {
            source.append("\t\t\t\t\tsender_pointer.operator_assign(head.sender_component);\n");
        }
        source.append("\t\t\t\t}\n");
        PortGenerator.generate_proc_incoming_data_logging(source, "reply", "getreply_template.log_match_reply", isAddress, isCheck, index);
        if (!isCheck) {
            source.append("\t\t\t\tremove_proc_queue_head();\n");
        }
        source.append("\t\t\t\treturn TitanAlt_Status.ALT_YES;\n");
        source.append("\t\t\t}\n");
        source.append("\t\t}\n\n");
    }

    private static void generateGenericGetexception(JavaGenData aData, StringBuilder source, PortDefinition portDefinition, boolean isCheck, boolean isAddress) {
        String functionName = isCheck ? "check_catch" : "get_exception";
        String printedFunctionName = isCheck ? "Check-catch" : "Catch";
        String senderType = isAddress ? portDefinition.addressName : "TitanComponent";
        String allowOmitInValueList = aData.getAllowOmitInValueList() ? "true" : "false";
        source.append(MessageFormat.format("\t\tpublic TitanAlt_Status {0}(final {1}_template sender_template, final {1} sender_pointer, final TitanFloat timestamp_redirect, final Index_Redirect index_redirect) '{'\n", functionName, senderType));
        source.append("\t\t\tif (procedure_queue.size() == 0) {\n");
        source.append("\t\t\t\tif(is_started) {\n");
        source.append("\t\t\t\t\treturn TitanAlt_Status.ALT_MAYBE;\n");
        source.append("\t\t\t\t} else {\n");
        source.append("\t\t\t\t\tTTCN_Logger.log_str(TTCN_Logger.Severity.MATCHING_PROBLEM, MessageFormat.format(\"Matching on port {0} failed: Port is not started and the queue is empty.\", get_name()));\n");
        source.append("\t\t\t\t\treturn TitanAlt_Status.ALT_NO;\n");
        source.append("\t\t\t\t}\n");
        source.append("\t\t\t}\n");
        source.append("\t\t\tfinal Procedure_queue_item head = procedure_queue.getFirst();\n");
        if (isAddress) {
            source.append("\t\t\tif (head.sender_component != TitanComponent.SYSTEM_COMPREF) {\n");
            source.append("\t\t\t\tTTCN_Logger.log_str(TTCN_Logger.Severity.MATCHING_PMUNSUCC, MessageFormat.format(\"Matching on port {0} failed: Sender of the first entity in the queue is not the system.\", get_name()));\n");
            source.append("\t\t\t\treturn TitanAlt_Status.ALT_NO;\n");
            source.append("\t\t\t} else if (head.sender_address == null) {\n");
            source.append(MessageFormat.format("\t\t\t\tthrow new TtcnError(MessageFormat.format(\"{0} operation on port '{'0'}' requires the address of the sender, which was not given by the test port.\", get_name()));\n", printedFunctionName));
            source.append(MessageFormat.format("\t\t\t} else if (!sender_template.match(head.sender_address, {0})) '{'\n", allowOmitInValueList));
            source.append("\t\t\t\tif (TTCN_Logger.log_this_event(TTCN_Logger.Severity.MATCHING_PMUNSUCC)) {\n");
            source.append("\t\t\t\t\tTTCN_Logger.begin_event(TTCN_Logger.Severity.MATCHING_PMUNSUCC);\n");
            source.append(MessageFormat.format("\t\t\t\t\tsender_template.log_match(head.sender_address, {0});\n", allowOmitInValueList));
            source.append("\t\t\t\t\tTTCN_Logger.log_matching_failure(TitanLoggerApi.PortType.enum_type.procedure__, get_name(), TitanComponent.SYSTEM_COMPREF, TitanLoggerApi.MatchingFailureType_reason.enum_type.sender__does__not__match__from__clause, TTCN_Logger.end_event_log2str());\n");
            source.append("\t\t\t\t}\n");
            source.append("\t\t\t\treturn TitanAlt_Status.ALT_NO;\n");
            source.append("\t\t\t}\n");
        } else {
            source.append(MessageFormat.format("\t\t\tif (!sender_template.match(head.sender_component, {0})) '{'\n", allowOmitInValueList));
            source.append("\t\t\t\tfinal TTCN_Logger.Severity log_sev = head.sender_component == TitanComponent.SYSTEM_COMPREF ? TTCN_Logger.Severity.MATCHING_PMUNSUCC : TTCN_Logger.Severity.MATCHING_PCUNSUCC;\n");
            source.append("\t\t\t\tif (TTCN_Logger.log_this_event(log_sev)) {\n");
            source.append("\t\t\t\t\tTTCN_Logger.begin_event(log_sev);\n");
            source.append("\t\t\t\t\tTTCN_Logger.log_event_str(MessageFormat.format(\"Matching on port {0} failed: Sender of the first entity in the queue does not match the from clause: \", get_name()));\n");
            source.append(MessageFormat.format("\t\t\t\t\tsender_template.log_match(new TitanComponent(head.sender_component), {0});\n", allowOmitInValueList));
            source.append("\t\t\t\t\tTTCN_Logger.end_event();\n");
            source.append("\t\t\t\t}\n");
            source.append("\t\t\t\treturn TitanAlt_Status.ALT_NO;\n");
            source.append("\t\t\t}\n");
        }
        source.append("\t\t\tswitch (head.item_selection) {\n");
        for (int i = 0; i < portDefinition.outProcedures.size(); ++i) {
            if (!portDefinition.outProcedures.get(i).hasExceptions) continue;
            source.append(MessageFormat.format("\t\t\tcase EXCEPTION_{0}:\n", i));
        }
        source.append("\t\t\t{\n");
        if (portDefinition.realtime) {
            source.append("\t\t\t\tif (timestamp_redirect != null && head.timestamp.is_bound()) {\n");
            source.append("\t\t\t\t\ttimestamp_redirect.operator_assign(head.timestamp);\n");
            source.append("\t\t\t\t}\n");
        }
        source.append("\t\t\t\tif (sender_pointer != null) {\n");
        if (isAddress) {
            source.append("\t\t\t\t\tsender_pointer.operator_assign(head.sender_address);\n");
        } else {
            source.append("\t\t\t\t\tsender_pointer.operator_assign(head.sender_component);\n");
        }
        source.append("\t\t\t\t}\n");
        if (isAddress) {
            source.append("\t\t\t\tTTCN_Logger.log(TTCN_Logger.Severity.MATCHING_PMSUCCESS,  MessageFormat.format(\"Matching on port {0} succeeded.\", get_name()));\n");
            source.append("\t\t\t\tif (TTCN_Logger.log_this_event(TTCN_Logger.Severity.PORTEVENT_PMIN)) {\n");
            source.append(MessageFormat.format("\t\t\t\t\tTTCN_Logger.log_procport_recv(get_name(), TitanLoggerApi.Port__oper.enum_type.exception__op, head.sender_component, {0}, new TitanCharString(\"\"), msg_head_count+1);\n", isCheck ? "true" : "false"));
            source.append("\t\t\t\t}\n");
        } else {
            source.append("\t\t\t\tTTCN_Logger.log(head.sender_component == TitanComponent.SYSTEM_COMPREF ? TTCN_Logger.Severity.MATCHING_PMSUCCESS : TTCN_Logger.Severity.MATCHING_PCSUCCESS,  MessageFormat.format(\"Matching on port {0} succeeded.\", get_name()));\n");
            source.append("\t\t\t\tfinal TTCN_Logger.Severity log_sev = head.sender_component ==  TitanComponent.SYSTEM_COMPREF ? TTCN_Logger.Severity.PORTEVENT_PMIN : TTCN_Logger.Severity.PORTEVENT_PCIN;\n");
            source.append("\t\t\t\tif (TTCN_Logger.log_this_event(log_sev)) {\n");
            source.append(MessageFormat.format("\t\t\t\t\tTTCN_Logger.log_procport_recv(get_name(), TitanLoggerApi.Port__oper.enum_type.exception__op, head.sender_component, {0} ,new TitanCharString(\"\"), msg_head_count+1);\n", isCheck ? "true" : "false"));
            source.append("\t\t\t\t}\n");
        }
        if (!isCheck) {
            source.append("\t\t\t\tremove_proc_queue_head();\n");
        }
        source.append("\t\t\t\treturn TitanAlt_Status.ALT_YES;\n");
        source.append("\t\t\t}\n");
        source.append("\t\t\tdefault:\n");
        source.append(MessageFormat.format("\t\t\t\tTTCN_Logger.log({0}, MessageFormat.format(\"Matching on port '{'0'}' failed: First entity in the queue is not an exception.\", get_name()));\n", isAddress ? "TTCN_Logger.Severity.MATCHING_PMUNSUCC" : "head.sender_component == TitanComponent.SYSTEM_COMPREF ? TTCN_Logger.Severity.MATCHING_PMUNSUCC : TTCN_Logger.Severity.MATCHING_PCUNSUCC"));
        source.append("\t\t\t\treturn TitanAlt_Status.ALT_NO;\n");
        source.append("\t\t\t}\n");
        source.append("\t\t}\n\n");
    }

    private static void generateTypedGetexception(JavaGenData aData, StringBuilder source, PortDefinition portDefinition, int index, procedureSignatureInfo info, boolean isCheck, boolean isAddress) {
        String functionName = isCheck ? "check_catch" : "get_exception";
        String printedFunctionName = isCheck ? "Check-catch" : "Catch";
        String senderType = isAddress ? portDefinition.addressName : "TitanComponent";
        String allowOmitInValueList = aData.getAllowOmitInValueList() ? "true" : "false";
        source.append(MessageFormat.format("\t\tpublic TitanAlt_Status {0}(final {1}_exception_template catch_template, final {2}_template sender_template, final {2} sender_pointer, final TitanFloat timestamp_redirect, final Index_Redirect index_redirect) '{'\n", functionName, info.mJavaTypeName, senderType));
        if (info.hasReturnValue) {
            source.append("\t\t\tif (catch_template.is_any_or_omit()) {\n");
            source.append(MessageFormat.format("\t\t\t\tthrow new TtcnError(\"{0} operation using '''*''' as matching template\");\n", printedFunctionName));
            source.append("\t\t\t}\n");
        }
        source.append("\t\t\tif (procedure_queue.size() == 0) {\n");
        source.append("\t\t\t\tif(is_started) {\n");
        source.append("\t\t\t\t\treturn TitanAlt_Status.ALT_MAYBE;\n");
        source.append("\t\t\t\t} else {\n");
        source.append("\t\t\t\t\tTTCN_Logger.log_str(TTCN_Logger.Severity.MATCHING_PROBLEM, MessageFormat.format(\"Matching on port {0} failed: Port is not started and the queue is empty.\", get_name()));\n");
        source.append("\t\t\t\t\treturn TitanAlt_Status.ALT_NO;\n");
        source.append("\t\t\t\t}\n");
        source.append("\t\t\t}\n");
        source.append("\t\t\tfinal Procedure_queue_item head = procedure_queue.getFirst();\n");
        if (isAddress) {
            source.append("\t\t\tif (head.sender_component != TitanComponent.SYSTEM_COMPREF) {\n");
            source.append("\t\t\t\tTTCN_Logger.log_matching_failure(TitanLoggerApi.PortType.enum_type.procedure__, get_name(), head.sender_component, TitanLoggerApi.MatchingFailureType_reason.enum_type.sender__is__not__system, new TitanCharString(\"\"));\n");
            source.append("\t\t\t\treturn TitanAlt_Status.ALT_NO;\n");
            source.append("\t\t\t} else if (head.sender_address == null) {\n");
            source.append(MessageFormat.format("\t\t\t\tthrow new TtcnError(MessageFormat.format(\"{0} operation on port '{'0'}' requires the address of the sender, which was not given by the test port.\", get_name()));\n", printedFunctionName));
            source.append(MessageFormat.format("\t\t\t} else if (!sender_template.match(head.sender_address, {0})) '{'\n", allowOmitInValueList));
            source.append("\t\t\t\tif (TTCN_Logger.log_this_event(TTCN_Logger.Severity.MATCHING_PMUNSUCC)) {\n");
            source.append("\t\t\t\t\tTTCN_Logger.begin_event(TTCN_Logger.Severity.MATCHING_PMUNSUCC);\n");
            source.append(MessageFormat.format("\t\t\t\t\tsender_template.log_match(head.sender_address, {0});\n", allowOmitInValueList));
            source.append("\t\t\t\t\tTTCN_Logger.log_matching_failure(TitanLoggerApi.PortType.enum_type.procedure__, get_name(), head.sender_component, TitanLoggerApi.MatchingFailureType_reason.enum_type.sender__does__not__match__from__clause, TTCN_Logger.end_event_log2str());\n");
            source.append("\t\t\t\t}\n");
            source.append("\t\t\t\treturn TitanAlt_Status.ALT_NO;\n");
            source.append("\t\t\t}");
        } else {
            source.append(MessageFormat.format("\t\t\tif (!sender_template.match(head.sender_component, {0})) '{'\n", allowOmitInValueList));
            source.append("\t\t\t\tfinal TTCN_Logger.Severity log_sev = head.sender_component == TitanComponent.SYSTEM_COMPREF ? TTCN_Logger.Severity.MATCHING_PMUNSUCC : TTCN_Logger.Severity.MATCHING_PCUNSUCC;\n");
            source.append("\t\t\t\tif (TTCN_Logger.log_this_event(log_sev)) {\n");
            source.append("\t\t\t\t\tTTCN_Logger.begin_event(log_sev);\n");
            source.append(MessageFormat.format("\t\t\t\t\tsender_template.log_match(new TitanComponent(head.sender_component), {0});\n", allowOmitInValueList));
            source.append("\t\t\t\t\tTTCN_Logger.log_matching_failure(TitanLoggerApi.PortType.enum_type.procedure__, get_name(), head.sender_component, TitanLoggerApi.MatchingFailureType_reason.enum_type.sender__does__not__match__from__clause, TTCN_Logger.end_event_log2str());\n");
            source.append("\t\t\t\t}\n");
            source.append("\t\t\t\treturn TitanAlt_Status.ALT_NO;\n");
            source.append("\t\t\t}");
        }
        source.append(MessageFormat.format(" else if (head.item_selection != proc_selection.EXCEPTION_{0}) '{'\n", index));
        source.append(MessageFormat.format("\t\t\t\tTTCN_Logger.log_matching_failure(TitanLoggerApi.PortType.enum_type.procedure__, get_name(), {0}, TitanLoggerApi.MatchingFailureType_reason.enum_type.not__an__exception__for__signature, new TitanCharString(\"{1} \"));\n", isAddress ? "TitanComponent.SYSTEM_COMPREF" : "head.sender_component", info.mDisplayName));
        source.append("\t\t\t\treturn TitanAlt_Status.ALT_NO;\n");
        source.append(MessageFormat.format("\t\t\t'}' else if (!catch_template.match(head.exception_{0}, {1})) '{'\n", index, allowOmitInValueList));
        if (isAddress) {
            source.append("\t\t\t\tif (TTCN_Logger.log_this_event(TTCN_Logger.Severity.MATCHING_PMUNSUCC)) {\n");
        } else {
            source.append("\t\t\t\tfinal TTCN_Logger.Severity log_sev = head.sender_component == TitanComponent.SYSTEM_COMPREF ? TTCN_Logger.Severity.MATCHING_PMUNSUCC : TTCN_Logger.Severity.MATCHING_PCUNSUCC;\n");
            source.append("\t\t\t\tif (TTCN_Logger.log_this_event(log_sev)) {\n");
        }
        source.append(MessageFormat.format("\t\t\t\t\tTTCN_Logger.begin_event({0});\n", isAddress ? "TTCN_Logger.Severity.MATCHING_PMUNSUCC" : "log_sev"));
        source.append(MessageFormat.format("\t\t\t\t\tcatch_template.log_match(head.exception_{0}, {1});\n", index, allowOmitInValueList));
        source.append("\t\t\t\t\tTTCN_Logger.end_event_log2str();\n");
        source.append("\t\t\t\t}\n");
        source.append("\t\t\t\treturn TitanAlt_Status.ALT_NO;\n");
        source.append("\t\t\t} else {\n");
        source.append(MessageFormat.format("\t\t\t\tcatch_template.set_value(head.exception_{0});\n", index));
        if (portDefinition.realtime) {
            source.append("\t\t\t\tif (timestamp_redirect != null && head.timestamp.is_bound()) {\n");
            source.append("\t\t\t\t\ttimestamp_redirect.operator_assign(head.timestamp);\n");
            source.append("\t\t\t\t}\n");
        }
        source.append("\t\t\t\tif (sender_pointer != null) {\n");
        if (isAddress) {
            source.append("\t\t\t\t\tsender_pointer.operator_assign(head.sender_address);\n");
        } else {
            source.append("\t\t\t\t\tsender_pointer.operator_assign(head.sender_component);\n");
        }
        source.append("\t\t\t\t}\n");
        PortGenerator.generate_proc_incoming_data_logging(source, "exception", "catch_template.log_match", isAddress, isCheck, index);
        if (!isCheck) {
            source.append("\t\t\t\tremove_proc_queue_head();\n");
        }
        source.append("\t\t\t\treturn TitanAlt_Status.ALT_YES;\n");
        source.append("\t\t\t}\n");
        source.append("\t\t}\n\n");
    }

    private static void generateTypedIcomingCall(StringBuilder source, int index, procedureSignatureInfo info, PortDefinition portDefinition) {
        StringBuilder comment = new StringBuilder();
        StringBuilder header = new StringBuilder();
        comment.append("\t\t/**\n");
        comment.append(MessageFormat.format("\t\t * Inserts a procedure call of {0} signature into the incoming procedure queue of this\n", info.mDisplayName));
        comment.append("\t\t * Test Port.\n");
        comment.append("\t\t *\n");
        comment.append("\t\t * @param incoming_par\n");
        comment.append("\t\t *            the value to be inserted.\n");
        comment.append("\t\t * @param sender_component\n");
        comment.append("\t\t *            the sender component.\n");
        header.append(MessageFormat.format("\t\tprotected void incoming_call(final {0}_call incoming_par, final int sender_component", info.mJavaTypeName));
        if (portDefinition.testportType == TestportType.ADDRESS) {
            comment.append("\t\t * @param sender_address\n");
            comment.append("\t\t *            the address of the sender.\n");
            header.append(MessageFormat.format(", final {0} sender_address", portDefinition.addressName));
        }
        if (portDefinition.realtime) {
            comment.append("\t\t * @param timestamp\n");
            comment.append("\t\t *            the timestamp to return.\n");
            header.append(", final TitanFloat timestamp");
        }
        comment.append("\t\t * */\n");
        source.append((CharSequence)comment);
        source.append((CharSequence)header);
        source.append(") {\n");
        source.append("\t\t\tif (!is_started) {\n");
        source.append("\t\t\t\tif(is_halted) {\n");
        source.append("\t\t\t\t\tTtcnError.TtcnWarning(MessageFormat.format(\"A call that arrived on port {0} has been discarded, because the port is not started.\", get_name()));\n");
        source.append("\t\t\t\t\treturn;\n");
        source.append("\t\t\t\t} else {\n");
        source.append("\t\t\t\t\tthrow new TtcnError(MessageFormat.format(\"Port {0} is not started but a call has arrived on it.\", get_name()));\n");
        source.append("\t\t\t\t}\n");
        source.append("\t\t\t}\n");
        source.append("\t\t\tif(TTCN_Logger.log_this_event(TTCN_Logger.Severity.PORTEVENT_PQUEUE)) {\n");
        if (portDefinition.testportType == TestportType.ADDRESS) {
            source.append("\t\t\t\tTTCN_Logger.begin_event(TTCN_Logger.Severity.PORTEVENT_PQUEUE);\n");
            source.append("\t\t\t\tTTCN_Logger.log_char('(');\n");
            source.append("\t\t\t\tsender_address.log();\n");
            source.append("\t\t\t\tTTCN_Logger.log_char(')');\n");
            source.append("\t\t\t\tTitanCharString tempLog = TTCN_Logger.end_event_log2str();\n");
        }
        source.append("\t\t\t\tTTCN_Logger.begin_event(TTCN_Logger.Severity.PORTEVENT_PQUEUE);\n");
        source.append("\t\t\t\tTTCN_Logger.log_char(' ');\n");
        source.append("\t\t\t\tincoming_par.log();\n");
        source.append("\t\t\t\tTTCN_Logger.log_port_queue(TitanLoggerApi.Port__Queue_operation.enum_type.enqueue__call, get_name(), sender_component, proc_tail_count, ");
        if (portDefinition.testportType == TestportType.ADDRESS) {
            source.append("tempLog, TTCN_Logger.end_event_log2str());\n");
        } else {
            source.append("new TitanCharString(\"\"), TTCN_Logger.end_event_log2str());\n");
        }
        source.append("}\n");
        source.append("\t\t\tfinal Procedure_queue_item newItem = new Procedure_queue_item();\n");
        source.append(MessageFormat.format("\t\t\tnewItem.item_selection = proc_selection.CALL_{0};\n", index));
        source.append(MessageFormat.format("\t\t\tnewItem.call_{0} = new {1}_call(incoming_par);\n", index, info.mJavaTypeName));
        source.append("\t\t\tnewItem.sender_component = sender_component;\n");
        if (portDefinition.realtime) {
            source.append("\t\t\tif(timestamp.is_bound()) {\n");
            source.append("\t\t\t\tnewItem.timestamp = new TitanFloat(timestamp);\n");
            source.append("\t\t\t}\n");
        }
        if (portDefinition.testportType == TestportType.ADDRESS) {
            source.append("\t\t\tif (sender_address != null) {\n");
            source.append(MessageFormat.format("\t\t\t\tnewItem.sender_address = new {0}(sender_address);\n", portDefinition.addressName));
            source.append("\t\t\t} else {\n");
            source.append("\t\t\t\tnewItem.sender_address = null;\n");
            source.append("\t\t\t}\n");
        }
        source.append("\t\t\tprocedure_queue.add(newItem);\n");
        source.append("\t\t}\n\n");
        if (portDefinition.testportType == TestportType.ADDRESS) {
            source.append("\t\t/**\n");
            source.append(MessageFormat.format("\t\t * Inserts a procedure call of {0} signature into the incoming procedure queue of this\n", info.mDisplayName));
            source.append("\t\t * Test Port.\n");
            source.append("\t\t *\n");
            source.append("\t\t * @param incoming_par\n");
            source.append("\t\t *            the value to be inserted.\n");
            source.append("\t\t * @param sender_component\n");
            source.append("\t\t *            the sender component.\n");
            source.append("\t\t * */\n");
            source.append(MessageFormat.format("\t\tprotected void incoming_call(final {0}_call incoming_par, final int sender_component) '{'\n", info.mJavaTypeName));
            source.append(MessageFormat.format("\t\t\tincoming_call(incoming_par, sender_component{0}, null);\n", portDefinition.realtime ? ", new TitanFloat()" : ""));
            source.append("\t\t}\n\n");
        }
        source.append("\t\t/**\n");
        source.append(MessageFormat.format("\t\t * Inserts a procedure call of {0} signature into the incoming procedure queue of this\n", info.mDisplayName));
        source.append("\t\t * Test Port, coming from the system component.\n");
        source.append("\t\t *\n");
        source.append("\t\t * @param incoming_par\n");
        source.append("\t\t *            the value to be inserted.\n");
        source.append("\t\t * */\n");
        source.append(MessageFormat.format("\t\tprotected void incoming_call(final {0}_call incoming_par) '{'\n", info.mJavaTypeName));
        source.append(MessageFormat.format("\t\t\tincoming_call(incoming_par, TitanComponent.SYSTEM_COMPREF{0});\n", portDefinition.realtime ? ", new TitanFloat()" : ""));
        source.append("\t\t}\n\n");
    }

    private static void generateTypedIcomingReply(StringBuilder source, int index, procedureSignatureInfo info, PortDefinition portDefinition) {
        StringBuilder comment = new StringBuilder();
        StringBuilder header = new StringBuilder();
        comment.append("\t\t/**\n");
        comment.append(MessageFormat.format("\t\t * Inserts a procedure reply of {0} signature into the incoming procedure queue of this\n", info.mDisplayName));
        comment.append("\t\t * Test Port.\n");
        comment.append("\t\t *\n");
        comment.append("\t\t * @param incoming_par\n");
        comment.append("\t\t *            the value to be inserted.\n");
        comment.append("\t\t * @param sender_component\n");
        comment.append("\t\t *            the sender component.\n");
        header.append(MessageFormat.format("\t\tprotected void incoming_reply(final {0}_reply incoming_par, final int sender_component", info.mJavaTypeName));
        if (portDefinition.testportType == TestportType.ADDRESS) {
            comment.append("\t\t * @param sender_address\n");
            comment.append("\t\t *            the address of the sender.\n");
            header.append(MessageFormat.format(", final {0} sender_address", portDefinition.addressName));
        }
        if (portDefinition.realtime) {
            comment.append("\t\t * @param timestamp\n");
            comment.append("\t\t *            the timestamp to return.\n");
            header.append(", final TitanFloat timestamp");
        }
        comment.append("\t\t * */\n");
        source.append((CharSequence)comment);
        source.append((CharSequence)header);
        source.append(") {\n");
        source.append("\t\t\tif (!is_started) {\n");
        source.append("\t\t\t\tif(is_halted) {\n");
        source.append("\t\t\t\t\tTtcnError.TtcnWarning(MessageFormat.format(\"A reply that arrived on port {0} has been discarded, because the port is not started.\", get_name()));\n");
        source.append("\t\t\t\t\treturn;\n");
        source.append("\t\t\t\t} else {\n");
        source.append("\t\t\t\t\tthrow new TtcnError(MessageFormat.format(\"Port {0} is not started but a reply has arrived on it.\", get_name()));\n");
        source.append("\t\t\t\t}\n");
        source.append("\t\t\t}\n");
        source.append("\t\t\tif(TTCN_Logger.log_this_event(TTCN_Logger.Severity.PORTEVENT_PQUEUE)) {\n");
        if (portDefinition.testportType == TestportType.ADDRESS) {
            source.append("\t\t\t\tTTCN_Logger.begin_event(TTCN_Logger.Severity.PORTEVENT_PQUEUE);\n");
            source.append("\t\t\t\tTTCN_Logger.log_char('(');\n");
            source.append("\t\t\t\tsender_address.log();\n");
            source.append("\t\t\t\tTTCN_Logger.log_char(')');\n");
            source.append("\t\t\t\tTitanCharString tempLog = TTCN_Logger.end_event_log2str();\n");
        }
        source.append("\t\t\t\tTTCN_Logger.begin_event(TTCN_Logger.Severity.PORTEVENT_PQUEUE);\n");
        source.append("\t\t\t\tTTCN_Logger.log_char(' ');\n");
        source.append("\t\t\t\tincoming_par.log();\n");
        source.append("\t\t\t\tTTCN_Logger.log_port_queue(TitanLoggerApi.Port__Queue_operation.enum_type.enqueue__reply, get_name(), sender_component, proc_tail_count, ");
        if (portDefinition.testportType == TestportType.ADDRESS) {
            source.append("tempLog, TTCN_Logger.end_event_log2str());\n");
        } else {
            source.append("new TitanCharString(\"\"), TTCN_Logger.end_event_log2str());\n");
        }
        source.append("\t\t\t}\n");
        source.append("\t\t\tfinal Procedure_queue_item newItem = new Procedure_queue_item();\n");
        source.append(MessageFormat.format("\t\t\tnewItem.item_selection = proc_selection.REPLY_{0};\n", index));
        source.append(MessageFormat.format("\t\t\tnewItem.reply_{0} = new {1}_reply(incoming_par);\n", index, info.mJavaTypeName));
        source.append("\t\t\tnewItem.sender_component = sender_component;\n");
        if (portDefinition.realtime) {
            source.append("\t\t\tif(timestamp.is_bound()) {\n");
            source.append("\t\t\t\tnewItem.timestamp = new TitanFloat(timestamp);\n");
            source.append("\t\t\t}\n");
        }
        if (portDefinition.testportType == TestportType.ADDRESS) {
            source.append("\t\t\tif (sender_address != null) {\n");
            source.append(MessageFormat.format("\t\t\t\tnewItem.sender_address = new {0}(sender_address);\n", portDefinition.addressName));
            source.append("\t\t\t} else {\n");
            source.append("\t\t\t\tnewItem.sender_address = null;\n");
            source.append("\t\t\t}\n");
        }
        source.append("\t\t\tprocedure_queue.add(newItem);\n");
        source.append("\t\t}\n\n");
        if (portDefinition.testportType == TestportType.ADDRESS) {
            source.append("\t\t/**\n");
            source.append(MessageFormat.format("\t\t * Inserts a procedure reply of {0} signature into the incoming procedure queue of this\n", info.mDisplayName));
            source.append("\t\t * Test Port.\n");
            source.append("\t\t *\n");
            source.append("\t\t * @param incoming_par\n");
            source.append("\t\t *            the value to be inserted.\n");
            source.append("\t\t * @param sender_component\n");
            source.append("\t\t *            the sender component.\n");
            source.append("\t\t * */\n");
            source.append(MessageFormat.format("\t\tprotected void incoming_reply(final {0}_reply incoming_par, final int sender_component) '{'\n", info.mJavaTypeName));
            source.append(MessageFormat.format("\t\t\tincoming_reply(incoming_par, sender_component{0}, null);\n", portDefinition.realtime ? ", new TitanFloat()" : ""));
            source.append("\t\t}\n\n");
        }
        source.append("\t\t/**\n");
        source.append(MessageFormat.format("\t\t * Inserts a procedure reply of {0} signature into the incoming procedure queue of this\n", info.mDisplayName));
        source.append("\t\t * Test Port, coming from the system component.\n");
        source.append("\t\t *\n");
        source.append("\t\t * @param incoming_par\n");
        source.append("\t\t *            the value to be inserted.\n");
        source.append("\t\t * */\n");
        source.append(MessageFormat.format("\t\tprotected void incoming_reply(final {0}_reply incoming_par) '{'\n", info.mJavaTypeName));
        source.append(MessageFormat.format("\t\t\tincoming_reply(incoming_par, TitanComponent.SYSTEM_COMPREF{0});\n", portDefinition.realtime ? ", new TitanFloat()" : ""));
        source.append("\t\t}\n\n");
    }

    private static void generateTypedIcomingException(StringBuilder source, int index, procedureSignatureInfo info, PortDefinition portDefinition) {
        StringBuilder comment = new StringBuilder();
        StringBuilder header = new StringBuilder();
        comment.append("\t\t/**\n");
        comment.append(MessageFormat.format("\t\t * Inserts a procedure exception of {0} signature into the incoming procedure queue of this\n", info.mDisplayName));
        comment.append("\t\t * Test Port.\n");
        comment.append("\t\t *\n");
        comment.append("\t\t * @param incoming_par\n");
        comment.append("\t\t *            the value to be inserted.\n");
        comment.append("\t\t * @param sender_component\n");
        comment.append("\t\t *            the sender component.\n");
        header.append(MessageFormat.format("\t\tprotected void incoming_exception(final {0}_exception incoming_par, final int sender_component", info.mJavaTypeName));
        if (portDefinition.testportType == TestportType.ADDRESS) {
            comment.append("\t\t * @param sender_address\n");
            comment.append("\t\t *            the address of the sender.\n");
            header.append(MessageFormat.format(", final {0} sender_address", portDefinition.addressName));
        }
        if (portDefinition.realtime) {
            comment.append("\t\t * @param timestamp\n");
            comment.append("\t\t *            the timestamp to return.\n");
            header.append(", final TitanFloat timestamp");
        }
        comment.append("\t\t * */\n");
        source.append((CharSequence)comment);
        source.append((CharSequence)header);
        source.append(") {\n");
        source.append("\t\t\tif (!is_started) {\n");
        source.append("\t\t\t\tif(is_halted) {\n");
        source.append("\t\t\t\t\tTtcnError.TtcnWarning(MessageFormat.format(\"An exception that arrived on port {0} has been discarded, because the port is not started.\", get_name()));\n");
        source.append("\t\t\t\t\treturn;\n");
        source.append("\t\t\t\t} else {\n");
        source.append("\t\t\t\t\tthrow new TtcnError(MessageFormat.format(\"Port {0} is not started but an exception has arrived on it.\", get_name()));\n");
        source.append("\t\t\t\t}\n");
        source.append("\t\t\t}\n");
        source.append("\t\t\tif(TTCN_Logger.log_this_event(TTCN_Logger.Severity.PORTEVENT_PQUEUE)) {\n");
        if (portDefinition.testportType == TestportType.ADDRESS) {
            source.append("\t\t\t\tTTCN_Logger.begin_event(TTCN_Logger.Severity.PORTEVENT_PQUEUE);\n");
            source.append("\t\t\t\tTTCN_Logger.log_char('(');\n");
            source.append("\t\t\t\tsender_address.log();\n");
            source.append("\t\t\t\tTTCN_Logger.log_char(')');\n");
            source.append("\t\t\t\tTitanCharString tempLog = TTCN_Logger.end_event_log2str();\n");
        }
        source.append("\t\t\t\tTTCN_Logger.begin_event(TTCN_Logger.Severity.PORTEVENT_PQUEUE);\n");
        source.append("\t\t\t\tTTCN_Logger.log_char(' ');\n");
        source.append("\t\t\t\tincoming_par.log();\n");
        source.append("\t\t\t\tTTCN_Logger.log_port_queue(TitanLoggerApi.Port__Queue_operation.enum_type.enqueue__exception, get_name(), sender_component, proc_tail_count, ");
        if (portDefinition.testportType == TestportType.ADDRESS) {
            source.append("tempLog, TTCN_Logger.end_event_log2str());\n");
        } else {
            source.append("new TitanCharString(\"\"), TTCN_Logger.end_event_log2str());\n");
        }
        source.append("\t\t\t}\n");
        source.append("\t\t\tfinal Procedure_queue_item newItem = new Procedure_queue_item();\n");
        source.append(MessageFormat.format("\t\t\tnewItem.item_selection = proc_selection.EXCEPTION_{0};\n", index));
        source.append(MessageFormat.format("\t\t\tnewItem.exception_{0} = new {1}_exception(incoming_par);\n", index, info.mJavaTypeName));
        source.append("\t\t\tnewItem.sender_component = sender_component;\n");
        if (portDefinition.realtime) {
            source.append("\t\t\tif(timestamp.is_bound()) {\n");
            source.append("\t\t\t\tnewItem.timestamp = new TitanFloat(timestamp);\n");
            source.append("\t\t\t}\n");
        }
        if (portDefinition.testportType == TestportType.ADDRESS) {
            source.append("\t\t\tif (sender_address != null) {\n");
            source.append(MessageFormat.format("\t\t\t\tnewItem.sender_address = new {0}(sender_address);\n", portDefinition.addressName));
            source.append("\t\t\t} else {\n");
            source.append("\t\t\t\tnewItem.sender_address = null;\n");
            source.append("\t\t\t}\n");
        }
        source.append("\t\t\tprocedure_queue.add(newItem);\n");
        source.append("\t\t}\n\n");
        if (portDefinition.testportType == TestportType.ADDRESS) {
            source.append("\t\t/**\n");
            source.append(MessageFormat.format("\t\t * Inserts a procedure exception of {0} signature into the incoming procedure queue of this\n", info.mDisplayName));
            source.append("\t\t * Test Port.\n");
            source.append("\t\t *\n");
            source.append("\t\t * @param incoming_par\n");
            source.append("\t\t *            the value to be inserted.\n");
            source.append("\t\t * @param sender_component\n");
            source.append("\t\t *            the sender component.\n");
            source.append("\t\t * */\n");
            source.append(MessageFormat.format("\t\tprotected void incoming_exception(final {0}_exception incoming_par, final int sender_component) '{'\n", info.mJavaTypeName));
            source.append(MessageFormat.format("\t\t\tincoming_exception(incoming_par, sender_component{0}, null);\n", portDefinition.realtime ? ", new TitanFloat()" : ""));
            source.append("\t\t}\n\n");
        }
        source.append("\t\t/**\n");
        source.append(MessageFormat.format("\t\t * Inserts a procedure exception of {0} signature into the incoming procedure queue of this\n", info.mDisplayName));
        source.append("\t\t * Test Port, coming from the system component.\n");
        source.append("\t\t *\n");
        source.append("\t\t * @param incoming_par\n");
        source.append("\t\t *            the value to be inserted.\n");
        source.append("\t\t * */\n");
        source.append(MessageFormat.format("\t\tprotected void incoming_exception(final {0}_exception incoming_par) '{'\n", info.mJavaTypeName));
        source.append(MessageFormat.format("\t\t\tincoming_exception(incoming_par, TitanComponent.SYSTEM_COMPREF{0});\n", portDefinition.realtime ? ", new TitanFloat()" : ""));
        source.append("\t\t}\n\n");
    }

    private static void generateProcessCall(StringBuilder source, PortDefinition portDefinition) {
        source.append("\t\t@Override\n");
        source.append("\t\tprotected boolean process_call(final byte[] signature_name, final Text_Buf incoming_buf, final int sender_component) {\n");
        source.append("\t\t\t");
        for (int i = 0; i < portDefinition.inProcedures.size(); ++i) {
            procedureSignatureInfo info = portDefinition.inProcedures.get(i);
            if (i != 0) {
                source.append("\t\t\t} else ");
            }
            source.append(MessageFormat.format("if (Arrays.equals(in_procedure_names[{0}], signature_name)) '{'\n", i));
            source.append(MessageFormat.format("\t\t\t\t//{0}\n", info.mDisplayName));
            source.append(MessageFormat.format("\t\t\t\tfinal {0}_call incoming_par = new {0}_call();\n", info.mJavaTypeName));
            source.append("\t\t\t\tincoming_par.decode_text(incoming_buf);\n");
            source.append(MessageFormat.format("\t\t\t\tincoming_call(incoming_par, sender_component{0});\n", portDefinition.realtime ? ", new TitanFloat()" : ""));
            source.append("\t\t\t\treturn true;\n");
        }
        source.append("\t\t\t} else {\n");
        source.append("\t\t\t\treturn false;\n");
        source.append("\t\t\t}\n");
        source.append("\t\t}\n");
    }

    private static void generateProcessReply(StringBuilder source, PortDefinition portDefinition) {
        source.append("\t\t@Override\n");
        source.append("\t\tprotected boolean process_reply(final byte[] signature_name, final Text_Buf incoming_buf, final int sender_component) {\n");
        source.append("\t\t\t");
        boolean isFirst = true;
        for (int i = 0; i < portDefinition.outProcedures.size(); ++i) {
            procedureSignatureInfo info = portDefinition.outProcedures.get(i);
            if (info.isNoBlock) continue;
            if (!isFirst) {
                source.append("\t\t\t} else ");
            }
            isFirst = false;
            source.append(MessageFormat.format("if (Arrays.equals(out_procedure_names[{0}], signature_name)) '{'\n", i));
            source.append(MessageFormat.format("\t\t\t\t//{0}\n", info.mDisplayName));
            source.append(MessageFormat.format("\t\t\t\tfinal {0}_reply incoming_par = new {0}_reply();\n", info.mJavaTypeName));
            source.append("\t\t\t\tincoming_par.decode_text(incoming_buf);\n");
            source.append(MessageFormat.format("\t\t\t\tincoming_reply(incoming_par, sender_component{0});\n", portDefinition.realtime ? ", new TitanFloat()" : ""));
            source.append("\t\t\t\treturn true;\n");
        }
        source.append("\t\t\t} else {\n");
        source.append("\t\t\t\treturn false;\n");
        source.append("\t\t\t}\n");
        source.append("\t\t}\n");
    }

    private static void generateProcessException(StringBuilder source, PortDefinition portDefinition) {
        source.append("\t\t@Override\n");
        source.append("\t\tprotected boolean process_exception(final byte[] signature_name, final Text_Buf incoming_buf, final int sender_component) {\n");
        source.append("\t\t\t");
        boolean isFirst = true;
        for (int i = 0; i < portDefinition.outProcedures.size(); ++i) {
            procedureSignatureInfo info = portDefinition.outProcedures.get(i);
            if (!info.hasExceptions) continue;
            if (!isFirst) {
                source.append("\t\t\t} else ");
            }
            isFirst = false;
            source.append(MessageFormat.format("if (Arrays.equals(out_procedure_names[{0}], signature_name)) '{'\n", i));
            source.append(MessageFormat.format("\t\t\t\t//{0}\n", info.mDisplayName));
            source.append(MessageFormat.format("\t\t\t\tfinal {0}_exception incoming_par = new {0}_exception();\n", info.mJavaTypeName));
            source.append("\t\t\t\tincoming_par.decode_text(incoming_buf);\n");
            source.append(MessageFormat.format("\t\t\t\tincoming_exception(incoming_par, sender_component{0});\n", portDefinition.realtime ? ", new TitanFloat()" : ""));
            source.append("\t\t\t\treturn true;\n");
        }
        source.append("\t\t\t} else {\n");
        source.append("\t\t\t\treturn false;\n");
        source.append("\t\t\t}\n");
        source.append("\t\t}\n");
    }

    public static void generateCodeStandalone(JavaGenData aData, StringBuilder source, String statement, String statementName, boolean canRepeat, Location location) {
        aData.addBuiltinTypeImport("TitanAlt_Status");
        aData.addBuiltinTypeImport("TTCN_Default");
        aData.addBuiltinTypeImport("TtcnError");
        aData.addCommonLibraryImport("TTCN_Snapshot");
        String tempLabel = aData.getTemporaryVariableName();
        source.append(MessageFormat.format("{0}: for( ; ; ) '{'\n", tempLabel));
        source.append("TitanAlt_Status alt_flag = TitanAlt_Status.ALT_UNCHECKED;\n");
        source.append("TitanAlt_Status default_flag = TitanAlt_Status.ALT_UNCHECKED;\n");
        source.append("TTCN_Snapshot.take_new(false);\n");
        source.append("for( ; ; ) {\n");
        source.append("if (alt_flag != TitanAlt_Status.ALT_NO) {\n");
        source.append(MessageFormat.format("alt_flag = {0};\n", statement));
        source.append("if (alt_flag == TitanAlt_Status.ALT_YES) {\n");
        source.append("break;\n");
        if (canRepeat) {
            source.append("} else if (alt_flag == TitanAlt_Status.ALT_REPEAT) {\n");
            source.append(MessageFormat.format("continue {0};\n", tempLabel));
            source.append("}\n");
        } else {
            source.append("}\n");
        }
        source.append("}\n");
        source.append("if (default_flag != TitanAlt_Status.ALT_NO) {\n");
        source.append("default_flag = TTCN_Default.try_altsteps();\n");
        source.append("if (default_flag == TitanAlt_Status.ALT_YES || default_flag == TitanAlt_Status.ALT_BREAK) {\n");
        source.append("break;\n");
        source.append("} else if (default_flag == TitanAlt_Status.ALT_REPEAT) {\n");
        source.append(MessageFormat.format("continue {0};\n", tempLabel));
        source.append("}\n");
        source.append("}\n");
        source.append("if (alt_flag == TitanAlt_Status.ALT_NO && default_flag == TitanAlt_Status.ALT_NO) {\n");
        source.append(MessageFormat.format("throw new TtcnError(\"Stand-alone {0} statement failed in file {1}, line {2}.\");\n", statementName, location.getFile().getProjectRelativePath(), location.getLine()));
        source.append("}\n");
        source.append("TTCN_Snapshot.take_new(true);\n");
        source.append("}\n");
        source.append("break;\n");
        source.append("}\n");
    }

    private static void generate_proc_incoming_data_logging(StringBuilder source, String opStr, String matchStr, boolean isAddress, boolean isCheck, int index) {
        String procOp = "";
        if ("call".equals(opStr)) {
            procOp = "call";
        } else if ("reply".equals(opStr)) {
            procOp = "reply";
        } else if ("exception".equals(opStr)) {
            procOp = "exception";
        }
        if (isAddress) {
            source.append("\t\t\tif (TTCN_Logger.log_this_event(TTCN_Logger.Severity.MATCHING_PMSUCCESS)) {\n");
            source.append("\t\t\t\tTTCN_Logger.begin_event(TTCN_Logger.Severity.MATCHING_PMSUCCESS);\n");
            source.append(MessageFormat.format("\t\t\t\t{0}(head.{1}_{2},false);\n", matchStr, opStr, index));
            source.append("\t\t\t\tTTCN_Logger.log_matching_success(TitanLoggerApi.PortType.enum_type.procedure__, get_name(), TitanComponent.SYSTEM_COMPREF, TTCN_Logger.end_event_log2str());\n");
            source.append("\t\t\t}\n");
            source.append("\t\t\tif (TTCN_Logger.log_this_event(TTCN_Logger.Severity.PORTEVENT_PMIN)) {\n");
            source.append("\t\t\t\tTTCN_Logger.begin_event(TTCN_Logger.Severity.PORTEVENT_PMIN);\n");
            source.append(MessageFormat.format("\t\t\t\thead.{0}_{1}.log();\n", opStr, index));
            source.append(MessageFormat.format("\t\t\t\tTTCN_Logger.log_procport_recv(get_name(), TitanLoggerApi.Port__oper.enum_type.{0}__op, head.sender_component, {1}, TTCN_Logger.end_event_log2str(), msg_head_count+1);\n", procOp, isCheck ? "true" : "false"));
            source.append("\t\t\t}\n");
        } else {
            source.append("\t\t\tTTCN_Logger.Severity log_sev = head.sender_component == TitanComponent.SYSTEM_COMPREF ? TTCN_Logger.Severity.MATCHING_PMSUCCESS : TTCN_Logger.Severity.MATCHING_PCSUCCESS;\n");
            source.append("\t\t\tif (TTCN_Logger.log_this_event(log_sev)) {\n");
            source.append("\t\t\t\tTTCN_Logger.begin_event(log_sev);\n");
            source.append("\t\t\t\tTTCN_Logger.log_event_str(MessageFormat.format(\"Matching on port {0} succeeded: \", get_name()));\n");
            source.append(MessageFormat.format("\t\t\t\t{0}(head.{1}_{2}, false);\n", matchStr, opStr, index));
            source.append("\t\t\t\tTTCN_Logger.end_event();\n");
            source.append("\t\t\t}\n");
            source.append("\t\t\tlog_sev = head.sender_component == TitanComponent.SYSTEM_COMPREF ? TTCN_Logger.Severity.PORTEVENT_PMIN : TTCN_Logger.Severity.PORTEVENT_PCIN;\n");
            source.append("\t\t\tif (TTCN_Logger.log_this_event(log_sev)) {\n");
            source.append("\t\t\t\tTTCN_Logger.begin_event(log_sev);\n");
            source.append(MessageFormat.format("\t\t\t\thead.{0}_{1}.log();\n", opStr, index));
            source.append(MessageFormat.format("\t\t\t\tTTCN_Logger.log_procport_recv(get_name(), TitanLoggerApi.Port__oper.enum_type.{0}__op, head.sender_component, {1} ,TTCN_Logger.end_event_log2str(), msg_head_count+1);\n", procOp, isCheck ? "true" : "false"));
            source.append("\t\t\t}\n");
        }
    }

    public static void generatePortArrayBodyMembers(JavaGenData aData, StringBuilder source, PortDefinition portDefinition, long arraySize, long indexOffset) {
        procedureSignatureInfo info;
        int i;
        int i2;
        aData.addBuiltinTypeImport("Index_Redirect");
        for (i2 = 0; i2 < portDefinition.inMessages.size(); ++i2) {
            messageTypeInfo inType = portDefinition.inMessages.get(i2);
            PortGenerator.generateArrayBodyTypedReceive(source, i2, inType, false, arraySize, indexOffset);
            PortGenerator.generateArrayBodyTypedReceive(source, i2, inType, true, arraySize, indexOffset);
            PortGenerator.generateArrayBodyTypeTrigger(source, i2, inType, arraySize, indexOffset);
        }
        for (i2 = 0; i2 < portDefinition.inProcedures.size(); ++i2) {
            procedureSignatureInfo info2 = portDefinition.inProcedures.get(i2);
            PortGenerator.generateArrayBodyTypedGetcall(source, portDefinition, i2, info2, false, false, arraySize, indexOffset);
            PortGenerator.generateArrayBodyTypedGetcall(source, portDefinition, i2, info2, true, false, arraySize, indexOffset);
            if (portDefinition.testportType != TestportType.ADDRESS) continue;
            PortGenerator.generateArrayBodyTypedGetcall(source, portDefinition, i2, info2, false, true, arraySize, indexOffset);
            PortGenerator.generateArrayBodyTypedGetcall(source, portDefinition, i2, info2, true, true, arraySize, indexOffset);
        }
        boolean hasIncomingReply = false;
        for (int i3 = 0; i3 < portDefinition.outProcedures.size(); ++i3) {
            procedureSignatureInfo info3 = portDefinition.outProcedures.get(i3);
            if (info3.isNoBlock) continue;
            hasIncomingReply = true;
        }
        boolean hasIncomingException = false;
        for (i = 0; i < portDefinition.outProcedures.size(); ++i) {
            info = portDefinition.outProcedures.get(i);
            if (!info.hasExceptions) continue;
            hasIncomingException = true;
        }
        if (hasIncomingReply) {
            for (i = 0; i < portDefinition.outProcedures.size(); ++i) {
                info = portDefinition.outProcedures.get(i);
                if (portDefinition.outProcedures.get(i).isNoBlock) continue;
                PortGenerator.generateArrayBodyTypedGetreply(source, portDefinition, i, info, false, false, arraySize, indexOffset);
                PortGenerator.generateArrayBodyTypedGetreply(source, portDefinition, i, info, true, false, arraySize, indexOffset);
                if (portDefinition.testportType != TestportType.ADDRESS) continue;
                PortGenerator.generateArrayBodyTypedGetreply(source, portDefinition, i, info, false, true, arraySize, indexOffset);
                PortGenerator.generateArrayBodyTypedGetreply(source, portDefinition, i, info, true, true, arraySize, indexOffset);
            }
        }
        if (hasIncomingException) {
            for (i = 0; i < portDefinition.outProcedures.size(); ++i) {
                info = portDefinition.outProcedures.get(i);
                if (!portDefinition.outProcedures.get(i).hasExceptions) continue;
                PortGenerator.generateArrayBodyTypedGetexception(source, portDefinition, i, info, false, false, arraySize, indexOffset);
                PortGenerator.generateArrayBodyTypedGetexception(source, portDefinition, i, info, true, false, arraySize, indexOffset);
                if (portDefinition.testportType != TestportType.ADDRESS) continue;
                PortGenerator.generateArrayBodyTypedGetexception(source, portDefinition, i, info, false, true, arraySize, indexOffset);
                PortGenerator.generateArrayBodyTypedGetexception(source, portDefinition, i, info, true, true, arraySize, indexOffset);
            }
        }
    }

    private static void generateArrayBodyTypedReceive(StringBuilder source, int index, messageTypeInfo inType, boolean isCheck, long arraySize, long indexOffset) {
        String typeValueName = inType.mJavaTypeName;
        String typeTemplateName = inType.mJavaTemplateName;
        String functionName = isCheck ? "check_receive" : "receive";
        source.append(MessageFormat.format("\t\tpublic TitanAlt_Status {0}(final {1} value_template, final Value_Redirect_Interface value_redirect, final TitanComponent_template sender_template, final TitanComponent sender_pointer, final TitanFloat timestamp_redirect, final Index_Redirect index_redirect) '{'\n", functionName, typeTemplateName));
        source.append("\t\t\tif (index_redirect != null) {\n");
        source.append("\t\t\t\tindex_redirect.incr_pos();\n");
        source.append("\t\t\t}\n");
        source.append("\t\t\tTitanAlt_Status result = TitanAlt_Status.ALT_NO;\n");
        source.append(MessageFormat.format("\t\t\tfor (int i = 0; i < {0}; i++) '{'\n", arraySize));
        source.append(MessageFormat.format("\t\t\t\tfinal TitanAlt_Status ret_val = get_at(i).{0}(value_template, value_redirect, sender_template, sender_pointer, timestamp_redirect, index_redirect);\n", functionName));
        source.append("\t\t\t\tif (ret_val == TitanAlt_Status.ALT_YES) {\n");
        source.append("\t\t\t\t\tif (index_redirect != null) {\n");
        source.append(MessageFormat.format("\t\t\t\t\t\tindex_redirect.add_index(i + {0});\n", indexOffset));
        source.append("\t\t\t\t\t}\n");
        source.append("\t\t\t\t\tresult = ret_val;\n");
        source.append("\t\t\t\t\tbreak;\n");
        source.append("\t\t\t\t} else if (ret_val == TitanAlt_Status.ALT_REPEAT || (ret_val == TitanAlt_Status.ALT_MAYBE && result == TitanAlt_Status.ALT_NO)) {\n");
        source.append("\t\t\t\t\tresult = ret_val;\n");
        source.append("\t\t\t\t}\n");
        source.append("\t\t\t}\n");
        source.append("\t\t\tif (index_redirect != null) {\n");
        source.append("\t\t\t\tindex_redirect.decr_pos();\n");
        source.append("\t\t\t}\n");
        source.append("\t\t\treturn result;\n");
        source.append("\t\t}\n");
    }

    private static void generateArrayBodyTypeTrigger(StringBuilder source, int index, messageTypeInfo inType, long arraySize, long indexOffset) {
        String typeValueName = inType.mJavaTypeName;
        String typeTemplateName = inType.mJavaTemplateName;
        source.append(MessageFormat.format("\t\tpublic TitanAlt_Status trigger(final {0} value_template, final Value_Redirect_Interface value_redirect, final TitanComponent_template sender_template, final TitanComponent sender_pointer, final TitanFloat timestamp_redirect, final Index_Redirect index_redirect) '{'\n", typeTemplateName));
        source.append("\t\t\tif (index_redirect != null) {\n");
        source.append("\t\t\t\tindex_redirect.incr_pos();\n");
        source.append("\t\t\t}\n");
        source.append("\t\t\tTitanAlt_Status result = TitanAlt_Status.ALT_NO;\n");
        source.append(MessageFormat.format("\t\t\tfor (int i = 0; i < {0}; i++) '{'\n", arraySize));
        source.append("\t\t\t\tfinal TitanAlt_Status ret_val = get_at(i).trigger(value_template, value_redirect, sender_template, sender_pointer, timestamp_redirect, index_redirect);\n");
        source.append("\t\t\t\tif (ret_val == TitanAlt_Status.ALT_YES) {\n");
        source.append("\t\t\t\t\tif (index_redirect != null) {\n");
        source.append(MessageFormat.format("\t\t\t\t\t\tindex_redirect.add_index(i + {0});\n", indexOffset));
        source.append("\t\t\t\t\t}\n");
        source.append("\t\t\t\t\tresult = ret_val;\n");
        source.append("\t\t\t\t\tbreak;\n");
        source.append("\t\t\t\t} else if (ret_val == TitanAlt_Status.ALT_REPEAT || (ret_val == TitanAlt_Status.ALT_MAYBE && result == TitanAlt_Status.ALT_NO)) {\n");
        source.append("\t\t\t\t\tresult = ret_val;\n");
        source.append("\t\t\t\t}\n");
        source.append("\t\t\t}\n");
        source.append("\t\t\tif (index_redirect != null) {\n");
        source.append("\t\t\t\tindex_redirect.decr_pos();\n");
        source.append("\t\t\t}\n");
        source.append("\t\t\treturn result;\n");
        source.append("\t\t}\n");
    }

    private static void generateArrayBodyTypedGetcall(StringBuilder source, PortDefinition portDefinition, int index, procedureSignatureInfo info, boolean isCheck, boolean isAddress, long arraySize, long indexOffset) {
        String functionName = isCheck ? "check_getcall" : "getcall";
        String senderType = isAddress ? portDefinition.addressName : "TitanComponent";
        source.append(MessageFormat.format("\t\tpublic TitanAlt_Status {0}(final {1}_template getcall_template, final {2}_template sender_template, final {1}_call_redirect param_ref, final {2} sender_pointer, final TitanFloat timestamp_redirect, final Index_Redirect index_redirect) '{'\n", functionName, info.mJavaTypeName, senderType));
        source.append("\t\t\tif (index_redirect != null) {\n");
        source.append("\t\t\t\tindex_redirect.incr_pos();\n");
        source.append("\t\t\t}\n");
        source.append("\t\t\tTitanAlt_Status result = TitanAlt_Status.ALT_NO;\n");
        source.append(MessageFormat.format("\t\t\tfor (int i = 0; i < {0}; i++) '{'\n", arraySize));
        source.append(MessageFormat.format("\t\t\t\tfinal TitanAlt_Status ret_val = get_at(i).{0}(getcall_template, sender_template, param_ref, sender_pointer, timestamp_redirect, index_redirect);\n", functionName));
        source.append("\t\t\t\tif (ret_val == TitanAlt_Status.ALT_YES) {\n");
        source.append("\t\t\t\t\tif (index_redirect != null) {\n");
        source.append(MessageFormat.format("\t\t\t\t\t\tindex_redirect.add_index(i + {0});\n", indexOffset));
        source.append("\t\t\t\t\t}\n");
        source.append("\t\t\t\t\tresult = ret_val;\n");
        source.append("\t\t\t\t\tbreak;\n");
        source.append("\t\t\t\t} else if (ret_val == TitanAlt_Status.ALT_REPEAT || (ret_val == TitanAlt_Status.ALT_MAYBE && result == TitanAlt_Status.ALT_NO)) {\n");
        source.append("\t\t\t\t\tresult = ret_val;\n");
        source.append("\t\t\t\t}\n");
        source.append("\t\t\t}\n");
        source.append("\t\t\tif (index_redirect != null) {\n");
        source.append("\t\t\t\tindex_redirect.decr_pos();\n");
        source.append("\t\t\t}\n");
        source.append("\t\t\treturn result;\n");
        source.append("\t\t}\n");
    }

    private static void generateArrayBodyTypedGetreply(StringBuilder source, PortDefinition portDefinition, int index, procedureSignatureInfo info, boolean isCheck, boolean isAddress, long arraySize, long indexOffset) {
        String functionName = isCheck ? "check_getreply" : "getreply";
        String senderType = isAddress ? portDefinition.addressName : "TitanComponent";
        source.append(MessageFormat.format("\t\tpublic TitanAlt_Status {0}(final {1}_template getreply_template, final {2}_template sender_template, final {1}_reply_redirect param_ref, final {2} sender_pointer, final TitanFloat timestamp_redirect, final Index_Redirect index_redirect) '{'\n", functionName, info.mJavaTypeName, senderType));
        source.append("\t\t\tif (index_redirect != null) {\n");
        source.append("\t\t\t\tindex_redirect.incr_pos();\n");
        source.append("\t\t\t}\n");
        source.append("\t\t\tTitanAlt_Status result = TitanAlt_Status.ALT_NO;\n");
        source.append(MessageFormat.format("\t\t\tfor (int i = 0; i < {0}; i++) '{'\n", arraySize));
        source.append(MessageFormat.format("\t\t\t\tfinal TitanAlt_Status ret_val = get_at(i).{0}(getreply_template, sender_template, param_ref, sender_pointer, timestamp_redirect, index_redirect);\n", functionName));
        source.append("\t\t\t\tif (ret_val == TitanAlt_Status.ALT_YES) {\n");
        source.append("\t\t\t\t\tif (index_redirect != null) {\n");
        source.append(MessageFormat.format("\t\t\t\t\t\tindex_redirect.add_index(i + {0});\n", indexOffset));
        source.append("\t\t\t\t\t}\n");
        source.append("\t\t\t\t\tresult = ret_val;\n");
        source.append("\t\t\t\t\tbreak;\n");
        source.append("\t\t\t\t} else if (ret_val == TitanAlt_Status.ALT_REPEAT || (ret_val == TitanAlt_Status.ALT_MAYBE && result == TitanAlt_Status.ALT_NO)) {\n");
        source.append("\t\t\t\t\tresult = ret_val;\n");
        source.append("\t\t\t\t}\n");
        source.append("\t\t\t}\n");
        source.append("\t\t\tif (index_redirect != null) {\n");
        source.append("\t\t\t\tindex_redirect.decr_pos();\n");
        source.append("\t\t\t}\n");
        source.append("\t\t\treturn result;\n");
        source.append("\t\t}\n");
    }

    private static void generateArrayBodyTypedGetexception(StringBuilder source, PortDefinition portDefinition, int index, procedureSignatureInfo info, boolean isCheck, boolean isAddress, long arraySize, long indexOffset) {
        String functionName = isCheck ? "check_catch" : "get_exception";
        String senderType = isAddress ? portDefinition.addressName : "TitanComponent";
        source.append(MessageFormat.format("\t\tpublic TitanAlt_Status {0}(final {1}_exception_template catch_template, final {2}_template sender_template, final {2} sender_pointer, final TitanFloat timestamp_redirect, final Index_Redirect index_redirect) '{'\n", functionName, info.mJavaTypeName, senderType));
        source.append("\t\t\tif (index_redirect != null) {\n");
        source.append("\t\t\t\tindex_redirect.incr_pos();\n");
        source.append("\t\t\t}\n");
        source.append("\t\t\tTitanAlt_Status result = TitanAlt_Status.ALT_NO;\n");
        source.append(MessageFormat.format("\t\t\tfor (int i = 0; i < {0}; i++) '{'\n", arraySize));
        source.append(MessageFormat.format("\t\t\t\tfinal TitanAlt_Status ret_val = get_at(i).{0}(catch_template, sender_template, sender_pointer, timestamp_redirect, index_redirect);\n", functionName));
        source.append("\t\t\t\tif (ret_val == TitanAlt_Status.ALT_YES) {\n");
        source.append("\t\t\t\t\tif (index_redirect != null) {\n");
        source.append(MessageFormat.format("\t\t\t\t\t\tindex_redirect.add_index(i + {0});\n", indexOffset));
        source.append("\t\t\t\t\t}\n");
        source.append("\t\t\t\t\tresult = ret_val;\n");
        source.append("\t\t\t\t\tbreak;\n");
        source.append("\t\t\t\t} else if (ret_val == TitanAlt_Status.ALT_REPEAT || (ret_val == TitanAlt_Status.ALT_MAYBE && result == TitanAlt_Status.ALT_NO)) {\n");
        source.append("\t\t\t\t\tresult = ret_val;\n");
        source.append("\t\t\t\t}\n");
        source.append("\t\t\t}\n");
        source.append("\t\t\tif (index_redirect != null) {\n");
        source.append("\t\t\t\tindex_redirect.decr_pos();\n");
        source.append("\t\t\t}\n");
        source.append("\t\t\treturn result;\n");
        source.append("\t\t}\n");
    }

    private static final String nameToByteArray(String name) {
        StringBuilder builder = new StringBuilder();
        builder.append("new byte[]{ ");
        for (int i = 0; i < name.length(); ++i) {
            if (i != 0) {
                builder.append(", ");
            }
            builder.append((int)name.charAt(i));
        }
        builder.append('}');
        return builder.toString();
    }

    public static class PortDefinition {
        public String javaName;
        public String displayName;
        public String addressName;
        public ArrayList<messageTypeInfo> inMessages = new ArrayList();
        public ArrayList<MessageMappedTypeInfo> outMessages = new ArrayList();
        public ArrayList<procedureSignatureInfo> inProcedures = new ArrayList();
        public ArrayList<procedureSignatureInfo> outProcedures = new ArrayList();
        public TestportType testportType;
        public PortType portType;
        public ArrayList<portMessageProvider> providerMessageOutList;
        public ArrayList<MessageMappedTypeInfo> providerInMessages = new ArrayList();
        public boolean has_sliding;
        public boolean legacy;
        public String varDefs;
        public String varInit;
        public String translationFunctions;
        public boolean realtime;

        public PortDefinition(String genName, String displayName) {
            this.javaName = genName;
            this.displayName = displayName;
        }
    }

    public static class portMessageProvider {
        private final String name;
        private final ArrayList<String> outMessageTypeNames;
        private final boolean realtime;

        public portMessageProvider(String name, ArrayList<String> outMessageTypeNames, boolean realtime) {
            this.name = name;
            this.outMessageTypeNames = outMessageTypeNames;
            this.realtime = realtime;
        }
    }

    public static final class procedureSignatureInfo {
        private final String mJavaTypeName;
        private final String mDisplayName;
        private final boolean isNoBlock;
        private final boolean hasExceptions;
        private final boolean hasReturnValue;

        public procedureSignatureInfo(String procedureType, String displayName, boolean isNoBlock, boolean hasExceptions, boolean hasReturnValue) {
            this.mJavaTypeName = procedureType;
            this.mDisplayName = displayName;
            this.isNoBlock = isNoBlock;
            this.hasExceptions = hasExceptions;
            this.hasReturnValue = hasReturnValue;
        }
    }

    public static class MessageMappedTypeInfo {
        private final String mJavaTypeName;
        private final String mJavaTemplateName;
        public final String mDisplayName;
        private final ArrayList<MessageTypeMappingTarget> targets;

        public MessageMappedTypeInfo(String messageType, String messageTemplate, String displayName) {
            this.mJavaTypeName = messageType;
            this.mJavaTemplateName = messageTemplate;
            this.mDisplayName = displayName;
            this.targets = new ArrayList();
        }

        public void addTarget(MessageTypeMappingTarget newTarget) {
            this.targets.add(newTarget);
        }

        public void addTargets(ArrayList<MessageTypeMappingTarget> newTargets) {
            this.targets.addAll(newTargets);
        }
    }

    public static class MessageTypeMappingTarget {
        private String targetName;
        private String targetDisplayName;
        public int targetIndex;
        private final MessageMappingType_type mappingType;
        private String functionDisplayName;
        private String functionName;
        private FunctionPrototype_Type functionPrototype;
        private String encdecTypedesriptorName;
        private String encdecEncodingType;
        private String encdecEncodingOptions;
        private String encdecErrorBehaviour;

        public MessageTypeMappingTarget() {
            this.mappingType = MessageMappingType_type.DISCARD;
        }

        public MessageTypeMappingTarget(String targetType, String displayName) {
            this.targetName = targetType;
            this.targetDisplayName = displayName;
            this.mappingType = MessageMappingType_type.SIMPLE;
        }

        public MessageTypeMappingTarget(String targetType, String displayName, String functionName, String functionDisplayName, FunctionPrototype_Type functionPrototype) {
            this.targetName = targetType;
            this.targetDisplayName = displayName;
            this.functionName = functionName;
            this.functionDisplayName = functionDisplayName;
            this.functionPrototype = functionPrototype;
            this.mappingType = MessageMappingType_type.FUNCTION;
        }

        public MessageTypeMappingTarget(String targetType, String displayName, String typedescriptorName, String encodingType, String encodingOptions, String errorbeviour, MessageMappingType_type mappingType) {
            this.targetName = targetType;
            this.targetDisplayName = displayName;
            this.encdecTypedesriptorName = typedescriptorName;
            this.encdecEncodingType = encodingType;
            this.encdecEncodingOptions = encodingOptions;
            this.encdecErrorBehaviour = errorbeviour;
            this.mappingType = mappingType;
        }
    }

    public static enum FunctionPrototype_Type {
        CONVERT,
        FAST,
        BACKTRACK,
        SLIDING;

    }

    public static enum MessageMappingType_type {
        SIMPLE,
        DISCARD,
        FUNCTION,
        ENCODE,
        DECODE;

    }

    public static class messageTypeInfo {
        private final String mJavaTypeName;
        private final String mJavaTemplateName;
        private final String mDisplayName;

        public messageTypeInfo(String messageType, String messageTemplate, String displayName) {
            this.mJavaTypeName = messageType;
            this.mJavaTemplateName = messageTemplate;
            this.mDisplayName = displayName;
        }
    }

    public static enum PortType {
        REGULAR,
        PROVIDER,
        USER;

    }

    public static enum TestportType {
        NORMAL,
        INTERNAL,
        ADDRESS;

    }
}

