/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.values;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.TTCN3.types.CharString_Type;
import org.eclipse.titan.designer.AST.TTCN3.values.UniversalChar;
import org.eclipse.titan.designer.AST.TTCN3.values.UniversalCharstring;

public class PredefFunc {
    private static final String utf32be = "0000FEFF";
    private static final String utf32le = "FFFE0000";
    private static final String utf16be = "FEFF";
    private static final String utf16le = "FFFE";
    private static final String utf8 = "EFBBBF";

    private PredefFunc() {
    }

    public static char hexdigit_to_char(char hexdigit) throws DecodeException {
        if (hexdigit < '\n') {
            return (char)(48 + hexdigit);
        }
        if (hexdigit < '\u0010') {
            return (char)(65 + hexdigit - 10);
        }
        throw new DecodeException(MessageFormat.format("hexdigit_to_char(): invalid argument: {0}", Character.valueOf(hexdigit)));
    }

    public static char char_to_hexdigit(char c) throws DecodeException {
        if (c >= '0' && c <= '9') {
            return (char)(c - 48);
        }
        if (c >= 'A' && c <= 'F') {
            return (char)(c - 65 + 10);
        }
        if (c >= 'a' && c <= 'f') {
            return (char)(c - 97 + 10);
        }
        throw new DecodeException(MessageFormat.format("char_to_hexdigit(): invalid argument: {0}", Character.valueOf(c)));
    }

    public static char str2uchar(char c1, char c2) throws DecodeException {
        char uc = '\u0000';
        uc = PredefFunc.char_to_hexdigit(c1);
        uc = (char)(uc << 4);
        uc = (char)(uc + PredefFunc.char_to_hexdigit(c2));
        return uc;
    }

    private static boolean findBom(String s, String bom) {
        return s.regionMatches(true, 0, bom, 0, bom.length());
    }

    public static String remove_bom(String encoded_value) throws DecodeException {
        int length = encoded_value.length();
        if (0 == length) {
            return "";
        }
        if (length % 2 != 0) {
            throw new DecodeException(MessageFormat.format("remove_bom(): Wrong string. The number of nibbles ({0}) in string shall be divisible by 2", length));
        }
        int length_of_BOM = 0;
        String upperCaseString = encoded_value.toUpperCase();
        if (upperCaseString.startsWith(utf32be)) {
            length_of_BOM = utf32be.length();
        } else if (upperCaseString.startsWith(utf32le)) {
            length_of_BOM = utf32le.length();
        } else if (upperCaseString.startsWith(utf16be)) {
            length_of_BOM = utf16be.length();
        } else if (upperCaseString.startsWith(utf16le)) {
            length_of_BOM = utf16le.length();
        } else if (upperCaseString.startsWith(utf8)) {
            length_of_BOM = utf8.length();
        } else {
            return encoded_value;
        }
        return encoded_value.substring(length_of_BOM, length);
    }

    public static CharString_Type.CharCoding is_ascii(String strptr) {
        int length = strptr.length();
        int nonASCII = 128;
        CharString_Type.CharCoding ret = CharString_Type.CharCoding.ASCII;
        for (int i = 0; i < length; ++i) {
            if ((strptr.charAt(i) & 0x80) == 0) continue;
            ret = CharString_Type.CharCoding.UNKNOWN;
            break;
        }
        return ret;
    }

    private static CharString_Type.CharCoding is_utf8(String strptr) {
        int length = strptr.length();
        int MSB = 128;
        int MSBmin1 = 64;
        for (int i = 0; length > i; ++i) {
            if ((strptr.charAt(i) & 0x80) == 0) continue;
            int maskUTF8 = 64;
            if ((strptr.charAt(i) & maskUTF8) == 0) {
                return CharString_Type.CharCoding.UNKNOWN;
            }
            int noofUTF8 = 0;
            while ((strptr.charAt(i) & maskUTF8) != 0) {
                ++noofUTF8;
                maskUTF8 = (char)(maskUTF8 >> 1);
            }
            while (0 < noofUTF8) {
                if (++i >= length || (strptr.charAt(i) & 0x80) == 0 || (strptr.charAt(i) & 0x40) != 0) {
                    return CharString_Type.CharCoding.UNKNOWN;
                }
                --noofUTF8;
            }
        }
        return CharString_Type.CharCoding.UTF_8;
    }

    public static CharString_Type.CharCoding get_stringencoding(String encoded_value, Location location) {
        int length = encoded_value.length();
        if (0 == length) {
            return CharString_Type.CharCoding.UNKNOWN;
        }
        if (length % 2 != 0) {
            location.reportSemanticError(MessageFormat.format("get_stringencoding(): Wrong string. The number of nibbles ({0}) in string shall be divisible by 2", length));
            return CharString_Type.CharCoding.UNKNOWN;
        }
        String upperCaseString = encoded_value.toUpperCase();
        if (upperCaseString.startsWith(utf32be)) {
            return CharString_Type.CharCoding.UTF32BE;
        }
        if (upperCaseString.startsWith(utf32le)) {
            return CharString_Type.CharCoding.UTF32LE;
        }
        if (upperCaseString.startsWith(utf16be)) {
            return CharString_Type.CharCoding.UTF16BE;
        }
        if (upperCaseString.startsWith(utf16le)) {
            return CharString_Type.CharCoding.UTF16LE;
        }
        if (upperCaseString.startsWith(utf8)) {
            return CharString_Type.CharCoding.UTF_8;
        }
        StringBuilder uc_str = new StringBuilder();
        for (int i = 0; i < length / 2; ++i) {
            try {
                uc_str.append(PredefFunc.str2uchar(encoded_value.charAt(2 * i), encoded_value.charAt(2 * i + 1)));
                continue;
            }
            catch (DecodeException e) {
                return CharString_Type.CharCoding.UNKNOWN;
            }
        }
        CharString_Type.CharCoding ret = PredefFunc.is_ascii(uc_str.toString()) == CharString_Type.CharCoding.ASCII ? CharString_Type.CharCoding.ASCII : (CharString_Type.CharCoding.UTF_8 == PredefFunc.is_utf8(uc_str.toString()) ? CharString_Type.CharCoding.UTF_8 : CharString_Type.CharCoding.UNKNOWN);
        return ret;
    }

    private static int check_BOM(CharString_Type.CharCoding expected_coding, int n_uc, String uc_str) throws DecodeException {
        if (0 == n_uc) {
            return 0;
        }
        switch (expected_coding) {
            case UTF32: 
            case UTF32BE: 
            case UTF32LE: {
                if (4 <= n_uc) break;
                throw new DecodeException("decode_utf32(): The string is shorter than the expected BOM");
            }
            case UTF16: 
            case UTF16BE: 
            case UTF16LE: {
                if (2 <= n_uc) break;
                throw new DecodeException("decode_utf16(): The string is shorter than the expected BOM");
            }
        }
        boolean badBOM = false;
        String errmsg = "<UNKNOWN>";
        String caller = "<UNKNOWN>";
        switch (expected_coding) {
            case UTF32: 
            case UTF32BE: {
                if ('\u0000' == uc_str.charAt(0) && '\u0000' == uc_str.charAt(1) && '\u00fe' == uc_str.charAt(2) && '\u00ff' == uc_str.charAt(3)) {
                    return 4;
                }
                badBOM = true;
                caller = "decode_utf32()";
                errmsg = "UTF-32BE";
                break;
            }
            case UTF32LE: {
                if ('\u00ff' == uc_str.charAt(0) && '\u00fe' == uc_str.charAt(1) && '\u0000' == uc_str.charAt(2) && '\u0000' == uc_str.charAt(3)) {
                    return 4;
                }
                badBOM = true;
                caller = "decode_utf32()";
                errmsg = "UTF-32LE";
                break;
            }
            case UTF16: 
            case UTF16BE: {
                if ('\u00fe' == uc_str.charAt(0) && '\u00ff' == uc_str.charAt(1)) {
                    return 2;
                }
                badBOM = true;
                caller = "decode_utf16()";
                errmsg = "UTF-16BE";
                break;
            }
            case UTF16LE: {
                if ('\u00ff' == uc_str.charAt(0) && '\u00fe' == uc_str.charAt(1)) {
                    return 2;
                }
                badBOM = true;
                caller = "decode_utf16()";
                errmsg = "UTF-16LE";
                break;
            }
            case UTF_8: {
                if ('\u00ef' == uc_str.charAt(0) && '\u00bb' == uc_str.charAt(1) && '\u00bf' == uc_str.charAt(2)) {
                    return 3;
                }
                return 0;
            }
            default: {
                if (CharString_Type.CharCoding.UTF32 == expected_coding || CharString_Type.CharCoding.UTF16 == expected_coding) {
                    String str = CharString_Type.CharCoding.UTF32 == expected_coding ? "UTF-32" : "UTF-16";
                    throw new DecodeException(MessageFormat.format("Wrong {0} string. No BOM detected, however the given coding type ({1}) expects it to define the endianness", str, str));
                }
                throw new DecodeException("Wrong string. No BOM detected");
            }
        }
        if (badBOM) {
            throw new DecodeException(MessageFormat.format("{0}: Wrong {1} string. The expected coding could not be verified", caller, errmsg));
        }
        return 0;
    }

    private static void fill_continuing_octets(int n_continuing, List<Character> continuing_ptr, int n_uc, StringBuilder uc_str, int start_pos, int uchar_pos) throws DecodeException {
        for (int i = 0; i < n_continuing; ++i) {
            if (start_pos + i < n_uc) {
                char octet = uc_str.charAt(start_pos + i);
                if ((octet & 0xC0) != 128) {
                    throw new DecodeException(MessageFormat.format("decode_utf8(): Malformed: At character position {0}, octet position {1}: {2} is not a valid continuing octet.", uchar_pos, start_pos + i, String.format("0x%02X", (byte)octet)));
                }
                continuing_ptr.add(Character.valueOf((char)(octet & 0x3F)));
                continue;
            }
            if (start_pos + i == n_uc) {
                if (i > 0) {
                    throw new DecodeException(MessageFormat.format("decode_utf8(): Incomplete: At character position {0}, octet position {1}: {2} out of {3} continuing octets {4} missing from the end of the stream.", uchar_pos, start_pos + i, n_continuing - i, n_continuing, n_continuing - i > 1 ? "are" : "is"));
                }
                throw new DecodeException(MessageFormat.format("decode_utf8(): Incomplete: At character position {0}, octet position {1}: {2} continuing octet{3} missing from the end of the stream.", uchar_pos, start_pos, n_continuing, n_continuing > 1 ? "s are" : " is"));
            }
            continuing_ptr.add(Character.valueOf('\u0000'));
        }
    }

    public static UniversalCharstring decode_utf8(String ostr, CharString_Type.CharCoding expected_coding) throws Exception {
        int start;
        int length = ostr.length();
        if (0 == length) {
            return new UniversalCharstring();
        }
        if (length % 2 != 0) {
            throw new DecodeException(MessageFormat.format("decode_utf8(): Wrong UTF-8 string. The number of nibbles ({0}) in octetstring shall be divisible by 2", length));
        }
        StringBuilder uc_str = new StringBuilder();
        for (int i = 0; i < length / 2; ++i) {
            uc_str.append(PredefFunc.str2uchar(ostr.charAt(2 * i), ostr.charAt(2 * i + 1)));
        }
        UniversalCharstring ucstr = new UniversalCharstring();
        int i = start = PredefFunc.check_BOM(CharString_Type.CharCoding.UTF_8, length / 2, uc_str.toString());
        while (i < length / 2) {
            char c;
            char r;
            char p;
            char g;
            if (uc_str.charAt(i) <= '\u007f') {
                boolean g2 = false;
                boolean p2 = false;
                boolean r2 = false;
                char c2 = uc_str.charAt(i);
                ucstr.append(new UniversalChar(0, 0, 0, c2));
                ++i;
                continue;
            }
            if (uc_str.charAt(i) <= '\u00bf') {
                throw new DecodeException(MessageFormat.format("decode_utf8(): Malformed: At character position {0}, octet position {1}: continuing octet {2} without leading octet.", ucstr.length(), i, String.format("0x%02X", (byte)uc_str.charAt(i))));
            }
            if (uc_str.charAt(i) <= '\u00df') {
                ArrayList<Character> octets = new ArrayList<Character>();
                octets.add(Character.valueOf((char)(uc_str.charAt(i) & 0x1F)));
                PredefFunc.fill_continuing_octets(1, octets, length / 2, uc_str, i + 1, ucstr.length());
                g = '\u0000';
                p = '\u0000';
                r = (char)(((Character)octets.get(0)).charValue() >> 2);
                c = (char)(((Character)octets.get(0)).charValue() << 6 | ((Character)octets.get(1)).charValue());
                if (r == '\u0000' && c < '\u0080') {
                    throw new DecodeException(MessageFormat.format("decode_utf8(): Overlong: At character position {0}, octet position {1}: 2-octet encoding for quadruple (0, 0, 0, {2}).", ucstr.length(), i, Character.valueOf(c)));
                }
                ucstr.append(new UniversalChar(0, 0, r, c));
                i += 2;
                continue;
            }
            if (uc_str.charAt(i) <= '\u00ef') {
                ArrayList<Character> octets = new ArrayList<Character>();
                octets.add(Character.valueOf((char)(uc_str.charAt(i) & 0xF)));
                PredefFunc.fill_continuing_octets(2, octets, length / 2, uc_str, i + 1, ucstr.length());
                g = '\u0000';
                p = '\u0000';
                r = (char)(((Character)octets.get(0)).charValue() << 4 | ((Character)octets.get(1)).charValue() >> 2);
                c = (char)(((Character)octets.get(1)).charValue() << 6 | ((Character)octets.get(2)).charValue());
                if (r < '\b') {
                    throw new DecodeException(MessageFormat.format("decode_utf8(): Overlong: At character position {0}, octet position {1}: 3-octet encoding for quadruple (0, 0, {2}, {3}).", ucstr.length(), i, Character.valueOf(r), Character.valueOf(c)));
                }
                ucstr.append(new UniversalChar(0, 0, r, c));
                i += 3;
                continue;
            }
            if (uc_str.charAt(i) <= '\u00f7') {
                ArrayList<Character> octets = new ArrayList<Character>();
                octets.add(Character.valueOf((char)(uc_str.charAt(i) & 7)));
                PredefFunc.fill_continuing_octets(3, octets, length / 2, uc_str, i + 1, ucstr.length());
                g = '\u0000';
                p = (char)(((Character)octets.get(0)).charValue() << 2 | ((Character)octets.get(1)).charValue() >> 4);
                r = (char)(((Character)octets.get(1)).charValue() << 4 | ((Character)octets.get(2)).charValue() >> 2);
                c = (char)(((Character)octets.get(2)).charValue() << 6 | ((Character)octets.get(3)).charValue());
                if (p == '\u0000') {
                    throw new DecodeException(MessageFormat.format("decode_utf8(): Overlong: At character position {0}, octet position {1}: 4-octet encoding for quadruple (0, 0, {2}, {3}).", ucstr.length(), i, Character.valueOf(r), Character.valueOf(c)));
                }
                ucstr.append(new UniversalChar(0, p, r, c));
                i += 4;
                continue;
            }
            if (uc_str.charAt(i) <= '\u00fb') {
                ArrayList<Character> octets = new ArrayList<Character>();
                octets.add(Character.valueOf((char)(uc_str.charAt(i) & 3)));
                PredefFunc.fill_continuing_octets(4, octets, length / 2, uc_str, i + 1, ucstr.length());
                g = ((Character)octets.get(0)).charValue();
                p = (char)(((Character)octets.get(1)).charValue() << 2 | ((Character)octets.get(2)).charValue() >> 4);
                r = (char)(((Character)octets.get(2)).charValue() << 4 | ((Character)octets.get(3)).charValue() >> 2);
                c = (char)(((Character)octets.get(3)).charValue() << 6 | ((Character)octets.get(4)).charValue());
                if (g == '\u0000' && p < ' ') {
                    throw new DecodeException(MessageFormat.format("decode_utf8(): Overlong: At character position {0}, octet position {1}: 5-octet encoding for quadruple (0, {2}, {3}, {4}).", ucstr.length(), i, Character.valueOf(p), Character.valueOf(r), Character.valueOf(c)));
                }
                ucstr.append(new UniversalChar(g, p, r, c));
                i += 5;
                continue;
            }
            if (uc_str.charAt(i) <= '\u00fd') {
                ArrayList<Character> octets = new ArrayList<Character>();
                octets.add(Character.valueOf((char)(uc_str.charAt(i) & '\u0001')));
                PredefFunc.fill_continuing_octets(5, octets, length / 2, uc_str, i + 1, ucstr.length());
                g = (char)(((Character)octets.get(0)).charValue() << 6 | ((Character)octets.get(1)).charValue());
                p = (char)(((Character)octets.get(2)).charValue() << 2 | ((Character)octets.get(3)).charValue() >> 4);
                r = (char)(((Character)octets.get(3)).charValue() << 4 | ((Character)octets.get(4)).charValue() >> 2);
                c = (char)(((Character)octets.get(4)).charValue() << 6 | ((Character)octets.get(5)).charValue());
                if (g < '\u0004') {
                    throw new DecodeException(MessageFormat.format("decode_utf8(): Overlong: At character position {0}, octet position {1}: 6-octet encoding for quadruple ({2}, {3}, {4}, {5}).", ucstr.length(), i, Character.valueOf(g), Character.valueOf(p), Character.valueOf(r), Character.valueOf(c)));
                }
                ucstr.append(new UniversalChar(g, p, r, c));
                i += 6;
                continue;
            }
            throw new DecodeException(MessageFormat.format("decode_utf8(): Malformed: At character position {0}, octet position {1}: unused/reserved octet {2}.", ucstr.length(), i, String.format("0x%02X", (byte)uc_str.charAt(i))));
        }
        return ucstr;
    }

    public static class DecodeException
    extends Exception {
        private static final long serialVersionUID = -5356312750957137499L;

        public DecodeException(String msg) {
            super(msg);
        }
    }
}

