/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.values;

import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.FieldSubReference;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.types.Float_Type;
import org.eclipse.titan.designer.AST.TTCN3.values.Integer_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Sequence_Value;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Real_Value
extends Value {
    private double value;

    public Real_Value(double value) {
        this.value = value;
    }

    public Real_Value(CompilationTimeStamp timestamp, Sequence_Value original) {
        this.copyGeneralProperties(original);
        boolean erroneous = false;
        Identifier mantissaID = new Identifier(Identifier.Identifier_type.ID_ASN, "mantissa");
        int mantissa = 0;
        if (original.hasComponentWithName(mantissaID)) {
            IValue tmpValue = original.getComponentByName(mantissaID).getValue();
            if (tmpValue != null) {
                ReferenceChain referenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
                tmpValue = tmpValue.getValueRefdLast(timestamp, referenceChain);
                referenceChain.release();
                if (IValue.Value_type.INTEGER_VALUE.equals((Object)tmpValue.getValuetype())) {
                    if (((Integer_Value)tmpValue).isNative()) {
                        mantissa = ((Integer_Value)tmpValue).intValue();
                    } else {
                        tmpValue.getLocation().reportSemanticError(MessageFormat.format("Mantissa `{0}'' should be less than `{1}''", ((Integer_Value)tmpValue).getValueValue(), Integer.MAX_VALUE));
                        erroneous = true;
                    }
                } else {
                    erroneous = true;
                }
            }
        } else {
            erroneous = true;
        }
        Identifier baseID = new Identifier(Identifier.Identifier_type.ID_ASN, "base");
        int base = 0;
        if (original.hasComponentWithName(baseID)) {
            IValue tmpValue = original.getComponentByName(baseID).getValue();
            if (tmpValue != null) {
                ReferenceChain referenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
                tmpValue = tmpValue.getValueRefdLast(timestamp, referenceChain);
                referenceChain.release();
                if (IValue.Value_type.INTEGER_VALUE.equals((Object)tmpValue.getValuetype())) {
                    BigInteger temp = ((Integer_Value)tmpValue).getValueValue();
                    if (!erroneous && temp.compareTo(BigInteger.TEN) != 0 && temp.compareTo(BigInteger.valueOf(2L)) != 0) {
                        tmpValue.getLocation().reportSemanticError("Base of the REAL must be 2 or 10");
                        erroneous = true;
                    } else {
                        base = ((Integer_Value)tmpValue).intValue();
                    }
                } else {
                    erroneous = true;
                }
            }
        } else {
            erroneous = true;
        }
        Identifier exponentID = new Identifier(Identifier.Identifier_type.ID_ASN, "exponent");
        int exponent = 0;
        if (original.hasComponentWithName(exponentID)) {
            IValue tmpValue = original.getComponentByName(exponentID).getValue();
            if (tmpValue != null) {
                ReferenceChain referenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
                tmpValue = tmpValue.getValueRefdLast(timestamp, referenceChain);
                referenceChain.release();
                if (IValue.Value_type.INTEGER_VALUE.equals((Object)tmpValue.getValuetype())) {
                    if (((Integer_Value)tmpValue).isNative()) {
                        exponent = ((Integer_Value)tmpValue).intValue();
                    } else {
                        tmpValue.getLocation().reportSemanticError(MessageFormat.format("Exponent `{0}'' should be less than `{1}''", ((Integer_Value)tmpValue).getValueValue(), Integer.MAX_VALUE));
                        erroneous = true;
                    }
                } else {
                    erroneous = true;
                }
            }
        } else {
            erroneous = true;
        }
        if (erroneous) {
            this.setIsErroneous(true);
            this.lastTimeChecked = timestamp;
            this.value = 0.0;
        } else {
            this.value = (float)((double)mantissa * Math.pow(base, exponent));
        }
    }

    @Override
    public IValue.Value_type getValuetype() {
        return IValue.Value_type.REAL_VALUE;
    }

    @Override
    public String createStringRepresentation() {
        return Double.toString(this.value);
    }

    public double getValue() {
        return this.value;
    }

    public void changeSign() {
        this.value *= -1.0;
    }

    @Override
    public IType.Type_type getExpressionReturntype(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        return IType.Type_type.TYPE_REAL;
    }

    @Override
    public IType getExpressionGovernor(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        if (this.myGovernor != null) {
            return this.myGovernor;
        }
        return new Float_Type();
    }

    @Override
    public IValue getReferencedSubValue(CompilationTimeStamp timestamp, Reference reference, int actualSubReference, IReferenceChain refChain) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (this.getIsErroneous(timestamp) || subreferences.size() <= actualSubReference) {
            return this;
        }
        IType type = this.myGovernor.getTypeRefdLast(timestamp);
        ISubReference subreference = subreferences.get(actualSubReference);
        switch (subreference.getReferenceType()) {
            case arraySubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid array element reference: type `{0}'' can not be indexed", type.getTypename()));
                return null;
            }
            case fieldSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((FieldSubReference)subreference).getId().getDisplayName(), type.getTypename()));
                return null;
            }
            case parameterisedSubReference: {
                subreference.getLocation().reportSemanticError("Invalid reference: internal parameterisation is not supported");
                return null;
            }
        }
        subreference.getLocation().reportSemanticError("Unsupported subreference kind.");
        return null;
    }

    @Override
    public boolean isUnfoldable(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        return false;
    }

    @Override
    public boolean checkEquality(CompilationTimeStamp timestamp, IValue other) {
        ReferenceChain referenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
        IValue last = other.getValueRefdLast(timestamp, referenceChain);
        referenceChain.release();
        return IValue.Value_type.REAL_VALUE.equals((Object)last.getValuetype()) && Double.compare(this.value, ((Real_Value)last).getValue()) == 0;
    }

    public String toString() {
        return Double.toString(this.value);
    }

    @Override
    public boolean evaluateIsvalue(boolean fromSequence) {
        return true;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
    }

    public boolean isPositiveInfinity() {
        return Double.isInfinite(this.value) && this.value > 0.0;
    }

    public boolean isNegativeInfinity() {
        return Double.isInfinite(this.value) && this.value < 0.0;
    }

    public boolean isSpecialFloat() {
        return Double.isInfinite(this.value) || Double.isNaN(this.value);
    }

    public boolean isNaN() {
        return Double.isNaN(this.value);
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        return true;
    }

    @Override
    public boolean canGenerateSingleExpression() {
        return true;
    }

    @Override
    public StringBuilder generateSingleExpression(JavaGenData aData) {
        aData.addBuiltinTypeImport("Ttcn3Float");
        StringBuilder result = new StringBuilder();
        result.append(MessageFormat.format("new Ttcn3Float( {0} )", this.createJavaStringRepresentation()));
        return result;
    }

    @Override
    public boolean returnsNative() {
        return true;
    }

    private String createJavaStringRepresentation() {
        if (Double.isNaN(this.value)) {
            return "Double.NaN";
        }
        if (Double.isInfinite(this.value)) {
            if (Double.compare(this.value, 0.0) > 0) {
                return "Double.POSITIVE_INFINITY";
            }
            return "Double.NEGATIVE_INFINITY";
        }
        if (this.value == 0.0) {
            if (1.0 / this.value == Double.NEGATIVE_INFINITY) {
                return "-0.0";
            }
            return "0.0";
        }
        return Double.toString(this.value);
    }

    @Override
    public StringBuilder generateCodeInit(JavaGenData aData, StringBuilder source, String name) {
        source.append(MessageFormat.format("{0}.operator_assign({1});\n", name, this.generateSingleExpression(aData)));
        this.lastTimeGenerated = aData.getBuildTimstamp();
        return source;
    }
}

