/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.metrics.preferences;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.titanium.metrics.IMetricEnum;
import org.eclipse.titanium.metrics.preferences.IRiskEditorListener;
import org.eclipse.titanium.metrics.preferences.IRiskEditorPropertyListener;
import org.eclipse.titanium.metrics.preferences.IRiskFieldEditor;
import org.eclipse.titanium.metrics.preferences.PreferenceManager;
import org.eclipse.titanium.metrics.preferences.RiskMethod;

public class SimpleRiskFieldEditor
implements IRiskFieldEditor {
    protected final IMetricEnum owner;
    private IRiskEditorPropertyListener propertyListener;
    private boolean valid;
    protected final Composite shell;
    private final Combo method;
    protected RiskMethod old;
    protected Spinner[] spinners;
    protected List<IRiskEditorListener> listeners;

    public SimpleRiskFieldEditor(Composite parent, IMetricEnum owner) {
        this.owner = owner;
        this.shell = new Composite(parent, 0);
        GridLayout l = new GridLayout();
        l.numColumns = 3;
        this.shell.setLayout((Layout)l);
        this.method = new Combo(this.shell, 0);
        for (RiskMethod m : RiskMethod.values()) {
            this.method.add(m.getText());
        }
        this.method.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RiskMethod newMethod = RiskMethod.myMethod(SimpleRiskFieldEditor.this.method.getSelectionIndex());
                if (newMethod != SimpleRiskFieldEditor.this.old) {
                    SimpleRiskFieldEditor.this.old = newMethod;
                    SimpleRiskFieldEditor.this.updateSpinners(newMethod, false);
                    SimpleRiskFieldEditor.this.firePropChanged();
                }
            }
        });
        this.method.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SimpleRiskFieldEditor.this.firePropChanged();
            }
        });
        this.spinners = new Spinner[0];
        this.listeners = new ArrayList<IRiskEditorListener>();
    }

    @Override
    public void load() {
        this.doLoad(false);
        this.old = RiskMethod.myMethod(this.method.getSelectionIndex());
        this.checkValid();
    }

    @Override
    public void loadDefault() {
        this.doLoad(true);
        this.old = RiskMethod.myMethod(this.method.getSelectionIndex());
        this.checkValid();
    }

    @Override
    public void store() {
        Number[] n = new Number[this.spinners.length];
        for (int i = 0; i < this.spinners.length; ++i) {
            n[i] = this.spinners[i].getSelection();
        }
        PreferenceManager.storeRisk(this.owner, this.old, n);
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public void setPropListener(IRiskEditorPropertyListener propertyListener) {
        this.propertyListener = propertyListener;
    }

    protected void firePropChanged() {
        if (this.propertyListener != null) {
            this.checkValid();
            this.propertyListener.propertyChange(this.valid);
        }
    }

    protected void checkValid() {
        this.valid = this.old != RiskMethod.NO_LOW_HIGH || this.spinners[0].getSelection() <= this.spinners[1].getSelection();
    }

    private void doLoad(boolean toDefault) {
        RiskMethod m = PreferenceManager.getRiskMethod(this.owner, toDefault);
        this.updateSpinners(m, toDefault);
        this.method.select(m.ordinal());
    }

    protected void updateSpinners(RiskMethod m, boolean toDefault) {
        for (Spinner s : this.spinners) {
            s.dispose();
        }
        Number[] limits = this.getLimits(m, toDefault);
        switch (m) {
            case NEVER: {
                this.spinners = new Spinner[0];
                break;
            }
            case NO_HIGH: 
            case NO_LOW: {
                this.spinners = new Spinner[1];
                this.spinners[0] = new Spinner(this.shell, 0);
                this.spinners[0].setMaximum(1000);
                this.spinners[0].setSelection(limits[0].intValue());
                this.spinners[0].addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        SimpleRiskFieldEditor.this.firePropChanged();
                    }
                });
                break;
            }
            case NO_LOW_HIGH: {
                this.spinners = new Spinner[2];
                for (int i = 0; i < 2; ++i) {
                    this.spinners[i] = new Spinner(this.shell, 0);
                    this.spinners[i].setMaximum(1000);
                    this.spinners[i].setSelection(limits[i].intValue());
                    this.spinners[i].addModifyListener(new ModifyListener(){

                        public void modifyText(ModifyEvent e) {
                            SimpleRiskFieldEditor.this.firePropChanged();
                        }
                    });
                }
                break;
            }
        }
        this.postUpdateSpinners();
    }

    protected void postUpdateSpinners() {
        this.shell.layout();
        for (IRiskEditorListener l : this.listeners) {
            l.editorChanged();
        }
    }

    protected Number[] getLimits(RiskMethod m, boolean toDefault) {
        Number[] limits = m == PreferenceManager.getRiskMethod(this.owner, toDefault) ? PreferenceManager.getLimits(this.owner, toDefault) : new Number[]{0, 0};
        return limits;
    }

    @Override
    public void addRiskEditorListener(IRiskEditorListener listener) {
        this.listeners.add(listener);
    }
}

