/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.metrics.view;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.titanium.metrics.IMetricEnum;
import org.eclipse.titanium.metrics.MetricData;
import org.eclipse.titanium.metrics.MetricGroup;
import org.eclipse.titanium.metrics.ProjectMetric;
import org.eclipse.titanium.metrics.preferences.PreferenceManager;
import org.eclipse.titanium.metrics.view.IContentNode;
import org.eclipse.titanium.metrics.view.INode;
import org.eclipse.titanium.metrics.view.ProjectNode;
import org.eclipse.titanium.metrics.view.ProjectStatNode;

class RootNode
implements INode {
    private final MetricGroup type;
    private boolean initialized;
    private Object[] children;

    public RootNode(MetricGroup type) {
        this.type = type;
        this.initialized = false;
    }

    @Override
    public Object[] getChildren(MetricData data) {
        if (this.initialized) {
            return this.children;
        }
        ArrayList<IContentNode> c = new ArrayList<IContentNode>();
        List<IMetricEnum> subs = this.type.getMetrics();
        Iterator<IMetricEnum> it = subs.iterator();
        while (it.hasNext()) {
            IMetricEnum m = it.next();
            if (PreferenceManager.isEnabledOnView(m)) continue;
            it.remove();
        }
        if (MetricGroup.PROJECT == this.type) {
            for (IMetricEnum m : subs) {
                c.add(new ProjectNode((ProjectMetric)m));
            }
        } else {
            for (IMetricEnum m : subs) {
                ProjectStatNode n = new ProjectStatNode(m);
                if (!n.hasChildren(data)) continue;
                c.add(n);
            }
        }
        this.children = c.toArray();
        this.initialized = true;
        return this.children;
    }

    @Override
    public boolean hasChildren(MetricData data) {
        if (!this.initialized) {
            this.getChildren(data);
        }
        return this.children.length != 0;
    }

    @Override
    public String getColumnText(MetricData data, int i) {
        if (i == 0) {
            return this.type.getGroupName() + " metrics";
        }
        return null;
    }
}

