/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.runtime.core;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.titan.runtime.core.RAW;
import org.eclipse.titan.runtime.core.TTCN_EncDec;
import org.eclipse.titan.runtime.core.TTCN_EncDec_ErrorContext;
import org.eclipse.titan.runtime.core.TTCN_Logger;
import org.eclipse.titan.runtime.core.TitanCharString;
import org.eclipse.titan.runtime.core.TitanOctetString;
import org.eclipse.titan.runtime.core.TitanUniversalChar;
import org.eclipse.titan.runtime.core.TitanUniversalCharString;
import org.eclipse.titan.runtime.core.TtcnError;

public final class TTCN_Buffer {
    private static final int INITIAL_SIZE = 1024;
    private byte[] data_ptr;
    private int buf_len;
    private int buf_pos;
    private int bit_pos;
    private int last_bit_pos;
    private int last_bit_bitpos;
    private int start_of_ext_bit;
    private boolean last_bit;
    private boolean current_bitorder;
    private boolean ext_bit_reverse;
    private int ext_level;

    private void reset_buffer() {
        this.buf_pos = 0;
        this.bit_pos = 0;
        this.last_bit_pos = 0;
        this.last_bit_bitpos = 0;
        this.start_of_ext_bit = 0;
        this.last_bit = false;
        this.current_bitorder = false;
        this.ext_bit_reverse = false;
        this.ext_level = 0;
    }

    private static int get_memory_size(int target_size) {
        int newSize = 1024;
        while (newSize < target_size) {
            int nextSize = newSize + newSize;
            if (nextSize > newSize) {
                newSize = nextSize;
                continue;
            }
            return -1;
        }
        return newSize;
    }

    private void increase_size(int size_incr) {
        if (this.data_ptr != null) {
            int target_size = this.buf_len + size_incr;
            if (target_size < this.buf_len) {
                TTCN_EncDec_ErrorContext.error_internal("TTCN_Buffer: Overflow error (cannot increase buffer size).", new Object[0]);
            }
            if (target_size > this.data_ptr.length) {
                int buf_size = TTCN_Buffer.get_memory_size(target_size);
                byte[] data_ptr_new = new byte[buf_size];
                System.arraycopy(this.data_ptr, 0, data_ptr_new, 0, this.buf_len);
                this.data_ptr = data_ptr_new;
            }
        } else {
            int buf_size = TTCN_Buffer.get_memory_size(size_incr);
            this.data_ptr = new byte[buf_size];
        }
    }

    public TTCN_Buffer() {
        this.data_ptr = null;
        this.buf_len = 0;
        this.reset_buffer();
    }

    public TTCN_Buffer(TTCN_Buffer p_buf) {
        this.data_ptr = new byte[p_buf.data_ptr.length];
        System.arraycopy(p_buf.data_ptr, 0, this.data_ptr, 0, p_buf.data_ptr.length);
        this.buf_len = p_buf.buf_len;
        this.reset_buffer();
    }

    public TTCN_Buffer(TitanOctetString p_os) {
        p_os.must_bound("Initializing a TTCN_Buffer with an unbound octetstring value.");
        this.buf_len = p_os.lengthof().get_int();
        this.data_ptr = new byte[this.buf_len];
        System.arraycopy(p_os.get_value(), 0, this.data_ptr, 0, this.buf_len);
        this.reset_buffer();
    }

    public TTCN_Buffer(TitanCharString p_cs) {
        p_cs.must_bound("Initializing a TTCN_Buffer with an unbound charstring value.");
        this.buf_len = p_cs.lengthof().get_int();
        this.data_ptr = new byte[this.buf_len];
        StringBuilder temp = p_cs.get_value();
        for (int i = 0; i < this.buf_len; ++i) {
            this.data_ptr[i] = (byte)temp.charAt(i);
        }
        this.reset_buffer();
    }

    public TTCN_Buffer operator_assign(TTCN_Buffer p_buf) {
        if (p_buf != this) {
            this.buf_len = p_buf.buf_len;
            if (p_buf.data_ptr != null) {
                this.data_ptr = new byte[p_buf.data_ptr.length];
                System.arraycopy(p_buf.data_ptr, 0, this.data_ptr, 0, p_buf.data_ptr.length);
            } else {
                this.data_ptr = null;
            }
        }
        this.reset_buffer();
        return this;
    }

    public TTCN_Buffer operator_assign(TitanOctetString p_os) {
        p_os.must_bound("Assignment of an unbound octetstring value to a TTCN_Buffer.");
        this.buf_len = p_os.lengthof().get_int();
        this.data_ptr = new byte[this.buf_len];
        System.arraycopy(p_os.get_value(), 0, this.data_ptr, 0, this.buf_len);
        this.reset_buffer();
        return this;
    }

    public TTCN_Buffer operator_assign(TitanCharString p_cs) {
        p_cs.must_bound("Assignment of an unbound charstring value to a TTCN_Buffer.");
        this.buf_len = p_cs.lengthof().get_int();
        this.data_ptr = new byte[this.buf_len];
        StringBuilder temp = p_cs.get_value();
        for (int i = 0; i < this.buf_len; ++i) {
            this.data_ptr[i] = (byte)temp.charAt(i);
        }
        this.reset_buffer();
        return this;
    }

    public void clear() {
        this.data_ptr = null;
        this.buf_len = 0;
        this.reset_buffer();
    }

    public int get_len() {
        return this.buf_len;
    }

    public byte[] get_data() {
        if (this.data_ptr == null) {
            return null;
        }
        byte[] result = new byte[this.buf_len];
        System.arraycopy(this.data_ptr, this.buf_pos, result, 0, this.buf_len);
        return result;
    }

    public int get_read_len() {
        return this.buf_len - this.buf_pos;
    }

    public byte[] get_read_data() {
        if (this.data_ptr != null) {
            byte[] result = new byte[this.buf_len - this.buf_pos];
            System.arraycopy(this.data_ptr, this.buf_pos, result, 0, this.buf_len - this.buf_pos);
            return result;
        }
        return null;
    }

    public void rewind() {
        this.buf_pos = 0;
        this.bit_pos = 0;
    }

    public int get_pos() {
        return this.buf_pos;
    }

    public void set_pos(int new_pos) {
        this.buf_pos = new_pos < this.buf_len ? new_pos : this.buf_len;
    }

    public void increase_pos(int delta) {
        int new_buf_pos = this.buf_pos + delta;
        this.buf_pos = new_buf_pos < this.buf_pos || new_buf_pos > this.buf_len ? this.buf_len : new_buf_pos;
    }

    public byte[] get_end() {
        if (this.data_ptr != null) {
            int end_len = this.data_ptr.length - this.buf_len;
            byte[] end_ptr = new byte[end_len];
            System.arraycopy(this.data_ptr, this.buf_len, end_ptr, 0, end_len);
            return end_ptr;
        }
        return null;
    }

    public void increase_length(int size_incr) {
        if (this.data_ptr.length < this.buf_len + size_incr) {
            this.increase_size(size_incr);
        }
        this.buf_len += size_incr;
    }

    public void put_c(byte c) {
        this.increase_size(1);
        this.data_ptr[this.buf_len] = c;
        ++this.buf_len;
    }

    public void put_s(char[] cstr) {
        int length = cstr.length;
        if (length > 0) {
            this.increase_size(length);
            for (int i = 0; i < length; ++i) {
                this.data_ptr[i + this.buf_len] = (byte)cstr[i];
            }
            this.buf_len += length;
        }
    }

    public void put_s(byte[] cstr) {
        int length = cstr.length;
        if (length > 0) {
            this.increase_size(length);
            System.arraycopy(cstr, 0, this.data_ptr, this.buf_len, length);
            this.buf_len += length;
        }
    }

    public void put_string(TitanOctetString p_os) {
        p_os.must_bound("Appending an unbound octetstring value to a TTCN_Buffer.");
        int n_octets = p_os.lengthof().get_int();
        if (n_octets > 0) {
            if (this.buf_len > 0) {
                this.increase_size(n_octets);
            } else {
                this.data_ptr = new byte[n_octets];
            }
            System.arraycopy(p_os.get_value(), 0, this.data_ptr, this.buf_len, n_octets);
            this.buf_len += n_octets;
        }
    }

    public void put_os(TitanOctetString p_os) {
        this.put_string(p_os);
    }

    public void put_string(TitanCharString p_cs) {
        p_cs.must_bound("Appending an unbound charstring value to a TTCN_Buffer.");
        int n_chars = p_cs.lengthof().get_int();
        if (n_chars > 0) {
            StringBuilder temp = p_cs.get_value();
            if (this.buf_len > 0) {
                this.increase_size(n_chars);
                for (int i = 0; i < n_chars; ++i) {
                    this.data_ptr[this.buf_len + i] = (byte)temp.charAt(i);
                }
                this.buf_len += n_chars;
            } else {
                this.data_ptr = new byte[n_chars];
                for (int i = 0; i < n_chars; ++i) {
                    this.data_ptr[i] = (byte)temp.charAt(i);
                }
                this.buf_len = n_chars;
            }
        }
    }

    public void put_cs(TitanCharString p_cs) {
        this.put_string(p_cs);
    }

    public void put_buf(TTCN_Buffer p_buf) {
        if (p_buf.data_ptr == null) {
            return;
        }
        if (p_buf.buf_len > 0) {
            if (this.buf_len > 0) {
                this.increase_size(p_buf.buf_len);
                System.arraycopy(p_buf.data_ptr, 0, this.data_ptr, this.buf_len, p_buf.buf_len);
                this.buf_len += p_buf.buf_len;
            } else {
                this.data_ptr = new byte[p_buf.data_ptr.length];
                System.arraycopy(p_buf.data_ptr, 0, this.data_ptr, 0, p_buf.data_ptr.length);
                this.buf_len = p_buf.buf_len;
                this.buf_pos = p_buf.buf_pos;
                this.bit_pos = p_buf.bit_pos;
                this.last_bit_pos = p_buf.last_bit_pos;
                this.last_bit_bitpos = p_buf.last_bit_bitpos;
                this.start_of_ext_bit = p_buf.start_of_ext_bit;
                this.last_bit = p_buf.last_bit;
                this.current_bitorder = p_buf.current_bitorder;
                this.ext_bit_reverse = p_buf.ext_bit_reverse;
                this.ext_level = p_buf.ext_level;
            }
        }
    }

    public void get_string(TitanOctetString p_os) {
        p_os.clean_up();
        if (this.buf_len > 0) {
            byte[] data = new byte[this.buf_len];
            System.arraycopy(this.data_ptr, 0, data, 0, this.buf_len);
            p_os.set_value(data);
        } else {
            p_os.set_value(new byte[0]);
        }
    }

    public void get_string(TitanCharString p_cs) {
        p_cs.clean_up();
        if (this.buf_len > 0) {
            p_cs.operator_assign(new String(this.get_data()));
        } else {
            p_cs.operator_assign("");
        }
    }

    public void get_string(TitanUniversalCharString p_cs) {
        p_cs.clean_up();
        if (this.buf_len > 0) {
            ArrayList<TitanUniversalChar> data = new ArrayList<TitanUniversalChar>(this.data_ptr.length / 4);
            for (int i = 0; i < this.buf_len / 4; ++i) {
                data.add(new TitanUniversalChar((char)(this.data_ptr[4 * i] & 0xFF), (char)(this.data_ptr[4 * i + 1] & 0xFF), (char)(this.data_ptr[4 * i + 2] & 0xFF), (char)(this.data_ptr[4 * i + 3] & 0xFF)));
            }
            p_cs.set_value(data);
        } else {
            p_cs.operator_assign("");
        }
    }

    public void cut() {
        if (this.buf_pos > 0) {
            int new_len;
            if (this.buf_pos > this.buf_len) {
                TTCN_EncDec_ErrorContext.error_internal("Read pointer points beyond the buffer end when cutting from a TTCN_Buffer.", new Object[0]);
            }
            if ((new_len = this.buf_len - this.buf_pos) > 0) {
                int allocation_size = TTCN_Buffer.get_memory_size(new_len);
                int new_size = allocation_size < this.data_ptr.length ? allocation_size : this.data_ptr.length;
                byte[] data = new byte[new_size];
                System.arraycopy(this.data_ptr, this.buf_pos, data, 0, new_len);
                this.data_ptr = data;
            } else {
                this.data_ptr = null;
            }
            this.buf_len = new_len;
        }
        this.reset_buffer();
    }

    public void cut_end() {
        if (this.buf_pos > this.buf_len) {
            TTCN_EncDec_ErrorContext.error_internal("Read pointer points beyond the buffer end when cutting from a TTCN_Buffer.", new Object[0]);
        }
        if (this.buf_pos < this.buf_len) {
            if (this.buf_pos > 0) {
                int new_size;
                if (this.data_ptr == null) {
                    TTCN_EncDec_ErrorContext.error_internal("Data pointer is NULL when cutting from a TTCN_Buffer.", new Object[0]);
                }
                if ((new_size = TTCN_Buffer.get_memory_size(this.buf_pos)) < this.data_ptr.length) {
                    byte[] helper = new byte[new_size];
                    System.arraycopy(this.data_ptr, 0, helper, 0, new_size);
                    this.data_ptr = helper;
                }
            } else {
                this.data_ptr = null;
            }
            this.buf_len = this.buf_pos;
        }
        this.last_bit_pos = 0;
        this.last_bit_bitpos = 0;
        this.start_of_ext_bit = 0;
        this.last_bit = false;
        this.current_bitorder = false;
        this.ext_bit_reverse = false;
        this.ext_level = 0;
    }

    public boolean contains_complete_TLV() {
        throw new TtcnError("contains_complete_TLV() for TTCN_Buffer is not implemented!");
    }

    public void log() {
        TTCN_Logger.log_event_str(MessageFormat.format("Buffer: size: {0}, pos: {1}, len: {2} data: (", this.data_ptr.length, this.buf_pos, this.buf_len));
        if (this.buf_len > 0) {
            int i;
            for (i = 0; i < this.buf_pos; ++i) {
                TTCN_Logger.log_octet(this.data_ptr[i]);
            }
            TTCN_Logger.log_event_str(" | ");
            for (i = this.buf_pos; i < this.buf_len; ++i) {
                TTCN_Logger.log_octet(this.data_ptr[i]);
            }
        }
        TTCN_Logger.log_char(')');
    }

    public void put_b(int len, byte[] s, RAW.RAW_coding_par coding_par, int align) {
        char ch;
        int a;
        int loc_align = align < 0 ? -align : align;
        boolean must_align = false;
        TTCN_EncDec.raw_order_t local_bitorder = coding_par.bitorder;
        TTCN_EncDec.raw_order_t local_fieldorder = coding_par.fieldorder;
        if (this.current_bitorder) {
            local_bitorder = local_bitorder == TTCN_EncDec.raw_order_t.ORDER_LSB ? TTCN_EncDec.raw_order_t.ORDER_MSB : TTCN_EncDec.raw_order_t.ORDER_LSB;
            local_fieldorder = local_fieldorder == TTCN_EncDec.raw_order_t.ORDER_LSB ? TTCN_EncDec.raw_order_t.ORDER_MSB : TTCN_EncDec.raw_order_t.ORDER_LSB;
        }
        if (align != 0) {
            if (local_fieldorder == TTCN_EncDec.raw_order_t.ORDER_LSB && local_bitorder != coding_par.byteorder || local_fieldorder == TTCN_EncDec.raw_order_t.ORDER_MSB && local_bitorder == coding_par.byteorder) {
                byte[] st = new byte[(len + loc_align + 7) / 8];
                if (align > 0) {
                    System.arraycopy(s, 0, st, 0, (len + 7) / 8);
                    if (len % 8 != 0) {
                        int n = (len + 7) / 8 - 1;
                        st[n] = (byte)(st[n] & RAW.BitMaskTable[len % 8]);
                    }
                } else if (loc_align % 8 != 0) {
                    int bit_bound = loc_align % 8;
                    int max_index = st.length - loc_align / 8 - 1;
                    byte[] ptr = new byte[max_index + 1];
                    for (a = 0; a < (len + 7) / 8; ++a) {
                        int n = a;
                        ptr[n] = (byte)(ptr[n] | s[a] << bit_bound & 0xFF);
                        if (a >= max_index) continue;
                        ptr[a + 1] = (byte)((s[a] & 0xFF) >> bit_bound);
                    }
                    System.arraycopy(ptr, 0, st, loc_align / 8, ptr.length);
                } else {
                    System.arraycopy(s, 0, st, loc_align / 8, (len + 7) / 8);
                }
                s = st;
                len += loc_align;
            } else {
                if (coding_par.byteorder == TTCN_EncDec.raw_order_t.ORDER_MSB) {
                    align = -align;
                }
                if (align < 0) {
                    this.put_zero(loc_align, local_fieldorder);
                } else {
                    must_align = true;
                }
            }
        }
        if (len == 0) {
            if (must_align) {
                this.put_zero(loc_align, local_fieldorder);
            }
            return;
        }
        int new_size = ((this.bit_pos == 0 ? this.buf_len * 8 : this.buf_len * 8 - (8 - this.bit_pos)) + len + 7) / 8;
        int new_bit_pos = (this.bit_pos + len) % 8;
        if (new_size > this.buf_len) {
            this.increase_size(new_size - this.buf_len);
        }
        if (coding_par.hexorder == TTCN_EncDec.raw_order_t.ORDER_MSB) {
            int a2;
            byte[] st2 = new byte[(len + 7) / 8];
            if (this.bit_pos == 4 && local_fieldorder == TTCN_EncDec.raw_order_t.ORDER_LSB) {
                st2[0] = s[0];
                for (a2 = 1; a2 < (len + 7) / 8; ++a2) {
                    ch = '\u0000';
                    ch = (char)(ch | (s[a2 - 1] & 0xFF) >> 4);
                    st2[a2 - 1] = (byte)(st2[a2 - 1] & 0xF | s[a2] << 4 & 0xF0);
                    st2[a2] = (byte)(s[a2] & 0xF0 | ch);
                }
            } else {
                for (a2 = 0; a2 < (len + 7) / 8; ++a2) {
                    st2[a2] = (byte)(s[a2] << 4 & 0xF0 | (s[a2] & 0xFF) >> 4);
                }
                if (len % 8 != 0) {
                    int n = (len + 7) / 8 - 1;
                    st2[n] = (byte)(st2[n] >> 4);
                }
            }
            s = st2;
        }
        if (this.bit_pos + len <= 8) {
            this.data_ptr[new_size - 1] = local_bitorder == TTCN_EncDec.raw_order_t.ORDER_LSB ? (local_fieldorder == TTCN_EncDec.raw_order_t.ORDER_LSB ? (byte)(this.data_ptr[new_size - 1] & RAW.BitMaskTable[this.bit_pos] | s[0] << this.bit_pos & 0xFF) : (byte)(this.data_ptr[new_size - 1] & ~RAW.BitMaskTable[8 - this.bit_pos] | (s[0] & RAW.BitMaskTable[len]) << 8 - this.bit_pos - len)) : (local_fieldorder == TTCN_EncDec.raw_order_t.ORDER_LSB ? (byte)(this.data_ptr[new_size - 1] & RAW.BitMaskTable[this.bit_pos] | RAW.REVERSE_BITS(s[0]) >> 8 - len - this.bit_pos) : (byte)(this.data_ptr[new_size - 1] & ~RAW.BitMaskTable[8 - this.bit_pos] | RAW.REVERSE_BITS(s[0] & RAW.BitMaskTable[len]) >> this.bit_pos));
            if (coding_par.csn1lh) {
                this.data_ptr[new_size - 1] = local_fieldorder == TTCN_EncDec.raw_order_t.ORDER_LSB ? (byte)(this.data_ptr[new_size - 1] ^ 0x2B & (RAW.BitMaskTable[this.bit_pos + len] & ~RAW.BitMaskTable[this.bit_pos])) : (byte)(this.data_ptr[new_size - 1] ^ 0x2B & (~RAW.BitMaskTable[8 - this.bit_pos - len] & RAW.BitMaskTable[8 - this.bit_pos]));
            }
        } else if (this.bit_pos == 0 && len % 8 == 0) {
            int a3;
            if (coding_par.byteorder == TTCN_EncDec.raw_order_t.ORDER_LSB) {
                if (local_bitorder == TTCN_EncDec.raw_order_t.ORDER_LSB) {
                    System.arraycopy(s, 0, this.data_ptr, this.buf_len, len / 8);
                } else {
                    for (a3 = 0; a3 < len / 8; ++a3) {
                        this.data_ptr[a3 + this.buf_len] = (byte)RAW.REVERSE_BITS(s[a3]);
                    }
                }
            } else if (local_bitorder == TTCN_EncDec.raw_order_t.ORDER_LSB) {
                a3 = 0;
                int b = len / 8 - 1;
                while (a3 < len / 8) {
                    this.data_ptr[a3 + this.buf_len] = s[b];
                    ++a3;
                    --b;
                }
            } else {
                a3 = 0;
                int b = len / 8 - 1;
                while (a3 < len / 8) {
                    this.data_ptr[a3 + this.buf_len] = (byte)RAW.REVERSE_BITS(s[b]);
                    ++a3;
                    --b;
                }
            }
            if (coding_par.csn1lh) {
                for (a3 = 0; a3 < len / 8; ++a3) {
                    int n = a3 + this.buf_len;
                    this.data_ptr[n] = (byte)(this.data_ptr[n] ^ 0x2B);
                }
            }
        } else {
            int a4;
            int offset;
            int maxindex = new_size - 1;
            if (coding_par.byteorder == TTCN_EncDec.raw_order_t.ORDER_LSB) {
                int a5;
                int offset2;
                if (local_bitorder == TTCN_EncDec.raw_order_t.ORDER_LSB) {
                    if (this.bit_pos != 0) {
                        int mask1 = RAW.BitMaskTable[this.bit_pos];
                        int n = offset2 = this.buf_len == 0 ? 0 : this.buf_len - 1;
                        if (local_fieldorder == TTCN_EncDec.raw_order_t.ORDER_MSB) {
                            int num_bytes = (len + 7) / 8;
                            int active_bits_in_last = len % 8;
                            if (active_bits_in_last == 0) {
                                active_bits_in_last = 8;
                            }
                            for (int a6 = 0; a6 < num_bytes; ++a6) {
                                int n2 = a6 + offset2;
                                this.data_ptr[n2] = (byte)(this.data_ptr[n2] & RAW.REVERSE_BITS(mask1));
                                byte sa = s[a6];
                                if (a6 == num_bytes - 1) {
                                    sa = (byte)(sa << 8 - active_bits_in_last);
                                }
                                int n3 = a6 + offset2;
                                this.data_ptr[n3] = (byte)(this.data_ptr[n3] | sa >> this.bit_pos & ~RAW.REVERSE_BITS(mask1));
                                if (a6 >= maxindex) continue;
                                this.data_ptr[a6 + offset2 + 1] = (byte)(sa << 8 - this.bit_pos);
                            }
                        } else {
                            for (a5 = 0; a5 < (len + 7) / 8; ++a5) {
                                int n4 = a5 + offset2;
                                this.data_ptr[n4] = (byte)(this.data_ptr[n4] & mask1);
                                int n5 = a5 + offset2;
                                this.data_ptr[n5] = (byte)(this.data_ptr[n5] | s[a5] << this.bit_pos & 0xFF);
                                if (a5 >= maxindex) continue;
                                this.data_ptr[a5 + offset2 + 1] = (byte)(s[a5] >> 8 - this.bit_pos);
                            }
                        }
                    } else {
                        System.arraycopy(s, 0, this.data_ptr, this.buf_len, (len + 7) / 8);
                        if (local_fieldorder == TTCN_EncDec.raw_order_t.ORDER_MSB && new_bit_pos != 0) {
                            int n = new_size - 1;
                            this.data_ptr[n] = (byte)(this.data_ptr[n] << 8 - new_bit_pos);
                        }
                    }
                } else {
                    if (this.bit_pos != 0) {
                        int mask1 = RAW.REVERSE_BITS(RAW.BitMaskTable[this.bit_pos]);
                        int n = offset2 = this.buf_len == 0 ? 0 : this.buf_len - 1;
                        if (local_fieldorder == TTCN_EncDec.raw_order_t.ORDER_MSB) {
                            int n6 = offset2;
                            this.data_ptr[n6] = (byte)(this.data_ptr[n6] & mask1);
                            int n7 = offset2;
                            this.data_ptr[n7] = (byte)(this.data_ptr[n7] | RAW.REVERSE_BITS(s[0]) >> this.bit_pos);
                            this.data_ptr[offset2 + 1] = (byte)(RAW.REVERSE_BITS(s[0]) << 8 - this.bit_pos);
                        } else {
                            int n8 = offset2;
                            this.data_ptr[n8] = (byte)(this.data_ptr[n8] & RAW.REVERSE_BITS(mask1));
                            int n9 = offset2;
                            this.data_ptr[n9] = (byte)(this.data_ptr[n9] | RAW.REVERSE_BITS(s[0]) & ~RAW.REVERSE_BITS(mask1));
                            this.data_ptr[offset2 + 1] = (byte)(RAW.REVERSE_BITS(s[0]) << 8 - this.bit_pos);
                        }
                        for (a5 = 1; a5 < (len + 7) / 8; ++a5) {
                            int n10 = a5 + offset2;
                            this.data_ptr[n10] = (byte)(this.data_ptr[n10] & mask1);
                            int n11 = a5 + offset2;
                            this.data_ptr[n11] = (byte)(this.data_ptr[n11] | RAW.REVERSE_BITS(s[a5]) >> this.bit_pos);
                            if (a5 >= maxindex) continue;
                            this.data_ptr[a5 + offset2 + 1] = (byte)(RAW.REVERSE_BITS(s[a5]) << 8 - this.bit_pos);
                        }
                    } else {
                        for (int a7 = 0; a7 < (len + 7) / 8; ++a7) {
                            this.data_ptr[a7 + this.buf_len] = (byte)RAW.REVERSE_BITS(s[a7]);
                        }
                    }
                    if (local_fieldorder == TTCN_EncDec.raw_order_t.ORDER_LSB && new_bit_pos != 0) {
                        int n = new_size - 1;
                        this.data_ptr[n] = (byte)(this.data_ptr[n] >> 8 - new_bit_pos);
                    }
                }
            } else if (local_bitorder == TTCN_EncDec.raw_order_t.ORDER_LSB) {
                if (this.bit_pos != 0) {
                    int mask1 = RAW.BitMaskTable[this.bit_pos];
                    ch = TTCN_Buffer.get_byte_rev(s, len, 0);
                    int n = offset = this.buf_len == 0 ? 0 : this.buf_len - 1;
                    if (local_fieldorder == TTCN_EncDec.raw_order_t.ORDER_MSB) {
                        int n12 = offset;
                        this.data_ptr[n12] = (byte)(this.data_ptr[n12] & RAW.REVERSE_BITS(mask1));
                        int n13 = offset;
                        this.data_ptr[n13] = (byte)(this.data_ptr[n13] | (ch & 0xFF) >> this.bit_pos);
                        this.data_ptr[offset + 1] = (byte)(ch << 8 - this.bit_pos);
                    } else {
                        int n14 = offset;
                        this.data_ptr[n14] = (byte)(this.data_ptr[n14] & mask1);
                        int n15 = offset;
                        this.data_ptr[n15] = (byte)(this.data_ptr[n15] | ch & 0xFF & ~mask1);
                        this.data_ptr[offset + 1] = (byte)(ch << 8 - this.bit_pos);
                    }
                    for (a4 = 1; a4 < (len + 7) / 8; ++a4) {
                        ch = (char)TTCN_Buffer.get_byte_rev(s, len, a4);
                        int n16 = a4 + offset;
                        this.data_ptr[n16] = (byte)(this.data_ptr[n16] & RAW.REVERSE_BITS(mask1));
                        int n17 = a4 + offset;
                        this.data_ptr[n17] = (byte)(this.data_ptr[n17] | (ch & 0xFF) >> this.bit_pos);
                        if (a4 >= maxindex) continue;
                        this.data_ptr[a4 + offset + 1] = (byte)(ch << 8 - this.bit_pos);
                    }
                } else {
                    for (int a8 = 0; a8 < (len + 7) / 8; ++a8) {
                        this.data_ptr[a8 + this.buf_len] = TTCN_Buffer.get_byte_rev(s, len, a8);
                    }
                }
                if (local_fieldorder == TTCN_EncDec.raw_order_t.ORDER_LSB && new_bit_pos != 0) {
                    int n = new_size - 1;
                    this.data_ptr[n] = (byte)(this.data_ptr[n] >> 8 - new_bit_pos);
                }
            } else {
                if (this.bit_pos != 0) {
                    int mask1 = RAW.BitMaskTable[this.bit_pos];
                    ch = TTCN_Buffer.get_byte_rev(s, len, 0);
                    int n = offset = this.buf_len == 0 ? 0 : this.buf_len - 1;
                    if (local_fieldorder == TTCN_EncDec.raw_order_t.ORDER_MSB) {
                        int n18 = offset;
                        this.data_ptr[n18] = (byte)(this.data_ptr[n18] & RAW.REVERSE_BITS(mask1));
                        int n19 = offset;
                        this.data_ptr[n19] = (byte)(this.data_ptr[n19] | RAW.REVERSE_BITS(ch) & ~RAW.REVERSE_BITS(mask1));
                        this.data_ptr[offset + 1] = (byte)(RAW.REVERSE_BITS(ch) >> 8 - this.bit_pos);
                    } else {
                        int n20 = offset;
                        this.data_ptr[n20] = (byte)(this.data_ptr[n20] & mask1);
                        int n21 = offset;
                        this.data_ptr[n21] = (byte)(this.data_ptr[n21] | RAW.REVERSE_BITS(ch) << this.bit_pos);
                        int n22 = offset;
                        this.data_ptr[n22] = (byte)(this.data_ptr[n22] & 0xFF);
                        this.data_ptr[offset + 1] = (byte)(RAW.REVERSE_BITS(ch) >> 8 - this.bit_pos);
                    }
                    for (a4 = 1; a4 < (len + 7) / 8; ++a4) {
                        ch = (char)TTCN_Buffer.get_byte_rev(s, len, a4);
                        int n23 = offset + a4;
                        this.data_ptr[n23] = (byte)(this.data_ptr[n23] & mask1);
                        int n24 = offset + a4;
                        this.data_ptr[n24] = (byte)(this.data_ptr[n24] | RAW.REVERSE_BITS(ch) << this.bit_pos);
                        if (a4 >= maxindex) continue;
                        this.data_ptr[offset + a4 + 1] = (byte)(RAW.REVERSE_BITS(ch) >> 8 - this.bit_pos);
                    }
                } else {
                    for (int a9 = 0; a9 < (len + 7) / 8; ++a9) {
                        this.data_ptr[a9 + this.buf_len] = (byte)RAW.REVERSE_BITS(TTCN_Buffer.get_byte_rev(s, len, a9));
                    }
                }
                if (local_fieldorder == TTCN_EncDec.raw_order_t.ORDER_MSB && new_bit_pos != 0) {
                    int n = new_size - 1;
                    this.data_ptr[n] = (byte)(this.data_ptr[n] << 8 - new_bit_pos);
                }
            }
            if (coding_par.csn1lh) {
                int offset3;
                int n = offset3 = this.buf_len == 0 ? 0 : this.buf_len - 1;
                if (local_fieldorder == TTCN_EncDec.raw_order_t.ORDER_LSB) {
                    int n25 = offset3;
                    this.data_ptr[n25] = (byte)(this.data_ptr[n25] ^ 0x2B & ~RAW.BitMaskTable[this.bit_pos]);
                } else {
                    int n26 = offset3;
                    this.data_ptr[n26] = (byte)(this.data_ptr[n26] ^ 0x2B & RAW.BitMaskTable[8 - this.bit_pos]);
                }
                for (a = 1; a < (len + this.bit_pos) / 8; ++a) {
                    int n27 = a + offset3;
                    this.data_ptr[n27] = (byte)(this.data_ptr[n27] ^ 0x2B);
                }
                if (new_bit_pos != 0) {
                    if (local_fieldorder == TTCN_EncDec.raw_order_t.ORDER_LSB) {
                        int n28 = new_size - 1;
                        this.data_ptr[n28] = (byte)(this.data_ptr[n28] ^ 0x2B & RAW.BitMaskTable[new_bit_pos]);
                    } else {
                        int n29 = new_size - 1;
                        this.data_ptr[n29] = (byte)(this.data_ptr[n29] ^ 0x2B & ~RAW.BitMaskTable[8 - new_bit_pos]);
                    }
                }
            }
        }
        this.buf_len = new_size;
        this.bit_pos = new_bit_pos;
        if (this.bit_pos != 0) {
            this.last_bit_pos = this.buf_len - 1;
            this.last_bit_bitpos = local_fieldorder == TTCN_EncDec.raw_order_t.ORDER_LSB ? this.bit_pos - 1 : 7 - (this.bit_pos - 1);
        } else {
            this.last_bit_pos = this.buf_len - 1;
            this.last_bit_bitpos = local_fieldorder == TTCN_EncDec.raw_order_t.ORDER_LSB ? 7 : 0;
        }
        if (must_align) {
            this.put_zero(loc_align, local_fieldorder);
        }
    }

    public void get_b(int len, byte[] s, RAW.RAW_coding_par coding_par, TTCN_EncDec.raw_order_t top_bit_order) {
        int a;
        if (len == 0) {
            return;
        }
        int new_buf_pos = this.buf_pos + (this.bit_pos + len) / 8;
        int new_bit_pos = (this.bit_pos + len) % 8;
        TTCN_EncDec.raw_order_t local_bitorder = coding_par.bitorder;
        TTCN_EncDec.raw_order_t local_fieldorder = coding_par.fieldorder;
        if (top_bit_order == TTCN_EncDec.raw_order_t.ORDER_LSB) {
            local_bitorder = local_bitorder == TTCN_EncDec.raw_order_t.ORDER_LSB ? TTCN_EncDec.raw_order_t.ORDER_MSB : TTCN_EncDec.raw_order_t.ORDER_LSB;
            local_fieldorder = local_fieldorder == TTCN_EncDec.raw_order_t.ORDER_LSB ? TTCN_EncDec.raw_order_t.ORDER_MSB : TTCN_EncDec.raw_order_t.ORDER_LSB;
        }
        if (this.bit_pos + len <= 8) {
            if (coding_par.csn1lh) {
                if (local_fieldorder == TTCN_EncDec.raw_order_t.ORDER_LSB) {
                    int n = this.buf_pos;
                    this.data_ptr[n] = (byte)(this.data_ptr[n] ^ 0x2B & (RAW.BitMaskTable[this.bit_pos + len] & ~RAW.BitMaskTable[this.bit_pos]));
                } else {
                    int n = this.buf_pos;
                    this.data_ptr[n] = (byte)(this.data_ptr[n] ^ 0x2B & (~RAW.BitMaskTable[8 - this.bit_pos - len] & RAW.BitMaskTable[8 - this.bit_pos]));
                }
            }
            s[0] = local_bitorder == TTCN_EncDec.raw_order_t.ORDER_LSB ? (local_fieldorder == TTCN_EncDec.raw_order_t.ORDER_LSB ? (byte)(this.data_ptr[this.buf_pos] >> this.bit_pos) : (byte)(this.data_ptr[this.buf_pos] >> 8 - this.bit_pos - len)) : (local_fieldorder == TTCN_EncDec.raw_order_t.ORDER_LSB ? (byte)(RAW.REVERSE_BITS(this.data_ptr[this.buf_pos]) >> 8 - this.bit_pos - len) : (byte)(RAW.REVERSE_BITS(this.data_ptr[this.buf_pos]) >> this.bit_pos));
        } else if (this.bit_pos == 0 && len % 8 == 0) {
            int b;
            if (coding_par.csn1lh) {
                for (a = 0; a < len / 8; ++a) {
                    int n = a + this.buf_pos;
                    this.data_ptr[n] = (byte)(this.data_ptr[n] ^ 0x2B);
                }
            }
            if (coding_par.byteorder == TTCN_EncDec.raw_order_t.ORDER_LSB) {
                if (local_bitorder == TTCN_EncDec.raw_order_t.ORDER_LSB) {
                    System.arraycopy(this.data_ptr, this.buf_pos, s, 0, len / 8);
                } else {
                    for (a = 0; a < len / 8; ++a) {
                        s[a] = (byte)RAW.REVERSE_BITS(this.data_ptr[a + this.buf_pos]);
                    }
                }
            } else if (local_bitorder == TTCN_EncDec.raw_order_t.ORDER_LSB) {
                a = 0;
                b = len / 8 - 1;
                while (a < len / 8) {
                    s[a] = this.data_ptr[b + this.buf_pos];
                    ++a;
                    --b;
                }
            } else {
                a = 0;
                b = len / 8 - 1;
                while (a < len / 8) {
                    s[a] = (byte)RAW.REVERSE_BITS(this.data_ptr[b + this.buf_pos]);
                    ++a;
                    --b;
                }
            }
        } else {
            int b;
            int a2;
            int a3;
            int mask1;
            if (coding_par.csn1lh) {
                if (local_fieldorder == TTCN_EncDec.raw_order_t.ORDER_LSB) {
                    int n = this.buf_pos;
                    this.data_ptr[n] = (byte)(this.data_ptr[n] ^ 0x2B & ~RAW.BitMaskTable[this.bit_pos]);
                } else {
                    int n = this.buf_pos;
                    this.data_ptr[n] = (byte)(this.data_ptr[n] ^ 0x2B & RAW.BitMaskTable[8 - this.bit_pos]);
                }
                for (a = 1; a < (len + this.bit_pos) / 8; ++a) {
                    int n = a + this.buf_pos;
                    this.data_ptr[n] = (byte)(this.data_ptr[n] ^ 0x2B);
                }
                if (new_bit_pos != 0) {
                    if (local_fieldorder == TTCN_EncDec.raw_order_t.ORDER_LSB) {
                        int n = this.buf_len - 1;
                        this.data_ptr[n] = (byte)(this.data_ptr[n] ^ 0x2B & RAW.BitMaskTable[new_bit_pos]);
                    } else {
                        int n = this.buf_len - 1;
                        this.data_ptr[n] = (byte)(this.data_ptr[n] ^ 0x2B & ~RAW.BitMaskTable[8 - new_bit_pos]);
                    }
                }
            }
            int num_bytes = (len + 7) / 8;
            if (coding_par.byteorder == TTCN_EncDec.raw_order_t.ORDER_LSB) {
                if (local_bitorder == TTCN_EncDec.raw_order_t.ORDER_LSB) {
                    if (this.bit_pos != 0) {
                        mask1 = RAW.BitMaskTable[8 - this.bit_pos];
                        if (local_fieldorder == TTCN_EncDec.raw_order_t.ORDER_LSB) {
                            for (a3 = 0; a3 < num_bytes; ++a3) {
                                s[a3] = (byte)(this.get_byte_align(len, local_fieldorder, TTCN_EncDec.raw_order_t.ORDER_MSB, a3 + 1) << 8 - this.bit_pos & 0xFF | (this.get_byte_align(len, local_fieldorder, TTCN_EncDec.raw_order_t.ORDER_MSB, a3) & 0xFF) >> this.bit_pos & mask1);
                            }
                        } else {
                            mask1 = RAW.BitMaskTable[this.bit_pos];
                            for (a3 = 0; a3 < num_bytes; ++a3) {
                                s[a3] = (byte)((this.get_byte_align(len, local_fieldorder, TTCN_EncDec.raw_order_t.ORDER_LSB, a3 + 1) & 0xFF) >> 8 - this.bit_pos & mask1 | this.get_byte_align(len, local_fieldorder, TTCN_EncDec.raw_order_t.ORDER_LSB, a3) << this.bit_pos & 0xFF);
                            }
                            int active_bits_in_last_byte = len % 8;
                            if (active_bits_in_last_byte != 0) {
                                int n = num_bytes - 1;
                                s[n] = (byte)(s[n] >> 8 - active_bits_in_last_byte);
                            }
                        }
                    } else {
                        System.arraycopy(this.data_ptr, this.buf_pos, s, 0, num_bytes);
                        if (local_fieldorder == TTCN_EncDec.raw_order_t.ORDER_MSB && new_bit_pos != 0) {
                            int n = num_bytes - 1;
                            s[n] = (byte)(s[n] >> 8 - new_bit_pos);
                        }
                    }
                } else if (this.bit_pos != 0) {
                    mask1 = RAW.BitMaskTable[this.bit_pos];
                    for (a3 = 0; a3 < num_bytes; ++a3) {
                        s[a3] = (byte)RAW.REVERSE_BITS((this.get_byte_align(len, local_fieldorder, TTCN_EncDec.raw_order_t.ORDER_LSB, a3 + 1) & 0xFF) >> 8 - this.bit_pos & mask1 | this.get_byte_align(len, local_fieldorder, TTCN_EncDec.raw_order_t.ORDER_LSB, a3) << this.bit_pos & 0xFF);
                    }
                } else {
                    for (a2 = 0; a2 < num_bytes; ++a2) {
                        s[a2] = (byte)RAW.REVERSE_BITS(this.data_ptr[a2 + this.buf_pos]);
                    }
                    if (local_fieldorder == TTCN_EncDec.raw_order_t.ORDER_LSB && new_bit_pos != 0) {
                        int n = num_bytes - 1;
                        s[n] = (byte)(s[n] >> 8 - new_bit_pos);
                    }
                }
            } else if (local_bitorder == TTCN_EncDec.raw_order_t.ORDER_LSB) {
                if (new_bit_pos != 0) {
                    mask1 = RAW.BitMaskTable[new_bit_pos];
                    a3 = 0;
                    int b2 = (this.bit_pos + len) / 8;
                    while (a3 < num_bytes) {
                        s[a3] = (byte)((this.get_byte_align(len, local_fieldorder, TTCN_EncDec.raw_order_t.ORDER_LSB, b2) & 0xFF) >> 8 - new_bit_pos & mask1 | this.get_byte_align(len, local_fieldorder, TTCN_EncDec.raw_order_t.ORDER_LSB, b2 - 1) << new_bit_pos & 0xFF);
                        ++a3;
                        --b2;
                    }
                } else {
                    a2 = 0;
                    b = new_buf_pos - 1;
                    while (a2 < num_bytes) {
                        s[a2] = this.data_ptr[b];
                        ++a2;
                        --b;
                    }
                    if (local_fieldorder == TTCN_EncDec.raw_order_t.ORDER_LSB && this.bit_pos != 0) {
                        int n = num_bytes - 1;
                        s[n] = (byte)(s[n] >> this.bit_pos);
                    }
                }
            } else if (new_bit_pos != 0) {
                a2 = 0;
                b = (this.bit_pos + len) / 8;
                while (a2 < num_bytes) {
                    s[a2] = (byte)RAW.REVERSE_BITS(this.get_byte_align(len, local_fieldorder, TTCN_EncDec.raw_order_t.ORDER_MSB, b) << 8 - new_bit_pos | (this.get_byte_align(len, local_fieldorder, TTCN_EncDec.raw_order_t.ORDER_MSB, b - 1) & 0xFF) >> new_bit_pos);
                    ++a2;
                    --b;
                }
            } else {
                a2 = 0;
                b = new_buf_pos - 1;
                while (a2 < num_bytes) {
                    s[a2] = (byte)RAW.REVERSE_BITS(this.data_ptr[b]);
                    ++a2;
                    --b;
                }
                if (local_fieldorder == TTCN_EncDec.raw_order_t.ORDER_MSB && this.bit_pos != 0) {
                    int n = num_bytes - 1;
                    s[n] = (byte)(s[n] >> this.bit_pos);
                }
            }
        }
        if (coding_par.hexorder == TTCN_EncDec.raw_order_t.ORDER_MSB) {
            if (this.bit_pos == 4 && local_fieldorder == TTCN_EncDec.raw_order_t.ORDER_LSB) {
                for (a = 1; a < (len + 7) / 8; ++a) {
                    int ch = 0;
                    ch = (char)(ch | s[a - 1] >> 4);
                    s[a - 1] = (byte)(s[a - 1] & 0xF | s[a] << 4);
                    s[a] = (byte)(s[a] & 0xF0 | ch);
                }
            } else {
                for (a = 0; a < (len + 7) / 8; ++a) {
                    s[a] = (byte)(s[a] << 4 | (s[a] & 0xFF) >> 4);
                }
                if (len % 8 != 0) {
                    int n = (len + 7) / 8 - 1;
                    s[n] = (byte)(s[n] >> 4);
                }
            }
        }
        int last_bit_offset = this.bit_pos + len - 1;
        byte last_bit_octet = this.data_ptr[this.buf_pos + last_bit_offset / 8];
        last_bit_octet = local_fieldorder == TTCN_EncDec.raw_order_t.ORDER_LSB ? (byte)(last_bit_octet >> last_bit_offset % 8) : (byte)(last_bit_octet >> 7 - last_bit_offset % 8);
        this.last_bit = (last_bit_octet & 1) != 0;
        this.buf_pos = new_buf_pos;
        this.bit_pos = new_bit_pos;
    }

    public void put_zero(int len, TTCN_EncDec.raw_order_t fieldorder) {
        if (len == 0) {
            return;
        }
        int new_size = ((this.bit_pos == 0 ? this.buf_len * 8 : this.buf_len * 8 - (8 - this.bit_pos)) + len + 7) / 8;
        if (new_size > this.buf_len) {
            this.increase_size(new_size - this.buf_len);
        }
        if (this.bit_pos != 0) {
            if (this.bit_pos + len > 8) {
                int offset;
                int mask1 = RAW.BitMaskTable[this.bit_pos];
                int n = offset = this.buf_len == 0 ? 0 : this.buf_len - 1;
                if (fieldorder == TTCN_EncDec.raw_order_t.ORDER_LSB) {
                    int n2 = offset;
                    this.data_ptr[n2] = (byte)(this.data_ptr[n2] & mask1);
                } else {
                    int n3 = offset;
                    this.data_ptr[n3] = (byte)(this.data_ptr[n3] & RAW.REVERSE_BITS(mask1));
                }
                for (int i = 1; i < (len - 1 + this.bit_pos) / 8; ++i) {
                    this.data_ptr[i + offset] = 0;
                }
            } else {
                this.data_ptr[new_size - 1] = fieldorder == TTCN_EncDec.raw_order_t.ORDER_LSB ? (byte)(this.data_ptr[new_size - 1] & RAW.BitMaskTable[this.bit_pos]) : (byte)(this.data_ptr[new_size - 1] & RAW.REVERSE_BITS(RAW.BitMaskTable[this.bit_pos]));
            }
        } else {
            for (int i = this.buf_len; i < (len + 7) / 8; ++i) {
                this.data_ptr[i] = 0;
            }
        }
        this.buf_len = new_size;
        this.bit_pos = (this.bit_pos + len) % 8;
        if (this.bit_pos != 0) {
            this.last_bit_pos = this.buf_len - 1;
            this.last_bit_bitpos = fieldorder == TTCN_EncDec.raw_order_t.ORDER_LSB ? this.bit_pos - 1 : 7 - (this.bit_pos - 1);
        } else {
            this.last_bit_pos = this.buf_len - 1;
            this.last_bit_bitpos = fieldorder == TTCN_EncDec.raw_order_t.ORDER_LSB ? 7 : 0;
        }
    }

    public byte[] get_read_data(AtomicInteger bitpos) {
        bitpos.set(this.bit_pos);
        if (this.data_ptr != null) {
            return this.get_data();
        }
        return null;
    }

    public void set_pos(int pos, int bitpos) {
        this.buf_pos = pos < this.buf_len ? pos : this.buf_len;
        this.bit_pos = bitpos;
    }

    public void set_pos_bit(int new_bit_pos) {
        int new_pos = new_bit_pos / 8;
        if (new_pos < this.buf_len) {
            this.buf_pos = new_pos;
            this.bit_pos = new_bit_pos % 8;
        } else {
            this.buf_pos = this.buf_len;
            this.bit_pos = 0;
        }
    }

    public int get_pos_bit() {
        return this.buf_pos * 8 + this.bit_pos;
    }

    public void increase_pos_bit(int delta) {
        int new_buf_pos = this.buf_pos + (this.bit_pos + delta) / 8;
        if (new_buf_pos < this.buf_pos || new_buf_pos > this.buf_len) {
            this.buf_pos = this.buf_len;
            this.bit_pos = 7;
        } else {
            this.buf_pos = new_buf_pos;
            this.bit_pos = (this.bit_pos + delta) % 8;
        }
    }

    public int increase_pos_padd(int padding) {
        if (padding != 0) {
            int new_bit_pos = (this.buf_pos * 8 + this.bit_pos + padding - 1) / padding * padding;
            int padded = new_bit_pos - this.buf_pos * 8 - this.bit_pos;
            this.buf_pos = new_bit_pos / 8;
            this.bit_pos = new_bit_pos % 8;
            return padded;
        }
        return 0;
    }

    public int unread_len_bit() {
        return (this.buf_len - this.buf_pos) * 8 - this.bit_pos;
    }

    public void start_ext_bit(boolean p_reverse) {
        if (this.ext_level == 0) {
            this.start_of_ext_bit = this.buf_len;
            this.ext_bit_reverse = p_reverse;
        }
        ++this.ext_level;
    }

    public void stop_ext_bit() {
        if (this.ext_level <= 0) {
            TTCN_EncDec_ErrorContext.error_internal("TTCN_Buffer.stop_ext_bit() was called without start_ext_bit().", new Object[0]);
        }
        --this.ext_level;
        if (this.ext_level == 0) {
            int one = this.current_bitorder ? 1 : 128;
            int zero = ~one;
            if (this.ext_bit_reverse) {
                int a = this.start_of_ext_bit;
                while (a < this.buf_len - 1) {
                    int n = a++;
                    this.data_ptr[n] = (byte)(this.data_ptr[n] | one);
                }
                int n = this.buf_len - 1;
                this.data_ptr[n] = (byte)(this.data_ptr[n] & zero);
            } else {
                int a = this.start_of_ext_bit;
                while (a < this.buf_len - 1) {
                    int n = a++;
                    this.data_ptr[n] = (byte)(this.data_ptr[n] & zero);
                }
                int n = this.buf_len - 1;
                this.data_ptr[n] = (byte)(this.data_ptr[n] | one);
            }
        }
    }

    public boolean get_order() {
        return this.current_bitorder;
    }

    public void set_order(boolean new_order) {
        this.current_bitorder = new_order;
    }

    public void put_pad(int len, byte[] s, int pat_len, TTCN_EncDec.raw_order_t fieldorder) {
        if (len == 0) {
            return;
        }
        if (pat_len == 0) {
            this.put_zero(len, fieldorder);
            return;
        }
        RAW.RAW_coding_par cp = new RAW.RAW_coding_par(TTCN_EncDec.raw_order_t.ORDER_LSB, TTCN_EncDec.raw_order_t.ORDER_LSB, TTCN_EncDec.raw_order_t.ORDER_LSB, fieldorder, false);
        for (int length = len; length > 0; length -= pat_len) {
            this.put_b(length > pat_len ? pat_len : length, s, cp, 0);
        }
    }

    public void put_pad(int len, String s, int pat_len, TTCN_EncDec.raw_order_t fieldorder) {
        if (len == 0) {
            return;
        }
        if (pat_len == 0) {
            this.put_zero(len, fieldorder);
            return;
        }
        RAW.RAW_coding_par cp = new RAW.RAW_coding_par(TTCN_EncDec.raw_order_t.ORDER_LSB, TTCN_EncDec.raw_order_t.ORDER_LSB, TTCN_EncDec.raw_order_t.ORDER_LSB, fieldorder, false);
        char[] str = s.toCharArray();
        byte[] temp = new byte[str.length];
        for (int i = 0; i < str.length; ++i) {
            temp[i] = (byte)str[i];
        }
        for (int length = len; length > 0; length -= pat_len) {
            this.put_b(length > pat_len ? pat_len : length, temp, cp, 0);
        }
    }

    public void set_last_bit(boolean p_last_bit) {
        int bitmask = 1 << this.last_bit_bitpos;
        if (p_last_bit) {
            int n = this.last_bit_pos;
            this.data_ptr[n] = (byte)(this.data_ptr[n] | bitmask);
        } else {
            int n = this.last_bit_pos;
            this.data_ptr[n] = (byte)(this.data_ptr[n] & ~bitmask);
            int n2 = this.last_bit_pos;
            this.data_ptr[n2] = (byte)(this.data_ptr[n2] & 0xFF);
        }
    }

    public boolean get_last_bit() {
        return this.last_bit;
    }

    private static byte get_byte_rev(byte[] data, int len, int idx) {
        byte ch = 0;
        int hossz = (len + 7) / 8 - 1;
        if (idx > hossz) {
            return ch;
        }
        int bit_limit = len % 8;
        if (bit_limit == 0) {
            return data[hossz - idx];
        }
        ch = (byte)(data[hossz - idx] << 8 - bit_limit & 0xFF);
        if (hossz - idx > 0) {
            ch = (byte)(ch | data[hossz - idx - 1] >> bit_limit & RAW.BitMaskTable[8 - bit_limit]);
        }
        return ch;
    }

    private byte get_byte_align(int len, TTCN_EncDec.raw_order_t fieldorder, TTCN_EncDec.raw_order_t req_align, int index) {
        if (index < 0 || index > (this.bit_pos + len) / 8 || this.buf_pos + index >= this.buf_len || this.data_ptr == null) {
            return 0;
        }
        if (index == 0) {
            if (fieldorder == req_align) {
                if (fieldorder == TTCN_EncDec.raw_order_t.ORDER_LSB) {
                    return (byte)(this.data_ptr[this.buf_pos] >> this.bit_pos);
                }
                return (byte)(this.data_ptr[this.buf_pos] << this.bit_pos & 0xFF);
            }
            return this.data_ptr[this.buf_pos];
        }
        if (index == (this.bit_pos + len) / 8) {
            if (fieldorder == req_align) {
                if (fieldorder == TTCN_EncDec.raw_order_t.ORDER_LSB) {
                    return (byte)(this.data_ptr[this.buf_pos + index] << 8 - (this.bit_pos + len) % 8 & 0xFF);
                }
                return (byte)(this.data_ptr[this.buf_pos + index] >> 8 - (this.bit_pos + len) % 8);
            }
            return this.data_ptr[this.buf_pos + index];
        }
        return this.data_ptr[this.buf_pos + index];
    }
}

