/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.runtime.core;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.text.MessageFormat;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.titan.runtime.core.TitanInteger;
import org.eclipse.titan.runtime.core.TtcnError;

public final class Text_Buf {
    private static final int BUF_SIZE = 1000;
    private static final int BUF_HEAD = 24;
    private int buf_size = 0;
    private int buf_begin = 24;
    private int buf_pos = 24;
    private int buf_len = 0;
    private byte[] data_ptr;

    public Text_Buf() {
        this.Allocate(1000);
    }

    private void Allocate(int size) {
        int new_buf_size;
        for (new_buf_size = 1024; new_buf_size < size + this.buf_begin; new_buf_size *= 2) {
        }
        this.data_ptr = new byte[new_buf_size];
        this.buf_size = new_buf_size;
    }

    private void Reallocate(int size) {
        int new_buf_size;
        for (new_buf_size = 1024; new_buf_size < size + this.buf_begin; new_buf_size *= 2) {
        }
        if (new_buf_size != this.buf_size) {
            byte[] temp_data_ptr = new byte[new_buf_size];
            System.arraycopy(this.data_ptr, 0, temp_data_ptr, 0, new_buf_size < this.buf_size ? new_buf_size : this.buf_size);
            this.data_ptr = temp_data_ptr;
            this.buf_size = new_buf_size;
        }
    }

    public void reset() {
        this.buf_begin = 24;
        this.Reallocate(1000);
        this.buf_pos = 24;
        this.buf_len = 0;
    }

    public void rewind() {
        this.buf_pos = this.buf_begin;
    }

    public int get_begin() {
        return this.buf_begin;
    }

    public int get_len() {
        return this.buf_len;
    }

    public int get_pos() {
        return this.buf_pos - this.buf_begin;
    }

    public void buf_seek(int new_pos) {
        this.buf_pos = this.buf_begin + new_pos;
    }

    public byte[] get_data() {
        return this.data_ptr;
    }

    public void push_int(int value) {
        boolean isNegative = value < 0;
        int unsignedValue = isNegative ? -value : value;
        int bytesNeeded = 1;
        for (int tmp = unsignedValue >> 6; tmp != 0; tmp >>= 7) {
            ++bytesNeeded;
        }
        this.Reallocate(this.buf_len + bytesNeeded);
        int i = bytesNeeded - 1;
        while (true) {
            int data_index = i + this.buf_begin + this.buf_len;
            if (i > 0) {
                this.data_ptr[data_index] = (byte)(unsignedValue & 0x7F);
                unsignedValue >>= 7;
            } else {
                this.data_ptr[data_index] = (byte)(unsignedValue & 0x3F);
            }
            if (i < bytesNeeded - 1) {
                int n = data_index;
                this.data_ptr[n] = (byte)(this.data_ptr[n] | 0x80);
            }
            if (i == 0) break;
            --i;
        }
        if (isNegative) {
            int n = 0 + this.buf_begin + this.buf_len;
            this.data_ptr[n] = (byte)(this.data_ptr[n] | 0x40);
        }
        this.buf_len += bytesNeeded;
    }

    public void push_int(TitanInteger value) {
        if (value.is_native()) {
            int nativeValue = value.get_int();
            this.push_int(nativeValue);
        } else {
            BigInteger bigValue = value.get_BigInteger();
            boolean isNegative = bigValue.compareTo(BigInteger.ZERO) == -1;
            BigInteger unsignedValue = bigValue.abs();
            int numBits = bigValue.bitLength();
            int bytesNeeded = numBits / 7 + 1;
            this.Reallocate(this.buf_len + bytesNeeded);
            int i = bytesNeeded - 1;
            while (true) {
                int data_index = i + this.buf_begin + this.buf_len;
                if (i > 0) {
                    this.data_ptr[data_index] = (byte)(unsignedValue.intValue() & 0x7F);
                    unsignedValue = unsignedValue.shiftRight(7);
                } else {
                    this.data_ptr[data_index] = (byte)(unsignedValue.intValue() & 0x3F);
                }
                if (i < bytesNeeded - 1) {
                    int n = data_index;
                    this.data_ptr[n] = (byte)(this.data_ptr[n] | 0x80);
                }
                if (i == 0) break;
                --i;
            }
            if (isNegative) {
                int n = 0 + this.buf_begin + this.buf_len;
                this.data_ptr[n] = (byte)(this.data_ptr[n] | 0x40);
            }
            this.buf_len += bytesNeeded;
        }
    }

    public TitanInteger pull_int() {
        TitanInteger value = new TitanInteger();
        if (!this.safe_pull_int(value)) {
            throw new TtcnError("Text decoder: Decoding of integer failed.");
        }
        return value;
    }

    public boolean safe_pull_int(TitanInteger value) {
        int pos;
        int buf_end = this.buf_begin + this.buf_len;
        if (this.buf_pos >= buf_end) {
            return false;
        }
        for (pos = this.buf_pos; pos < buf_end && (this.data_ptr[pos] & 0x80) != 0; ++pos) {
        }
        if (pos >= buf_end) {
            return false;
        }
        int bytesNeeded = pos - this.buf_pos + 1;
        if (bytesNeeded > 4) {
            int locValue = 0;
            for (int i = 0; i < 4; ++i) {
                locValue = i > 0 ? (locValue |= this.data_ptr[i + this.buf_pos] & 0x7F) : (locValue |= this.data_ptr[i + this.buf_pos] & 0x3F);
                if (i >= 3) continue;
                locValue <<= 7;
            }
            BigInteger bigValue = BigInteger.valueOf(locValue);
            bigValue = bigValue.shiftLeft(7);
            for (int i = 4; i < bytesNeeded; ++i) {
                bigValue = bigValue.add(BigInteger.valueOf(this.data_ptr[i + this.buf_pos] & 0x7F));
                if (i >= bytesNeeded - 1) continue;
                bigValue = bigValue.shiftLeft(7);
            }
            if ((this.data_ptr[0 + this.buf_pos] & 0x40) != 0) {
                bigValue = bigValue.negate();
            }
            if (bigValue.bitLength() > 31) {
                value.operator_assign(bigValue);
            } else {
                value.operator_assign(bigValue.intValue());
            }
        } else {
            int locValue = 0;
            for (int i = 0; i < bytesNeeded; ++i) {
                locValue = i > 0 ? (locValue |= this.data_ptr[i + this.buf_pos] & 0x7F) : (locValue |= this.data_ptr[i + this.buf_pos] & 0x3F);
                if (i >= bytesNeeded - 1) continue;
                locValue <<= 7;
            }
            if ((this.data_ptr[0 + this.buf_pos] & 0x40) != 0) {
                value.operator_assign(-locValue);
            } else {
                value.operator_assign(locValue);
            }
        }
        this.buf_pos = pos + 1;
        return true;
    }

    public void push_double(double value) {
        byte[] bytes = new byte[8];
        ByteBuffer.wrap(bytes).putDouble(value);
        this.Reallocate(this.buf_len + 8);
        System.arraycopy(bytes, 0, this.data_ptr, this.buf_begin + this.buf_len, 8);
        this.buf_len += 8;
    }

    public double pull_double() {
        if (this.buf_pos + 8 > this.buf_begin + this.buf_len) {
            throw new TtcnError("Text decoder: Decoding of float failed. (End of buffer reached)");
        }
        byte[] bytes = new byte[8];
        System.arraycopy(this.data_ptr, this.buf_pos, bytes, 0, 8);
        this.buf_pos += 8;
        return ByteBuffer.wrap(bytes).getDouble();
    }

    public void push_raw(byte[] data) {
        int len = data.length;
        this.Reallocate(this.buf_len + len);
        System.arraycopy(data, 0, this.data_ptr, this.buf_begin + this.buf_len, len);
        this.buf_len += len;
    }

    public void push_raw(int len, byte[] data) {
        if (len < 0) {
            throw new TtcnError(MessageFormat.format("Text encoder: Encoding raw data with negative length ({0}).", len));
        }
        this.Reallocate(this.buf_len + len);
        System.arraycopy(data, 0, this.data_ptr, this.buf_begin + this.buf_len, len);
        this.buf_len += len;
    }

    public void push_raw(int start, int len, byte[] data) {
        if (len < 0) {
            throw new TtcnError(MessageFormat.format("Text encoder: Encoding raw data with negative length ({0}).", len));
        }
        this.Reallocate(this.buf_len + len);
        System.arraycopy(data, 0, this.data_ptr, start, len);
        this.buf_len += len;
    }

    public void push_raw_front(int len, byte[] data) {
        if (len < 0) {
            throw new TtcnError(MessageFormat.format("Text encoder: Encoding raw data with negative length ({0}).", len));
        }
        this.Reallocate(this.buf_len + len);
        for (int i = this.buf_len - 1; i >= 0; --i) {
            this.data_ptr[this.buf_begin + len + i] = this.data_ptr[this.buf_begin + i];
        }
        System.arraycopy(data, len, this.data_ptr, this.buf_begin, len);
        this.buf_len += len;
    }

    public void pull_raw(int len, byte[] data) {
        if (len < 0) {
            throw new TtcnError(MessageFormat.format("Text decoder: Decoding raw data with negative length ({0}).", len));
        }
        if (this.buf_pos + len > this.buf_begin + this.buf_len) {
            throw new TtcnError("Text decoder: End of buffer reached.");
        }
        System.arraycopy(this.data_ptr, this.buf_pos, data, 0, len);
        this.buf_pos += len;
    }

    public void push_string(String string) {
        if (string != null) {
            byte[] bytes = string.getBytes();
            int len = bytes.length;
            this.push_int(len);
            this.push_raw(bytes);
        } else {
            this.push_int(0);
        }
    }

    public String pull_string() {
        int len = this.pull_int().get_int();
        if (len < 0) {
            throw new TtcnError(MessageFormat.format("Text decoder: Negative string length ({0}).", len));
        }
        byte[] raw = new byte[len];
        this.pull_raw(len, raw);
        return new String(raw);
    }

    public void calculate_length() {
        int value = this.buf_len;
        int bytes_needed = 1;
        for (int tmp = value >> 6; tmp != 0; tmp >>= 7) {
            ++bytes_needed;
        }
        if (this.buf_begin < bytes_needed) {
            throw new TtcnError("Text encoder: There is not enough space to calculate message length.");
        }
        if (bytes_needed == 1) {
            this.data_ptr[this.buf_begin - bytes_needed] = (byte)(value & 0x3F);
        } else {
            this.data_ptr[this.buf_begin - 1] = (byte)(value & 0x7F);
            value >>= 7;
            for (int i = bytes_needed - 2; i > 0; --i) {
                this.data_ptr[this.buf_begin - bytes_needed + i] = (byte)(value & 0x7F | 0x80);
                value >>= 7;
            }
            this.data_ptr[this.buf_begin - bytes_needed] = (byte)(value & 0x3F | 0x80);
        }
        this.buf_begin -= bytes_needed;
        this.buf_len += bytes_needed;
    }

    public void get_end(AtomicInteger end_index, AtomicInteger end_len) {
        int buf_end = this.buf_begin + this.buf_len;
        if (this.buf_size - buf_end < 1000) {
            this.Reallocate(this.buf_len + 1000);
        }
        end_index.set(buf_end);
        end_len.set(this.buf_size - buf_end);
    }

    public void increase_length(int add_len) {
        if (add_len < 0) {
            throw new TtcnError(MessageFormat.format("Text decoder: Addition is negative ({0}) when increasing length.", add_len));
        }
        if (this.buf_begin + this.buf_len + add_len > this.buf_size) {
            throw new TtcnError("Text decoder: Addition is too big when increasing length.");
        }
        this.buf_len += add_len;
    }

    public boolean is_message() {
        this.rewind();
        TitanInteger msg_len = new TitanInteger();
        boolean returnValue = false;
        if (this.safe_pull_int(msg_len)) {
            int temp = msg_len.get_int();
            if (temp < 0) {
                throw new TtcnError(MessageFormat.format("Text decoder: Negative message length ({0}).", temp));
            }
            returnValue = this.buf_pos + temp <= this.buf_begin + this.buf_len;
        }
        this.rewind();
        return returnValue;
    }

    public void cut_message() {
        if (this.is_message()) {
            int msg_len = this.pull_int().get_int();
            int msg_end = this.buf_pos + msg_len;
            this.buf_len -= msg_end - this.buf_begin;
            System.arraycopy(this.data_ptr, msg_end, this.data_ptr, this.buf_begin, this.buf_len);
            this.Reallocate(this.buf_len);
            this.rewind();
        }
    }
}

