/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.runtime.core.cfgparser;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;

public final class DefineSectionHandler {
    private final Map<String, List<Token>> definitions = new LinkedHashMap<String, List<Token>>();
    private final CommonTokenStream tokenStream;
    private static final String PATTERN_STRING_MACRO = "\\$\\s*([A-Za-z][A-Za-z0-9_]*)\\s*";
    private static final Pattern PATTERN_MACRO = Pattern.compile("\\$\\s*([A-Za-z][A-Za-z0-9_]*)\\s*");
    private static final String PATTERN_STRING_MACRO_BRACE = "\\$\\s*\\{\\s*([A-Za-z][A-Za-z0-9_]*)\\s*\\}";
    private static final Pattern PATTERN_MACRO_BRACE = Pattern.compile("\\$\\s*\\{\\s*([A-Za-z][A-Za-z0-9_]*)\\s*\\}");
    private static final String PATTERN_STRING_TYPED_MACRO = "\\$\\s*\\{\\s*([A-Za-z][A-Za-z0-9_]*)\\s*,\\s*[A-Za-z][A-Za-z0-9_]*\\s*\\}";
    private static final Pattern PATTERN_TYPED_MACRO = Pattern.compile("\\$\\s*\\{\\s*([A-Za-z][A-Za-z0-9_]*)\\s*,\\s*[A-Za-z][A-Za-z0-9_]*\\s*\\}");

    public DefineSectionHandler(CommonTokenStream tokenStream) {
        this.tokenStream = tokenStream;
    }

    public Map<String, List<Token>> getDefinitions() {
        return this.definitions;
    }

    public void addDefinition(String name, ParserRuleContext def) {
        List<Token> tokenList = this.getTokenList(def, this.tokenStream);
        this.definitions.put(name, tokenList);
    }

    private List<Token> getTokenList(ParserRuleContext def, CommonTokenStream tokenStream) {
        Token startToken = def.start;
        int startIndex = startToken.getTokenIndex();
        Token stopToken = def.stop;
        int stopIndex = stopToken.getTokenIndex();
        return tokenStream.getTokens(startIndex, stopIndex);
    }

    public List<Token> getDefinitionTokens(String aDefinition) {
        if (this.definitions != null && this.definitions.containsKey(aDefinition)) {
            return this.definitions.get(aDefinition);
        }
        return null;
    }

    public static String getMacroName(String macroString) {
        Matcher m = PATTERN_MACRO.matcher(macroString);
        if (m.find()) {
            return m.group(1);
        }
        m = PATTERN_MACRO_BRACE.matcher(macroString);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    public static String getTypedMacroName(String aMacroString) {
        Matcher m = PATTERN_TYPED_MACRO.matcher(aMacroString);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }
}

