/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.markers.export;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titanium.markers.export.CsvProblemExporter;
import org.eclipse.titanium.markers.handler.Marker;
import org.eclipse.titanium.markers.handler.MarkerHandler;
import org.eclipse.titanium.markers.utils.AnalyzerCache;

public class SingleCsvProblemExporter
extends CsvProblemExporter {
    public SingleCsvProblemExporter(IProject proj) {
        super(proj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportMarkers(IProgressMonitor monitor, String path, Date date) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        BufferedWriter summaryFile = null;
        try {
            summaryFile = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(path)), "UTF-8"));
            MarkerHandler mh = AnalyzerCache.withAll().analyzeProject((IProgressMonitor)progress.newChild(30), this.project);
            for (Map.Entry<IResource, List<Marker>> entry : mh.getMarkersByResource().entrySet()) {
                IResource resource = entry.getKey();
                for (Marker marker : entry.getValue()) {
                    summaryFile.write(resource.getProjectRelativePath().toString());
                    summaryFile.write(";");
                    summaryFile.write(String.valueOf(marker.getLine()));
                    summaryFile.write(";");
                    summaryFile.write(marker.getProblemType().name());
                    summaryFile.write(";");
                    summaryFile.write(";");
                    summaryFile.write(";");
                    summaryFile.newLine();
                }
            }
        }
        catch (IOException e) {
            ErrorReporter.logExceptionStackTrace((String)("Error while exporting to CSV file: " + path), (Throwable)e);
        }
        finally {
            if (summaryFile != null) {
                try {
                    summaryFile.close();
                }
                catch (IOException e) {
                    ErrorReporter.logExceptionStackTrace((String)("Error while closing the file: " + path), (Throwable)e);
                }
            }
        }
    }
}

