/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.preferences.pages;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.titanium.Activator;
import org.eclipse.titanium.markers.types.CodeSmellType;
import org.eclipse.titanium.markers.types.ProblemNameToPreferenceMapper;
import org.eclipse.titanium.markers.types.TaskType;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class RiskFactorPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String DESCRIPTION = "Tuning parameters of project risk factor calculation.";
    private static final Map<String, String> USED_MARKERS = new HashMap<String, String>();
    private final IPreferenceStore prefStore = Activator.getDefault().getPreferenceStore();
    private Text projectBase;
    private final List<String> markers = new ArrayList<String>();
    private final List<Combo> impacts = new ArrayList<Combo>();
    private final List<Text> baselines = new ArrayList<Text>();

    public RiskFactorPreferencePage() {
        super("Risk factor parameters");
    }

    public void init(IWorkbench sworkbench) {
        this.setDescription(DESCRIPTION);
    }

    protected Control createContents(Composite parent) {
        Composite tmpParent = new Composite(parent, 0);
        tmpParent.setLayout((Layout)new GridLayout(1, true));
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        tmpParent.setLayoutData((Object)gd);
        Composite head = new Composite(tmpParent, 0);
        head.setLayout((Layout)new GridLayout(2, false));
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        head.setLayoutData((Object)gd);
        Label label = new Label(head, 0);
        label.setText("Base risk factor");
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gd);
        this.projectBase = new Text(head, 4);
        this.projectBase.setTextLimit(7);
        gd = new GridData();
        gd.widthHint = 100;
        this.projectBase.setLayoutData((Object)gd);
        Group rest = new Group(tmpParent, 0);
        rest.setText("Parameters of the code smells");
        GridLayout layout = new GridLayout(3, false);
        rest.setLayout((Layout)layout);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        rest.setLayoutData((Object)gd);
        label = new Label((Composite)rest, 0);
        label.setText("Code smell");
        gd = new GridData();
        gd.widthHint = 250;
        gd.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gd);
        label = new Label((Composite)rest, 0);
        label.setText("Impact factor");
        gd = new GridData();
        gd.widthHint = 80;
        label.setLayoutData((Object)gd);
        label = new Label((Composite)rest, 0);
        label.setText("LoC for one occurrence");
        gd = new GridData();
        gd.widthHint = 150;
        label.setLayoutData((Object)gd);
        for (String markerName : USED_MARKERS.keySet()) {
            this.createRow(markerName, (Composite)rest);
        }
        this.load();
        return tmpParent;
    }

    private void createRow(String markerName, Composite comp) {
        Label label = new Label(comp, 0);
        label.setText(USED_MARKERS.get(markerName));
        Combo imp = new Combo(comp, 4);
        imp.setItems(new String[]{"low", "medium", "high"});
        imp.setTextLimit(6);
        GridData gd = new GridData();
        gd.widthHint = 80;
        imp.setLayoutData((Object)gd);
        Text bl = new Text(comp, 4);
        bl.setTextLimit(7);
        gd = new GridData();
        gd.widthHint = 60;
        bl.setLayoutData((Object)gd);
        this.markers.add(markerName);
        this.impacts.add(imp);
        this.baselines.add(bl);
    }

    private void load() {
        this.projectBase.setText(this.prefStore.getString("BASE_RISK_FACTOR"));
        for (int i = 0; i < this.markers.size(); ++i) {
            this.impacts.get(i).select(this.prefStore.getInt(ProblemNameToPreferenceMapper.nameSmellImpact(this.markers.get(i))) - 1);
            this.baselines.get(i).setText(this.prefStore.getString(ProblemNameToPreferenceMapper.nameSmellBaseLine(this.markers.get(i))));
        }
        this.updateApplyButton();
    }

    protected void performDefaults() {
        this.projectBase.setText(this.prefStore.getDefaultString("BASE_RISK_FACTOR"));
        for (int i = 0; i < USED_MARKERS.size(); ++i) {
            this.impacts.get(i).select(this.prefStore.getDefaultInt(ProblemNameToPreferenceMapper.nameSmellImpact(this.markers.get(i))) - 1);
            this.baselines.get(i).setText(this.prefStore.getDefaultString(ProblemNameToPreferenceMapper.nameSmellBaseLine(this.markers.get(i))));
        }
        this.updateApplyButton();
    }

    public boolean performOk() {
        this.prefStore.setValue("BASE_RISK_FACTOR", this.projectBase.getText());
        for (int i = 0; i < USED_MARKERS.size(); ++i) {
            this.prefStore.setValue(ProblemNameToPreferenceMapper.nameSmellImpact(this.markers.get(i)), this.impacts.get(i).getSelectionIndex() + 1);
            this.prefStore.setValue(ProblemNameToPreferenceMapper.nameSmellBaseLine(this.markers.get(i)), this.baselines.get(i).getText());
        }
        return true;
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return this.prefStore;
    }

    private static void insertSP(CodeSmellType p) {
        USED_MARKERS.put(p.name(), p.getHumanReadableName());
    }

    private static void insertTask(TaskType p) {
        USED_MARKERS.put(p.name(), p.getHumanReadableName());
    }

    static {
        RiskFactorPreferencePage.insertTask(TaskType.FIXME);
        RiskFactorPreferencePage.insertTask(TaskType.TODO);
        RiskFactorPreferencePage.insertSP(CodeSmellType.CIRCULAR_IMPORTATION);
        RiskFactorPreferencePage.insertSP(CodeSmellType.LANGUAGE_MIXING);
        RiskFactorPreferencePage.insertSP(CodeSmellType.TOO_MANY_STATEMENTS);
        RiskFactorPreferencePage.insertSP(CodeSmellType.TOO_MANY_PARAMETERS);
        RiskFactorPreferencePage.insertSP(CodeSmellType.RUNS_ON_SCOPE_REDUCTION);
        RiskFactorPreferencePage.insertSP(CodeSmellType.UNCOMMENTED_FUNCTION);
        RiskFactorPreferencePage.insertSP(CodeSmellType.TYPENAME_IN_DEFINITION);
        RiskFactorPreferencePage.insertSP(CodeSmellType.MODULENAME_IN_DEFINITION);
        RiskFactorPreferencePage.insertSP(CodeSmellType.VISIBILITY_IN_DEFINITION);
        RiskFactorPreferencePage.insertSP(CodeSmellType.UNINITIALIZED_VARIABLE);
        RiskFactorPreferencePage.insertSP(CodeSmellType.GOTO);
        RiskFactorPreferencePage.insertSP(CodeSmellType.PRIVATE_COMPONENT_VARIABLE_ACCESS);
        RiskFactorPreferencePage.insertSP(CodeSmellType.INVOKING_FUNCTIONS_FROM_SPECIFIC_PLACES);
        RiskFactorPreferencePage.insertSP(CodeSmellType.UNUSED_IMPORT);
        RiskFactorPreferencePage.insertSP(CodeSmellType.UNUSED_GLOBAL_DEFINITION);
        RiskFactorPreferencePage.insertSP(CodeSmellType.UNUSED_LOCAL_DEFINITION);
        RiskFactorPreferencePage.insertSP(CodeSmellType.UNUSED_FUNTION_RETURN_VALUES);
        RiskFactorPreferencePage.insertSP(CodeSmellType.UNUSED_STARTED_FUNCTION_RETURN_VALUES);
        RiskFactorPreferencePage.insertSP(CodeSmellType.INFINITE_LOOP);
        RiskFactorPreferencePage.insertSP(CodeSmellType.NONPRIVATE_PRIVATE);
        RiskFactorPreferencePage.insertSP(CodeSmellType.SIZECHECK_IN_LOOP);
        RiskFactorPreferencePage.insertSP(CodeSmellType.TOO_COMPLEX_EXPRESSIONS);
        RiskFactorPreferencePage.insertSP(CodeSmellType.READONLY_INOUT_PARAM);
        RiskFactorPreferencePage.insertSP(CodeSmellType.READONLY_OUT_PARAM);
        RiskFactorPreferencePage.insertSP(CodeSmellType.READONLY_LOC_VARIABLE);
        RiskFactorPreferencePage.insertSP(CodeSmellType.EMPTY_STATEMENT_BLOCK);
        RiskFactorPreferencePage.insertSP(CodeSmellType.SETVERDICT_WITHOUT_REASON);
        RiskFactorPreferencePage.insertSP(CodeSmellType.STOP_IN_FUNCTION);
        RiskFactorPreferencePage.insertSP(CodeSmellType.UNNECESSARY_VALUEOF);
        RiskFactorPreferencePage.insertSP(CodeSmellType.MAGIC_NUMBERS);
        RiskFactorPreferencePage.insertSP(CodeSmellType.MAGIC_STRINGS);
        RiskFactorPreferencePage.insertSP(CodeSmellType.LOGIC_INVERSION);
        RiskFactorPreferencePage.insertSP(CodeSmellType.UNNECESSARY_CONTROLS);
    }
}

